/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.database.hibernate;

import de.pontonconsulting.xmlpipe.messenger.database.hibernate.AbstractOutboundQueueMessage;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Future;

public class OutboundQueueMessage
extends AbstractOutboundQueueMessage {
    private static final long serialVersionUID = -8518085231961807221L;
    private transient String transportUrl;
    private transient String lastError;
    private transient Future<?> sendingTask;
    private transient OffsetDateTime retryTime;
    private transient Integer noOfTries;

    public OutboundQueueMessage() {
    }

    public OutboundQueueMessage(Long messageId, Integer messengerId) {
        super(messageId, messengerId);
    }

    public OutboundQueueMessage(Long messageId, int status, String receiverId, int priority, OffsetDateTime enqueueTime, OffsetDateTime timeToLive, OffsetDateTime lastTransmission, Integer messengerId) {
        super(messageId, status, receiverId, priority, enqueueTime, timeToLive, lastTransmission, messengerId);
    }

    public Optional<String> getTransportUrl() {
        return Optional.ofNullable(this.transportUrl);
    }

    public void setTransportUrl(String transportUrl) {
        this.transportUrl = transportUrl;
    }

    public Optional<String> getLastError() {
        return Optional.ofNullable(this.lastError);
    }

    public void setLastError(String lastError) {
        this.lastError = lastError;
    }

    public boolean isInTransfer() {
        return this.getStatus() == 1;
    }

    public boolean isInRetryDelay() {
        return this.getStatus() == 2;
    }

    public Future<?> getSendingTask() {
        return this.sendingTask;
    }

    public void setSendingTask(Future<?> sendingTask) {
        this.sendingTask = sendingTask;
    }

    public void setRetryTimeLong(Long retryTime) {
        this.retryTime = this.toOffsetDateTime(retryTime);
    }

    public void setTimeToLiveLong(Long timeToLive) {
        this.setTimeToLive(this.toOffsetDateTime(timeToLive));
    }

    private OffsetDateTime toOffsetDateTime(Long millis) {
        return Objects.isNull(millis) ? null : OffsetDateTime.ofInstant(Instant.ofEpochMilli(millis), ZoneOffset.UTC);
    }

    public void incNoOfRetries() {
        if (Objects.isNull(this.getNoOfTries())) {
            this.setNoOfTries(1);
        } else {
            this.setNoOfTries(this.getNoOfTries() + 1);
        }
    }

    public OffsetDateTime getRetryTime() {
        return this.retryTime;
    }

    public Integer getNoOfTries() {
        return this.noOfTries;
    }

    public void setNoOfTries(Integer noOfTries) {
        this.noOfTries = noOfTries;
    }
}

