/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.database.hibernate;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.Properties;

@Entity
@Table(name="HTTP_ADAPTER_INFO")
public class HttpAdapterInfo
implements Serializable {
    private static final long serialVersionUID = 7592909056289731380L;
    private static final String FOLDER_PATTERN = "$PONTONXP_HOME/httpadapter_%s/%s";
    public static final String PROP_ID = "httpadapter.id";
    public static final String PROP_PORT = "httpadapter.port";
    public static final String PROP_USE_HTTPS = "httpadapter.use_https";
    public static final String PROP_PARALLEL_THREADS = "httpadapter.parallel_threads";
    public static final String PROP_PROCESSING_TIMEOUT = "httpadapter.processing_timeout";
    public static final String PROP_ACCEPTED_USER = "httpadapter.accepted_user";
    public static final String PROP_RECEIVE_ACK = "httpadapter.receive_ack";
    @Id
    @Column(name="ADAPTER_ID", nullable=false, length=50)
    private String adapterId;
    @Column(name="PORT", nullable=false)
    private Integer port;
    @Column(name="USE_HTTPS")
    private Boolean useHttps;
    @Column(name="PARALLEL_THREADS")
    private Integer parallelThreads;
    @Column(name="PROCESSING_TIMEOUT")
    private Integer processingTimeout;
    @Column(name="ACCEPTED_USER", length=30)
    private String acceptedUser;
    @Column(name="RECEIVE_ACK")
    private Boolean receiveAck = true;
    @Column(name="USERNAME", length=30)
    private String username;
    @Column(name="LAST_CHANGE")
    private OffsetDateTime lastChange;

    public String getAdapterId() {
        return this.adapterId;
    }

    public HttpAdapterInfo setAdapterId(String adapterId) {
        this.adapterId = adapterId;
        return this;
    }

    public Integer getPort() {
        return this.port;
    }

    public HttpAdapterInfo setPort(Integer port) {
        this.port = port;
        return this;
    }

    public Boolean getUseHttps() {
        return this.useHttps;
    }

    public HttpAdapterInfo setUseHttps(Boolean useHttps) {
        this.useHttps = useHttps;
        return this;
    }

    public Integer getParallelThreads() {
        return this.parallelThreads;
    }

    public HttpAdapterInfo setParallelThreads(Integer parallelThreads) {
        this.parallelThreads = parallelThreads;
        return this;
    }

    public Integer getProcessingTimeout() {
        return this.processingTimeout;
    }

    public HttpAdapterInfo setProcessingTimeout(Integer processingTimeout) {
        this.processingTimeout = processingTimeout;
        return this;
    }

    public String getAcceptedUser() {
        return this.acceptedUser;
    }

    public HttpAdapterInfo setAcceptedUser(String acceptedUser) {
        this.acceptedUser = acceptedUser;
        return this;
    }

    public Boolean getReceiveAck() {
        return this.receiveAck;
    }

    public HttpAdapterInfo setReceiveAck(Boolean receiveAck) {
        this.receiveAck = receiveAck;
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    public HttpAdapterInfo setUsername(String username) {
        this.username = username;
        return this;
    }

    public OffsetDateTime getLastChange() {
        return this.lastChange;
    }

    public HttpAdapterInfo setLastChange(OffsetDateTime lastChange) {
        this.lastChange = lastChange;
        return this;
    }

    public Properties toProperties() {
        Properties props = new Properties();
        props.setProperty(PROP_ID, this.getAdapterId());
        props.setProperty(PROP_PORT, String.valueOf(this.getPort()));
        props.setProperty("httpadapter.work_folder", FOLDER_PATTERN.formatted(this.getPort(), "work"));
        props.setProperty("httpadapter.inbound_folder", FOLDER_PATTERN.formatted(this.getPort(), "inbound"));
        props.setProperty("httpadapter.ack_folder", FOLDER_PATTERN.formatted(this.getPort(), "ack"));
        props.setProperty("httpadapter.outbound_folder", FOLDER_PATTERN.formatted(this.getPort(), "outbound"));
        if (this.getUseHttps() != null) {
            props.setProperty(PROP_USE_HTTPS, String.valueOf(this.getUseHttps()));
        }
        if (this.getParallelThreads() != null) {
            props.setProperty(PROP_PARALLEL_THREADS, String.valueOf(this.getParallelThreads()));
        }
        if (this.getProcessingTimeout() != null) {
            props.setProperty(PROP_PROCESSING_TIMEOUT, String.valueOf(this.getProcessingTimeout()));
        }
        if (this.getAcceptedUser() != null) {
            props.setProperty(PROP_ACCEPTED_USER, this.getAcceptedUser());
        }
        if (this.getReceiveAck() != null) {
            props.setProperty(PROP_RECEIVE_ACK, String.valueOf(this.getReceiveAck()));
        }
        return props;
    }

    public HttpAdapterInfo readFromProperties(Properties properties) {
        String processingTimeoutValue;
        this.setAdapterId(properties.getProperty(PROP_ID));
        String portValue = properties.getProperty(PROP_PORT);
        if (Objects.nonNull(portValue)) {
            this.setPort(Integer.valueOf(portValue));
        }
        this.setUseHttps(Boolean.valueOf(properties.getProperty(PROP_USE_HTTPS)));
        String parallelThreadsValue = properties.getProperty(PROP_PARALLEL_THREADS);
        if (Objects.nonNull(parallelThreadsValue)) {
            this.setParallelThreads(Integer.valueOf(parallelThreadsValue));
        }
        if (Objects.nonNull(processingTimeoutValue = properties.getProperty(PROP_PROCESSING_TIMEOUT))) {
            this.setProcessingTimeout(Integer.valueOf(processingTimeoutValue));
        }
        this.setAcceptedUser(properties.getProperty(PROP_ACCEPTED_USER));
        this.setReceiveAck(Boolean.valueOf(properties.getProperty(PROP_RECEIVE_ACK)));
        return this;
    }
}

