/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.database.hibernate;

import de.ponton.xmlpipe.rest.cpa.AgreementListItemDto;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.BackendPartnerId;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.PartnerProfile;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import java.io.Serializable;
import java.time.OffsetDateTime;
import org.hibernate.annotations.Immutable;

@Entity
@Immutable
@Table(name="PARTNER_AGREEMENT")
public class AgreementListItem
implements Serializable {
    private static final long serialVersionUID = 4678166896951628846L;
    @Id
    private String id;
    @Column(name="USERNAME")
    private String username;
    @Column(name="ADAPTER_ID")
    private String adapterId;
    @Column(name="PACKAGING_ID")
    private String packagingId;
    @Column(name="PING_ALL_ENABLED")
    private boolean pingAllEnabled;
    @Column(name="LAST_CHANGE")
    private OffsetDateTime lastChange;
    @OneToOne(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @JoinColumn(name="OWN_PARTNER_ID")
    private PartnerProfile ownPartner;
    @OneToOne(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @JoinColumn(name="COMMUNICATION_PARTNER_ID")
    private PartnerProfile communicationPartner;

    public String getId() {
        return this.id;
    }

    public String getOwnPartnerId() {
        return this.ownPartner.getPartnerId();
    }

    public String getCommunicationPartnerId() {
        return this.communicationPartner.getPartnerId();
    }

    public String getAdapterId() {
        return this.adapterId;
    }

    public String getPackagingId() {
        return this.packagingId;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isPingAllEnabled() {
        return this.pingAllEnabled;
    }

    public OffsetDateTime getLastChange() {
        return this.lastChange;
    }

    public String getOwnPartnerBackendId() {
        return this.ownPartner.getBackendPartnerIds().stream().findFirst().map(BackendPartnerId::getBackendPartnerId).orElse(null);
    }

    public String getCommunicationPartnerBackendId() {
        return this.communicationPartner.getBackendPartnerIds().stream().findFirst().map(BackendPartnerId::getBackendPartnerId).orElse(null);
    }

    public String getOwnPartnerDisplayName() {
        return this.ownPartner.getDisplayName();
    }

    public String getCommunicationPartnerDisplayName() {
        return this.communicationPartner.getDisplayName();
    }

    public AgreementListItemDto convertToDto() {
        return new AgreementListItemDto().setAgreementId(this.id).setLocalPartnerId(this.getOwnPartnerId()).setLocalPartnerDisplayName(this.getOwnPartnerDisplayName()).setLocalPartnerBackendId(this.getOwnPartnerBackendId()).setRemotePartnerId(this.getCommunicationPartnerId()).setRemotePartnerDisplayName(this.getCommunicationPartnerDisplayName()).setRemotePartnerBackendId(this.getCommunicationPartnerBackendId()).setAdapterId(this.adapterId).setPackagerName(this.getPackagingId()).setLastModified(this.getLastChange());
    }
}

