/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.database;

import jakarta.persistence.SharedCacheMode;
import jakarta.persistence.ValidationMode;
import jakarta.persistence.spi.ClassTransformer;
import jakarta.persistence.spi.PersistenceUnitInfo;
import jakarta.persistence.spi.PersistenceUnitTransactionType;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import org.hibernate.jpa.HibernatePersistenceProvider;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class MessengerPersistenceUnitInfo
implements PersistenceUnitInfo {
    public String getPersistenceUnitName() {
        return this.getClass().getSimpleName();
    }

    public String getPersistenceProviderClassName() {
        return HibernatePersistenceProvider.class.getName();
    }

    public PersistenceUnitTransactionType getTransactionType() {
        return PersistenceUnitTransactionType.RESOURCE_LOCAL;
    }

    public DataSource getJtaDataSource() {
        return null;
    }

    public DataSource getNonJtaDataSource() {
        return null;
    }

    public List<String> getMappingFileNames() {
        String pattern = "de/pontonconsulting/xmlpipe/messenger/database/hibernate/%s";
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        try {
            Resource[] resources = resolver.getResources(pattern.formatted("*.hbm.xml"));
            ArrayList<String> result = new ArrayList<String>();
            for (Resource resource : resources) {
                result.add(pattern.formatted(resource.getFilename()));
            }
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<URL> getJarFileUrls() {
        return List.of(this.getClass().getProtectionDomain().getCodeSource().getLocation());
    }

    public URL getPersistenceUnitRootUrl() {
        return null;
    }

    public List<String> getManagedClassNames() {
        String packageName = "de/pontonconsulting/xmlpipe/messenger/database/hibernate";
        ArrayList<String> classNames = new ArrayList<String>();
        try {
            Resource[] resources;
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
            for (Resource resource : resources = resolver.getResources("classpath*:de/pontonconsulting/xmlpipe/messenger/database/hibernate/**/*.class")) {
                if (!resource.isReadable()) continue;
                String path = resource.getURL().getPath();
                int startIndex = path.indexOf("de/pontonconsulting/xmlpipe/messenger/database/hibernate");
                classNames.add(path.substring(startIndex).replace('/', '.').replace(".class", ""));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to scan package: de/pontonconsulting/xmlpipe/messenger/database/hibernate", e);
        }
        return classNames;
    }

    public boolean excludeUnlistedClasses() {
        return false;
    }

    public SharedCacheMode getSharedCacheMode() {
        return null;
    }

    public ValidationMode getValidationMode() {
        return null;
    }

    public Properties getProperties() {
        return new Properties();
    }

    public String getPersistenceXMLSchemaVersion() {
        return null;
    }

    public ClassLoader getClassLoader() {
        return null;
    }

    public void addTransformer(ClassTransformer transformer) {
    }

    public ClassLoader getNewTempClassLoader() {
        return null;
    }
}

