/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.database;

import de.pontonconsulting.xmlpipe.events.ServiceLevel;
import de.pontonconsulting.xmlpipe.events.ShutdownCompleted;
import de.pontonconsulting.xmlpipe.events.ShutdownService;
import de.pontonconsulting.xmlpipe.messenger.IServiceProvider;
import de.pontonconsulting.xmlpipe.messenger.database.DbConsistencyChecker;
import de.pontonconsulting.xmlpipe.messenger.database.HibernateSessionFactory;
import de.pontonconsulting.xmlpipe.messenger.database.tables.AdapterInfoDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.LogMessageDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import jakarta.annotation.PostConstruct;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

public class DatabaseBean
implements IServiceProvider {
    private static final Log _log = LogFactory.getFactory().getInstance("Messenger.DatabaseBean");
    private final ApplicationEventPublisher applicationEventPublisher;
    private final HibernateSessionFactory _hibernateSessionFactory;
    private final MessageDAO _messageDAO;
    private final LogMessageDAO _logMessageDAO;
    private final AdapterInfoDAO _adapterInfoDAO;
    private final DbConsistencyChecker _dbConsistencyChecker;
    private final MessengerLog _messengerLog;
    private AtomicBoolean isAvailable = new AtomicBoolean(false);

    public DatabaseBean(ApplicationEventPublisher applicationEventPublisher, HibernateSessionFactory hibernateSessionFactory, MessageDAO messageDAO, LogMessageDAO logMessageDAO, AdapterInfoDAO adapterInfoDAO, DbConsistencyChecker dbConsistencyChecker, MessengerLog messengerLog) {
        this.applicationEventPublisher = applicationEventPublisher;
        this._hibernateSessionFactory = hibernateSessionFactory;
        this._messageDAO = messageDAO;
        this._logMessageDAO = logMessageDAO;
        this._adapterInfoDAO = adapterInfoDAO;
        this._dbConsistencyChecker = dbConsistencyChecker;
        this._messengerLog = messengerLog;
    }

    public synchronized void reconnectDatabase() throws Exception {
        this.isAvailable.set(false);
        try {
            this.shutdownDatabase();
        }
        catch (HibernateException e) {
            _log.error((Object)"Could not shutdown old Database connection");
            throw e;
        }
        this.reinit();
        this.isAvailable.set(true);
        _log.info((Object)"Successfully connected to Database");
    }

    private void reinit() throws Exception {
        try {
            this._hibernateSessionFactory.initSessionFactory();
            _log.info((Object)"verifying database structure...");
            this._dbConsistencyChecker.checkConsistency();
            this._logMessageDAO.init();
            this._messageDAO.init();
            this.reinitAdapterRegistry();
        }
        catch (Exception e) {
            _log.error((Object)("Can't initialise database connection: " + e.getMessage()), (Throwable)e);
            throw e;
        }
    }

    @PostConstruct
    public void init() throws Exception {
        _log.info((Object)"connecting to database...");
        this._logMessageDAO.init();
        List<Long> interruptedMessages = this._messageDAO.init();
        if (!interruptedMessages.isEmpty()) {
            for (Long id : interruptedMessages) {
                this._messengerLog.log2db(540, id, "");
            }
        }
        this.initAdapterRegistry();
        this.isAvailable.set(true);
    }

    private void shutdownDatabase() throws HibernateException {
        this._hibernateSessionFactory.close();
    }

    private void initAdapterRegistry() {
        try {
            this._adapterInfoDAO.init();
            _log.info((Object)"Adapter Registry initialized.");
        }
        catch (Exception de) {
            _log.fatal((Object)("AdapterRegistry Init problem:" + de.getMessage()), (Throwable)de);
        }
    }

    private void reinitAdapterRegistry() {
        try {
            this._adapterInfoDAO.restoreAdapters();
            _log.info((Object)"Adapter Registry reinitialized.");
        }
        catch (Exception de) {
            _log.fatal((Object)("AdapterRegistry Reinit problem:" + de.getMessage()), (Throwable)de);
        }
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ShutdownService) {
            ShutdownService shutdownEvent = (ShutdownService)event;
            if (this.getServiceLevel() == shutdownEvent.getServiceLevel()) {
                this.shutdownDatabase();
                this.applicationEventPublisher.publishEvent((ApplicationEvent)new ShutdownCompleted(this));
            }
        }
    }

    @Override
    public ServiceLevel getServiceLevel() {
        return ServiceLevel.getServiceLevel(this.getClass());
    }

    @Override
    public String getServiceName() {
        return "DatabaseBean";
    }

    public boolean isDatabaseAvailable() {
        return this.isAvailable.get();
    }
}

