/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.archive;

import de.pontonconsulting.xmlpipe.messenger.database.tables.ArchiveQueueDAO;
import jakarta.persistence.PersistenceException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ArchiveQueueTimeoutCheckTask {
    private static final Logger log = LogManager.getLogger((String)("Messenger." + ArchiveQueueTimeoutCheckTask.class.getSimpleName()));
    private final ArchiveQueueDAO archiveQueueDAO;

    public ArchiveQueueTimeoutCheckTask(ArchiveQueueDAO archiveQueueDAO) {
        this.archiveQueueDAO = archiveQueueDAO;
    }

    public void run() {
        log.debug("Starting {}", (Object)ArchiveQueueTimeoutCheckTask.class.getSimpleName());
        try {
            int timeoutCount = this.archiveQueueDAO.resetTimedOutArchiveQueueMessages();
            if (timeoutCount > 0) {
                log.info("Found and reset {} timed out archiving queue records", (Object)timeoutCount);
            } else {
                log.trace("Found no timed out archiving queue records");
            }
        }
        catch (PersistenceException e) {
            log.fatal("Failed to reset timed out archiving queue records", (Throwable)e);
            throw new IllegalStateException("Failed to reset timed out archiving queue records", e);
        }
        log.debug("Finished {}", (Object)ArchiveQueueTimeoutCheckTask.class.getSimpleName());
    }
}

