/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.archive;

import de.ponton.xmlpipe.rest.message.MessageArtifact;
import de.pontonconsulting.xmlpipe.TempFileCreator;
import de.pontonconsulting.xmlpipe.config.MessengerConfigLoader;
import de.pontonconsulting.xmlpipe.config.model.messenger.archive.XpArchiveDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.archive.XpMessagePart;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.XpMessageSerializer;
import de.pontonconsulting.xmlpipe.messenger.archive.ArchiverDispatcher;
import de.pontonconsulting.xmlpipe.messenger.archive.ArchiverException;
import de.pontonconsulting.xmlpipe.messenger.archive.IArchiver;
import de.pontonconsulting.xmlpipe.messenger.database.DbException;
import de.pontonconsulting.xmlpipe.messenger.database.FileType;
import de.pontonconsulting.xmlpipe.messenger.database.MessageInfo;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.ArchiveQueue;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.FileRef;
import de.pontonconsulting.xmlpipe.messenger.database.tables.ArchiveQueueDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.FileRefDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageWorkDataDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import jakarta.xml.bind.JAXBException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ArchiveProcessor
implements Runnable {
    public static final Logger LOG = LogManager.getLogger((String)"Messenger.ArchiveProcessor");
    public static final String PAYLOAD_ORG_XML = "payload_org.xml";
    public static final int MAX_THREAD_COUNT = 10;
    private final MessageDAO messageDAO;
    private final FileRefDAO fileRefDAO;
    private final ArchiverDispatcher archiverDispatcher;
    private final MessengerLog messengerLog;
    private final XpMessageSerializer xpMessageSerializer;
    private final MessageWorkDataDAO messageWorkDataDAO;
    private final ArchiveQueueDAO archiveQueueDAO;
    private final MessengerConfigLoader configLoader;
    private final AtomicBoolean isRunning = new AtomicBoolean(true);
    private static final long WAIT_TIME_IN_SECONDS = 5L;
    private final ExecutorService threadExecutor;
    private final TempFileCreator tempFileCreator;
    private final List<Future<?>> tasks = new ArrayList();
    private final AtomicInteger runningTaskCount = new AtomicInteger(0);
    private final AtomicBoolean archiverIsReachable = new AtomicBoolean(true);
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();

    public ArchiveProcessor(MessageDAO messageDAO, FileRefDAO fileRefDAO, ArchiverDispatcher archiverDispatcher, MessengerLog messengerLog, XpMessageSerializer xpMessageSerializer, MessageWorkDataDAO messageWorkDataDAO, ArchiveQueueDAO archiveQueueDAO, MessengerConfigLoader configLoader, ExecutorService threadExecutor, TempFileCreator tempFileCreator) {
        this.messageDAO = messageDAO;
        this.fileRefDAO = fileRefDAO;
        this.archiverDispatcher = archiverDispatcher;
        this.messengerLog = messengerLog;
        this.xpMessageSerializer = xpMessageSerializer;
        this.messageWorkDataDAO = messageWorkDataDAO;
        this.archiveQueueDAO = archiveQueueDAO;
        this.configLoader = configLoader;
        this.threadExecutor = threadExecutor;
        this.tempFileCreator = tempFileCreator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendFilesToArchive(long messageDbId, boolean failed) {
        try {
            if (this.archiveQueueDAO.enqueue(messageDbId, failed)) {
                if (this.messageDAO.updateArchiveStatus(messageDbId, 1)) {
                    LOG.debug("Enqueued{} message ({}) for archiving", (Object)(failed ? " FAILED" : ""), (Object)messageDbId);
                    this.wakeUpArchiveTask();
                } else {
                    LOG.warn("Message {} is already archived => skip further ArchiveTask", (Object)messageDbId);
                }
            } else {
                LOG.warn("Message {} is already enqueued for archiving => skip further ArchiveTask", (Object)messageDbId);
            }
        }
        catch (DbException e) {
            LOG.error("Unexpected error when enqueuing message ({}) for archiving: {}", (Object)messageDbId, (Object)e);
        }
        finally {
            MessageDAO.removeDbIdFromThreadContext();
        }
    }

    public void init() {
        int updateCount = this.archiveQueueDAO.resetOwnArchiveQueueMessages();
        if (updateCount > 0) {
            LOG.info("Reset status (ON_ARCHIVING (1) => ENQUEUED (0)) of {} ArchiveQueue records", (Object)updateCount);
        }
    }

    @Override
    public void run() {
        int updateCount = this.archiveQueueDAO.resetOwnArchiveQueueMessages();
        if (updateCount > 0) {
            LOG.info("Reset status (ON_ARCHIVING (1) => ENQUEUED (0)) of {} ArchiveQueue records", (Object)updateCount);
        }
        while (this.isRunning.get()) {
            Thread.interrupted();
            this.archiverIsReachable.set(true);
            try {
                while (this.isRunning.get() && this.archiverIsReachable.get() && this.runningTaskCount.get() < 10) {
                    LOG.trace("Running tasks {}", (Object)this.runningTaskCount.get());
                    Optional<ArchiveQueue> nextArchiveQueueMessage = this.archiveQueueDAO.getNextMessageToArchive();
                    if (nextArchiveQueueMessage.isPresent()) {
                        CountDownLatch latch = new CountDownLatch(1);
                        Future<?> task = this.threadExecutor.submit(() -> {
                            try {
                                latch.await();
                                long messageDbId = ((ArchiveQueue)nextArchiveQueueMessage.get()).getMessageId();
                                MessageDAO.putDbIdToThreadContext(messageDbId);
                                boolean failed = ((ArchiveQueue)nextArchiveQueueMessage.get()).isFailedMessage();
                                this.archiverIsReachable.set(this.sendMessageToArchive(messageDbId, failed));
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                            }
                            finally {
                                this.tasks.remove(this);
                                this.runningTaskCount.decrementAndGet();
                                MessageDAO.removeDbIdFromThreadContext();
                                this.wakeUpArchiveTask();
                            }
                        });
                        this.tasks.add(task);
                        this.runningTaskCount.incrementAndGet();
                        latch.countDown();
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                LOG.error("Unexpected error occurred when processing archive queue message: {}", (Object)e.toString());
            }
            this.waitAMoment();
        }
    }

    protected void waitAMoment() {
        this.lock.lock();
        try {
            LOG.trace("Suspend ArchiveTask for {} s", (Object)5L);
            this.condition.await(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void wakeUpArchiveTask() {
        this.lock.lock();
        try {
            this.condition.signalAll();
            LOG.trace("Waked up ArchiveTask");
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * Exception decompiling
     */
    boolean sendMessageToArchive(long messageDbId, boolean failed) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 13[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void storeArchiveResponse(long messageDataId, List<IArchiver.ArchiveResponse> archiveResponse) throws DbException {
        if (LOG.isDebugEnabled()) {
            String msg = archiveResponse.stream().map(IArchiver.ArchiveResponse::toString).collect(Collectors.joining(", "));
            LOG.debug("Stored ArchiveResponse(s): {}", (Object)msg);
        }
        this.fileRefDAO.storeArchiveResponse(messageDataId, archiveResponse);
    }

    public void writeFileFromArchiveToOutputStream(MessageInfo messageInfo, MessageArtifact messageArtifact, OutputStream outputStream) {
        FileRef archiveFileRef = this.getArchiveFileRef(messageInfo, this.getFileType(messageArtifact), null);
        this.archiverDispatcher.readFileFromArchive(archiveFileRef.getArchiveReference(), outputStream);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    public Optional<XpMessage> getXpMessageFromArchive(MessageInfo messageInfo) {
        if (Objects.isNull(messageInfo)) {
            return Optional.empty();
        }
        try (PipedOutputStream outputStream = new PipedOutputStream();){
            Optional<XpMessage> optional;
            try (PipedInputStream inputStream = new PipedInputStream(outputStream);){
                FileRef archiveFileRef = this.getArchiveFileRef(messageInfo, FileType.PAYLOAD_TECHNICAL, null);
                new Thread(() -> {
                    try (PipedOutputStream pipedOutputStream = outputStream;){
                        this.archiverDispatcher.readFileFromArchive(archiveFileRef.getArchiveReference(), outputStream);
                    }
                    catch (Exception e) {
                        LOG.error("{} while reading '{}' from archive: {}", (Object)e.getClass().getName(), (Object)archiveFileRef.getArchiveReference(), (Object)e.getMessage());
                    }
                }).start();
                optional = this.xpMessageSerializer.deserialize(inputStream);
            }
            return optional;
        }
        catch (Exception e) {
            LOG.error("Error while reading XpMessage from archive: {}", (Object)e.toString());
            return Optional.empty();
        }
    }

    public List<IArchiver.ArchiveResponse> listFilesInArchive(MessageInfo messageInfo) {
        ArrayList<IArchiver.ArchiveResponse> filesInArchive = new ArrayList<IArchiver.ArchiveResponse>();
        for (FileRef fileRef : this.getArchiveFileRefs(messageInfo, null)) {
            filesInArchive.add(new IArchiver.ArchiveResponse(fileRef.getArchiveReference(), fileRef.getFileName(), FileType.fromDbValue(fileRef.getFileType())));
        }
        return filesInArchive;
    }

    public List<MessageArtifact> listMessageArtifactsInArchive(long messageDbId) {
        try {
            MessageInfo messageInfo = this.messageDAO.getMessageInfo(messageDbId);
            return this.listMessageArtifactsInArchive(messageInfo);
        }
        catch (DbException e) {
            LOG.error("Can't load MessageInfo: {}", (Object)e.toString());
            return Collections.emptyList();
        }
    }

    public List<MessageArtifact> listMessageArtifactsInArchive(MessageInfo messageInfo) {
        HashSet<MessageArtifact> messageArtifacts = new HashSet<MessageArtifact>();
        for (FileRef fileRef : this.getArchiveFileRefs(messageInfo, null)) {
            this.addMessageArtifact(messageArtifacts, fileRef);
        }
        return messageArtifacts.stream().toList();
    }

    private void addMessageArtifact(Set<MessageArtifact> messageArtifacts, FileRef fileRef) {
        if (Objects.isNull(fileRef) || Objects.isNull(fileRef.getArchiveReference()) || fileRef.getArchiveReference().isEmpty()) {
            return;
        }
        FileType fileType = FileType.fromDbValue(fileRef.getFileType());
        switch (fileType) {
            case PAYLOAD: {
                messageArtifacts.add(MessageArtifact.RAW_PAYLOAD);
                if (!Objects.nonNull(fileRef.getFileName()) || !fileRef.getFileName().endsWith(".xml")) break;
                messageArtifacts.add(MessageArtifact.HTML_RENDERED_PAYLOAD);
                break;
            }
            case BACKEND_ENVELOPE: {
                messageArtifacts.add(MessageArtifact.BACKEND_ENVELOPE);
                break;
            }
            case PACKAGING_ENVELOPE: {
                messageArtifacts.add(MessageArtifact.PACKAGING_ENVELOPE);
                break;
            }
        }
    }

    public void exportArchiveFiles(MessageInfo messageInfo, File targetDirectory, FileType ... fileTypes) {
        File attachmentsDirectory = new File(targetDirectory, "attachments");
        attachmentsDirectory.mkdirs();
        Set<FileType> fileTypeFilter = Set.of(Objects.isNull(fileTypes) || fileTypes.length == 0 ? FileType.values() : fileTypes);
        for (FileRef fileRef : this.getArchiveFileRefs(messageInfo, null)) {
            if (!fileTypeFilter.contains((Object)FileType.fromDbValue(fileRef.getFileType()))) continue;
            File currentTargetDirectory = FileType.isAttachment(fileRef.getFileType()) ? attachmentsDirectory : targetDirectory;
            File targetFile = new File(currentTargetDirectory, fileRef.getFileName());
            try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(targetFile.toPath(), new OpenOption[0]));){
                this.archiverDispatcher.readFileFromArchive(fileRef.getArchiveReference(), out);
                LOG.debug("Exported archive file {}", (Object)targetFile);
            }
            catch (IOException e) {
                LOG.error("IOException while exporting ArchiveFile {} ({}) to targetDirectory {}: {}", (Object)fileRef.getFileName(), (Object)FileType.fromDbValue(fileRef.getFileType()), (Object)targetDirectory, (Object)e.toString());
            }
        }
    }

    public void deleteFromArchive(MessageInfo messageInfo) throws ArchiverException {
        List<String> archiveReferences = this.getArchiveFileRefs(messageInfo, null).stream().map(FileRef::getArchiveReference).toList();
        if (archiveReferences.isEmpty()) {
            return;
        }
        try {
            this.archiverDispatcher.deleteFileFromArchive(archiveReferences);
            LOG.info("Deleted {} files from archive", (Object)archiveReferences.size());
        }
        catch (ArchiverException e) {
            LOG.error("Can't delete archive files from archive: {}", (Object)e.toString());
        }
    }

    private List<FileRef> getArchiveFileRefs(MessageInfo messageInfo, FileType fileType) throws ArchiverException {
        try {
            List<FileRef> archiveFileRefs = this.fileRefDAO.getArchiveFileRefs(messageInfo.getDatabaseId(), fileType);
            if (LOG.isDebugEnabled()) {
                String msg = archiveFileRefs.stream().map(this::FileRefToString).collect(Collectors.joining(", "));
                LOG.debug("Found {} ArchiveFileRef(s) [messageId={} / fileType={}]: {}", (Object)archiveFileRefs.size(), (Object)messageInfo.getDatabaseId(), (Object)fileType, (Object)msg);
            }
            if (archiveFileRefs.isEmpty() && (Objects.isNull((Object)fileType) || this.fileRefDAO.getArchiveFileRefs(messageInfo.getDatabaseId(), null).isEmpty())) {
                try {
                    List<IArchiver.ArchiveResponse> legacyArchiverResponse = this.archiverDispatcher.createLegacyArchiveResponse(messageInfo);
                    if (!legacyArchiverResponse.isEmpty()) {
                        this.storeArchiveResponse(messageInfo.getDatabaseId(), legacyArchiverResponse);
                        LOG.info("Converted {} legacy archive reference(s)", (Object)legacyArchiverResponse.size());
                        archiveFileRefs = this.fileRefDAO.getArchiveFileRefs(messageInfo.getDatabaseId(), fileType);
                        String msg = archiveFileRefs.stream().map(this::FileRefToString).collect(Collectors.joining(", "));
                        LOG.debug("Found {} ArchiveFileRef(s) [messageId={} / fileType={}] after legacy ArchiveReference conversion: {}", (Object)archiveFileRefs.size(), (Object)messageInfo.getDatabaseId(), (Object)fileType, (Object)msg);
                    }
                }
                catch (Exception e) {
                    LOG.error("Can't create legacy archive references due to {}", (Object)e.toString());
                }
            }
            if (archiveFileRefs.isEmpty()) {
                LOG.warn("No Archive-FileRefs found for message with fileType {}", (Object)fileType);
            }
            return archiveFileRefs;
        }
        catch (DbException e) {
            throw new ArchiverException("Can't load FileRefs of message " + messageInfo.getDatabaseId(), e);
        }
    }

    private String FileRefToString(FileRef fileRef) {
        return "FileRef{fileName='" + fileRef.getFileName() + "', fileType=" + String.valueOf((Object)FileType.fromDbValue(fileRef.getFileType())) + ", archiveReference='" + fileRef.getArchiveReference() + "'}";
    }

    public FileRef getArchiveFileRef(MessageInfo messageInfo, MessageArtifact messageArtifact, String fileName) {
        return this.getArchiveFileRef(messageInfo, this.getFileType(messageArtifact), fileName);
    }

    private FileRef getArchiveFileRef(MessageInfo messageInfo, FileType fileType, String fileName) {
        List<FileRef> archiveFileRefs = this.getArchiveFileRefs(messageInfo, fileType);
        if (archiveFileRefs.size() > 1) {
            if (Objects.nonNull(fileName)) {
                archiveFileRefs = archiveFileRefs.stream().filter(ar -> fileName.equals(ar.getFileName())).toList();
            } else if (fileType.isPayLoad()) {
                List<FileRef> filteredArchRefs = archiveFileRefs.stream().filter(ar -> !PAYLOAD_ORG_XML.equals(ar.getFileName())).toList();
                archiveFileRefs = filteredArchRefs.isEmpty() ? archiveFileRefs.stream().filter(ar -> PAYLOAD_ORG_XML.equals(ar.getFileName())).toList() : filteredArchRefs;
            }
        }
        if (archiveFileRefs.isEmpty()) {
            throw new ArchiverException("ArchiveFileRef for messageId=" + messageInfo.getDatabaseId() + " / fileType=" + String.valueOf((Object)fileType) + " not found");
        }
        if (archiveFileRefs.size() > 1) {
            LOG.warn("Found {} ArchiveFiles of FileType {}", (Object)archiveFileRefs.size(), (Object)fileType);
        }
        return archiveFileRefs.getFirst();
    }

    private FileType getFileType(MessageArtifact messageArtifact) {
        return switch (messageArtifact) {
            default -> throw new MatchException(null, null);
            case MessageArtifact.HTML_RENDERED_PAYLOAD, MessageArtifact.RAW_PAYLOAD -> FileType.PAYLOAD;
            case MessageArtifact.PACKAGING_ENVELOPE -> FileType.PACKAGING_ENVELOPE;
            case MessageArtifact.BACKEND_ENVELOPE -> FileType.BACKEND_ENVELOPE;
        };
    }

    private List<IArchiver.File2Archive> collectFiles2Archive(MessageInfo messageInfo, File fileOrFolder, boolean isFailedMessage) throws IOException {
        ArrayList<IArchiver.File2Archive> files2Archive = new ArrayList<IArchiver.File2Archive>();
        EnumSet<FileType> types2archive = this.types2ArchiveFromConfig();
        if (fileOrFolder.isFile()) {
            FileType fileType = this.archiverDispatcher.getFileType(messageInfo, fileOrFolder);
            if (isFailedMessage || types2archive.contains((Object)fileType)) {
                files2Archive.add(new IArchiver.File2Archive(fileOrFolder.getName(), fileType, new BufferedInputStream(Files.newInputStream(fileOrFolder.toPath(), new OpenOption[0]))));
            }
        } else {
            File[] files = fileOrFolder.listFiles();
            if (Objects.nonNull(files)) {
                for (File file : files) {
                    files2Archive.addAll(this.collectFiles2Archive(messageInfo, file, isFailedMessage));
                }
            }
        }
        return files2Archive;
    }

    private EnumSet<FileType> types2ArchiveFromConfig() {
        try {
            XpArchiveDto xpArchiveDto = this.configLoader.getXpArchiveDto();
            Set<XpMessagePart> messageParts = xpArchiveDto.getMessageParts();
            EnumSet enumSet = messageParts.stream().map(FileType::fromXpMessagePart).filter(Objects::nonNull).collect(Collectors.toCollection(() -> EnumSet.noneOf(FileType.class)));
            if (enumSet.contains((Object)FileType.PAYLOAD)) {
                enumSet.add(FileType.PAYLOAD_TECHNICAL);
            }
            return enumSet;
        }
        catch (JAXBException e) {
            LOG.error("Failed to load file types to archive from MessengerConfig", (Throwable)e);
            return EnumSet.allOf(FileType.class);
        }
    }

    public void shutdown() throws InterruptedException, ExecutionException {
        LOG.info("Start stopping ArchiveProcessor-Task");
        this.isRunning.set(false);
        this.wakeUpArchiveTask();
        for (Future<?> task : this.tasks) {
            if (task == null) continue;
            task.get();
        }
        LOG.info("ArchiveProcessor-Task is stopped.");
    }

    public long getQueueSize() {
        return this.archiveQueueDAO.getArchiveQueueSize();
    }
}

