/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.adapter;

import de.ponton.xmlpipe.queue.QueueMessageConsumer;
import de.pontonconsulting.xmlpipe.Util;
import de.pontonconsulting.xmlpipe.adapter.AdapterException;
import de.pontonconsulting.xmlpipe.adapter.AdapterInfo;
import de.pontonconsulting.xmlpipe.adapter.AgreementPartners;
import de.pontonconsulting.xmlpipe.adapter.ExtendedMessageResult;
import de.pontonconsulting.xmlpipe.adapter.IMessengerCommunication;
import de.pontonconsulting.xmlpipe.adapter.MaintenanceModeException;
import de.pontonconsulting.xmlpipe.adapter.MessageResult;
import de.pontonconsulting.xmlpipe.adapter.StatusResult;
import de.pontonconsulting.xmlpipe.config.IFolders;
import de.pontonconsulting.xmlpipe.message.BackEndMessage;
import de.pontonconsulting.xmlpipe.message.BackEndMessageException;
import de.pontonconsulting.xmlpipe.message.DimeMessage;
import de.pontonconsulting.xmlpipe.messenger.MaintenanceManager;
import de.pontonconsulting.xmlpipe.messenger.Messenger;
import de.pontonconsulting.xmlpipe.messenger.adapter.AdapterAccessException;
import de.pontonconsulting.xmlpipe.messenger.adapter.AdapterAccessFactory;
import de.pontonconsulting.xmlpipe.messenger.adapter.AdapterServiceException;
import de.pontonconsulting.xmlpipe.messenger.adapter.IAdapterAccess;
import de.pontonconsulting.xmlpipe.messenger.database.DbException;
import de.pontonconsulting.xmlpipe.messenger.database.tables.AdapterInfoDAO;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AdapterServlet
extends HttpServlet {
    public static final String RECEPTION_DISABLED = "ReceptionDisabled";
    public static final String ADAPTER_API_VERSION_UNKNOWN = "0.0.0";
    public static final String SUPPORTED_MIN_ADAPTER_API_VERSION = "3.2.27";
    public static final String NEW_ADAPTER_API_FROM_VERSION = "3.2.28";
    private static final long serialVersionUID = -7955426157844157391L;
    private static final Log _log = LogFactory.getFactory().getInstance("Messenger.AdapterServlet");
    private final IMessengerCommunication _communication;
    private final AdapterInfoDAO _adapterInfoDAO;
    private final IFolders _folders;
    private final MaintenanceManager _maintenanceManager;
    private final AdapterAccessFactory _adapterAccessFactory;
    private final QueueMessageConsumer inboundQueueMessageConsumer;
    private static final AtomicLong _transmissionId = new AtomicLong(0L);

    public AdapterServlet(IMessengerCommunication communication, AdapterInfoDAO adapterInfoDAO, IFolders folders, MaintenanceManager maintenanceManager, AdapterAccessFactory adapterAccessFactory, QueueMessageConsumer inboundQueueMessageConsumer) {
        this._communication = communication;
        this._adapterInfoDAO = adapterInfoDAO;
        this._folders = folders;
        this._maintenanceManager = maintenanceManager;
        this._adapterAccessFactory = adapterAccessFactory;
        this.inboundQueueMessageConsumer = inboundQueueMessageConsumer;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.checkPermission(request)) {
            response.sendError(403, "Access denied for this IP: " + request.getRemoteAddr());
            return;
        }
        String command = request.getHeader("X-COMMAND");
        if (command != null) {
            if (_log.isTraceEnabled()) {
                String adapterName = request.getHeader("X-AdapterId");
                _log.trace((Object)("received command: '" + command + "' from adapter '" + adapterName + "'"));
            }
            if (command.equals("Ping")) {
                this.pingPartner(request, response);
            } else if (command.equals("GetXml")) {
                this.getXml(request, response);
            } else if (command.equals("GetHtml")) {
                this.getHtml(request, response);
            } else if (command.equals("LocalStatusRequest")) {
                this.localStatusRequest(request, response);
            } else {
                response.sendError(404, "command not recognized");
            }
        } else {
            response.sendError(404, "command not recognized");
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            if (!this.checkPermission(request)) {
                MessageResult messageResult = new MessageResult(MessageResult.ADAPTER_SERVICE_COULD_NOT_BE_REACHED);
                messageResult.setDescription("Access denied for this IP: " + request.getRemoteAddr());
                this.sendResponse(messageResult, request, response);
                return;
            }
            String command = request.getHeader("X-COMMAND");
            if (command == null) {
                command = request.getParameter("X-COMMAND");
            }
            if (command != null && command.length() > 0) {
                if (_log.isTraceEnabled()) {
                    String adapterName = request.getHeader("X-AdapterId");
                    _log.trace((Object)("received command: '" + command + "' from adapter '" + adapterName + "'"));
                }
                if (command.equals("Register")) {
                    this.registerAdapter(request, response);
                } else if (command.equals("Unregister")) {
                    this.unregisterAdapter(request, response);
                } else if (command.equals("SendDocument")) {
                    this.sendOutboundDocument(request, response);
                } else if (command.equals("ArchiveDocument")) {
                    this.archiveDocument(request, response);
                } else if (command.equals("PartnerExists")) {
                    this.partnerExists(request, response);
                } else if (command.equals("GetFullPartnerList") || command.equals("GetLocalPartnerList") || command.equals("GetRemotePartnerList")) {
                    this.returnPartnerList(command, request, response);
                } else if (command.equals("GetAgreementPartnersList")) {
                    this.returnAgreementPartnersList(request, response);
                } else if (command.equals("GetSchemaSets")) {
                    this.returnSchemaSets(request, response);
                } else if (command.equals("Ping")) {
                    this.pingPartner(request, response);
                } else if (command.equals("StatusRequest")) {
                    this.sendStatusRequest(request, response);
                } else if (command.equals("CheckConnection")) {
                    this.checkConnection(request, response);
                } else {
                    this.sendResponse(new MessageResult(MessageResult.COMMAND_NOT_RECOGNIZED), request, response);
                }
            } else {
                this.sendResponse(new MessageResult(MessageResult.NO_COMMAND_SUPPLIED), request, response);
            }
        }
        catch (Exception e) {
            _log.error((Object)"internal error ", (Throwable)e);
            MessageResult result = new MessageResult(MessageResult.CUSTOM_ERROR);
            result.setDescription("internal error: " + e.getMessage());
            this.sendResponse(result, request, response);
        }
    }

    private void returnSchemaSets(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String adapterName = request.getHeader("X-AdapterId");
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Received schemasets request from adapter " + adapterName));
        }
        try {
            if (adapterName != null) {
                this.checkAdapterIdentification(request, adapterName, true);
            }
        }
        catch (AdapterException e) {
            _log.fatal((Object)("Could get schemasets: " + e.getMessage()));
            this.sendErrorMessageResult(MessageResult.ADAPTER_REGISTRY_COULD_NOT_BE_ACCESSED, request, response, e);
            return;
        }
        String localPartner = request.getHeader("X-SenderId");
        String remotePartner = request.getHeader("X-ReceiverId");
        try {
            String[] schemaSets;
            try {
                schemaSets = this._communication.getSchemaSets(localPartner, remotePartner);
            }
            catch (MaintenanceModeException e) {
                _log.error((Object)e.getMessage());
                this.sendErrorMessageResult(MessageResult.MAINTENANCE_MODE, request, response, (AdapterException)((Object)e));
                return;
            }
            for (int j = 0; j < schemaSets.length; ++j) {
                response.addHeader("X-SchemaSet" + j, schemaSets[j]);
            }
            if (_log.isTraceEnabled()) {
                _log.trace((Object)("found " + schemaSets.length + " schema sets."));
            }
            response.addHeader("NumberOfSchemaSets", String.valueOf(schemaSets.length));
            this.sendResponse(new MessageResult(MessageResult.PARTNERS_FOUND), request, response);
            if (_log.isTraceEnabled()) {
                _log.trace((Object)"Schema Set list sent to adapter via http.");
            }
        }
        catch (AdapterException e) {
            this.sendResponse(new MessageResult(MessageResult.PARTNER_STORE_COULD_NOT_BE_ACCESSED), request, response);
        }
    }

    private boolean checkPermission(HttpServletRequest request) {
        String remote = request.getRemoteAddr();
        if (_log.isTraceEnabled()) {
            _log.trace((Object)("HTTP Request from:" + remote));
        }
        String sname = request.getServerName();
        try {
            if ("127.0.0.1".equals(sname)) {
                _log.error((Object)"access to 127.0.0.1 is not allowed. use localhost instead.");
                throw new Exception();
            }
            return true;
        }
        catch (UnknownHostException un) {
            _log.warn((Object)("hostname couldnt be resolved. access denied: " + un.getMessage()));
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void init() {
    }

    private void pingPartner(HttpServletRequest request, HttpServletResponse response) throws IOException {
        MessageResult msgResult;
        String senderId = request.getHeader("X-SenderId");
        String receiverId = request.getHeader("X-ReceiverId");
        String adapterName = request.getHeader("X-AdapterId");
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Received ping request to partner: " + receiverId + " from adapter " + adapterName));
        }
        try {
            if (adapterName != null) {
                this.checkAdapterIdentification(request, adapterName, false);
            }
        }
        catch (AdapterException e) {
            _log.fatal((Object)("Could not ping partner: " + e.getMessage()));
            ExtendedMessageResult messageResult = this.createExtendedMessageResult(MessageResult.ADAPTER_REGISTRY_COULD_NOT_BE_ACCESSED, e.getMessage(), senderId, receiverId);
            messageResult.setDescription(e.getMessage());
            this.sendResponse((MessageResult)messageResult, request, response);
            return;
        }
        try {
            msgResult = this._communication.pingPartner(senderId, receiverId, adapterName);
        }
        catch (MaintenanceModeException e) {
            _log.error((Object)e.getMessage());
            response.addHeader("X-MaintenanceMode", "true");
            ExtendedMessageResult messageResult = this.createExtendedMessageResult(MessageResult.MAINTENANCE_MODE, e.getMessage(), senderId, receiverId);
            msgResult = messageResult;
        }
        catch (AdapterException e) {
            ExtendedMessageResult messageResult = this.createExtendedMessageResult(MessageResult.ADAPTER_REGISTRY_COULD_NOT_BE_ACCESSED, e.getMessage(), senderId, receiverId);
            msgResult = messageResult;
        }
        this.sendResponse(msgResult, request, response);
    }

    private void sendStatusRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        MessageResult msgResult;
        String senderId = request.getHeader("X-SenderId");
        String receiverId = request.getHeader("X-ReceiverId");
        String adapterName = request.getHeader("X-AdapterId");
        String referenceId = request.getHeader("X-ReferenceId");
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Status Request to partner: " + receiverId + " reference MSG: " + referenceId + " received from adapter " + adapterName));
        }
        try {
            if (adapterName != null) {
                this.checkAdapterIdentification(request, adapterName, false);
            }
        }
        catch (AdapterException e) {
            _log.fatal((Object)("Could not send status request: " + e.getMessage()));
            ExtendedMessageResult messageResult = this.createExtendedMessageResult(MessageResult.ADAPTER_REGISTRY_COULD_NOT_BE_ACCESSED, e.getMessage(), senderId, receiverId);
            this.sendResponse((MessageResult)messageResult, request, response);
            return;
        }
        try {
            msgResult = this._communication.sendStatusRequest(senderId, receiverId, referenceId, adapterName);
        }
        catch (MaintenanceModeException e) {
            _log.error((Object)e.getMessage());
            response.addHeader("X-MaintenanceMode", "true");
            ExtendedMessageResult messageResult = this.createExtendedMessageResult(MessageResult.MAINTENANCE_MODE, e.getMessage(), senderId, receiverId);
            msgResult = messageResult;
        }
        catch (AdapterException e) {
            ExtendedMessageResult messageResult = this.createExtendedMessageResult(MessageResult.ADAPTER_SERVICE_COULD_NOT_BE_REACHED, e.getMessage(), senderId, receiverId);
            msgResult = messageResult;
        }
        this.sendResponse(msgResult, request, response);
    }

    private void registerAdapter(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            String usedAdapterAPIVersion;
            boolean apiVersionIsSet;
            String adapterName = request.getHeader("X-AdapterId");
            AdapterInfo registeredAdapter = this._adapterInfoDAO.getAdapter(adapterName);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Adapter '" + adapterName + "' will be registered."));
            }
            boolean bl = apiVersionIsSet = !ADAPTER_API_VERSION_UNKNOWN.equals(usedAdapterAPIVersion = this.getAdapterAPIVersion(request));
            if (apiVersionIsSet && !this.isAdapterUsesSupportedAdapterAPI(usedAdapterAPIVersion)) {
                throw new AdapterException("Adapter " + adapterName + " uses adapter API version '" + usedAdapterAPIVersion + "' but the messenger supports at least adapter API version '3.2.27'.");
            }
            String adapterUrl = this.getAdapterURL(request);
            if (registeredAdapter == null || RECEPTION_DISABLED.equals(registeredAdapter.getAddress()) || this.similarURLs(registeredAdapter.getAddress(), adapterUrl)) {
                this.doRegisterAdapter(request);
            } else {
                IAdapterAccess adapterAccess = this._adapterAccessFactory.getAdapterAccess(registeredAdapter);
                try {
                    if (adapterAccess.isSelfCheckOk()) {
                        throw new AdapterException("Another adapter with the same AdapterId '" + adapterName + "' and different URL '" + registeredAdapter.getAddress() + "' is already registered and running.");
                    }
                    _log.info((Object)("Registering new Adapter with URL: '" + adapterUrl + "' and over writing old URL '" + registeredAdapter.getAddress() + "'."));
                    this.doRegisterAdapter(request);
                }
                catch (AdapterAccessException e) {
                    this.doRegisterAdapter(request);
                }
            }
            this.sendResponse(new MessageResult(MessageResult.ADAPTER_SUCCESSFULLY_REGISTERED), request, response);
        }
        catch (DbException e) {
            _log.fatal((Object)("Failed to re-register Adapter in Database: " + e.getMessage()));
            this.sendResponse(new MessageResult(MessageResult.ADAPTER_REGISTRY_COULD_NOT_BE_ACCESSED), request, response);
        }
        catch (AdapterException e) {
            _log.fatal((Object)("Could not register adapter: " + e.getMessage()));
            this.sendErrorMessageResult(MessageResult.ADAPTER_REGISTRY_COULD_NOT_BE_ACCESSED, request, response, e);
        }
    }

    private boolean similarURLs(String currentURL, String newURL) {
        if (StringUtils.isBlank((CharSequence)currentURL) || StringUtils.isBlank((CharSequence)newURL)) {
            return false;
        }
        try {
            URI currentURI = new URI(currentURL);
            URI newURI = new URI(newURL);
            return currentURI.getHost().equals(newURI.getHost()) && currentURI.getPort() == newURI.getPort();
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    private void checkAdapterIdentification(HttpServletRequest request, String adapterName, boolean continueOnError) throws AdapterException {
        boolean apiVersionIsSet;
        String usedAdapterAPIVersion = this.getAdapterAPIVersion(request);
        boolean bl = apiVersionIsSet = !ADAPTER_API_VERSION_UNKNOWN.equals(usedAdapterAPIVersion);
        if (apiVersionIsSet && !this.isAdapterUsesSupportedAdapterAPI(usedAdapterAPIVersion)) {
            throw new AdapterException("Adapter uses adapter API version '" + usedAdapterAPIVersion + "' but the messenger supports at least adapter API version '3.2.27'.");
        }
        AdapterInfo adapterInfo = this._adapterInfoDAO.getAdapter(adapterName);
        if (adapterInfo == null) {
            _log.warn((Object)("Adapter '" + adapterName + "' is not registered."));
        } else {
            String adapterUrl = this.getAdapterURL(request);
            if (adapterUrl.equals(adapterInfo.getAddress())) {
                adapterInfo.setIsDown(false);
            } else if (apiVersionIsSet || !continueOnError) {
                throw new AdapterException("Another adapter with the same AdapterId '" + adapterName + "' and different URL '" + adapterInfo.getAddress() + "' is already registered.");
            }
        }
    }

    private void drainInputStream(HttpServletRequest request) {
        try {
            ServletInputStream in = request.getInputStream();
            int len = 0;
            byte[] buffer = new byte[4096];
            while (len > -1) {
                len = in.read(buffer);
            }
        }
        catch (IOException e) {
            _log.warn((Object)("could not drain inputstream. " + String.valueOf(e)));
        }
    }

    private String getAdapterAPIVersion(HttpServletRequest request) {
        String adapterAPIVersion = request.getHeader("X-AdapterAPI-Version");
        if (adapterAPIVersion == null || adapterAPIVersion.length() == 0) {
            _log.warn((Object)"Adapter API version was not sent. Adapter has to update the used adapter API to the last version.");
            return ADAPTER_API_VERSION_UNKNOWN;
        }
        return adapterAPIVersion;
    }

    private boolean isAdapterUsesNewAdapterAPI(HttpServletRequest request) {
        String adapterAPIVersion = this.getAdapterAPIVersion(request);
        return this.isAdapterUsesNeededVersion(adapterAPIVersion, NEW_ADAPTER_API_FROM_VERSION);
    }

    private boolean isAdapterUsesSupportedAdapterAPI(String adapterAPIVersion) {
        return this.isAdapterUsesNeededVersion(adapterAPIVersion, SUPPORTED_MIN_ADAPTER_API_VERSION);
    }

    private boolean isAdapterUsesNeededVersion(String adapterAPIVersion, String minNeededVersion) {
        try {
            return Util.compareVersions(adapterAPIVersion, minNeededVersion) >= 0;
        }
        catch (Exception e) {
            _log.warn((Object)("The sent adapter API version '" + adapterAPIVersion + "' has wrong format: " + String.valueOf(e)));
            return false;
        }
    }

    private int parseHeaderWithDefaultValue(String header, int defaultValue) {
        try {
            return Integer.parseInt(header);
        }
        catch (NumberFormatException e) {
            _log.error((Object)("could not parse headerValue " + header + ": " + String.valueOf(e)));
            return defaultValue;
        }
    }

    private void doRegisterAdapter(HttpServletRequest request) throws DbException {
        String adapterName = request.getHeader("X-AdapterId");
        String adapterUrl = this.getAdapterURL(request);
        int maximumThreads = this.parseHeaderWithDefaultValue(request.getHeader("MaximumThreads"), 5);
        boolean supportsAcknowledgements = Boolean.parseBoolean(request.getHeader("SupportsAcknowledgements"));
        boolean supportsResponses = Boolean.parseBoolean(request.getHeader("SupportsResponses"));
        boolean supportsErrorNotifications = Boolean.parseBoolean(request.getHeader("SupportsErrorNotifications"));
        boolean supportsAttachments = Boolean.parseBoolean(request.getHeader("SupportsAttachments"));
        boolean acceeptsPartnerChangeEvents = Boolean.parseBoolean(request.getHeader("AcceptsPartnerChangeEvents"));
        boolean acceeptsPartnerCertificateChangeEvents = Boolean.parseBoolean(request.getHeader("AcceptsPartnerCertificateChangeEvents"));
        boolean acceeptsAgreementChangeEvents = Boolean.parseBoolean(request.getHeader("AcceptsPartnerAgreementEvents"));
        String processingTimeoutString = request.getHeader("X-ProcessingTimeout");
        int processingTimeout = this.parseHeaderWithDefaultValue(processingTimeoutString, 600);
        _log.info((Object)("Registering adapter: " + adapterName + " URL: " + adapterUrl + "  Maximum threads: " + maximumThreads + "; Supports acknowledgements: " + supportsAcknowledgements + "; Supports status responses: " + supportsResponses + "; Supports error notification: " + supportsErrorNotifications + "; Supports attachments: " + supportsAttachments + "; ProcessingTimeout: " + processingTimeout));
        AdapterInfo info = this._adapterInfoDAO.getAdapter(adapterName);
        if (info == null) {
            info = new AdapterInfo(adapterName, adapterUrl, processingTimeout);
        } else {
            info.setAddress(adapterUrl);
            _log.warn((Object)("Unregistering Adapter: " + adapterName));
            try {
                this._adapterInfoDAO.removeAdapter(adapterName);
            }
            catch (DbException e) {
                _log.error((Object)("Could not unregister Adapter: " + adapterName));
            }
        }
        info.setMaximumThreads(maximumThreads);
        info.setSupportsAcknowledgements(supportsAcknowledgements);
        info.setSupportsAttachments(supportsAttachments);
        info.setAcceptsAgreementChangeEvents(acceeptsAgreementChangeEvents);
        info.setAcceptsPartnerChangeEvents(acceeptsPartnerChangeEvents);
        info.setAcceptsPartnerCertificateChangeEvents(acceeptsPartnerCertificateChangeEvents);
        info.setSupportsStatusResponses(supportsResponses);
        info.setSupportsErrorNotification(supportsErrorNotifications);
        info.setProcessingTimeout(processingTimeout);
        this._adapterInfoDAO.addAdapter(info);
        _log.info((Object)("Adapter " + adapterName + " is registered."));
        this.inboundQueueMessageConsumer.wakeUp();
    }

    private String getAdapterURL(HttpServletRequest request) {
        String adapterUrl = request.getHeader("URL");
        if (adapterUrl == null || adapterUrl.length() == 0) {
            _log.debug((Object)"Adapter cannot accept inbound messages");
            adapterUrl = RECEPTION_DISABLED;
        }
        return adapterUrl;
    }

    private void unregisterAdapter(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (_log.isTraceEnabled()) {
            _log.trace((Object)"Adapter requested unregistration.");
        }
        String adapterName = request.getHeader("X-AdapterId");
        String adapterUrl = this.getAdapterURL(request);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Unregisting adapter: " + adapterName + " Address: " + adapterUrl));
        }
        try {
            if (adapterName != null) {
                this.checkAdapterIdentification(request, adapterName, true);
            }
        }
        catch (AdapterException e) {
            _log.fatal((Object)("Could not unregister adapter: " + e.getMessage()));
            this.sendErrorMessageResult(MessageResult.ADAPTER_REGISTRY_COULD_NOT_BE_ACCESSED, request, response, e);
            return;
        }
        try {
            this._adapterInfoDAO.removeAdapter(adapterName);
        }
        catch (DbException de) {
            _log.fatal((Object)"Adapter could not be unregistered in database", (Throwable)de);
            this.sendResponse(new MessageResult(MessageResult.ADAPTER_REGISTRY_COULD_NOT_BE_ACCESSED), request, response);
            return;
        }
        this.sendResponse(new MessageResult(MessageResult.ADAPTER_SUCCESSFULLY_UNREGISTERED), request, response);
    }

    private void partnerExists(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String partnerID = request.getHeader("PartnerID");
        String adapterName = request.getHeader("X-AdapterId");
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Received partner exists request from adapter " + adapterName));
        }
        try {
            if (adapterName != null) {
                this.checkAdapterIdentification(request, adapterName, true);
            }
        }
        catch (AdapterException e) {
            _log.fatal((Object)("Could not check whether partner is exist: " + e.getMessage()));
            this.sendErrorMessageResult(MessageResult.ADAPTER_REGISTRY_COULD_NOT_BE_ACCESSED, request, response, e);
            return;
        }
        try {
            boolean partnerExists = this._communication.partnerExists(partnerID);
            if (partnerExists) {
                this.sendResponse(new MessageResult(MessageResult.PARTNER_IS_KNOWN_AND_ENABLED), request, response);
            } else {
                this.sendResponse(new MessageResult(MessageResult.PARTNER_IS_NOT_KNOWN), request, response);
            }
        }
        catch (MaintenanceModeException e) {
            _log.error((Object)e.getMessage());
            this.sendErrorMessageResult(MessageResult.MAINTENANCE_MODE, request, response, (AdapterException)((Object)e));
        }
        catch (AdapterException psae) {
            this.sendResponse(new MessageResult(MessageResult.PARTNER_STORE_COULD_NOT_BE_ACCESSED), request, response);
        }
    }

    private void returnPartnerList(String command, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String adapterName = request.getHeader("X-AdapterId");
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Received partner list request from adapter " + adapterName));
        }
        try {
            if (adapterName != null) {
                this.checkAdapterIdentification(request, adapterName, true);
            }
        }
        catch (AdapterException e) {
            _log.fatal((Object)("Could not partner list: " + e.getMessage()));
            this.sendErrorMessageResult(MessageResult.ADAPTER_REGISTRY_COULD_NOT_BE_ACCESSED, request, response, e);
            return;
        }
        String[] partners = new String[]{};
        try {
            partners = command.equals("GetRemotePartnerList") ? this._communication.getRemotePartnerList() : (command.equals("GetLocalPartnerList") ? this._communication.getLocalPartnerList() : this._communication.getFullPartnerList());
        }
        catch (MaintenanceModeException e) {
            _log.error((Object)e.getMessage());
            response.addHeader("X-MaintenanceMode", "true");
        }
        catch (AdapterException e) {
            _log.error((Object)("Problem while getting partner list: " + e.getMessage()));
        }
        for (int j = 0; j < partners.length; ++j) {
            response.addHeader("PartnerID" + j, partners[j]);
        }
        if (_log.isTraceEnabled()) {
            _log.trace((Object)("Received " + partners.length + " partners."));
        }
        response.addHeader("NumberOfPartners", String.valueOf(partners.length));
        this.sendResponse(new MessageResult(MessageResult.PARTNERS_FOUND), request, response);
        if (_log.isTraceEnabled()) {
            _log.trace((Object)"Partner ID-list sent to adapter via http.");
        }
    }

    private void returnAgreementPartnersList(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String adapterName = request.getHeader("X-AdapterId");
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Received agreement list request from adapter " + adapterName));
        }
        try {
            if (adapterName != null) {
                this.checkAdapterIdentification(request, adapterName, true);
            }
        }
        catch (AdapterException e) {
            _log.fatal((Object)("Could get agreement list: " + e.getMessage()));
            this.sendErrorMessageResult(MessageResult.ADAPTER_REGISTRY_COULD_NOT_BE_ACCESSED, request, response, e);
            return;
        }
        try {
            AgreementPartners[] agreementPartners = this._communication.getAgreementPartnersList();
            for (int j = 0; j < agreementPartners.length; ++j) {
                AgreementPartners aPartners = agreementPartners[j];
                response.addHeader("LocalPartnerID" + j, aPartners.getLocalPartnerId());
                response.addHeader("RemotePartnerID" + j, aPartners.getRemotePartnerId());
            }
            if (_log.isTraceEnabled()) {
                _log.trace((Object)("Received " + agreementPartners.length + " agreements."));
            }
            response.addHeader("NumberOfAgreements", String.valueOf(agreementPartners.length));
            this.sendResponse(new MessageResult(MessageResult.PARTNERS_FOUND), request, response);
            if (_log.isTraceEnabled()) {
                _log.trace((Object)"Agreement partners list sent to adapter via http.");
            }
        }
        catch (MaintenanceModeException e) {
            _log.error((Object)e.getMessage());
            this.sendErrorMessageResult(MessageResult.ADAPTER_REGISTRY_COULD_NOT_BE_ACCESSED, request, response, (AdapterException)((Object)e));
        }
        catch (AdapterException psae) {
            this.sendResponse(new MessageResult(MessageResult.PARTNER_STORE_COULD_NOT_BE_ACCESSED), request, response);
        }
    }

    public static DimeMessage getDimeMessageProvider() {
        ServiceLoader<DimeMessage> serviceLoader = ServiceLoader.load(DimeMessage.class);
        DimeMessage dimeMessage = serviceLoader.findFirst().orElseThrow(() -> new IllegalStateException("No DimeMessage implementation found."));
        return dimeMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendOutboundDocument(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String adapterName = request.getHeader("X-AdapterId");
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Received send document request from adapter: " + adapterName));
        }
        ExtendedMessageResult result = null;
        File outboundMessageFolder = null;
        BackEndMessage beMessage = null;
        try {
            this.checkAdapterIdentification(request, adapterName, false);
            outboundMessageFolder = this.getNewTempFolder();
            ServletInputStream in = request.getInputStream();
            DimeMessage dimeMessage = AdapterServlet.getDimeMessageProvider();
            dimeMessage.init((InputStream)in, outboundMessageFolder);
            beMessage = this.storeMessage(dimeMessage);
            if (_log.isTraceEnabled()) {
                _log.trace((Object)("Data successfully received from adapter: " + adapterName));
            }
            result = this._communication.sendOutboundDocument(beMessage, adapterName);
        }
        catch (MaintenanceModeException e) {
            _log.error((Object)e.getMessage());
            response.addHeader("X-MaintenanceMode", "true");
            result = this.createExtendedMessageResult(MessageResult.MAINTENANCE_MODE, beMessage);
        }
        catch (AdapterServiceException ase) {
            _log.error((Object)"BackendMessage could no be reconstructed", (Throwable)ase);
            result = this.createExtendedMessageResult(MessageResult.BACKENDMSG_COULD_NOT_BE_RECONSTRUCTED, beMessage);
            result.appendToDescription((Throwable)ase);
        }
        catch (Exception e) {
            _log.error((Object)"BackendMessage could no be reconstructed", (Throwable)e);
            result = this.createExtendedMessageResult(MessageResult.BACKENDMSG_COULD_NOT_BE_RECONSTRUCTED, beMessage);
            result.appendToDescription((Throwable)e);
        }
        finally {
            if (outboundMessageFolder != null && outboundMessageFolder.exists()) {
                this.cleanupTempFolder(outboundMessageFolder);
            }
        }
        this.sendResponse((MessageResult)result, request, response);
    }

    private ExtendedMessageResult createExtendedMessageResult(MessageResult.MessageResultIdentifier resultIdentifier, String description, String senderId, String receiverId) {
        ExtendedMessageResult result = new ExtendedMessageResult(resultIdentifier);
        result.setDescription(description);
        result.setSenderId(senderId);
        result.setReceiverId(receiverId);
        return result;
    }

    private ExtendedMessageResult createExtendedMessageResult(MessageResult.MessageResultIdentifier resultIdentifier, BackEndMessage backEndMessage) {
        ExtendedMessageResult result = new ExtendedMessageResult(resultIdentifier);
        this.setMessageResult(result, backEndMessage);
        return result;
    }

    private void setMessageResult(ExtendedMessageResult result, BackEndMessage beMessage) {
        if (result != null && beMessage != null) {
            result.setMessageId(beMessage.getTransferIDText());
            result.setConversationId(beMessage.getConversationIDText());
            result.setMessageTime(String.valueOf(beMessage.getCreationTimestamp()));
            result.setMessageType(beMessage.getMessageName());
            result.setSchemaVersion(beMessage.getDTDVersionNumberText());
            result.setSchemaSet(beMessage.getDTDSetText());
            result.setProcessingDirectives((Map)beMessage.getProcessingDirectivesMap());
            result.setSenderId(beMessage.getSenderOrganisationText());
            result.setReceiverId(beMessage.getReceiverOrganisationText());
            result.setTestMessage("Test".equalsIgnoreCase(beMessage.getTestFlag()));
        }
    }

    private void cleanupTempFolder(File outboundMessageFolder) {
        if (outboundMessageFolder == null) {
            return;
        }
        if (!Messenger.isDevelopmentMode()) {
            if (!AdapterServlet.deleteDirectory(outboundMessageFolder)) {
                _log.warn((Object)("folder " + String.valueOf(outboundMessageFolder) + " was not successfully deleted."));
            }
        } else {
            _log.trace((Object)("folder " + String.valueOf(outboundMessageFolder) + " was not deleted due to development mode."));
        }
    }

    public static boolean deleteDirectory(File folder) {
        if (!folder.exists() || !folder.isDirectory()) {
            return false;
        }
        boolean allOk = true;
        File[] files = folder.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                if (AdapterServlet.deleteDirectory(file)) continue;
                allOk = false;
                continue;
            }
            if (file.delete()) continue;
            allOk = false;
        }
        if (!folder.delete()) {
            allOk = false;
        }
        return allOk;
    }

    private File getNewTempFolder() {
        long temporaryId = this.getNextTemporaryId();
        File outboundMessageFolder = new File(this._folders.getWorkOutboundFolder(), "a-" + temporaryId);
        if (outboundMessageFolder.exists()) {
            AdapterServlet.deleteDirectory(outboundMessageFolder);
        }
        outboundMessageFolder.mkdirs();
        return outboundMessageFolder;
    }

    public void destroy() {
        super.destroy();
        if (_log.isTraceEnabled()) {
            _log.trace((Object)"AdapterServlet shutting down");
        }
    }

    private void sendErrorMessageResult(MessageResult.MessageResultIdentifier messageResultIdentifier, HttpServletRequest request, HttpServletResponse response, AdapterException e) throws IOException {
        MessageResult messageResult = new MessageResult(messageResultIdentifier);
        messageResult.setDescription(e.getMessage());
        if (MessageResult.MAINTENANCE_MODE.equals(messageResultIdentifier)) {
            response.setHeader("X-MaintenanceMode", Boolean.TRUE.toString());
        }
        this.sendResponse(messageResult, request, response);
    }

    private void sendResponse(MessageResult messageResult, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.drainInputStream(request);
        if (this.isAdapterUsesNewAdapterAPI(request)) {
            Properties resultData = new Properties(){
                private static final long serialVersionUID = 1929415353117300891L;

                @Override
                public synchronized Enumeration<Object> keys() {
                    return Collections.enumeration(new TreeSet<Object>(this.keySet()));
                }
            };
            resultData.setProperty("result.xpCode", String.valueOf(messageResult.getXpCode()));
            if (StringUtils.isNotEmpty((CharSequence)messageResult.getDescription())) {
                resultData.setProperty("result.description", String.valueOf(messageResult.getDescription()));
            }
            if (StringUtils.isNotEmpty((CharSequence)messageResult.getMessageId())) {
                resultData.setProperty("result.messageId", messageResult.getMessageId());
            }
            if (StringUtils.isNotEmpty((CharSequence)messageResult.getConversationId())) {
                resultData.setProperty("result.conversationId", messageResult.getConversationId());
            }
            if (StringUtils.isNotEmpty((CharSequence)messageResult.getMessageType())) {
                resultData.setProperty("result.messageType", messageResult.getMessageType());
            }
            if (StringUtils.isNotEmpty((CharSequence)messageResult.getSchemaVersion())) {
                resultData.setProperty("result.schemaVersion", messageResult.getSchemaVersion());
            }
            if (StringUtils.isNotEmpty((CharSequence)messageResult.getSchemaSet())) {
                resultData.setProperty("result.schemaSet", messageResult.getSchemaSet());
            }
            if (StringUtils.isNotEmpty((CharSequence)messageResult.getMessageTime())) {
                resultData.setProperty("result.messageTime", messageResult.getMessageTime());
            }
            if (StringUtils.isNotEmpty((CharSequence)messageResult.getTransmissionProtocol())) {
                resultData.setProperty("result.transmissionProtocol", messageResult.getTransmissionProtocol());
            }
            if (messageResult instanceof ExtendedMessageResult) {
                ExtendedMessageResult extendedMessageResult = (ExtendedMessageResult)messageResult;
                if (extendedMessageResult.getSenderId() != null) {
                    resultData.setProperty("result.senderId", extendedMessageResult.getSenderId());
                }
                if (extendedMessageResult.getReceiverId() != null) {
                    resultData.setProperty("result.receiverId", extendedMessageResult.getReceiverId());
                }
                resultData.setProperty("result.testMessage", Boolean.toString(extendedMessageResult.isTestMessage()));
                Map processingDirectives = extendedMessageResult.getProcessingDirectives();
                if (processingDirectives != null && !processingDirectives.isEmpty()) {
                    int i = 0;
                    for (Map.Entry entry : processingDirectives.entrySet()) {
                        resultData.setProperty("result.processingDirective" + ++i + ".key", (String)entry.getKey());
                        resultData.setProperty("result.processingDirective" + i + ".value", (String)entry.getValue());
                    }
                }
            }
            ByteArrayOutputStream resultOutputStream = new ByteArrayOutputStream();
            resultData.store(resultOutputStream, "Generated by Ponton X/P");
            byte[] body = resultOutputStream.toByteArray();
            response.setStatus(messageResult.getHttpCode());
            response.setContentType("text/plain");
            response.setCharacterEncoding("ISO-8859-1");
            response.setContentLength(body.length);
            response.setHeader("Content-Transfer-Encoding", "binary");
            response.setHeader("X-ExtendedResultData", Boolean.TRUE.toString());
            response.getOutputStream().write(body);
        } else {
            this.sendLegacyMessageResult(messageResult, response);
        }
    }

    private void sendLegacyMessageResult(MessageResult messageResult, HttpServletResponse response) throws IOException {
        if (messageResult.getMessageId() != null && messageResult.getMessageId().length() > 0) {
            response.setHeader("X-MessageId", messageResult.getMessageId());
        }
        if (messageResult.getConversationId() != null) {
            response.setHeader("X-ConversationId", messageResult.getConversationId());
        }
        if (messageResult.getMessageType() != null) {
            response.setHeader("X-MessageType", messageResult.getMessageType());
        }
        if (messageResult.getSchemaVersion() != null) {
            response.setHeader("X-SchemaVersion", messageResult.getSchemaVersion());
        }
        if (messageResult.getSchemaSet() != null) {
            response.setHeader("X-SchemaSet", messageResult.getSchemaSet());
        }
        if (messageResult.getMessageTime() != null) {
            response.setHeader("X-MessageTime", messageResult.getMessageTime());
        }
        if (messageResult.getTransmissionProtocol() != null) {
            response.setHeader("X-TransmissionProtocol", messageResult.getTransmissionProtocol());
        }
        response.setHeader("XPMessageResultCode", String.valueOf(messageResult.getXpCode()));
        response.sendError(messageResult.getHttpCode(), messageResult.getDescription());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void archiveDocument(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String adapterName = request.getHeader("X-AdapterId");
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Received archive document request from adapter: " + adapterName));
        }
        ExtendedMessageResult result = null;
        File outboundMessageFolder = null;
        BackEndMessage beMessage = null;
        try {
            this.checkAdapterIdentification(request, adapterName, false);
            outboundMessageFolder = this.getNewTempFolder();
            ServletInputStream in = request.getInputStream();
            DimeMessage dimeMessage = AdapterServlet.getDimeMessageProvider();
            dimeMessage.init((InputStream)in, outboundMessageFolder);
            beMessage = this.storeMessage(dimeMessage);
            if (_log.isTraceEnabled()) {
                _log.trace((Object)("Data successfully received from adapter: " + adapterName));
            }
            result = this._communication.archiveDocument(beMessage, adapterName);
        }
        catch (MaintenanceModeException e) {
            _log.error((Object)e.getMessage());
            response.addHeader("X-MaintenanceMode", "true");
            result = this.createExtendedMessageResult(MessageResult.MAINTENANCE_MODE, beMessage);
        }
        catch (AdapterServiceException ase) {
            result = this.createExtendedMessageResult(MessageResult.BACKENDMSG_COULD_NOT_BE_RECONSTRUCTED, beMessage);
            result.appendToDescription((Throwable)ase);
        }
        catch (Exception e) {
            _log.error((Object)"BackendMessage could no be reconstructed", (Throwable)e);
            result = this.createExtendedMessageResult(MessageResult.BACKENDMSG_COULD_NOT_BE_RECONSTRUCTED, beMessage);
            result.appendToDescription((Throwable)e);
        }
        finally {
            if (outboundMessageFolder != null && outboundMessageFolder.exists()) {
                this.cleanupTempFolder(outboundMessageFolder);
            }
        }
        this.sendResponse((MessageResult)result, request, response);
    }

    private BackEndMessage storeMessage(DimeMessage dime) throws IOException, AdapterServiceException {
        try {
            BackEndMessage beMessage = dime.getBackEndMessage();
            return beMessage;
        }
        catch (BackEndMessageException bme) {
            _log.fatal((Object)"Could not construct BackEndMessage.", (Throwable)bme);
            throw new AdapterServiceException(11002, "Could not construct BackEndMessage.", bme);
        }
    }

    private long getNextTemporaryId() {
        return _transmissionId.incrementAndGet();
    }

    private void checkConnection(HttpServletRequest request, HttpServletResponse response) {
        String adapterName = request.getHeader("X-AdapterId");
        if (_log.isTraceEnabled()) {
            _log.trace((Object)("Received checkConnection request from adapter: " + adapterName));
        }
        response.setStatus(200);
    }

    private void localStatusRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String messageId = request.getHeader("X-MessageId");
        String adapterId = request.getHeader("X-AdapterId");
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Received local status request for message " + messageId + " from adapter " + adapterId));
        }
        try {
            if (adapterId != null) {
                this.checkAdapterIdentification(request, adapterId, true);
            }
        }
        catch (AdapterException e) {
            _log.fatal((Object)("Could not get local status: " + e.getMessage()));
            this.sendErrorMessageResult(MessageResult.ADAPTER_REGISTRY_COULD_NOT_BE_ACCESSED, request, response, e);
            return;
        }
        try {
            StatusResult result = this._communication.sendLocalStatusRequest(messageId, adapterId);
            response.addHeader("XPMessageResultCode", String.valueOf(result.getStatus()));
            response.setStatus(200);
        }
        catch (AdapterException e) {
            response.sendError(500, "Message couldn't be read: " + String.valueOf((Object)e));
        }
    }

    private void getXml(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String messageId = request.getHeader("X-MessageId");
        String adapterName = request.getHeader("X-AdapterId");
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Received get XML request from adapter " + adapterName));
        }
        try {
            if (adapterName != null) {
                this.checkAdapterIdentification(request, adapterName, true);
            }
        }
        catch (AdapterException e) {
            _log.fatal((Object)("Could not get XML: " + e.getMessage()));
            this.sendErrorMessageResult(MessageResult.ADAPTER_REGISTRY_COULD_NOT_BE_ACCESSED, request, response, e);
            return;
        }
        if (messageId == null || messageId.length() == 0) {
            response.sendError(400, "No message id supplied");
        }
        ServletOutputStream out = response.getOutputStream();
        try {
            this._communication.writeXmlDocumentTo(messageId, (OutputStream)out);
            response.setStatus(200);
        }
        catch (MaintenanceModeException e) {
            _log.error((Object)e.getMessage());
            this.sendErrorMessageResult(MessageResult.MAINTENANCE_MODE, request, response, (AdapterException)((Object)e));
        }
        catch (AdapterException e) {
            response.sendError(500, "Message couldn't be read: " + String.valueOf((Object)e));
        }
    }

    private void getHtml(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String messageId = request.getHeader("X-MessageId");
        String adapterName = request.getHeader("X-AdapterId");
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Received get HTML request from adapter " + adapterName));
        }
        try {
            if (adapterName != null) {
                this.checkAdapterIdentification(request, adapterName, true);
            }
        }
        catch (AdapterException e) {
            _log.fatal((Object)("Could not get HTML: " + e.getMessage()));
            this.sendErrorMessageResult(MessageResult.ADAPTER_REGISTRY_COULD_NOT_BE_ACCESSED, request, response, e);
            return;
        }
        if (messageId == null || messageId.length() == 0) {
            response.sendError(400, "No message id supplied");
        }
        ServletOutputStream out = response.getOutputStream();
        try {
            this._communication.writeHtmlDocumentTo(messageId, (OutputStream)out);
            response.setStatus(200);
        }
        catch (AdapterException e) {
            if (e instanceof MaintenanceModeException) {
                _log.error((Object)e.getMessage());
                this.sendErrorMessageResult(MessageResult.MAINTENANCE_MODE, request, response, e);
                return;
            }
            response.sendError(500, "Message couldn't be read: " + String.valueOf((Object)e));
        }
    }
}

