/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger;

import de.pontonconsulting.xmlpipe.config.DistributionConfigFinder;
import de.pontonconsulting.xmlpipe.messenger.IPipelineFactory;
import de.pontonconsulting.xmlpipe.messenger.Pipeline;
import de.pontonconsulting.xmlpipe.messenger.database.tables.FileRefDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageDAO;
import de.pontonconsulting.xmlpipe.messenger.filter.BaseFilter;
import de.pontonconsulting.xmlpipe.messenger.filter.IFilterPlugin;
import de.pontonconsulting.xmlpipe.uioption.UIOption;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;

public class PipelineFactory
implements IPipelineFactory {
    protected static final Log LOG = LogFactory.getFactory().getInstance("Messenger.PipelineFactory");
    private final HashMap<String, Pipeline> _inboundPipes = new HashMap();
    private final HashMap<String, Pipeline> _outboundPipes = new HashMap();
    private final HashMap<String, UIOption[]> _pipelineOptions = new HashMap();
    private final FileRefDAO _fileRefDAO;
    private final MessageDAO messageDAO;
    private final DistributionConfigFinder _distributionConfigFinder;
    private final ApplicationContext _applicationContext;

    public PipelineFactory(FileRefDAO fileRefDAO, MessageDAO messageDAO, DistributionConfigFinder distributionConfigFinder, ApplicationContext applicationContext) {
        this._fileRefDAO = fileRefDAO;
        this.messageDAO = messageDAO;
        this._distributionConfigFinder = distributionConfigFinder;
        this._applicationContext = applicationContext;
    }

    @Override
    @PostConstruct
    public void initialize() throws Exception {
        try {
            LOG.info((Object)"Setting up inbound processing pipelines");
            Map<String, String[]> configInbound = this._distributionConfigFinder.getInboundPipes();
            this.setupProcessingPipes(configInbound, this._inboundPipes);
            LOG.info((Object)"Setting up outbound processing pipelines");
            Map<String, String[]> configOutbound = this._distributionConfigFinder.getOutboundPipes();
            this.setupProcessingPipes(configOutbound, this._outboundPipes);
            LOG.info((Object)"Getting available options from pipelines");
            this.setupPipelineOptions();
        }
        catch (Exception e) {
            LOG.error((Object)("Could not set up Pipelines:" + String.valueOf(e)));
            throw e;
        }
    }

    private void setupProcessingPipes(Map<String, String[]> pipelineConfig, Map<String, Pipeline> pipelineStore) {
        for (String name : pipelineConfig.keySet()) {
            String[] filters = pipelineConfig.get(name);
            Pipeline pipeline = new Pipeline(name, this._applicationContext, filters, this._fileRefDAO, this.messageDAO);
            pipeline.init();
            pipelineStore.put(name, pipeline);
        }
    }

    private void setupPipelineOptions() {
        HashMap<String, BaseFilter<IFilterPlugin>> filters;
        Pipeline pipeline;
        HashMap pipelineFilters = new HashMap();
        for (String pipelineName : this._inboundPipes.keySet()) {
            pipeline = this._inboundPipes.get(pipelineName);
            filters = (HashMap<String, BaseFilter<IFilterPlugin>>)pipelineFilters.get(pipelineName);
            if (filters == null) {
                filters = new HashMap<String, BaseFilter<IFilterPlugin>>();
            }
            for (BaseFilter<IFilterPlugin> filter : pipeline.getFilters()) {
                if (filters.containsKey(filter.getClass().getName())) continue;
                filters.put(filter.getClass().getName(), filter);
            }
            pipelineFilters.put(pipelineName, filters);
        }
        for (String pipelineName : this._outboundPipes.keySet()) {
            pipeline = this._outboundPipes.get(pipelineName);
            filters = (HashMap<String, BaseFilter<IFilterPlugin>>)pipelineFilters.get(pipelineName);
            if (filters == null) {
                filters = new HashMap<String, BaseFilter<IFilterPlugin>>();
            }
            for (BaseFilter<IFilterPlugin> filter : pipeline.getFilters()) {
                if (filters.containsKey(filter.getClass().getName())) continue;
                filters.put(filter.getClass().getName(), filter);
            }
            pipelineFilters.put(pipelineName, filters);
        }
        for (String pipelineName : pipelineFilters.keySet()) {
            ArrayList<UIOption> options = new ArrayList<UIOption>();
            filters = (HashMap)pipelineFilters.get(pipelineName);
            for (BaseFilter<IFilterPlugin> filter : filters.values()) {
                try {
                    UIOption[] filterOptions = filter.getUIOptions();
                    for (int i = 0; i < filterOptions.length; ++i) {
                        options.add(filterOptions[i]);
                    }
                }
                catch (Exception exception) {
                }
            }
            this._pipelineOptions.put(pipelineName, options.toArray(new UIOption[options.size()]));
        }
    }

    @Override
    public Pipeline getOutboundPipeline(String name) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Pipeline pipeline = this._outboundPipes.get(name);
        if (pipeline == null) {
            throw new InstantiationException("Pipline with Id:" + name + " does not exist");
        }
        return pipeline;
    }

    @Override
    public Pipeline getInboundPipeline(String name) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Pipeline pipeline = this._inboundPipes.get(name);
        if (pipeline == null) {
            throw new InstantiationException("Pipline with Id:" + name + " does not exist");
        }
        return pipeline;
    }

    @Override
    public String[] getPipelineIds() {
        String[] result = null;
        if (this._pipelineOptions != null) {
            result = this._pipelineOptions.keySet().toArray(new String[this._pipelineOptions.keySet().size()]);
        }
        return result;
    }

    @Override
    public UIOption[] getPipelineOptions(String pipelineId) {
        try {
            return UIOption.clone(this._pipelineOptions.get(pipelineId));
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

