/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger;

import de.ponton.xmlpipe.queue.OutboundQueue;
import de.pontonconsulting.xmlpipe.config.IFolders;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.cpa.Agreement;
import de.pontonconsulting.xmlpipe.cpa.AgreementException;
import de.pontonconsulting.xmlpipe.cpa.AgreementNotFoundException;
import de.pontonconsulting.xmlpipe.cpa.Agreements;
import de.pontonconsulting.xmlpipe.cpa.CommunicationNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.IdGenerator;
import de.pontonconsulting.xmlpipe.messenger.ProcessingResult;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.database.MessageInfo;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.messenger.packaging.BasePackager;
import de.pontonconsulting.xmlpipe.messenger.packaging.IPackagingManager;
import java.io.File;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AsyncResponseManager {
    public static final Logger _log = LogManager.getLogger((String)"Messenger.AsyncResponse");
    private final IPackagingManager _packagingManager;
    private final OutboundQueue _outboundMessageQueue;
    private final MessageDAO _messageDAO;
    private final MessengerLog _messengerLog;
    private final Agreements _agreements;
    private final Profiles _profiles;
    private final ReferenceDateTask _referenceDate;
    private final IFolders _folders;
    private final IdGenerator _idGenerator;
    private final MessengerConfig messengerConfig;

    public AsyncResponseManager(IPackagingManager packagingManager, OutboundQueue outboundMessageQueue, MessageDAO messageDAO, MessengerLog messengerLog, Agreements agreements, Profiles profiles, ReferenceDateTask referenceDate, IFolders folders, IdGenerator idGenerator, MessengerConfig messengerConfig) {
        this._packagingManager = packagingManager;
        this._outboundMessageQueue = outboundMessageQueue;
        this._messageDAO = messageDAO;
        this._messengerLog = messengerLog;
        this._agreements = agreements;
        this._profiles = profiles;
        this._referenceDate = referenceDate;
        this._folders = folders;
        this._idGenerator = idGenerator;
        this.messengerConfig = messengerConfig;
    }

    public void sendAsyncResponse(List<ProcessingResult> result, MessageInfo messageInfo) {
        XpMessage xpResponse = null;
        try {
            xpResponse = this.createXpResponse(messageInfo);
            this._messageDAO.registerMessage(xpResponse);
            File folder = new File(this._folders.getWorkOutboundFolder(), String.valueOf(xpResponse.getDatabaseId()));
            folder.mkdirs();
            xpResponse.setCurrentContentReferenceFolder(folder);
            this._messageDAO.updateMessageFolder(xpResponse.getDatabaseId(), folder);
            String packagingId = messageInfo.getPackagingId();
            BasePackager packager = this._packagingManager.getPackager(packagingId);
            if (this.isOK(result)) {
                this._messengerLog.log2dbWithHref(2, messageInfo.getDatabaseId(), xpResponse.getMessageId(), xpResponse.getMessageId(), xpResponse.getDatabaseId(), false);
                xpResponse = packager.createAsyncAck(result, xpResponse, messageInfo.isSignedAckRequested());
            } else {
                this._messengerLog.log2dbWithHref(7, messageInfo.getDatabaseId(), xpResponse.getMessageId(), xpResponse.getMessageId(), xpResponse.getDatabaseId(), false);
                xpResponse = packager.createErrorResponse(result, xpResponse, messageInfo.isSignedAckRequested());
            }
            xpResponse.setPackaged(true);
            String destinationURL = xpResponse.getCommunication().getTransportURL();
            xpResponse.setDestinationUrl(destinationURL);
            this._outboundMessageQueue.deliverMessageToPartner(xpResponse);
            _log.info("Async response created");
        }
        catch (Exception e) {
            this._messengerLog.log2db(522, messageInfo.getDatabaseId(), "ACK could not be created: " + e.getMessage());
            if (xpResponse != null) {
                this._messengerLog.log2db(522, xpResponse.getDatabaseId(), "ACK could not be created: " + e.getMessage());
                this._messageDAO.updateMessageStatus(xpResponse.getDatabaseId(), xpResponse.getMessageId(), 4);
            }
            _log.error("Async response could not be created: {}", (Object)e.getMessage());
        }
    }

    private boolean isOK(List<ProcessingResult> result) {
        boolean isOK = false;
        if (result != null) {
            for (ProcessingResult procResult : result) {
                if (procResult.getResultCode() != 0) continue;
                isOK = true;
                break;
            }
        }
        return isOK;
    }

    private XpMessage createXpResponse(MessageInfo messageInfo) throws AgreementNotFoundException, CommunicationNotFoundException, ProfileException, AgreementException {
        XpMessage xpResponse = new XpMessage();
        xpResponse.setMessageId(this._idGenerator.generateMessageId());
        xpResponse.setConversationDatabaseId(messageInfo.getConversationDatabaseId());
        xpResponse.setConversationId(messageInfo.getConversationId());
        xpResponse.setMessageTimestamp(this._referenceDate.getReferenceDate());
        xpResponse.setMessengerId(this.messengerConfig.getMessengerId());
        xpResponse.setReferenceDatabaseId(messageInfo.getDatabaseId());
        xpResponse.setReferenceId(messageInfo.getMessageId());
        xpResponse.setSenderLocalId(messageInfo.getReceiverId());
        xpResponse.setReceiverLocalId(messageInfo.getSenderId());
        Agreement agreement = this._agreements.getAgreement(xpResponse.getSenderLocalId(), xpResponse.getReceiverLocalId(), true);
        xpResponse.setAgreement(agreement);
        xpResponse.setOwnPartner(this._profiles.getProfileForLocalId(agreement.getOwnPartner().getId(), true));
        xpResponse.setCommunicationPartner(this._profiles.getProfileForLocalId(agreement.getCommunicationPartner().getId(), true));
        xpResponse.setCommunication(xpResponse.getAgreement().getCommunication(xpResponse.getSenderLocalId(), xpResponse.getReceiverLocalId()));
        xpResponse.setInboundMessage(false);
        xpResponse.setIsAck(true);
        xpResponse.setMessagePackaging(messageInfo.getPackagingId());
        xpResponse.setProtocol(messageInfo.getProtocol());
        xpResponse.setMessageType("ACK");
        xpResponse.setSchemaSet("ponton");
        xpResponse.setMessageVersion("2.1");
        return xpResponse;
    }
}

