/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.message.identification;

import de.pontonconsulting.common.io.UTF8BOMSkippingInputStream;
import de.pontonconsulting.xmlpipe.cp.DocumentType;
import de.pontonconsulting.xmlpipe.message.PayloadRecognizer;
import de.pontonconsulting.xmlpipe.message.StAXXPath;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public abstract class WrappedDocumentRecognizer {
    protected PayloadRecognizer _recognizer;

    public abstract List<DocumentType> getDocumentType(StAXXPath var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DocumentType> recognizeMessage(File file, List<String> xpaths, PayloadRecognizer recognizer) {
        this._recognizer = recognizer;
        List<DocumentType> result = null;
        XMLStreamReader reader = null;
        UTF8BOMSkippingInputStream in = null;
        ArrayList<StAXXPath> staxXPaths = new ArrayList<StAXXPath>();
        for (String xpathString : xpaths) {
            staxXPaths.add(new StAXXPath(xpathString));
        }
        try {
            in = new UTF8BOMSkippingInputStream(new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]), 16384));
            XMLInputFactory f = XMLInputFactory.newInstance();
            f.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
            f.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
            reader = f.createXMLStreamReader(in);
            ArrayList<Object> xpath = new ArrayList<Object>();
            Object currentXPath = "";
            int xpathLevel = 0;
            xpath.add(0, currentXPath);
            while (reader.hasNext() && result == null) {
                switch (reader.getEventType()) {
                    case 1: {
                        currentXPath = (String)xpath.get(xpathLevel) + "/" + reader.getName().getLocalPart();
                        xpath.add(++xpathLevel, currentXPath);
                        for (StAXXPath staxXPath : staxXPaths) {
                            staxXPath.handleStartElement(reader, xpathLevel, (String)currentXPath);
                        }
                        break;
                    }
                    case 2: {
                        for (StAXXPath staxXPath : staxXPaths) {
                            staxXPath.handleEndElement(xpathLevel);
                        }
                        --xpathLevel;
                        break;
                    }
                    case 6: {
                        break;
                    }
                    case 4: {
                        for (StAXXPath staxXPath : staxXPaths) {
                            staxXPath.handleText(reader);
                        }
                        break;
                    }
                }
                reader.next();
                for (StAXXPath staxXPath : staxXPaths) {
                    if (staxXPath.getQName() == null || result != null) continue;
                    result = this.getDocumentType(staxXPath);
                }
            }
        }
        catch (XMLStreamException xMLStreamException) {
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception exception) {}
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
        return result;
    }
}

