/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.message;

import de.pontonconsulting.xmlpipe.config.ConfigResourceService;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class XslResolver
implements URIResolver {
    private static final Logger LOG = LogManager.getLogger((String)"Messenger.XslResolver");
    private final ConfigResourceService configResourceService;
    private final String xslFolder;

    public XslResolver(ConfigResourceService configResourceService, String xslFolder) {
        this.configResourceService = configResourceService;
        this.xslFolder = xslFolder;
    }

    @Override
    public Source resolve(String href, String base) throws TransformerException {
        StreamSource streamSource;
        block8: {
            LOG.trace("href:" + href + " base: " + base);
            InputStream resourceAsStream = this.configResourceService.getResource(this.xslFolder + "/" + href).getValue();
            try {
                streamSource = new StreamSource(resourceAsStream);
                if (resourceAsStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (resourceAsStream != null) {
                        try {
                            resourceAsStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.error("could not resolve XSL resource " + this.xslFolder + "/" + href + " base:" + base);
                    throw new TransformerException(e);
                }
            }
            resourceAsStream.close();
        }
        return streamSource;
    }
}

