/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.message;

import de.pontonconsulting.xmlpipe.config.MultipleSchemaSetFoundException;
import de.pontonconsulting.xmlpipe.config.SchemaData;
import de.pontonconsulting.xmlpipe.config.SchemataConfig;
import de.pontonconsulting.xmlpipe.config.schemaset.SchemaSet;
import de.pontonconsulting.xmlpipe.cp.AdditionalSchema;
import de.pontonconsulting.xmlpipe.cp.DocumentType;
import de.pontonconsulting.xmlpipe.message.EdifactMessage;
import de.pontonconsulting.xmlpipe.message.X12Message;
import de.pontonconsulting.xmlpipe.message.identification.WrappedDocumentByNamespaceRecognizer;
import de.pontonconsulting.xmlpipe.messenger.XmlMetaData;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;

public class PayloadRecognizer {
    private static final Logger LOG = LogManager.getLogger((String)"Messenger.PayloadRecognizer");
    private static final char TAB = '\t';
    private final HashMap<String, DocumentType> _typeVersionLookup;
    private final HashMap<String, DocumentType> _typeVersionSchemaSetLookup;
    private final HashMap<String, DocumentType> _typeLookup;
    private final HashMap<String, DocumentType> _schemalocationLookup;
    private final HashMap<String, DocumentType> _schemalocationIgnoreCaseLookup;
    private final HashMap<String, DocumentType> _dtdLookup;
    private final HashMap<String, DocumentType> _dtdIgnoreCaseLookup;
    private final HashMap<String, List<DocumentType>> _namespaceLookup;
    private final List<DocumentType> _documentTypes = new ArrayList<DocumentType>();
    private final SchemataConfig _schemataConfig;

    public PayloadRecognizer(SchemataConfig schemataConfig) {
        this(PayloadRecognizer.getAllDocumentTypes(schemataConfig), schemataConfig);
    }

    public PayloadRecognizer(List<DocumentType> documentTypes, SchemataConfig schemataConfig) {
        this._schemataConfig = schemataConfig;
        this._documentTypes.addAll(documentTypes);
        this.addInternalSchemaSetsToDocumentTypes();
        this._typeVersionSchemaSetLookup = new HashMap();
        this._typeVersionLookup = new HashMap();
        this._typeLookup = new HashMap();
        this._schemalocationLookup = new HashMap();
        this._schemalocationIgnoreCaseLookup = new HashMap();
        this._dtdLookup = new HashMap();
        this._dtdIgnoreCaseLookup = new HashMap();
        this._namespaceLookup = new HashMap();
        ArrayList<String> schemaLocationBlackList = new ArrayList<String>();
        String[] schemaLocations = new String[this._documentTypes.size()];
        int i = 0;
        for (DocumentType type : this._documentTypes) {
            schemaLocations[i] = type.getSchemalocation();
            this._typeVersionLookup.put(this.buildTypeVersionId(type.getType(), type.getVersion()), type);
            this._typeVersionSchemaSetLookup.put(this.buildTypeVersionSchemasetId(type.getType(), type.getVersion(), type.getSchemaSet()), type);
            DocumentType old = this._typeLookup.get(type.getType());
            if (old == null || old.getVersion().toLowerCase().compareTo(type.getVersion().toLowerCase()) < 0) {
                this._typeLookup.put(type.getType(), type);
            }
            if (!schemaLocationBlackList.contains(type.getSchemalocation())) {
                if (this._schemalocationLookup.containsKey(type.getSchemalocation())) {
                    this._schemalocationLookup.remove(type.getSchemalocation());
                    this._schemalocationIgnoreCaseLookup.remove(type.getSchemalocation().toLowerCase());
                    schemaLocationBlackList.add(type.getSchemalocation());
                } else {
                    this._schemalocationLookup.put(type.getSchemalocation(), type);
                    this._schemalocationIgnoreCaseLookup.put(type.getSchemalocation().toLowerCase(), type);
                }
            }
            if (type.getDtd() != null && !type.getDtd().isEmpty()) {
                this._dtdLookup.put(type.getDtd(), type);
                this._dtdIgnoreCaseLookup.put(type.getDtd().toLowerCase(), type);
            }
            this._namespaceLookup.computeIfAbsent(type.getNamespace(), k -> new ArrayList()).add(type);
            ++i;
        }
    }

    private void addInternalSchemaSetsToDocumentTypes() {
        List<String> internalSchemaSets = this._schemataConfig.getInternalSchemaSetNames();
        for (String name : internalSchemaSets) {
            SchemaSet.Schema[] schemaTypesFor;
            for (SchemaSet.Schema schema : schemaTypesFor = this._schemataConfig.getSchemaTypesFor(name)) {
                this._documentTypes.add(new DocumentType(schema.getMessageType(), schema.getMessageVersion(), schema.getNamespace(), schema.getName(), name, schema.getSchemaFile(), schema.getRootElement()));
            }
        }
    }

    private static List<DocumentType> getAllDocumentTypes(SchemataConfig schemataConfig) {
        ArrayList<DocumentType> documentTypes = new ArrayList<DocumentType>();
        for (String name : schemataConfig.getSchemaSetNames()) {
            SchemaSet.Schema[] schemaTypesFor;
            for (SchemaSet.Schema schema : schemaTypesFor = schemataConfig.getSchemaTypesFor(name)) {
                documentTypes.add(new DocumentType(schema.getMessageType(), schema.getMessageVersion(), schema.getNamespace(), schema.getName(), name, schema.getSchemaFile(), schema.getRootElement()));
            }
        }
        return documentTypes;
    }

    public DocumentType getDocumentType(String type, String version) {
        if (version == null || version.isEmpty() || version.equals("*")) {
            return this._typeLookup.get(type);
        }
        return this._typeVersionLookup.get(this.buildTypeVersionId(type, version));
    }

    private DocumentType getDocumentTypeFromSchemalocation(String schemalocation) {
        if (schemalocation == null || schemalocation.isEmpty()) {
            return null;
        }
        return this._schemalocationLookup.get(schemalocation);
    }

    private DocumentType getDocumentTypeFromSchemalocationIgnoreCase(String schemalocation) {
        if (schemalocation == null || schemalocation.isEmpty()) {
            return null;
        }
        return this._schemalocationIgnoreCaseLookup.get(schemalocation.toLowerCase());
    }

    public DocumentType getDocumentTypeFromDTD(String dtd) {
        if (dtd == null || dtd.isEmpty()) {
            return null;
        }
        return this._dtdLookup.get(dtd);
    }

    public DocumentType getDocumentTypeFromDTDIgnoreCase(String dtd) {
        if (dtd == null || dtd.isEmpty()) {
            return null;
        }
        return this._dtdIgnoreCaseLookup.get(dtd.toLowerCase());
    }

    public List<DocumentType> getDocumentTypeFromNamespace(String namespace) {
        if (namespace == null || namespace.isEmpty()) {
            return null;
        }
        return this._namespaceLookup.get(namespace);
    }

    private DocumentType getDocumentType(List<DocumentType> docTypeList, XmlMetaData meta, String payloadXPath) {
        if (docTypeList != null) {
            if (docTypeList.size() == 1) {
                return docTypeList.getFirst();
            }
            ArrayList<SchemaData> foundSchemas = new ArrayList<SchemaData>();
            if (!meta.getRootElementName().isEmpty()) {
                try {
                    SchemaData schemaData = this._schemataConfig.fetchSchemaDataFromMetaData(meta.getNamespaceUri(), null, null, meta.getRootElementName());
                    for (DocumentType documentType : docTypeList) {
                        if (!documentType.getType().equals(schemaData.getMessageType()) || !documentType.getVersion().equals(schemaData.getMessageVersion())) continue;
                        return documentType;
                    }
                }
                catch (MultipleSchemaSetFoundException e) {
                    LOG.warn("could not identify payload by root element, try identification by schemalocation. {}", (Object)e.getMessage());
                    foundSchemas.addAll(e.getSchemas());
                }
            }
            if (meta.getSchemaLocation() != null) {
                String schemaloc;
                for (DocumentType documentType : docTypeList) {
                    schemaloc = documentType.getSchemalocation();
                    if (schemaloc == null || !meta.getSchemaLocation().endsWith(schemaloc)) continue;
                    return documentType;
                }
                for (DocumentType documentType : docTypeList) {
                    schemaloc = documentType.getSchemalocation();
                    if (schemaloc == null || !meta.getSchemaLocation().toLowerCase().endsWith(schemaloc.toLowerCase())) continue;
                    return documentType;
                }
            }
            if (!foundSchemas.isEmpty()) {
                List<SchemaData> messageTypes = this.recognizeMessageTypeByMarker(meta.getFile(), foundSchemas, payloadXPath);
                switch (messageTypes.size()) {
                    case 0: {
                        LOG.warn("could not identify payload by marker. No matching marker found.");
                        break;
                    }
                    default: {
                        for (SchemaData schemaData : messageTypes) {
                            for (DocumentType documentType : docTypeList) {
                                if (!documentType.getType().equals(schemaData.getMessageType()) || !documentType.getVersion().equals(schemaData.getMessageVersion())) continue;
                                return documentType;
                            }
                        }
                    }
                }
            }
        }
        return null;
    }

    private List<SchemaData> recognizeMessageTypeByMarker(File file, List<SchemaData> schemaDataList, String payloadXPath) {
        ArrayList<SchemaData> messageTypes = new ArrayList<SchemaData>();
        try (FileInputStream payloadInputStream = new FileInputStream(file);){
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            Document xmlDocument = builder.parse(payloadInputStream);
            for (SchemaData schemaData : schemaDataList) {
                if (schemaData.getMessageTypeMarkerXPath() == null || schemaData.getMessageTypeMarkerValue() == null) continue;
                try {
                    XPath xPath = XPathFactory.newInstance().newXPath();
                    String expression = payloadXPath + schemaData.getMessageTypeMarkerXPath();
                    String foundValue = xPath.compile(expression).evaluate(xmlDocument);
                    if (!schemaData.getMessageTypeMarkerValue().equals(foundValue)) continue;
                    messageTypes.add(schemaData);
                    LOG.info("Recognized message type '{}' by defined message type marker '{}'.", (Object)schemaData, (Object)foundValue);
                }
                catch (XPathExpressionException xPathExpressionException) {
                    LOG.warn("Error occurs while message type recognizing by marker: {}", (Object)String.valueOf(xPathExpressionException));
                }
            }
        }
        catch (Exception e) {
            LOG.error("Could not read payload.", (Throwable)e);
        }
        return messageTypes;
    }

    public DocumentType getDocumentType(XmlMetaData meta, String payloadXPath) {
        DocumentType result = null;
        result = this.getDocumentType(this.getDocumentTypeFromNamespace(meta.getNamespaceUri()), meta, payloadXPath);
        if (result == null) {
            result = this.getDocumentTypeFromSchemalocation(meta.getSchemaLocation());
        }
        if (result == null && (result = this.getDocumentTypeFromDTD(meta.getSystemId())) == null) {
            result = this.getDocumentTypeFromSchemalocation(meta.getSystemId());
        }
        if (result == null) {
            result = this.getDocumentTypeFromSchemalocationIgnoreCase(meta.getSchemaLocation());
        }
        if (result == null && (result = this.getDocumentTypeFromDTDIgnoreCase(meta.getSystemId())) == null) {
            result = this.getDocumentTypeFromSchemalocationIgnoreCase(meta.getSystemId());
        }
        if (result == null) {
            Map<AdditionalSchema, DocumentType> additionalDocs = this.getDocumentTypesByAdditionalSchema_Namespace(meta.getNamespaceUri(), false);
            ArrayList<String> xpaths = new ArrayList<String>();
            for (AdditionalSchema additionalSchema : additionalDocs.keySet()) {
                xpaths.addAll(additionalSchema.getXPaths());
            }
            if (!xpaths.isEmpty()) {
                result = this.identifyWrappedDocumentByNamespace(meta, xpaths, payloadXPath);
            }
        }
        String rootElementName = meta.getRootElementName();
        for (int i = 0; i < this._documentTypes.size() && result == null && rootElementName != null; ++i) {
            DocumentType tempDocType = this._documentTypes.get(i);
            if (!this.rootElementEquals(rootElementName, tempDocType) || !this.rootNamespaceisEqual(meta.getNamespaceUri(), tempDocType.getNamespace())) continue;
            result = tempDocType;
            break;
        }
        return result;
    }

    private boolean rootNamespaceisEqual(String namespaceUri, String checkNamespace) {
        if (StringUtils.isNotEmpty((CharSequence)namespaceUri) && StringUtils.isNotEmpty((CharSequence)checkNamespace)) {
            return namespaceUri.equals(checkNamespace);
        }
        return StringUtils.isEmpty((CharSequence)namespaceUri) && StringUtils.isEmpty((CharSequence)checkNamespace);
    }

    private boolean rootElementEquals(String rootElementName, DocumentType tempDocType) {
        return !rootElementName.isEmpty() && tempDocType.getRootElement().equals(rootElementName);
    }

    private Map<AdditionalSchema, DocumentType> getDocumentTypesByAdditionalSchema_Namespace(String namespace, boolean ignoreCase) {
        HashMap<AdditionalSchema, DocumentType> result = new HashMap<AdditionalSchema, DocumentType>();
        if (namespace == null || namespace.isEmpty()) {
            return result;
        }
        block0: for (DocumentType type : this._documentTypes) {
            for (AdditionalSchema additionalSchema : type.getAdditionalSchemata()) {
                if (ignoreCase && namespace.equalsIgnoreCase(additionalSchema.getNamespace())) {
                    if (additionalSchema.getXPaths().isEmpty()) continue;
                    result.put(additionalSchema, type);
                    continue block0;
                }
                if (ignoreCase || !namespace.equals(additionalSchema.getNamespace()) || additionalSchema.getXPaths().isEmpty()) continue;
                result.put(additionalSchema, type);
                continue block0;
            }
        }
        return result;
    }

    public RecognizePayloadResult recognizePayload(File payloadReference, String messageType, String messageVersion, String schemaSet, String schemaLocation, String payloadXPath, String payloadRootElement, String payloadNamespace) {
        DocumentType documentType = null;
        if (payloadReference != null && payloadReference.isFile() && "BINARY".equals(schemaSet) || messageType == null || messageVersion == null || schemaSet == null) {
            if (messageType != null && messageVersion != null) {
                documentType = this.getDocumentType(messageType, messageVersion);
                return new RecognizePayloadResult(documentType);
            }
            if (schemaLocation != null && (documentType = this.getDocumentTypeFromSchemalocation(schemaLocation)) == null) {
                documentType = this.getDocumentTypeFromSchemalocationIgnoreCase(schemaLocation);
            }
            if (documentType == null) {
                try {
                    XmlMetaData meta = new XmlMetaData(payloadReference, payloadNamespace, payloadRootElement);
                    documentType = this.getDocumentType(meta, payloadXPath);
                }
                catch (Exception meta) {
                    // empty catch block
                }
            }
            if (documentType == null) {
                try {
                    EdifactMessage ediMsg = new EdifactMessage(payloadReference);
                    documentType = this.getDocumentType(ediMsg.getMessageType(), ediMsg.getMessageVersion());
                }
                catch (Exception ediMsg) {
                    // empty catch block
                }
            }
            if (documentType == null) {
                try {
                    X12Message x12Msg = new X12Message(payloadReference);
                    documentType = this.getDocumentType(x12Msg.getMessageType(), x12Msg.getMessageVersion());
                }
                catch (Exception x12Msg) {
                    // empty catch block
                }
            }
            if (documentType == null) {
                if (this != this._schemataConfig.getGlobalPayloadRecognizer()) {
                    RecognizePayloadResult result = this._schemataConfig.getGlobalPayloadRecognizer().recognizePayload(payloadReference, messageType, messageVersion, schemaSet, schemaLocation, payloadXPath, payloadRootElement, payloadNamespace);
                    if (result.isValid) {
                        documentType = result.documentType;
                    }
                }
                if (Objects.nonNull(documentType) && !"BINARY".equals(documentType.getSchemaSet())) {
                    return new RecognizePayloadResult(false, documentType, "MessageType '" + documentType.getType() + "' of SchemaSet '" + documentType.getSchemaSet() + "' is not activated in agreement.");
                }
                documentType = this.getDocumentTypeFromSchemalocation("BINARY");
            }
        }
        return new RecognizePayloadResult(documentType);
    }

    private DocumentType identifyWrappedDocumentByNamespace(XmlMetaData meta, List<String> xpaths, String payloadXPath) {
        WrappedDocumentByNamespaceRecognizer recognizer = new WrappedDocumentByNamespaceRecognizer();
        return this.getDocumentType(recognizer.recognizeMessage(meta.getFile(), xpaths, this), meta, payloadXPath);
    }

    public DocumentType getDocumentType(String type, String version, String schemaset) {
        return this._typeVersionSchemaSetLookup.get(this.buildTypeVersionSchemasetId(type, version, schemaset));
    }

    private String buildTypeVersionId(String type, String version) {
        return type + "\t" + version;
    }

    private String buildTypeVersionSchemasetId(String type, String version, String schemaset) {
        return type + "\t" + version + "\t" + schemaset;
    }

    public record RecognizePayloadResult(boolean isValid, DocumentType documentType, String errorMessage) {
        RecognizePayloadResult(DocumentType documentType) {
            this(Objects.nonNull(documentType), documentType, Objects.isNull(documentType) ? "MessageType can't be recognized." : null);
        }
    }
}

