/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.mail;

import jakarta.activation.DataSource;
import jakarta.mail.internet.ContentType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class DispositionNotification {
    public static final String PRIMARYTYPE_MESSAGE = "message";
    public static final String SUBTYPE_DISPOSITION_NOTIFICATION = "disposition-notification";
    public static final String CONTENT_TYPE_DISPOSITION_NOTIFICATION = "message/disposition-notification";
    public static final String DISPOSITION_MODE_AUTOMATIC_SENT_AUTOMATICALLY = "automatic-action/MDN-sent-automatically";
    public static final String DISPOSITION_MODE_MANUAL_SENT_MANUALLY = "manual-action/MDN-sent-manually";
    public static final String REPORTING_UA = "Reporting-UA";
    public static final String ORIGINAL_RECIPIENT = "Original-Recipient";
    public static final String FINAL_RECIPIENT = "Final-Recipient";
    public static final String ORIGINAL_MESSAGE_ID = "Original-Message-ID";
    public static final String DISPOSITION = "Disposition";
    public static final String FAILURE = "Failure";
    public static final String ERROR = "Error";
    public static final String WARNING = "Warning";
    public static final String RECEIVED_CONTENT_MIC = "Received-content-MIC";
    private static final String COLON = ":";
    private static final String SEMICOLON = ";";
    private static final String LINE_FEED = "\r\n";
    private static final String COLON_SPACE = ": ";
    private static final String COMMA = ",";
    private static final String SLASH = "/";
    private ContentType _contentType = new ContentType("message", "disposition-notification", null);
    private String _reportingUA;
    private String _originalRecipient;
    private String _finalRecipient;
    private String _originalMessageID;
    private String _disposition;
    private final List<String> _failures = new ArrayList<String>();
    private final List<String> _errors = new ArrayList<String>();
    private final List<String> _warnings = new ArrayList<String>();
    private String _receivedContentMIC;
    private String _receivedContentMICAlg;
    private String _dispositionType;
    private String _dispositionModifier;
    private String _dispositionModifierText;

    public DispositionNotification() {
    }

    public DispositionNotification(DataSource datasource) throws IOException {
        this();
        String line;
        LineNumberReader lnr = new LineNumberReader(new InputStreamReader(datasource.getInputStream()));
        while ((line = lnr.readLine()) != null) {
            StringTokenizer st = new StringTokenizer(line, COLON);
            if (st.countTokens() <= 1) continue;
            String key = st.nextToken().trim();
            Object value = st.nextToken();
            while (st.hasMoreTokens()) {
                value = (String)value + COLON + st.nextToken();
            }
            if (key.equalsIgnoreCase(REPORTING_UA)) {
                this._reportingUA = value;
                continue;
            }
            if (key.equalsIgnoreCase(ORIGINAL_RECIPIENT)) {
                this._originalRecipient = value;
                continue;
            }
            if (key.equalsIgnoreCase(FINAL_RECIPIENT)) {
                this._finalRecipient = value;
                continue;
            }
            if (key.equalsIgnoreCase(ORIGINAL_MESSAGE_ID)) {
                value = ((String)value).replace('<', ' ');
                value = ((String)value).replace('>', ' ');
                this._originalMessageID = value = ((String)value).trim();
                continue;
            }
            if (key.equalsIgnoreCase(DISPOSITION)) {
                this._disposition = value;
                this.parseDispositionString();
                continue;
            }
            if (key.equalsIgnoreCase(FAILURE)) {
                this._failures.add((String)value);
                continue;
            }
            if (key.equalsIgnoreCase(ERROR)) {
                this._errors.add((String)value);
                continue;
            }
            if (key.equalsIgnoreCase(WARNING)) {
                this._warnings.add((String)value);
                continue;
            }
            if (!key.equalsIgnoreCase(RECEIVED_CONTENT_MIC)) continue;
            StringTokenizer valueTokens = new StringTokenizer((String)value, COMMA);
            this._receivedContentMIC = valueTokens.nextToken().trim();
            this._receivedContentMICAlg = valueTokens.nextToken().trim();
        }
    }

    public void writeTo(OutputStream out) throws IOException {
        if (this._reportingUA != null) {
            out.write(("Reporting-UA: " + this._reportingUA + LINE_FEED).getBytes());
        }
        if (this._originalRecipient != null) {
            out.write(("Original-Recipient: " + this._originalRecipient + LINE_FEED).getBytes());
        }
        if (this._finalRecipient != null) {
            out.write(("Final-Recipient: " + this._finalRecipient + LINE_FEED).getBytes());
        }
        if (this._originalMessageID != null && this._originalMessageID.length() > 0) {
            Object omid = this._originalMessageID;
            if (!((String)omid).startsWith("<")) {
                omid = "<" + (String)omid;
            }
            if (!((String)omid).endsWith(">")) {
                omid = (String)omid + ">";
            }
            out.write(("Original-Message-ID: " + (String)omid + LINE_FEED).getBytes());
        }
        if (this._disposition != null) {
            out.write(("Disposition: " + this._disposition + LINE_FEED).getBytes());
        }
        for (String failure : this._failures) {
            out.write(("Failure: " + failure + LINE_FEED).getBytes());
        }
        for (String error : this._errors) {
            out.write(("Error: " + error + LINE_FEED).getBytes());
        }
        for (String warning : this._warnings) {
            out.write(("Warning: " + warning + LINE_FEED).getBytes());
        }
        if (this._receivedContentMIC != null && this._receivedContentMICAlg != null) {
            out.write(("Received-content-MIC: " + this._receivedContentMIC + ", " + this._receivedContentMICAlg + LINE_FEED).getBytes());
        }
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.writeTo(baos);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new String(baos.toByteArray());
    }

    public String getContentType() {
        return this._contentType.toString();
    }

    public String getDisposition() {
        return this._disposition;
    }

    public void setDisposition(String disposition) {
        this._disposition = disposition;
    }

    public String getOriginalMessageID() {
        return this._originalMessageID;
    }

    public String getFinalRecipient() {
        return this._finalRecipient;
    }

    public void setFinalRecipient(String final_Recipient) {
        this._finalRecipient = final_Recipient;
    }

    public void setOriginalMessageID(String original_Message_ID) {
        this._originalMessageID = original_Message_ID;
    }

    public String getOriginalRecipient() {
        return this._originalRecipient;
    }

    public void setOriginalRecipient(String original_Recipient) {
        this._originalRecipient = original_Recipient;
    }

    public String getReportingUA() {
        return this._reportingUA;
    }

    public void setReportingUA(String reporting_UA) {
        this._reportingUA = reporting_UA;
    }

    public String getReceivedContentMIC() {
        return this._receivedContentMIC;
    }

    public void setReceivedContentMIC(String receivedContentMIC) {
        this._receivedContentMIC = receivedContentMIC;
    }

    public String getReceivedContentMICAlg() {
        return this._receivedContentMICAlg;
    }

    public void setReceivedContentMICAlg(String receivedContentMICAlg) {
        this._receivedContentMICAlg = receivedContentMICAlg;
    }

    public Iterator<String> getFailureIterator() {
        return this._failures.iterator();
    }

    public void addFailure(String failure) {
        this._failures.add(failure);
    }

    public Iterator<String> getErrorIterator() {
        return this._errors.iterator();
    }

    public void addError(String error) {
        this._errors.add(error);
    }

    public Iterator<String> getWarningIterator() {
        return this._warnings.iterator();
    }

    public void addWarning(String warning) {
        this._warnings.add(warning);
    }

    public String getDispositionType() {
        return this._dispositionType;
    }

    public void setDispositionType(String dispositionType) {
        this._dispositionType = dispositionType;
        this.setDisposition(this.getComposedDispositionString());
    }

    public String getDispositionModifier() {
        return this._dispositionModifier;
    }

    public void setDispositionModifier(String dispositionModifier) {
        if (dispositionModifier != null && dispositionModifier.length() > 0) {
            this._dispositionModifier = dispositionModifier;
            this.setDisposition(this.getComposedDispositionString());
        }
    }

    public String getDispositionModifierText() {
        return this._dispositionModifierText;
    }

    public void setDispositionModifierText(String dispositionModifierText) {
        if (dispositionModifierText != null && dispositionModifierText.length() > 0) {
            this._dispositionModifierText = dispositionModifierText;
            this.setDisposition(this.getComposedDispositionString());
        }
    }

    private void parseDispositionString() {
        int start = this._disposition.indexOf(SEMICOLON) + 1;
        int end = this._disposition.indexOf(SLASH, start) == -1 ? this._disposition.length() : this._disposition.indexOf(SLASH, start);
        this._dispositionType = this._disposition.substring(start, end).trim();
        if (end < this._disposition.length()) {
            String str = this._disposition.substring(end + 1).trim();
            end = str.indexOf(COLON) == -1 ? str.length() : str.indexOf(COLON);
            this._dispositionModifier = str.substring(0, end);
            if (end < str.length()) {
                this._dispositionModifierText = str.substring(end + 1).trim();
            }
        }
    }

    public String getComposedDispositionString() {
        StringBuilder disposition = new StringBuilder();
        disposition.append(DISPOSITION_MODE_AUTOMATIC_SENT_AUTOMATICALLY);
        disposition.append(SEMICOLON);
        disposition.append(this.getDispositionType());
        if (this.getDispositionModifier() != null && this.getDispositionModifier().length() > 0) {
            disposition.append(SLASH);
            disposition.append(this.getDispositionModifier());
            if (this.getDispositionModifierText() != null && this.getDispositionModifierText().length() > 0) {
                disposition.append(COLON_SPACE);
                disposition.append(this.getDispositionModifierText());
            }
        }
        return disposition.toString();
    }
}

