/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.listener;

import de.pontonconsulting.xmlpipe.config.IMessengerProperties;
import de.pontonconsulting.xmlpipe.listener.AS4Processor;
import de.pontonconsulting.xmlpipe.listener.EbXml2Processor;
import de.pontonconsulting.xmlpipe.listener.ISoapProcessor;
import de.pontonconsulting.xmlpipe.listener.ISoapProcessorFactory;
import de.pontonconsulting.xmlpipe.util.ApplicationContextBeanLoader;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;

public class SoapProcessorFactory
extends ApplicationContextBeanLoader
implements ISoapProcessorFactory {
    private static final String NAMESPACE_EBXML30 = "http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/";
    private static final String NAMESPACE_EBXML20 = "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd";
    protected Log _log = LogFactory.getFactory().getInstance("Messenger.SoapProcessorFactory");
    private final HashMap<String, String> _soapProcessors = new HashMap();

    public SoapProcessorFactory(IMessengerProperties messengerProperties, ApplicationContext applicationContext) {
        super(applicationContext);
        this.setDefaultHandlers();
        int i = 1;
        while (true) {
            String pre = "ponton.soap." + i++;
            String namespace = messengerProperties.getProperty(pre + ".namespace");
            String handler = messengerProperties.getProperty(pre + ".handler");
            if (namespace == null || namespace.length() <= 0 || handler == null || handler.length() <= 0) break;
            this._soapProcessors.put(namespace, handler);
            if (!this._log.isTraceEnabled()) continue;
            this._log.trace((Object)("Found soap processor for uri '" + namespace + "'"));
        }
    }

    private void setDefaultHandlers() {
        this._soapProcessors.put(NAMESPACE_EBXML20, EbXml2Processor.class.getCanonicalName());
        this._soapProcessors.put(NAMESPACE_EBXML30, AS4Processor.class.getCanonicalName());
    }

    @Override
    public ISoapProcessor getProcessor(String uri) {
        String processor = null;
        ISoapProcessor soapProcessor = null;
        processor = this._soapProcessors.get(uri);
        if (processor != null) {
            try {
                soapProcessor = (ISoapProcessor)this.getBean(Class.forName(processor));
            }
            catch (Exception e) {
                this._log.error((Object)("Could not initialize SOAP-Processor:" + processor + " error:" + String.valueOf(e)));
            }
        } else if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("No soap processor for the uri '" + uri + "' available."));
        }
        return soapProcessor;
    }
}

