/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.listener;

import de.pontonconsulting.common.activation.StreamDataSource;
import de.pontonconsulting.xmlpipe.config.IFolders;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.cpp.CppPartner;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.cpp.ProfileNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.listener.DuplicateMessageException;
import de.pontonconsulting.xmlpipe.listener.ErrorNotificationResult;
import de.pontonconsulting.xmlpipe.listener.ErrorNotificationService;
import de.pontonconsulting.xmlpipe.listener.PlainListenerException;
import de.pontonconsulting.xmlpipe.listener.PlainMessage;
import de.pontonconsulting.xmlpipe.listener.ProcessingResultToErrorNotificationResultConverter;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.message.XpMessageAttachment;
import de.pontonconsulting.xmlpipe.messenger.IdGenerator;
import de.pontonconsulting.xmlpipe.messenger.ProcessingResult;
import de.pontonconsulting.xmlpipe.messenger.ReceiveFromListener;
import de.pontonconsulting.xmlpipe.messenger.database.DbException;
import de.pontonconsulting.xmlpipe.messenger.database.MessageExistsException;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.mail.Header;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.ContentDisposition;
import jakarta.mail.internet.ContentType;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.internet.SharedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlainProcessor {
    private static final String PLAIN = "Plain";
    private static final String PLAIN_PAYLOAD_XML = "plain-payload.xml";
    public static final String X_MESSAGE_ID = "X-MessageId";
    public static final String X_CONVERSATION_ID = "X-ConversationId";
    public static final String CONTENT_ID = "Content-Id";
    public static final String CONTENT_DISPOSITION = "Content-Disposition";
    public static final Logger _log = LogManager.getLogger((String)"Messenger.PlainProcessor");
    private final Profiles _profiles;
    private final ReceiveFromListener _receiveFromListener;
    private final MessageDAO _messageDAO;
    private final MessengerLog _messengerLog;
    private final IFolders _folders;
    private final IdGenerator _idGenerator;
    private final ErrorNotificationService _errorNotificationService;
    private final MessengerConfig messengerConfig;
    private boolean _inProcessing = false;

    public PlainProcessor(Profiles profiles, ReceiveFromListener receiveFromListener, MessageDAO messageDAO, MessengerLog messengerLog, IFolders folders, IdGenerator idGenerator, ErrorNotificationService errorNotificationService, MessengerConfig messengerConfig) {
        this._profiles = profiles;
        this._receiveFromListener = receiveFromListener;
        this._messageDAO = messageDAO;
        this._messengerLog = messengerLog;
        this._folders = folders;
        this._idGenerator = idGenerator;
        this._errorNotificationService = errorNotificationService;
        this.messengerConfig = messengerConfig;
    }

    public void processMessage(PlainMessage plainMessage) throws DuplicateMessageException, PlainListenerException {
        File workFolder;
        XpMessage message = plainMessage.getXp();
        this.checkReceiver(message);
        this.checkSender(message);
        this.validateSupportedPackager(message);
        try {
            Optional.ofNullable(plainMessage.getMimeMessage().getHeader("X-Remote-Address")).ifPresent(e -> {
                if (((String[])e).length > 0) {
                    try {
                        message.setProcessingDirective("X-RemoteAddress", plainMessage.getMimeMessage().getHeader("X-Remote-Address")[0]);
                    }
                    catch (MessagingException ex) {
                        _log.warn(ex.getMessage());
                    }
                }
            });
        }
        catch (MessagingException e2) {
            _log.warn(e2.getMessage());
        }
        try {
            Optional.ofNullable(plainMessage.getMimeMessage().getHeader("X-Forwarded-For")).ifPresent(e -> {
                if (((String[])e).length > 0) {
                    try {
                        message.setProcessingDirective("X-ForwardedFor", plainMessage.getMimeMessage().getHeader("X-Forwarded-For")[0]);
                    }
                    catch (MessagingException ex) {
                        _log.warn(ex.getMessage());
                    }
                }
            });
        }
        catch (MessagingException e3) {
            _log.warn(e3.getMessage());
        }
        try {
            Optional.ofNullable(plainMessage.getMimeMessage().getHeader("User-Agent")).ifPresent(e -> {
                if (((String[])e).length > 0) {
                    try {
                        message.setProcessingDirective("X-UserAgent", plainMessage.getMimeMessage().getHeader("User-Agent")[0]);
                    }
                    catch (MessagingException ex) {
                        _log.warn(ex.getMessage());
                    }
                }
            });
        }
        catch (MessagingException e4) {
            _log.warn(e4.getMessage());
        }
        try {
            workFolder = this.saveContent(plainMessage);
        }
        catch (DuplicateMessageException e5) {
            _log.warn("Ignored duplicate message.");
            this._messengerLog.log2db(106, message.getDatabaseId(), null);
            throw e5;
        }
        if (this._inProcessing) {
            return;
        }
        this._messageDAO.updateMessageFolder(message.getDatabaseId(), workFolder);
        _log.debug("Storing message header data.");
        try {
            this.saveHeaders(plainMessage, workFolder);
        }
        catch (MessagingException e6) {
            throw new PlainListenerException(-1, "Could not process headers", e6);
        }
        this.updateMessage(message);
        ProcessingResult[] result = this._receiveFromListener.handleMessage(message);
        if (result != null) {
            if (result[result.length - 1].getResultCode() != 0) {
                this.notifyAdapter(message, result);
                String description = result[result.length - 1].getDescription();
                throw new PlainListenerException(-1, description);
            }
        } else {
            throw new PlainListenerException(-1, "no result received");
        }
        _log.debug("Creating OK response");
    }

    void validateSupportedPackager(XpMessage xpMessage) throws PlainListenerException {
        if (!PLAIN.equals(xpMessage.getCommunication().getPackagingId())) {
            _log.error("Agreement supports {} and not Plain.", (Object)xpMessage.getCommunication().getPackagingId());
            throw new PlainListenerException(43000, "Agreement supports only " + xpMessage.getCommunication().getPackagingId() + ".");
        }
    }

    private void notifyAdapter(XpMessage xpMessage, ProcessingResult[] results) {
        List<ErrorNotificationResult> notifications = ProcessingResultToErrorNotificationResultConverter.mapResultsToNotificationCodes(results);
        this._errorNotificationService.notifyAdapter(xpMessage, notifications);
    }

    private File registerMessage(XpMessage message) throws DbException, PlainListenerException, DuplicateMessageException {
        int messageStatus;
        try {
            this._messageDAO.registerMessage(message);
            messageStatus = 0;
        }
        catch (MessageExistsException e) {
            messageStatus = this._messageDAO.getStatusOfMessage(message.getMessageId(), 1);
        }
        catch (DbException e) {
            throw new PlainListenerException(45005, " Could not register message", e);
        }
        if (messageStatus != 0) {
            boolean updated;
            message.setDatabaseId(this._messageDAO.getMessageDataID(message.getMessageId(), 1));
            if (messageStatus == 4 && !(updated = this._messageDAO.updateMessageStatus(message.getDatabaseId(), 4, 1))) {
                messageStatus = this._messageDAO.getStatusOfMessage(message.getMessageId(), 1);
            }
        }
        this._messengerLog.log2db(60, message.getDatabaseId(), " Plain " + message.getProtocol());
        if (messageStatus != 0 && messageStatus != 4) {
            if (messageStatus == 3 || messageStatus == 2) {
                this._inProcessing = false;
                _log.info("Message received is a duplicate and will not be processed. messageId:{}", (Object)message.getMessageId());
                throw new DuplicateMessageException(message.getMessageId());
            }
            _log.info("Message received which is currently being processed:{} (status:{})", (Object)message.getMessageId(), (Object)messageStatus);
            this._inProcessing = true;
            return null;
        }
        this._inProcessing = false;
        File workFolder = new File(this._folders.getWorkInboundFolder(), String.valueOf(message.getDatabaseId()));
        workFolder.mkdirs();
        return workFolder;
    }

    private void saveHeaders(PlainMessage plainMessage, File workFolder) throws PlainListenerException, MessagingException {
        File headersFile = new File(workFolder, "headers.txt");
        BufferedOutputStream out = null;
        try {
            out = new BufferedOutputStream(Files.newOutputStream(headersFile.toPath(), new OpenOption[0]));
            Enumeration headers = plainMessage.getMimeMessage().getAllHeaders();
            while (headers.hasMoreElements()) {
                Header header = (Header)headers.nextElement();
                out.write(header.getName().getBytes());
                out.write(58);
                out.write(32);
                out.write(header.getValue().getBytes());
                out.write(10);
            }
        }
        catch (IOException ioe) {
            throw new PlainListenerException(43005, "Could not write message headers.", ioe);
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                }
                catch (Exception exception) {}
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void updateMessage(XpMessage xpMessage) {
        try {
            this._messageDAO.updateMessage(xpMessage);
        }
        catch (DbException e) {
            _log.fatal("Error while updating Message: {}", (Object)e.getMessage());
        }
    }

    private File saveContent(PlainMessage message) throws PlainListenerException, DuplicateMessageException {
        File workFolder = null;
        try {
            workFolder = message.isMultipart() ? this.saveMultiparts(message) : this.saveSinglePart(message);
        }
        catch (DbException e) {
            _log.error("Could not register message in database. Reception failed. {}", (Object)e.getMessage());
            throw new PlainListenerException(43000, "Could not register message in database. Reception failed.");
        }
        catch (MessagingException | IOException e) {
            _log.error("Could not store message in filesystem. {}", (Object)e.getMessage());
            throw new PlainListenerException(43000, "Could not store message. Reception failed.");
        }
        return workFolder;
    }

    private File saveSinglePart(PlainMessage message) throws FileNotFoundException, IOException, PlainListenerException, DbException, DuplicateMessageException, MessagingException {
        File workFolder = null;
        XpMessage xp = message.getXp();
        String messageId = message.getMimeMessage().getHeader(X_MESSAGE_ID, null);
        if (messageId == null && (messageId = message.getMimeMessage().getHeader(CONTENT_ID, null)) == null) {
            messageId = this._idGenerator.generateMessageId();
        }
        xp.setMessageId(messageId);
        String conversationId = message.getMimeMessage().getHeader(X_CONVERSATION_ID, null);
        if (conversationId != null) {
            xp.setConversationId(conversationId);
        } else {
            xp.setConversationId(xp.getMessageId());
        }
        xp.setMessengerId(this.messengerConfig.getMessengerId());
        xp.setMessagePackaging(PLAIN);
        workFolder = this.registerMessage(xp);
        if (this._inProcessing) {
            return null;
        }
        File file = new File(workFolder, PLAIN_PAYLOAD_XML);
        try (BufferedOutputStream contentOutputStream = new BufferedOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0]));){
            message.getMimeMessage().getDataHandler().writeTo((OutputStream)contentOutputStream);
        }
        xp.setCurrentContentReference(file);
        return workFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File saveMultiparts(PlainMessage message) throws PlainListenerException, DbException, DuplicateMessageException {
        File workFolder = null;
        ContentType contentType = message.getContentType();
        XpMessage xp = message.getXp();
        Object in = null;
        try {
            MimeBodyPart mime = new MimeBodyPart();
            MimeMessage mimeMessage = message.getMimeMessage();
            Object content = mimeMessage.getContent();
            if (content instanceof SharedInputStream) {
                mime.setDataHandler(new DataHandler((DataSource)new StreamDataSource(contentType.toString(), (SharedInputStream)content)));
            } else {
                mime.setContent(content, contentType.getBaseType());
            }
            MimeMultipart mp = (MimeMultipart)mime.getContent();
            int parts = mp.getCount();
            if (parts == 0) {
                throw new IOException("multipart mime without bodypart cannot be processed.");
            }
            MimeBodyPart payload = (MimeBodyPart)mp.getBodyPart(0);
            String messageId = payload.getHeader(X_MESSAGE_ID, null);
            if (messageId == null && (messageId = payload.getHeader(CONTENT_ID, null)) == null) {
                xp.setMessageId(this._idGenerator.generateMessageId());
            }
            xp.setMessageId(messageId);
            String conversationId = payload.getHeader(X_CONVERSATION_ID, null);
            if (conversationId != null) {
                xp.setConversationId(conversationId);
            } else {
                xp.setConversationId(xp.getMessageId());
            }
            workFolder = this.registerMessage(xp);
            if (this._inProcessing) {
                File file = null;
                return file;
            }
            workFolder.mkdir();
            byte[] buffer = new byte[4096];
            InputStream in2 = payload.getDataHandler().getInputStream();
            File payloadFile = new File(workFolder, PLAIN_PAYLOAD_XML);
            BufferedOutputStream fos = new BufferedOutputStream(Files.newOutputStream(payloadFile.toPath(), new OpenOption[0]));
            int len = -1;
            while ((len = in2.read(buffer)) != -1) {
                ((OutputStream)fos).write(buffer, 0, len);
            }
            ((OutputStream)fos).close();
            in2.close();
            xp.setCurrentContentReference(payloadFile);
            if (parts > 1) {
                File attachmentFolder = new File(workFolder, "attachments");
                attachmentFolder.mkdir();
                for (int i = 1; i < parts; ++i) {
                    File attachmentFile = null;
                    String filename = "payload.dat";
                    MimeBodyPart part = (MimeBodyPart)mp.getBodyPart(i);
                    String disposition = part.getHeader(CONTENT_DISPOSITION, ",");
                    if (disposition != null) {
                        ContentDisposition dis = new ContentDisposition(disposition);
                        filename = dis.getParameter("filename");
                    }
                    String contentType2 = part.getHeader("Content-Type", ",");
                    in2 = part.getDataHandler().getInputStream();
                    attachmentFile = new File(attachmentFolder, filename);
                    fos = new BufferedOutputStream(Files.newOutputStream(attachmentFile.toPath(), new OpenOption[0]));
                    len = -1;
                    while ((len = in2.read(buffer)) != -1) {
                        ((OutputStream)fos).write(buffer, 0, len);
                    }
                    ((OutputStream)fos).close();
                    in2.close();
                    xp.addAttachment(new XpMessageAttachment(attachmentFile, contentType2));
                }
            }
        }
        catch (IOException e) {
            _log.error("could not store mime multiparts: {}", (Object)e.getMessage());
        }
        catch (MessagingException e) {
            _log.error("could not store mime multiparts: {}", (Object)e.getMessage());
        }
        finally {
            if (in != null) {
                try {
                    in.dispose();
                }
                catch (IOException e) {}
            }
        }
        return workFolder;
    }

    private void checkSender(XpMessage message) throws PlainListenerException {
        try {
            CppPartner sender = this._profiles.getProfileForLocalId(message.getSenderLocalId(), true);
            if (sender.isDisabled()) {
                _log.fatal("Sender is disabled. Reception denied. localId={}", (Object)message.getSenderLocalId());
                throw new PlainListenerException(43000, "Sender is disabled. Reception denied.");
            }
        }
        catch (ProfileNotFoundException e) {
            _log.error("Sender is unknown. Reception denied. localId={}", (Object)message.getReceiverLocalId());
            throw new PlainListenerException(43000, "Receiver is unknown. Reception denied.");
        }
        catch (ProfileException e) {
            _log.error("Sender profile cannot be loaded. Reception denied. localId={}", (Object)message.getReceiverLocalId());
            throw new PlainListenerException(43000, "Sender profile is broken. Reception denied.");
        }
    }

    private void checkReceiver(XpMessage message) throws PlainListenerException {
        try {
            CppPartner receiver = this._profiles.getProfileForLocalId(message.getReceiverLocalId(), true);
            if (receiver.isRemote()) {
                _log.error("Receiver is a remote partner. Reception denied. localId={}", (Object)message.getReceiverLocalId());
                throw new PlainListenerException(43000, "Receiver is a remote partner. Reception denied.");
            }
            if (receiver.isDisabled()) {
                _log.error("Receiver is disabled. Reception denied. localId={}", (Object)message.getReceiverLocalId());
                throw new PlainListenerException(43000, "Receive is disabled. Reception denied.");
            }
        }
        catch (ProfileNotFoundException e) {
            _log.error("Receiver is unknown. Reception denied. localId={}", (Object)message.getReceiverLocalId());
            throw new PlainListenerException(43000, "Receiver is unknown. Reception denied.");
        }
        catch (ProfileException e) {
            _log.error("Receiver profile cannot be loaded. Reception denied. localId={}", (Object)message.getReceiverLocalId());
            throw new PlainListenerException(43000, "Receiver profile is broken. Reception denied.");
        }
    }
}

