/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.listener;

import de.pontonconsulting.xmlpipe.config.IFolders;
import de.pontonconsulting.xmlpipe.listener.IMessageReceiver;
import de.pontonconsulting.xmlpipe.listener.ListenerManager;
import de.pontonconsulting.xmlpipe.listener.MessageRequest;
import de.pontonconsulting.xmlpipe.listener.MessageResponse;
import de.pontonconsulting.xmlpipe.util.IOUtil;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ListenerDispatcherServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LogManager.getLogger((String)"Messenger.ListenerDispatcherServlet");
    private static AtomicLong callNumber = new AtomicLong(0L);
    private final IFolders folders;
    private final ListenerManager listenerManager;

    public ListenerDispatcherServlet(IFolders folders, ListenerManager listenerManager) {
        this.folders = folders;
        this.listenerManager = listenerManager;
    }

    private long getCallNumber() {
        return callNumber.incrementAndGet();
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.forward("GET", httpServletRequest, httpServletResponse);
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.forward("POST", httpServletRequest, httpServletResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forward(String httpMethod, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        File wiredDataFile = null;
        MessageResponse messageResponse = null;
        String messageReceiverName = this.getMessageReceiverName(httpServletRequest);
        IMessageReceiver messageReceiver = this.getMessageReceiver(messageReceiverName);
        try {
            if (messageReceiver == null) {
                messageResponse = new MessageResponse();
                messageResponse.setResult(404, "no message handler found for " + messageReceiverName);
            } else {
                Map<String, String> requestHeaders = this.createRequestHeaders(httpServletRequest);
                wiredDataFile = this.storeIncomingData(messageReceiverName, httpServletRequest);
                MessageRequest messageRequest = new MessageRequest(wiredDataFile, requestHeaders);
                switch (httpMethod) {
                    case "GET": {
                        messageResponse = messageReceiver.receiveGetRequest(messageRequest);
                        break;
                    }
                    case "POST": {
                        messageResponse = messageReceiver.receivePostRequest(messageRequest);
                        break;
                    }
                    default: {
                        messageResponse = new MessageResponse();
                        messageResponse.setResult(404, "no message handler found for HTTP method " + httpMethod);
                    }
                }
            }
            this.handleMessageResponse(httpServletResponse, messageResponse);
            FileUtils.deleteQuietly((File)wiredDataFile);
        }
        catch (IOException e) {
            LOG.error("Error occurred while handling message.", (Throwable)e);
        }
        finally {
            FileUtils.deleteQuietly(wiredDataFile);
        }
    }

    private void handleMessageResponse(HttpServletResponse httpServletResponse, MessageResponse messageResponse) throws IOException {
        for (Map.Entry<String, String> header : messageResponse.getHeaders().entrySet()) {
            httpServletResponse.addHeader(header.getKey(), header.getValue());
        }
        if (messageResponse.getResultCode() / 100 == 2) {
            httpServletResponse.setStatus(messageResponse.getResultCode());
        } else {
            httpServletResponse.sendError(messageResponse.getResultCode(), messageResponse.getResultText());
        }
        byte[] responseData = messageResponse.getData();
        if (responseData != null && responseData.length > 0) {
            ServletOutputStream responseOutputStream = httpServletResponse.getOutputStream();
            responseOutputStream.write(responseData);
            responseOutputStream.flush();
        }
    }

    private Map<String, String> createRequestHeaders(HttpServletRequest httpServletRequest) {
        HashMap<String, String> incomingHeaders = new HashMap<String, String>(4);
        incomingHeaders.put("X-Forwarded-For", httpServletRequest.getRemoteAddr());
        incomingHeaders.put("X-Request-URL", this.getOriginalUrl(httpServletRequest));
        incomingHeaders.put("X-Request-Servlet-Path", httpServletRequest.getServletPath());
        incomingHeaders.put("X-Request-Method", httpServletRequest.getMethod());
        return incomingHeaders;
    }

    private String getOriginalUrl(HttpServletRequest httpServletRequest) {
        String query = httpServletRequest.getQueryString();
        StringBuffer url = httpServletRequest.getRequestURL();
        if (Objects.nonNull(query)) {
            url.append("?").append(query);
        }
        return URLDecoder.decode(url.toString(), StandardCharsets.UTF_8);
    }

    private String getMessageReceiverName(HttpServletRequest httpServletRequest) {
        return httpServletRequest.getServletPath().replaceFirst("/", "");
    }

    private File storeIncomingData(String messageReceiverName, HttpServletRequest httpServletRequest) throws IOException {
        File incomingDataFile = new File(this.folders.getWorkInboundFolder(), messageReceiverName + "-data-" + this.getCallNumber());
        try (BufferedOutputStream incomingData = new BufferedOutputStream(Files.newOutputStream(incomingDataFile.toPath(), new OpenOption[0]));){
            Enumeration headerNames = httpServletRequest.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                Enumeration values = httpServletRequest.getHeaders(headerName);
                while (values.hasMoreElements()) {
                    String value = (String)values.nextElement();
                    ((OutputStream)incomingData).write((headerName + ": " + value + "\r\n").getBytes());
                }
            }
            ((OutputStream)incomingData).write(("X-Remote-Address: " + httpServletRequest.getRemoteAddr() + "\r\n").getBytes());
            ((OutputStream)incomingData).write("\r\n".getBytes());
            IOUtil.write((InputStream)httpServletRequest.getInputStream(), incomingData);
        }
        return incomingDataFile;
    }

    private IMessageReceiver getMessageReceiver(String messageReceiverName) {
        IMessageReceiver messageReceiver = this.listenerManager.getListener(messageReceiverName);
        return messageReceiver;
    }
}

