/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.listener;

import de.ponton.xmlpipe.queue.InboundQueue;
import de.pontonconsulting.xmlpipe.adapter.AdapterInfo;
import de.pontonconsulting.xmlpipe.adapter.AdapterRegistry;
import de.pontonconsulting.xmlpipe.config.IFolders;
import de.pontonconsulting.xmlpipe.listener.ErrorNotificationResult;
import de.pontonconsulting.xmlpipe.message.XpErrorNotification;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.message.signals.XpSignal;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageDAO;
import java.io.File;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ErrorNotificationService {
    private static final Logger LOG = LogManager.getLogger((String)"Messenger.ErrorNotificationService");
    private final InboundQueue _inboundMessageQueue;
    private final AdapterRegistry adapterRegistry;
    private final IFolders _folders;
    private final ReferenceDateTask referenceDateTask;
    private final MessageDAO _messageDAO;

    public ErrorNotificationService(InboundQueue inboundMessageQueue, IFolders folders, ReferenceDateTask referenceDateTask, MessageDAO messageDAO, AdapterRegistry adapterRegistry) {
        this._inboundMessageQueue = inboundMessageQueue;
        this._folders = folders;
        this.referenceDateTask = referenceDateTask;
        this._messageDAO = messageDAO;
        this.adapterRegistry = adapterRegistry;
    }

    public void notifyAdapter(XpMessage xpMessage, List<ErrorNotificationResult> results) {
        String adapterId = xpMessage.getAdapterId();
        if (adapterId == null || adapterId.isEmpty()) {
            return;
        }
        AdapterInfo adapterInfo = this.adapterRegistry.getAdapter(adapterId);
        if (adapterInfo == null || !adapterInfo.supportsErrorNotifications()) {
            LOG.debug("adapter {} does not support error notifications. delivery skipped.", (Object)adapterId);
            return;
        }
        try {
            XpSignal xpSignal = new XpSignal();
            xpSignal.setErrorNotification(true);
            xpSignal.setInboundMessage(true);
            xpSignal.setMessageId("Error_%d_%s".formatted(System.currentTimeMillis(), xpMessage.getMessageId()));
            xpSignal.setConversationId(xpMessage.getConversationId());
            xpSignal.setConversationDatabaseId(xpMessage.getConversationDatabaseId());
            xpSignal.setReferenceId(xpMessage.getMessageId());
            xpSignal.setReferenceDatabaseId(xpMessage.getDatabaseId());
            xpSignal.setSenderInternalId(xpMessage.getSenderInternalId());
            xpSignal.setSenderLocalId(xpMessage.getSenderLocalId());
            xpSignal.setReceiverInternalId(xpMessage.getReceiverInternalId());
            xpSignal.setReceiverLocalId(xpMessage.getReceiverLocalId());
            xpSignal.setAdapterId(xpMessage.getAdapterId());
            xpSignal.setAgreement(xpMessage.getAgreement());
            xpSignal.setOwnPartner(xpMessage.getOwnPartner());
            xpSignal.setCommunicationPartner(xpMessage.getCommunicationPartner());
            xpSignal.setCommunication(xpMessage.getCommunication());
            xpSignal.setMessagePackaging(xpMessage.getMessagePackaging());
            xpSignal.setMessageType("ErrorNotification");
            xpSignal.setMessageVersion("2.1");
            xpSignal.setSchemaSet("ponton");
            xpSignal.setMessageTimestamp(xpMessage.getMessageTimestamp());
            xpSignal.setProcessingDirectives(xpMessage.getProcessingDirectives());
            xpSignal.setProtocol(xpMessage.getProtocol());
            xpSignal.setSchemaLocation(xpMessage.getSchemaLocation());
            xpSignal.setSchemaNamespace(xpMessage.getSchemaNamespace());
            xpSignal.setProcessingDirective("ReferenceUniqueId", String.valueOf(xpMessage.getDatabaseId()));
            xpSignal.setProcessingDirective("ReferenceMessageType", xpMessage.getMessageType());
            xpSignal.setProcessingDirective("ReferenceSchemaSet", xpMessage.getSchemaSet());
            xpSignal.setProcessingDirective("ReferenceSchemaVersion", xpMessage.getMessageVersion());
            xpSignal.setProcessingDirective("ReferenceMessageId", xpMessage.getMessageId());
            xpSignal.setProcessingDirective("ReferenceConversationId", xpMessage.getConversationId());
            xpSignal.setProcessingDirective("ReferenceSenderId", xpMessage.getSenderInternalId());
            xpSignal.setProcessingDirective("ReferenceReceiverId", xpMessage.getReceiverInternalId());
            xpSignal.setProcessingDirective("ReferenceCreationTime", String.valueOf(xpMessage.getMessageTimestamp().getTime()));
            xpSignal.setProcessingDirective("ReferenceRegistrationTime", String.valueOf(xpMessage.getRegistrationTimestamp().getTime()));
            xpSignal.setProcessingDirective("ReferenceSequenceNumber", String.valueOf(xpMessage.getSequenceNumber()));
            String filename = xpMessage.getProcessingDirective("OriginalFilename");
            if (filename != null) {
                xpSignal.setProcessingDirective("OriginalFilename", filename);
            }
            xpSignal.setProcessingDirective("ReferenceContentType", xpMessage.getCurrentContentType());
            xpMessage.getProcessingDirectives().forEach((key, value) -> xpSignal.setProcessingDirective("ReferenceProcessingDirective_" + key, (String)value));
            if (!results.isEmpty()) {
                xpSignal.setProcessingDirective("ErrorNotificationResult", results.get(0).getCode().toString());
                xpSignal.setProcessingDirective("ErrorNotificationResultText", results.get(0).getDescription());
            }
            this._messageDAO.registerMessage(xpSignal);
            XpErrorNotification xpErrorNotification = new XpErrorNotification(xpMessage, xpSignal);
            for (ErrorNotificationResult result : results) {
                xpErrorNotification.addError(result.getCode(), result.getDescription());
            }
            File file = xpErrorNotification.saveToDisk(new File(this._folders.getWorkInboundFolder(), String.valueOf(xpSignal.getDatabaseId())));
            xpSignal.setCurrentContentReference(file);
            this._inboundMessageQueue.deliverMessageToAdapter(xpSignal.getAdapterId(), xpSignal);
        }
        catch (Exception e) {
            LOG.error("Could not create or process error notification: {}", (Object)e.getMessage());
        }
    }
}

