/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.listener;

import de.pontonconsulting.activation.ActivationException;
import de.pontonconsulting.xmlpipe.activation.MessengerActivation;
import de.pontonconsulting.xmlpipe.adapter.activation.MimeTypeMapper;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.config.MultipleSchemaSetFoundException;
import de.pontonconsulting.xmlpipe.config.SchemaData;
import de.pontonconsulting.xmlpipe.config.SchemataConfig;
import de.pontonconsulting.xmlpipe.cp.Option;
import de.pontonconsulting.xmlpipe.cpa.Communication;
import de.pontonconsulting.xmlpipe.cpp.CppPartner;
import de.pontonconsulting.xmlpipe.cpp.OptionNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.jaxb.as4.From;
import de.pontonconsulting.xmlpipe.jaxb.as4.MessageProperties;
import de.pontonconsulting.xmlpipe.jaxb.as4.PartInfo;
import de.pontonconsulting.xmlpipe.jaxb.as4.PartProperties;
import de.pontonconsulting.xmlpipe.jaxb.as4.PartyId;
import de.pontonconsulting.xmlpipe.jaxb.as4.PayloadInfo;
import de.pontonconsulting.xmlpipe.jaxb.as4.Property;
import de.pontonconsulting.xmlpipe.jaxb.as4.Schema;
import de.pontonconsulting.xmlpipe.jaxb.as4.SignalMessage;
import de.pontonconsulting.xmlpipe.jaxb.as4.To;
import de.pontonconsulting.xmlpipe.listener.AS4Exception;
import de.pontonconsulting.xmlpipe.message.XpAcknowledgment;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.database.DbException;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.messenger.packaging.AS4CertificateUpdateUtility;
import de.pontonconsulting.xmlpipe.messenger.packaging.AS4Error;
import de.pontonconsulting.xmlpipe.messenger.packaging.AS4PingMessageConverter;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import de.pontonconsulting.xmlpipe.security.CryptoManager;
import de.pontonconsulting.xmlpipe.security.IWSSecurity;
import de.pontonconsulting.xmlpipe.security.XpWSSecurity;
import de.pontonconsulting.xmlpipe.security.util.SignCertInfo;
import jakarta.mail.internet.ContentDisposition;
import jakarta.mail.internet.MimeUtility;
import jakarta.mail.internet.ParseException;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.xml.namespace.NamespaceContext;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AS4ProcessorHelper {
    public static String AS4_BDEW_SCHEMASET = "BDEW-Pathswitch";
    public static String AS4_BDEW_SCHEMASET_VERSION = "1.0";
    public static String AS4_BDEW_CONFIRM_SWITCH = "ConfirmSwitch";
    public static String AS4_BDEW_REQUEST_SWITCH = "RequestSwitch";
    public static String AS4_BDEW_SERVICE = "https://www.bdew.de/as4/communication/services/pathSwitch";
    public static String AS4_BDEW_ACTION_REQUEST_SWITCH = "https://www.bdew.de/as4/communication/actions/requestSwitch";
    public static String AS4_BDEW_ACTION_CONFIRM_SWITCH = "https://www.bdew.de/as4/communication/actions/confirmSwitch";
    public static String AS4_PACKAGE = "AS4";
    public static String PARTINFO_PROPERTY_COMPRESSION_TYPE = "CompressionType";
    public static String PARTINFO_PROPERTY_MIME_TYPE = "MimeType";
    public static String PARTINFO_PROPERTY_EDIGAS_DOCUMENT_TYPE = "EDIGASDocumentType";
    public static String MESSAGE = "/S12:Envelope/S12:Header/eb3:Messaging";
    public static String USER_MESSAGE = MESSAGE + "/eb3:UserMessage";
    public static String USER_MESSAGE_MSGID = USER_MESSAGE + "/eb3:MessageInfo/eb3:MessageId";
    public static String USER_MESSAGE_REFERENCE_ID = USER_MESSAGE + "/eb3:MessageInfo/eb3:RefToMessageId";
    public static String USER_MESSAGE_CONVERSATION_ID = USER_MESSAGE + "/eb3:CollaborationInfo/eb3:ConversationId";
    public static String USER_MESSAGE_SERVICETYPE = USER_MESSAGE + "/eb3:CollaborationInfo/eb3:Service/@type";
    public static String USER_MESSAGE_SERVICE = USER_MESSAGE + "/eb3:CollaborationInfo/eb3:Service";
    public static String USER_MESSAGE_ACTION = USER_MESSAGE + "/eb3:CollaborationInfo/eb3:Action";
    public static String USER_MESSAGE_AGREEMENT_REF = USER_MESSAGE + "/eb3:CollaborationInfo/eb3:AgreementRef";
    public static String USER_MESSAGE_AGREEMENT_REF_TYPE = USER_MESSAGE + "/eb3:CollaborationInfo/eb3:AgreementRef/@type";
    public static String USER_MESSAGE_FROM_TYPES = USER_MESSAGE + "/eb3:PartyInfo/eb3:From/eb3:PartyId/@type";
    public static String USER_MESSAGE_FROM_URI = USER_MESSAGE + "/eb3:PartyInfo/eb3:From/eb3:PartyId[@type='uri' or @type='URI' or string-length(@type) = 0]";
    public static String USER_MESSAGE_FROM_VALUE = USER_MESSAGE + "/eb3:PartyInfo/eb3:From/eb3:PartyId[@type='%s']";
    public static String USER_MESSAGE_TO = USER_MESSAGE + "/eb3:PartyInfo/eb3:To/eb3:PartyId/text()";
    public static String USER_MESSAGE_TO_URI = USER_MESSAGE + "/eb3:PartyInfo/eb3:To/eb3:PartyId[@type='uri' or @type='URI' or string-length(@type) = 0]";
    public static String PARTY_FROM_NODE = USER_MESSAGE + "/eb3:PartyInfo/eb3:From";
    public static String PARTY_TO_NODE = USER_MESSAGE + "/eb3:PartyInfo/eb3:To";
    public static String MESSAGE_PROPERTIES = USER_MESSAGE + "/eb3:MessageProperties";
    public static String USER_MESSAGE_TIMESTAMP = USER_MESSAGE + "/eb3:MessageInfo/eb3:Timestamp";
    public static String USER_MESSAGE_PAYLOAD = USER_MESSAGE + "/eb3:PayloadInfo";
    public static String SIGNAL_MESSAGE = "/S12:Envelope/S12:Header/eb3:Messaging/eb3:SignalMessage";
    public static String SIGNATURE_DSIG = "/S12:Envelope/S12:Header/wsse:Security/ds:Signature";
    public static String SIGNATURE_DSIG_REFERENCE = SIGNATURE_DSIG + "/ds:SignedInfo/ds:Reference";
    private static final String TRUE = "true";
    private static final Logger _log = LogManager.getLogger((String)"Messenger.AS4ProcessorHelper");
    private final NamespaceContext _namespaceContext;
    private final JAXBContext _as4JAXBContext;
    private final MessageDAO _messageDAO;
    private final MessengerLog _messengerLog;
    private final CryptoManager _cryptoManager;
    private final IWSSecurity _wsSecurity;
    private final SchemataConfig _schemataConfig;
    private final CertificateUtility _certificateUtility;
    private final AS4PingMessageConverter as4PingMessageConverter;
    private final AS4CertificateUpdateUtility as4CertificateUpdateUtility;
    private final MessengerActivation _activationProvider;
    private final MessengerConfig messengerConfig;
    private final Profiles _profiles;

    public AS4ProcessorHelper(NamespaceContext namespaceContext, JAXBContext as4JAXBContext, MessageDAO messageDAO, MessengerLog messengerLog, CryptoManager cryptoManager, IWSSecurity wsSecurity, SchemataConfig schemataConfig, CertificateUtility certificateUtility, AS4PingMessageConverter as4PingMessageConverter, AS4CertificateUpdateUtility as4CertificateUpdateUtility, MessengerActivation activationProvider, MessengerConfig messengerConfig, Profiles profiles) {
        this._namespaceContext = namespaceContext;
        this._as4JAXBContext = as4JAXBContext;
        this._messageDAO = messageDAO;
        this._messengerLog = messengerLog;
        this._cryptoManager = cryptoManager;
        this._wsSecurity = wsSecurity;
        this._schemataConfig = schemataConfig;
        this._certificateUtility = certificateUtility;
        this.as4PingMessageConverter = as4PingMessageConverter;
        this.as4CertificateUpdateUtility = as4CertificateUpdateUtility;
        this._activationProvider = activationProvider;
        this.messengerConfig = messengerConfig;
        this._profiles = profiles;
    }

    public String evalXPath(Source source, String xpath) {
        if (source == null) {
            return null;
        }
        Node node = null;
        if (!(source instanceof DOMSource)) {
            return null;
        }
        node = ((DOMSource)source).getNode();
        return this.evaluateXPath(node, xpath);
    }

    public Node evalXPathToNode(Source source, String xpath) {
        if (source == null) {
            return null;
        }
        Node node = null;
        if (!(source instanceof DOMSource)) {
            return null;
        }
        node = ((DOMSource)source).getNode();
        XPath xPath = this.createXPath();
        try {
            return (Node)xPath.evaluate(xpath, node, XPathConstants.NODE);
        }
        catch (XPathExpressionException ex) {
            _log.error("xpath problem: {}", (Object)ex.getMessage());
            return null;
        }
    }

    public Node evalXPathToNode(Document document, String xpath) {
        if (document == null) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)xpath)) {
            return null;
        }
        XPath xPath = this.createXPath();
        try {
            return (Node)xPath.evaluate(xpath, document, XPathConstants.NODE);
        }
        catch (XPathExpressionException ex) {
            _log.error("xpath problem {}", (Object)ex.getMessage());
            return null;
        }
    }

    public Map<String, String> getToPartyIds(Source source) throws AS4Exception {
        try {
            Node partyIdNode = this.evalXPathToNode(source, PARTY_TO_NODE);
            if (partyIdNode != null) {
                JAXBElement to = this.getUnmarshaller().unmarshal(partyIdNode, To.class);
                return this.toHashMap(((To)to.getValue()).getPartyId());
            }
        }
        catch (JAXBException ex) {
            _log.error("JAXB problem with PartyInfo/To unmarshalling {}", (Object)ex.getMessage());
        }
        throw new AS4Exception(AS4Error.EBMS_0009, "PartyInfo/To  format invalid");
    }

    public Map<String, String> getFromPartyIds(Source source) throws AS4Exception {
        try {
            Node partyIdNode = this.evalXPathToNode(source, PARTY_FROM_NODE);
            if (partyIdNode != null) {
                JAXBElement from = this.getUnmarshaller().unmarshal(partyIdNode, From.class);
                return this.toHashMap(((From)from.getValue()).getPartyId());
            }
        }
        catch (JAXBException ex) {
            _log.error("JAXB problem with PartyInfo/From unmarshalling {}", (Object)ex.getMessage());
        }
        throw new AS4Exception(AS4Error.EBMS_0009, "PartyInfo/From  format invalid");
    }

    public Map<String, String> getMessageProperties(Source source) throws AS4Exception {
        try {
            Node messageProperties = this.evalXPathToNode(source, MESSAGE_PROPERTIES);
            if (messageProperties != null) {
                JAXBElement from = this.getUnmarshaller().unmarshal(messageProperties, MessageProperties.class);
                return this.messagePropertiesToHashMap(((MessageProperties)from.getValue()).getProperty());
            }
        }
        catch (JAXBException ex) {
            _log.error("MessageProperties format invalid {}", (Object)ex.getMessage());
            throw new AS4Exception(AS4Error.EBMS_0009, "MessageProperties format invalid");
        }
        return new HashMap<String, String>();
    }

    public Date evalXPathDate(Source source, String userMessageTimestamp) {
        String timestamp = this.evalXPath(source, userMessageTimestamp);
        return this.parseDateTime(timestamp);
    }

    private Date parseDateTime(String timestamp) {
        try {
            OffsetDateTime offsetDateTime = OffsetDateTime.parse(timestamp, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
            return Date.from(offsetDateTime.toInstant());
        }
        catch (DateTimeParseException offsetDateTimeParseException) {
            try {
                LocalDateTime localDateTime = LocalDateTime.parse(timestamp, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
                return Date.from(localDateTime.toInstant(ZoneOffset.UTC));
            }
            catch (DateTimeParseException localDateTimeParseException) {
                throw new IllegalArgumentException("invalid timestamp format " + timestamp);
            }
        }
    }

    public boolean isSyncResponse(Communication communication) {
        return this.isOptionActivated(communication, "/SendReceipt/SyncReply");
    }

    public boolean isDuplicateElimination(Communication communication) {
        return this.isOptionActivated(communication, "/DuplicateElimination");
    }

    private boolean isExpectCompressedContent(Communication communication) {
        return this.isOptionActivated(communication, "/ExpectCompressedContent");
    }

    public boolean isSendReceipt(Communication communication) {
        return this.getPackagingOption(communication, "/SendReceipt") != null;
    }

    private boolean isOptionActivated(Communication communication, String optionString) {
        return Boolean.valueOf(this.getPackagingOption(communication, optionString));
    }

    private String getPackagingOption(Communication communication, String optionString) {
        try {
            Option option = communication.getPackagingOption(optionString);
            return option.getValue();
        }
        catch (OptionNotFoundException option) {
        }
        catch (Exception ex) {
            _log.error(ex.getMessage());
        }
        return null;
    }

    public boolean containsUserMessages(Source source) {
        try {
            NodeList result = this.evalXPathToNodeList(source, USER_MESSAGE);
            return result.getLength() > 0;
        }
        catch (XPathExpressionException xPathExpressionException) {
            return false;
        }
    }

    public boolean containsSignals(Source source) {
        try {
            NodeList result = this.evalXPathToNodeList(source, SIGNAL_MESSAGE);
            if (result != null) {
                return result.getLength() > 0;
            }
            return false;
        }
        catch (XPathExpressionException xPathExpressionException) {
            return false;
        }
    }

    public List<SignalMessage> getSignals(Source source) {
        ArrayList<SignalMessage> signals = new ArrayList<SignalMessage>();
        try {
            NodeList result = this.evalXPathToNodeList(source, SIGNAL_MESSAGE);
            if (result != null && result.getLength() != 0) {
                for (int index = 0; index < result.getLength(); ++index) {
                    Node node = result.item(index);
                    JAXBElement message = this.getUnmarshaller().unmarshal(node, SignalMessage.class);
                    signals.add((SignalMessage)message.getValue());
                }
                return signals;
            }
        }
        catch (XPathExpressionException e) {
            _log.error("xpath problem " + String.valueOf(e));
        }
        catch (JAXBException e) {
            _log.error("xpath problem " + String.valueOf((Object)e));
        }
        return Collections.emptyList();
    }

    public XpMessage createUserMessage(Source source) throws AS4Exception {
        String action = this.evalXPath(source, USER_MESSAGE_ACTION);
        String service = this.evalXPath(source, USER_MESSAGE_SERVICE);
        String serviceType = this.evalXPath(source, USER_MESSAGE_SERVICETYPE);
        String agreementRef = this.evalXPath(source, USER_MESSAGE_AGREEMENT_REF);
        String agreementRefType = this.evalXPath(source, USER_MESSAGE_AGREEMENT_REF_TYPE);
        String messageId = this.evalXPath(source, USER_MESSAGE_MSGID);
        String conversationId = this.evalXPath(source, USER_MESSAGE_CONVERSATION_ID);
        HashMap messageProperties = (HashMap)this.getMessageProperties(source);
        Date messageTimestamp = this.evalXPathDate(source, USER_MESSAGE_TIMESTAMP);
        XpMessage xpMessage = new XpMessage();
        xpMessage.setMessageId(messageId);
        xpMessage.setConversationId(conversationId);
        xpMessage.setProcessingDirectives(messageProperties);
        xpMessage.setMessagePackaging(AS4_PACKAGE);
        xpMessage.setInboundMessage(true);
        xpMessage.setMessageTimestamp(messageTimestamp);
        xpMessage.setMessengerId(this.messengerConfig.getMessengerId());
        String flag = xpMessage.getProcessingDirective("TestFlag");
        if (TRUE.equalsIgnoreCase(flag)) {
            xpMessage.setTestMessage(true);
        }
        xpMessage.setProcessingDirective("service", service);
        if (serviceType != null) {
            xpMessage.setProcessingDirective("servicetype", serviceType);
        }
        xpMessage.setProcessingDirective("action", action);
        if (agreementRef != null) {
            xpMessage.setProcessingDirective("agreementRef", agreementRef);
        }
        if (agreementRefType != null) {
            xpMessage.setProcessingDirective("agreementRefType", agreementRefType);
        }
        this.populateLocalIds(source, xpMessage);
        return xpMessage;
    }

    public SOAPMessage signMessage(SOAPMessage originalMessage, XpMessage xpMessage) throws GeneralSecurityException {
        try {
            SOAPMessage resultSoapMessage = null;
            String algorithmOptionPath = "/SignMessage";
            String keyInfoOption = "/SignMessage/KeyInfo";
            Communication communication = xpMessage.getCommunication();
            if (xpMessage.isAck()) {
                algorithmOptionPath = "/SendReceipt";
                keyInfoOption = "/SendReceipt/KeyInfo";
                communication = xpMessage.getAgreement().getCommunication(xpMessage.getReceiverLocalId(), xpMessage.getSenderLocalId());
            }
            String algorithm = null;
            try {
                algorithm = communication.getPackagingOptionValue(algorithmOptionPath);
                if ("unsigned".equals(algorithm)) {
                    algorithm = null;
                }
            }
            catch (OptionNotFoundException optionNotFoundException) {
                // empty catch block
            }
            if (algorithm != null) {
                if (_log.isDebugEnabled()) {
                    _log.debug("Signature needs to be generated");
                }
                SignCertInfo signCertInfo = xpMessage.isAck() ? communication.getPackagingAckSignKey() : communication.getPackagingSignKey();
                CppPartner ownPartner = this._profiles.getProfileForLocalId(xpMessage.getAgreement().getOwnPartner().getId(), true);
                SignCertInfo selectedSignCertInfo = this.isCertificateUpdateRelated(xpMessage, ownPartner) ? ownPartner.getPrivateKey(communication.getAgreement().getAS4CertUpdateID()) : signCertInfo;
                String keyInfoType = this.getPackagingOption(communication, keyInfoOption);
                Crypto crypto = ownPartner.getCrypto();
                resultSoapMessage = this._wsSecurity.sign(originalMessage, crypto, selectedSignCertInfo, algorithm, keyInfoType);
                String usingInfoText = this._certificateUtility.toUsingInfoText(selectedSignCertInfo.getCertificateChain()[0], "(" + AS4_PACKAGE + ") using " + algorithm + ", " + keyInfoType + " and certificate");
                if (_log.isDebugEnabled()) {
                    _log.debug("Created Signature {}", (Object)usingInfoText);
                }
                this._messengerLog.log2db(73, xpMessage.getDatabaseId(), usingInfoText);
            } else {
                resultSoapMessage = originalMessage;
            }
            return resultSoapMessage;
        }
        catch (Exception ex) {
            throw new GeneralSecurityException(ex);
        }
    }

    private boolean isCertificateUpdateRelated(XpMessage xpMessage, CppPartner partner) {
        if (!this.checkMessageTypeIsAS4Ping(xpMessage)) {
            return false;
        }
        if (!this.as4PingMessageConverter.isAS4UpdateTestMessage(xpMessage)) {
            return false;
        }
        String as4CertUpdateInitiator = xpMessage.getAgreement().getAS4CertUpdateInitiator();
        return partner.getLocalId().equals(as4CertUpdateInitiator);
    }

    private <T> T getValueOrDefault(T value, T defaultValue) {
        return value == null ? defaultValue : value;
    }

    public SOAPMessage encryptMessage(SOAPMessage originalMessage, XpMessage xpMessage) throws GeneralSecurityException {
        String algorithm = null;
        try {
            String algorithmOption = "/EncryptMessage";
            String keyInfoOption = "/EncryptMessage/KeyInfo";
            String keyEncAlgorithmOption = "/EncryptMessage/KeyEncryption";
            SOAPMessage resultSoapMessage = null;
            Communication communication = xpMessage.getCommunication();
            try {
                algorithm = communication.getPackagingOptionValue("/EncryptMessage");
            }
            catch (OptionNotFoundException optionNotFoundException) {
                // empty catch block
            }
            if (algorithm != null) {
                if (_log.isDebugEnabled()) {
                    _log.debug("Encryption needs to be generated");
                }
                String keyInfoType = this.getValueOrDefault(this.getPackagingOption(communication, "/EncryptMessage/KeyInfo"), "IssuerAndSerialNumber");
                String keyEncAlgorithm = this.getValueOrDefault(this.getPackagingOption(communication, "/EncryptMessage/KeyEncryption"), "rsa-oaep");
                CppPartner communicationPartner = this._profiles.getProfileForLocalId(xpMessage.getAgreement().getCommunicationPartner().getId(), true);
                X509Certificate certificate = this.isCertificateUpdateRelated(xpMessage, communicationPartner) ? communicationPartner.getX509Certificate(communication.getAgreement().getAS4CertUpdateID()) : communication.getPackagingEncryptionCertificate();
                if (certificate == null) {
                    throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "No receiver certificate found.");
                }
                if (keyEncAlgorithm.toLowerCase().startsWith("rsa") && certificate.getPublicKey() instanceof ECPublicKey) {
                    throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, keyEncAlgorithm + " does not support ECPublicKey.");
                }
                if (keyEncAlgorithm.toLowerCase().startsWith("ecdh") && certificate.getPublicKey() instanceof RSAPublicKey) {
                    throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, keyEncAlgorithm + " does not support RSAPublicKey.");
                }
                resultSoapMessage = this._wsSecurity.encrypt(originalMessage, communicationPartner.getCrypto(), certificate, algorithm, keyInfoType, keyEncAlgorithm);
                String usingInfoText = this._certificateUtility.toUsingInfoText(certificate, "(" + AS4_PACKAGE + ") using " + algorithm + ", " + keyEncAlgorithm + ", " + keyInfoType + " and certificate");
                _log.debug("Encrypted Message {}", (Object)usingInfoText);
                this._messengerLog.log2db(90, xpMessage.getDatabaseId(), usingInfoText);
            } else {
                resultSoapMessage = originalMessage;
            }
            return resultSoapMessage;
        }
        catch (Exception ex) {
            throw new GeneralSecurityException(ex.getMessage(), ex);
        }
    }

    public void saveAckToDiskAndUpdateMessage(XpAcknowledgment ack, XpMessage xpMessage) {
        try {
            File ackRef = ack.saveToDisk(xpMessage.getCurrentContentReferenceFolder());
            xpMessage.setCurrentContentReference(ackRef);
            this._messageDAO.updateMessage(xpMessage);
        }
        catch (DbException | JAXBException ex) {
            _log.fatal("Acknowledgment could not be processed due to a {}: {}", (Object)ex.getClass().getSimpleName(), (Object)ex.getMessage());
        }
    }

    private void populateLocalIds(Source source, XpMessage xpMessage) {
        String toUrl = "unknown";
        String fromUrl = "unknown";
        String to = this.evalXPath(source, USER_MESSAGE_TO_URI);
        String from = this.evalXPath(source, USER_MESSAGE_FROM_URI);
        if (to != null && to.length() > 19) {
            toUrl = to.substring(0, 19);
        }
        if (from != null && from.length() > 19) {
            fromUrl = from.substring(0, 19);
        }
        xpMessage.setSenderLocalId(fromUrl);
        xpMessage.setReceiverLocalId(toUrl);
    }

    public void storeEnvelope(SOAPMessage soapMessage, XpMessage message) {
        File ebxmlEnvelopeFile = new File(message.getCurrentContentReferenceFolder(), "packaging_envelope.xml");
        try (BufferedOutputStream fos = new BufferedOutputStream(Files.newOutputStream(ebxmlEnvelopeFile.toPath(), new OpenOption[0]));){
            soapMessage.setProperty("javax.xml.soap.write-xml-declaration", (Object)TRUE);
            soapMessage.setProperty("javax.xml.soap.character-set-encoding", (Object)"UTF-8");
            ArrayList<AttachmentPart> attachments = new ArrayList<AttachmentPart>();
            Iterator iter = soapMessage.getAttachments();
            while (iter.hasNext()) {
                attachments.add((AttachmentPart)iter.next());
            }
            soapMessage.removeAllAttachments();
            soapMessage.saveChanges();
            soapMessage.writeTo((OutputStream)fos);
            for (int i = 0; i < attachments.size(); ++i) {
                AttachmentPart temp = (AttachmentPart)attachments.get(i);
                soapMessage.addAttachmentPart(temp);
            }
            soapMessage.saveChanges();
        }
        catch (IOException | SOAPException e) {
            _log.error("Could not store envelope. ", e);
        }
    }

    private String determineProcessedOriginalFilename(AttachmentPart attachmentPart, XpMessage xpMessage, boolean isCompressed) {
        Object processedOriginalFilename = null;
        String[] contentDispositionValues = attachmentPart.getMimeHeader("Content-Disposition");
        if (contentDispositionValues != null && contentDispositionValues.length > 0) {
            try {
                ContentDisposition contentDisposition = new ContentDisposition(contentDispositionValues[0]);
                processedOriginalFilename = contentDisposition.getParameter("filename");
                if (StringUtils.isNotBlank((CharSequence)processedOriginalFilename)) {
                    _log.trace("Filename '{}' from content disposition header", processedOriginalFilename);
                    processedOriginalFilename = this.decodeValue((String)processedOriginalFilename);
                    _log.trace("Decoded filename '{}", processedOriginalFilename);
                }
            }
            catch (ParseException e) {
                _log.error("Could not get filename from Content-Disposition: {}", (Object)String.valueOf((Object)e));
            }
        }
        if (processedOriginalFilename == null) {
            processedOriginalFilename = attachmentPart.getContentId().replace("<", "").replace(">", "");
            _log.trace("Filename '{}' from content id", processedOriginalFilename);
        }
        if (((String)processedOriginalFilename).toLowerCase().endsWith(".gz")) {
            processedOriginalFilename = ((String)processedOriginalFilename).substring(0, ((String)processedOriginalFilename).length() - ".gz".length());
            _log.trace("Filename '{}' after removing '.gz'", processedOriginalFilename);
        }
        if (xpMessage.getCurrentContentType() != null) {
            processedOriginalFilename = this.getNameWithoutExtension((String)processedOriginalFilename) + MimeTypeMapper.getExtension((String)xpMessage.getCurrentContentType());
            _log.trace("Filename '{}' after adding default file extension", processedOriginalFilename);
        }
        return processedOriginalFilename;
    }

    private String getNameWithoutExtension(String file) {
        String fileName = new File(file).getName();
        int dotIndex = fileName.lastIndexOf(46);
        return dotIndex == -1 ? fileName : fileName.substring(0, dotIndex);
    }

    private String decodeValue(String value) {
        if (value == null) {
            return null;
        }
        try {
            return MimeUtility.decodeText((String)value);
        }
        catch (UnsupportedEncodingException ex) {
            _log.error(ex.getMessage());
            return value;
        }
    }

    public void storeAttachments(SOAPMessage soapMessage, XpMessage xpMessage) throws SOAPException, JAXBException, IOException, AS4Exception, DbException {
        File workfolder = xpMessage.getCurrentContentReferenceFolder();
        Source source = soapMessage.getSOAPPart().getContent();
        Node payloadNode = this.evalXPathToNode(source, USER_MESSAGE_PAYLOAD);
        if (payloadNode == null) {
            _log.warn("No content sent. Creating dummy content.");
            File attachmentFile = new File(workfolder, "payload.xml");
            Files.write(attachmentFile.toPath(), "<dummy/>".getBytes(), new OpenOption[0]);
            xpMessage.setCurrentContentType("application/xml");
            xpMessage.setCurrentContentReference(attachmentFile);
            this.detectMessageType(xpMessage, null);
            this._messageDAO.updateMessage(xpMessage);
            return;
        }
        JAXBElement payloadInfo = this.getUnmarshaller().unmarshal(payloadNode, PayloadInfo.class);
        for (PartInfo partInfo : ((PayloadInfo)payloadInfo.getValue()).getPartInfo()) {
            String strippedCid = StringUtils.removeStart((String)partInfo.getHref(), (String)"cid:");
            MimeHeaders header = new MimeHeaders();
            header.addHeader("Content-ID", strippedCid);
            Iterator parts = soapMessage.getAttachments(header);
            if (!parts.hasNext()) {
                MimeHeaders header2 = new MimeHeaders();
                header2.addHeader("Content-ID", "<" + strippedCid + ">");
                parts = soapMessage.getAttachments(header2);
            }
            if (parts.hasNext()) {
                boolean isCompressed;
                AttachmentPart firstAttachment = (AttachmentPart)parts.next();
                String mimeTypeProperty = this.getPartPropertyValue(partInfo, PARTINFO_PROPERTY_MIME_TYPE);
                if (mimeTypeProperty != null) {
                    xpMessage.setCurrentContentType(mimeTypeProperty);
                }
                boolean bl = isCompressed = this.getPartPropertyValue(partInfo, PARTINFO_PROPERTY_COMPRESSION_TYPE) != null;
                if (this.getPartPropertyValue(partInfo, "ProcessedOriginalFilename") == null) {
                    String processedOriginalFilename = this.determineProcessedOriginalFilename(firstAttachment, xpMessage, isCompressed);
                    xpMessage.setProcessingDirective("ProcessedOriginalFilename", processedOriginalFilename);
                    _log.trace("Set processing directive ProcessedOriginalFilename to {}", (Object)processedOriginalFilename);
                }
                File attachmentFile = new File(workfolder, "payload" + MimeTypeMapper.getExtension((String)xpMessage.getCurrentContentType()));
                boolean expectCompressedContent = this.isExpectCompressedContent(xpMessage.getCommunication());
                if (isCompressed) {
                    File compressedFile = new File(workfolder, attachmentFile.getName() + ".gz");
                    if (!expectCompressedContent) {
                        throw new AS4Exception(AS4Error.EBMS_0303, "(" + AS4_PACKAGE + ") Compression is not expected, but the content is compressed.");
                    }
                    try (BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(compressedFile.toPath(), new OpenOption[0]));){
                        firstAttachment.getDataHandler().writeTo((OutputStream)os);
                    }
                    try (GZIPInputStream fis = new GZIPInputStream(new BufferedInputStream(Files.newInputStream(compressedFile.toPath(), new OpenOption[0])));
                         BufferedOutputStream fos = new BufferedOutputStream(Files.newOutputStream(attachmentFile.toPath(), new OpenOption[0]));){
                        fis.transferTo(fos);
                    }
                    long before = compressedFile.length();
                    long after = attachmentFile.length();
                    this._messengerLog.log2db(69, xpMessage.getDatabaseId(), "(" + AS4_PACKAGE + ") " + before + " bytes -> " + after + " bytes");
                } else {
                    if (expectCompressedContent) {
                        throw new AS4Exception(AS4Error.EBMS_0303, "(" + AS4_PACKAGE + ") Compression is expected, but the content is not compressed.");
                    }
                    try (BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(attachmentFile.toPath(), new OpenOption[0]));){
                        firstAttachment.getDataHandler().writeTo((OutputStream)os);
                    }
                }
                xpMessage.setCurrentContentReference(attachmentFile);
                this.detectMessageType(xpMessage, partInfo);
                this._messageDAO.updateMessage(xpMessage);
                continue;
            }
            throw new AS4Exception(AS4Error.EBMS_0011, "Attachment with " + partInfo.getHref() + " was not found in the mime structure.");
        }
    }

    private void detectMessageType(XpMessage xpMessage, PartInfo partInfo) {
        String service = xpMessage.getProcessingDirectives().get("service");
        String action = xpMessage.getProcessingDirectives().get("action");
        if ("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/test".equals(action) && "http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/service".equals(service)) {
            this.as4PingMessageConverter.convertInboundMessage(xpMessage);
        } else if (AS4_BDEW_SERVICE.equals(service) && AS4_BDEW_ACTION_REQUEST_SWITCH.equals(action)) {
            SchemaData schema = this._schemataConfig.getSchemaBySetTypeVersion(AS4_BDEW_SCHEMASET, AS4_BDEW_REQUEST_SWITCH, AS4_BDEW_SCHEMASET_VERSION);
            this.setSchemaData(xpMessage, schema);
            this.copyPayloadPropertiesToXpMessage(partInfo, xpMessage);
        } else if (AS4_BDEW_SERVICE.equals(service) && AS4_BDEW_ACTION_CONFIRM_SWITCH.equals(action)) {
            SchemaData schema = this._schemataConfig.getSchemaBySetTypeVersion(AS4_BDEW_SCHEMASET, AS4_BDEW_CONFIRM_SWITCH, AS4_BDEW_SCHEMASET_VERSION);
            this.setSchemaData(xpMessage, schema);
            this.copyPayloadPropertiesToXpMessage(partInfo, xpMessage);
        } else if ("http://docs.oasis-open.org/ebcore/ns/CertificateUpdate/v1.0".equals(service)) {
            if ("UpdateCertificate".equals(action)) {
                this.as4CertificateUpdateUtility.setMessageTypeToCertificateUpdateRequest(xpMessage);
            } else if ("ConfirmCertificateUpdate".equals(action)) {
                this.as4CertificateUpdateUtility.setMessageTypeToCertificateUpdateResponse(xpMessage);
            } else if ("RejectCertificateUpdate".equals(action)) {
                this.as4CertificateUpdateUtility.setMessageTypeToCertificateUpdateException(xpMessage);
            }
        } else {
            this.recognizeMessageType(partInfo, xpMessage);
            this.copyPayloadPropertiesToXpMessage(partInfo, xpMessage);
        }
    }

    private void copyPayloadPropertiesToXpMessage(PartInfo partInfo, XpMessage xpMessage) {
        if (partInfo == null) {
            return;
        }
        PartProperties partProperties = partInfo.getPartProperties();
        if (partProperties == null) {
            return;
        }
        partProperties.getProperty().forEach(property -> {
            String currentProcessingDirective = xpMessage.getProcessingDirective(property.getName());
            if (StringUtils.isBlank((CharSequence)currentProcessingDirective)) {
                xpMessage.setProcessingDirective(property.getName(), property.getValue());
            }
        });
    }

    private void recognizeMessageType(PartInfo partInfo, XpMessage xpMessage) {
        String edigasDocTypeProperty = this.getPartPropertyValue(partInfo, PARTINFO_PROPERTY_EDIGAS_DOCUMENT_TYPE);
        SchemaData schemaData = null;
        if (edigasDocTypeProperty != null) {
            if (_log.isDebugEnabled()) {
                _log.debug("Found {} with value '{}'.", (Object)PARTINFO_PROPERTY_EDIGAS_DOCUMENT_TYPE, (Object)edigasDocTypeProperty);
            }
            try {
                schemaData = this._schemataConfig.fetchSchemaDataFromContentProperty(PARTINFO_PROPERTY_EDIGAS_DOCUMENT_TYPE, edigasDocTypeProperty);
            }
            catch (MultipleSchemaSetFoundException e) {
                _log.warn("Could not identify MessageType for received {} with value '{}': {}", (Object)PARTINFO_PROPERTY_EDIGAS_DOCUMENT_TYPE, (Object)edigasDocTypeProperty, (Object)e.getMessage());
            }
        }
        if (schemaData == null) {
            String schemaLocation;
            Schema schemaElement = partInfo.getSchema();
            if (schemaElement != null && StringUtils.isNotBlank((CharSequence)(schemaLocation = schemaElement.getLocation()))) {
                _log.info("Found schema location in the AS4 envelope: {}.", (Object)schemaLocation);
                if ("BINARY".equals(schemaLocation)) {
                    _log.info("Ignored schemaLocation '{}'.", (Object)"BINARY");
                } else {
                    xpMessage.setSchemaLocation(schemaLocation);
                }
            }
        } else {
            this.setSchemaData(xpMessage, schemaData);
        }
    }

    private void setSchemaData(XpMessage xpMessage, SchemaData schemaData) {
        if (_log.isDebugEnabled()) {
            _log.debug("Recognized MessageType: {}", (Object)schemaData.toString());
        }
        xpMessage.setSchemaLocation(schemaData.getName());
        xpMessage.setSchemaSet(schemaData.getSchemaSetName());
        xpMessage.setMessageType(schemaData.getMessageType());
        xpMessage.setMessageVersion(schemaData.getMessageVersion());
    }

    private String getPartPropertyValue(PartInfo partInfo, String propertyName) {
        PartProperties partProperties = partInfo.getPartProperties();
        if (partProperties == null) {
            return null;
        }
        Property property = (Property)CollectionUtils.find((Collection)partProperties.getProperty(), object -> {
            if (object instanceof Property) {
                Property prop = (Property)object;
                return propertyName.equals(prop.getName());
            }
            return false;
        });
        return property == null ? null : property.getValue();
    }

    private Unmarshaller getUnmarshaller() throws JAXBException {
        return this._as4JAXBContext.createUnmarshaller();
    }

    private String evaluateXPath(Object item, String expression) {
        if (item == null) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)expression)) {
            return null;
        }
        try {
            XPath xPath = this.createXPath();
            return (String)xPath.evaluate(expression, item, XPathConstants.STRING);
        }
        catch (Exception ex) {
            _log.error("xpath problem " + String.valueOf(ex));
            return null;
        }
    }

    public NodeList evalXPathToNodeList(Source source, String expression) throws XPathExpressionException {
        XPath xPath = this.createXPath();
        Node node = null;
        if (!(source instanceof DOMSource)) {
            return null;
        }
        node = ((DOMSource)source).getNode();
        return (NodeList)xPath.evaluate(expression, node, XPathConstants.NODESET);
    }

    public SOAPMessage processSecurityHeaders(SOAPMessage soapMessage, XpMessage xpMessage, List<InputStream> openedInputStreams) throws AS4Exception {
        String usingInfoText;
        String signAlgorithm = null;
        String encAlgorithm = null;
        XpWSSecurity.SecurityResult securityResult = null;
        String type = "Message";
        try {
            if (xpMessage.isAck()) {
                type = "Acknowledgment";
                signAlgorithm = this.getPackagingOption(xpMessage.getAgreement().getCommunication(xpMessage.getReceiverLocalId(), xpMessage.getSenderLocalId()), "/ExpectReceipt");
                if ("unsigned".equals(signAlgorithm)) {
                    signAlgorithm = null;
                }
            } else {
                signAlgorithm = this.getPackagingOption(xpMessage.getCommunication(), "/ExpectSignedMessage");
                encAlgorithm = this.getPackagingOption(xpMessage.getCommunication(), "/ExpectEncryptedMessage");
            }
            CppPartner ownPartner = this._profiles.getProfileForLocalId(xpMessage.getReceiverLocalId(), true);
            CppPartner communicationPartner = this._profiles.getProfileForLocalId(xpMessage.getSenderLocalId(), true);
            securityResult = this._wsSecurity.processSecurityHeaders(ownPartner.getCrypto(), communicationPartner.getCrypto(), soapMessage, openedInputStreams);
        }
        catch (WSSecurityException e) {
            switch (e.getErrorCode()) {
                case FAILED_ENCRYPTION: {
                    throw new AS4Exception(AS4Error.EBMS_0102, e.getMessage(), e);
                }
                case FAILED_SIGNATURE: {
                    throw new AS4Exception(AS4Error.EBMS_0101, e.getMessage(), e);
                }
                case FAILED_CHECK: {
                    throw new AS4Exception(AS4Error.EBMS_0101, e.getMessage(), e);
                }
            }
            throw new AS4Exception(AS4Error.EBMS_0003, e.getMessage(), e);
        }
        catch (Exception e) {
            _log.error("security headers could not be processed: {}", (Object)e.toString());
            throw new AS4Exception(AS4Error.EBMS_0004, e.getMessage(), e);
        }
        String usedEncAlgorithm = securityResult.getEncAlgorithm();
        if (encAlgorithm == null || encAlgorithm.isEmpty()) {
            if (usedEncAlgorithm != null) {
                errorMsg = "(" + AS4_PACKAGE + ") " + type + " is encrypted, but decryption is disabled in agreement.";
                this._messengerLog.log2db(506, xpMessage.getDatabaseId(), errorMsg);
                throw new AS4Exception(AS4Error.EBMS_0103, errorMsg);
            }
        } else if (soapMessage.countAttachments() == 0) {
            _log.warn("No content was sent. Ignoring encryption check.");
        } else {
            if (usedEncAlgorithm == null) {
                errorMsg = "(" + AS4_PACKAGE + ") " + type + " should be encrypted, but is not encrypted.";
                this._messengerLog.log2db(506, xpMessage.getDatabaseId(), errorMsg);
                throw new AS4Exception(AS4Error.EBMS_0103, errorMsg);
            }
            if (!encAlgorithm.equals(usedEncAlgorithm)) {
                errorMsg = "(" + AS4_PACKAGE + ") " + type + " is encrypted with the algorithm " + usedEncAlgorithm + " instead of " + encAlgorithm + ".";
                this._messengerLog.log2db(506, xpMessage.getDatabaseId(), errorMsg);
                throw new AS4Exception(AS4Error.EBMS_0103, errorMsg);
            }
            _log.debug("Decryption OK");
            X509Certificate encCertificate = securityResult.getEncCertificate();
            if (encCertificate != null) {
                try {
                    this._cryptoManager.checkCertificateForDecryption(encCertificate, xpMessage);
                }
                catch (GeneralSecurityException e) {
                    this._messengerLog.log2db(506, xpMessage.getDatabaseId(), e.getMessage());
                    throw new AS4Exception(AS4Error.EBMS_0102, e.getMessage(), e);
                }
                String keyInfoType = securityResult.getEncKeyInfoType() != null ? securityResult.getEncKeyInfoType() : "[no KeyInfoType found]";
                String keyEncAlgorithmPart = securityResult.getKeyEncAlgorithm() != null ? securityResult.getKeyEncAlgorithm() + ", " : "";
                usingInfoText = this._certificateUtility.toUsingInfoText(encCertificate, "(" + AS4_PACKAGE + ") using " + usedEncAlgorithm + ", " + keyEncAlgorithmPart + keyInfoType + " and certificate");
                if (securityResult.getEncKeyInfoType() == null) {
                    _log.warn("Decrypted Message {}", (Object)usingInfoText);
                } else if (_log.isDebugEnabled()) {
                    _log.debug("Decrypted Message {}", (Object)usingInfoText);
                }
                this._messengerLog.log2db(91, xpMessage.getDatabaseId(), usingInfoText);
            }
        }
        String usedSignAlgorithm = securityResult.getSignAlgorithm();
        if (signAlgorithm == null || signAlgorithm.isEmpty()) {
            if (usedSignAlgorithm != null) {
                errorMsg = "(" + AS4_PACKAGE + ") " + type + " is signed, but signing is disabled in agreement.";
                this._messengerLog.log2db(504, xpMessage.getDatabaseId(), errorMsg);
                throw new AS4Exception(AS4Error.EBMS_0101, errorMsg);
            }
        } else {
            if (usedSignAlgorithm == null) {
                errorMsg = "(" + AS4_PACKAGE + ") " + type + " should be signed, but is not signed.";
                this._messengerLog.log2db(504, xpMessage.getDatabaseId(), errorMsg);
                throw new AS4Exception(AS4Error.EBMS_0101, errorMsg);
            }
            if (!signAlgorithm.equals(usedSignAlgorithm)) {
                errorMsg = "(" + AS4_PACKAGE + ") " + type + " is signed with the algorithm " + usedSignAlgorithm + " instead of " + signAlgorithm + ".";
                this._messengerLog.log2db(504, xpMessage.getDatabaseId(), errorMsg);
                throw new AS4Exception(AS4Error.EBMS_0101, errorMsg);
            }
            _log.debug("Signature ok");
            X509Certificate signCertificate = securityResult.getSignCertificate();
            if (signCertificate != null) {
                try {
                    this._cryptoManager.checkCertificateForVerification(signCertificate, xpMessage);
                }
                catch (GeneralSecurityException e) {
                    this._messengerLog.log2db(504, xpMessage.getDatabaseId(), e.getMessage());
                    throw new AS4Exception(AS4Error.EBMS_0101, e.getMessage(), e);
                }
                String keyInfoType = securityResult.getSignKeyInfoType();
                usingInfoText = this._certificateUtility.toUsingInfoText(signCertificate, "(" + AS4_PACKAGE + ") using " + usedSignAlgorithm + ", " + keyInfoType + " and certificate");
                if (_log.isDebugEnabled()) {
                    _log.debug("Verified Signature {}", (Object)usingInfoText);
                }
                this._messengerLog.log2db(72, xpMessage.getDatabaseId(), usingInfoText);
            } else {
                _log.error("sign certificate is NULL");
            }
        }
        return securityResult.getSoapMessage();
    }

    private XPath createXPath() {
        XPath xPath = XPathFactory.newInstance().newXPath();
        xPath.setNamespaceContext(this._namespaceContext);
        return xPath;
    }

    private Map<String, String> messagePropertiesToHashMap(List<Property> properties) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Property property : properties) {
            result.put(property.getName(), property.getValue());
        }
        return result;
    }

    private Map<String, String> toHashMap(List<PartyId> partyIds) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (PartyId partyId : partyIds) {
            result.put(partyId.getType(), partyId.getValue());
        }
        return result;
    }

    public boolean checkMessageTypeIsAS4Ping(XpMessage xpMessage) {
        if ("PING".equals(xpMessage.getMessageType()) && "ponton".equals(xpMessage.getSchemaSet()) && "2.1".equals(xpMessage.getMessageVersion())) {
            this.as4PingMessageConverter.convertOutboundMessage(xpMessage);
            return true;
        }
        return false;
    }

    public void isCoveredByLicence(XpMessage xpMessage) throws AS4Exception {
        if ("AS4".equals(xpMessage.getMessagePackaging())) {
            try {
                if (!this._activationProvider.isAS4EllipticCurveEnabled() && this.usesEllipticCurve(xpMessage)) {
                    throw new AS4Exception(AS4Error.EBMS_0008, "AS4 EllipticCurve option isn't covered by current license");
                }
            }
            catch (ActivationException e) {
                _log.error("Can't check AS4-EllipticCurve license option", (Throwable)e);
            }
        }
    }

    private boolean usesEllipticCurve(XpMessage xpMessage) {
        String signAlgorithm = this.getPackagingOption(xpMessage.getCommunication(), "/SignMessage");
        if ("ecdsa-sha1".equals(signAlgorithm) || "ecdsa-sha256".equals(signAlgorithm) || "ecdsa-sha512".equals(signAlgorithm)) {
            return true;
        }
        signAlgorithm = this.getPackagingOption(xpMessage.getCommunication(), "/ExpectSignedMessage");
        if ("ecdsa-sha1".equals(signAlgorithm) || "ecdsa-sha256".equals(signAlgorithm) || "ecdsa-sha512".equals(signAlgorithm)) {
            return true;
        }
        String keyEncryptionAlgorithm = this.getPackagingOption(xpMessage.getCommunication(), "/EncryptMessage/KeyEncryption");
        return "ECDH-ES-ConcatKDF-empty-sha256".equals(keyEncryptionAlgorithm) || "ECDH-ES-ConcatKDF-empty-sha512".equals(keyEncryptionAlgorithm) || "ECDH-ES-ConcatKDF-generated-sha256".equals(keyEncryptionAlgorithm) || "ECDH-ES-ConcatKDF-generated-sha512".equals(keyEncryptionAlgorithm);
    }
}

