/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.listener;

import de.pontonconsulting.xmlpipe.config.IFolders;
import de.pontonconsulting.xmlpipe.cpa.Agreement;
import de.pontonconsulting.xmlpipe.cpa.AgreementException;
import de.pontonconsulting.xmlpipe.cpa.AgreementNotFoundException;
import de.pontonconsulting.xmlpipe.cpa.Agreements;
import de.pontonconsulting.xmlpipe.cpa.Communication;
import de.pontonconsulting.xmlpipe.cpp.CppPartner;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.cpp.ProfileNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.jaxb.as4.SignalMessage;
import de.pontonconsulting.xmlpipe.listener.AS4ErrorProcessor;
import de.pontonconsulting.xmlpipe.listener.AS4Exception;
import de.pontonconsulting.xmlpipe.listener.AS4ProcessorHelper;
import de.pontonconsulting.xmlpipe.listener.AS4SignalProcessor;
import de.pontonconsulting.xmlpipe.listener.ErrorNotificationResult;
import de.pontonconsulting.xmlpipe.listener.ErrorNotificationService;
import de.pontonconsulting.xmlpipe.listener.IAS4SignalProcessorCallback;
import de.pontonconsulting.xmlpipe.listener.ProcessingResultToErrorNotificationResultConverter;
import de.pontonconsulting.xmlpipe.listener.SoapProcessor;
import de.pontonconsulting.xmlpipe.message.XpAcknowledgment;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.ProcessingResult;
import de.pontonconsulting.xmlpipe.messenger.ReceiveFromListener;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.archive.ArchiveProcessor;
import de.pontonconsulting.xmlpipe.messenger.database.DbException;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageWorkDataDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.messenger.packaging.AS4Error;
import de.pontonconsulting.xmlpipe.messenger.packaging.AS4ReceiptGenerator;
import de.pontonconsulting.xmlpipe.messenger.packaging.AsyncSoapResponseSender;
import de.pontonconsulting.xmlpipe.messenger.packaging.PackagingException;
import jakarta.mail.internet.MimeUtility;
import jakarta.xml.bind.JAXBException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.FileSystemUtils;

public class AS4Processor
extends SoapProcessor {
    private static final Logger _log = LogManager.getLogger((String)"Messenger.AS4Processor");
    private CppPartner _sender;
    private CppPartner _receiver;
    private Agreement _agreement;
    private boolean _duplicateElimination;
    private boolean _syncReply = true;
    private boolean _sendReceipt;
    private final MessageDAO _messageDAO;
    private final MessengerLog _messengerLog;
    private final AS4SignalProcessor _signalProcessor;
    private final AS4ProcessorHelper _processorHelper;
    private final AS4ErrorProcessor _errorProcessor;
    private final ReceiveFromListener _receiveFromListener;
    private final AS4ReceiptGenerator _as4ReceiptGenerator;
    private final AsyncSoapResponseSender asyncSoapResponseSender;
    private final IFolders _folders;
    private final ErrorNotificationService _errorNotificationService;
    private final MessageWorkDataDAO messageWorkDataDAO;

    @Override
    public SOAPMessage processMessage(SOAPMessage soapMessage, String protocol, Optional<Long> refDbId) throws SOAPException, IOException {
        SOAPMessage responseSoapMessage = null;
        Source source = soapMessage.getSOAPPart().getContent();
        boolean containsSignals = this._processorHelper.containsSignals(source);
        boolean containsUserMessages = this._processorHelper.containsUserMessages(source);
        boolean synchronous = refDbId.isPresent();
        if (containsUserMessages) {
            try {
                responseSoapMessage = this.processMessage(soapMessage, protocol);
            }
            catch (AS4Exception exception) {
                responseSoapMessage = this._errorProcessor.createErrorMessage(source, (Exception)exception);
            }
            if (responseSoapMessage != null) {
                responseSoapMessage = this.preProcessSignals(responseSoapMessage, new OutboundSignalCallback(), refDbId);
            }
        }
        if (containsSignals) {
            try {
                this.preProcessSignals(soapMessage, new InboundSignalCallback(synchronous), refDbId);
            }
            catch (SOAPException e) {
                _log.error("signal cannot be extracted from SOAP message." + e.getMessage());
            }
            catch (RuntimeException e) {
                _log.error("unexpected error in signal processing.", (Throwable)e);
            }
        }
        return responseSoapMessage;
    }

    public AS4Processor(Agreements agreements, Profiles profiles, ReferenceDateTask referenceDate, ArchiveProcessor archiveProcessor, MessageDAO messageDAO, MessengerLog messengerLog, AS4SignalProcessor signalProcessor, AS4ProcessorHelper processorHelper, AS4ErrorProcessor errorProcessor, ReceiveFromListener receiveFromListener, AS4ReceiptGenerator as4ReceiptGenerator, AsyncSoapResponseSender asyncSoapResponseSender, IFolders folders, ErrorNotificationService errorNotificationService, MessageWorkDataDAO messageWorkDataDAO) {
        super(agreements, profiles, referenceDate, archiveProcessor);
        this._messageDAO = messageDAO;
        this._messengerLog = messengerLog;
        this._signalProcessor = signalProcessor;
        this._processorHelper = processorHelper;
        this._errorProcessor = errorProcessor;
        this._receiveFromListener = receiveFromListener;
        this._as4ReceiptGenerator = as4ReceiptGenerator;
        this.asyncSoapResponseSender = asyncSoapResponseSender;
        this._folders = folders;
        this._errorNotificationService = errorNotificationService;
        this.messageWorkDataDAO = messageWorkDataDAO;
    }

    private SOAPMessage processMessage(SOAPMessage soapMessage, String protocol) throws AS4Exception, SOAPException, IOException {
        int status;
        String oFilename;
        SOAPMessage response = null;
        Source source = soapMessage.getSOAPPart().getContent();
        XpMessage xpMessage = this._processorHelper.createUserMessage(source);
        xpMessage.setProtocol(protocol);
        Optional.ofNullable(soapMessage.getMimeHeaders().getHeader("X-Remote-Address")).ifPresent(e -> {
            if (((String[])e).length > 0) {
                xpMessage.setProcessingDirective("X-RemoteAddress", soapMessage.getMimeHeaders().getHeader("X-Remote-Address")[0]);
            }
        });
        Optional.ofNullable(soapMessage.getMimeHeaders().getHeader("X-Forwarded-For")).ifPresent(e -> {
            if (((String[])e).length > 0) {
                xpMessage.setProcessingDirective("X-ForwardedFor", soapMessage.getMimeHeaders().getHeader("X-Forwarded-For")[0]);
            }
        });
        Optional.ofNullable(soapMessage.getMimeHeaders().getHeader("User-Agent")).ifPresent(e -> {
            if (((String[])e).length > 0) {
                xpMessage.setProcessingDirective("X-UserAgent", soapMessage.getMimeHeaders().getHeader("User-Agent")[0]);
            }
        });
        MimeHeaders mimeHeaders = soapMessage.getMimeHeaders();
        String[] originalFilenames = mimeHeaders.getHeader("X-Original-Filename");
        if (originalFilenames != null && originalFilenames.length > 0 && StringUtils.isNotBlank((CharSequence)(oFilename = originalFilenames[0]))) {
            String decoded = "";
            try {
                decoded = MimeUtility.decodeText((String)oFilename);
            }
            catch (UnsupportedEncodingException ex) {
                _log.error(ex.getMessage());
                decoded = oFilename;
            }
            xpMessage.setProcessingDirective("OriginalFilename", decoded.trim());
        }
        try {
            status = this._messageDAO.registerOrUpdateMessage(xpMessage);
        }
        catch (DbException ex) {
            _log.error(xpMessage.getMessageId(), (Object)ex.getMessage(), (Object)ex);
            throw new AS4Exception(AS4Error.EBMS_0003, "Could not register message.", ex);
        }
        try {
            this._messengerLog.log2db(60, xpMessage.getDatabaseId(), "AS4 " + protocol);
            this._receiver = this.identifyPartner(xpMessage, (HashMap)this._processorHelper.getToPartyIds(source), false);
            xpMessage.setReceiverLocalId(this._receiver.getLocalId());
            this._sender = this.identifyPartner(xpMessage, (HashMap)this._processorHelper.getFromPartyIds(source), true);
            xpMessage.setSenderLocalId(this._sender.getLocalId());
            this.identifyAgreement(xpMessage);
            this._processorHelper.isCoveredByLicence(xpMessage);
            switch (status) {
                case 0: 
                case 4: {
                    response = this.handleNewMessage(soapMessage, source, xpMessage);
                    break;
                }
                case 3: {
                    if (this._duplicateElimination) {
                        _log.warn("Ignored duplicate message.");
                        this._messengerLog.log2db(106, xpMessage.getDatabaseId(), null);
                        if (!this._sendReceipt) break;
                        response = this._as4ReceiptGenerator.generateReceipt(source);
                        break;
                    }
                    boolean updated = this._messageDAO.updateMessageStatus(xpMessage.getDatabaseId(), 3, 1);
                    if (updated) {
                        response = this.handleNewMessage(soapMessage, source, xpMessage);
                        break;
                    }
                    _log.warn("Ignored duplicate message. Message is currently being processed.");
                    break;
                }
                case 1: {
                    _log.warn("Ignored duplicate message. Message is currently being processed.");
                    break;
                }
                case 2: {
                    _log.warn("Ignored duplicate message. Message is currently in the inbound queue.");
                }
            }
        }
        catch (AS4Exception e2) {
            this.prepareWorkFolder(xpMessage);
            this._processorHelper.storeEnvelope(soapMessage, xpMessage);
            this.logAndSetToFailed(xpMessage, e2.getMessage(), false);
            ArrayList<ErrorNotificationResult> errorNotificationResults = new ArrayList<ErrorNotificationResult>(1);
            errorNotificationResults.add(new ErrorNotificationResult(ErrorNotificationResult.ErrorType.PACKAGING_ERROR, e2.getMessage()));
            this._errorNotificationService.notifyAdapter(xpMessage, errorNotificationResults);
            throw e2;
        }
        catch (DbException ex) {
            this.logAndSetToFailed(xpMessage, "Could not update message: " + ex.getMessage());
            throw new AS4Exception(AS4Error.EBMS_0003, "Could not update message.");
        }
        catch (PackagingException | JAXBException | XPathExpressionException e3) {
            this.logAndSetToFailed(xpMessage, "Could not generate receipt: " + e3.getMessage());
            throw new AS4Exception(AS4Error.EBMS_0003, "Could not generate receipt.");
        }
        catch (RuntimeException e4) {
            this.logAndSetToFailed(xpMessage, "unexpected error during inbound processing: " + String.valueOf(e4));
            throw e4;
        }
        return response;
    }

    private void logAndSetToFailed(XpMessage xpMessage, String logMessage, boolean log) {
        if (log) {
            _log.error(logMessage);
        }
        this._messengerLog.log2db(527, xpMessage.getDatabaseId(), logMessage);
        try {
            this.messageWorkDataDAO.uploadDirectoryToDB(xpMessage.getDatabaseId(), xpMessage.getCurrentContentReferenceFolder());
            FileSystemUtils.deleteRecursively((File)xpMessage.getCurrentContentReferenceFolder());
        }
        catch (DbException e) {
            _log.error("Couldn't upload message folder for {} to database: {}", (Object)xpMessage.getDatabaseId(), (Object)e.getMessage());
        }
        this._archiveProcessor.sendFilesToArchive(xpMessage.getDatabaseId(), true);
        this._messageDAO.updateMessageStatus(xpMessage.getDatabaseId(), xpMessage.getMessageId(), 4);
    }

    private void logAndSetToFailed(XpMessage xpMessage, String logMessage) {
        this.logAndSetToFailed(xpMessage, logMessage, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SOAPMessage handleNewMessage(SOAPMessage soapMessage, Source source, XpMessage xpMessage) throws PackagingException, XPathExpressionException, JAXBException, IOException, SOAPException, AS4Exception, DbException {
        SOAPMessage response = null;
        this._messageDAO.updateMessage(xpMessage);
        this.prepareWorkFolder(xpMessage);
        ProcessingResult[] results = this.handleMessage(xpMessage, soapMessage);
        if (results.length > 0) {
            if (results[results.length - 1].getResultCode() == 0) {
                if (!this._sendReceipt) return response;
                return this._as4ReceiptGenerator.generateReceipt(source);
            }
            List<ErrorNotificationResult> notifications = ProcessingResultToErrorNotificationResultConverter.mapResultsToNotificationCodes(results);
            this._errorNotificationService.notifyAdapter(xpMessage, notifications);
            return this._errorProcessor.createErrorMessage(results, xpMessage.getMessageId());
        }
        _log.error("no processing result was returned");
        return response;
    }

    private void prepareWorkFolder(XpMessage xpMessage) throws IOException {
        boolean deleteSuccessful;
        File workFolder = new File(this._folders.getWorkInboundFolder(), String.valueOf(xpMessage.getDatabaseId()));
        if (workFolder.exists() && !(deleteSuccessful = FileUtils.deleteQuietly((File)workFolder))) {
            _log.error("one or more files could not be deleted from workfolder {}", (Object)workFolder);
            throw new IOException("There was a problem, accesing the filesystem.");
        }
        workFolder.mkdirs();
        this._messageDAO.updateMessageFolder(xpMessage.getDatabaseId(), workFolder);
        xpMessage.setCurrentContentReferenceFolder(workFolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProcessingResult[] handleMessage(XpMessage message, SOAPMessage processedSoapMessage) throws SOAPException, JAXBException, IOException, AS4Exception, DbException {
        ArrayList<InputStream> openedInputStreams = new ArrayList<InputStream>();
        try {
            this._processorHelper.storeEnvelope(processedSoapMessage, message);
            processedSoapMessage = this._processorHelper.processSecurityHeaders(processedSoapMessage, message, openedInputStreams);
            this._processorHelper.storeAttachments(processedSoapMessage, message);
        }
        finally {
            openedInputStreams.forEach(openedInputStream -> {
                try {
                    openedInputStream.close();
                }
                catch (IOException e) {
                    _log.error("Could not close opened input stream.", (Throwable)e);
                }
            });
        }
        return this._receiveFromListener.handleMessage(message);
    }

    private SOAPMessage preProcessSignals(SOAPMessage message, IAS4SignalProcessorCallback callback, Optional<Long> refDbId) throws SOAPException {
        List<SignalMessage> signals = this._processorHelper.getSignals(message.getSOAPPart().getContent());
        return this._signalProcessor.processSignals(message, signals, callback, refDbId);
    }

    void identifyAgreement(XpMessage xpMessage) throws AS4Exception {
        try {
            this._agreement = this._agreements.getAgreement(xpMessage.getReceiverLocalId(), xpMessage.getSenderLocalId(), true);
            xpMessage.setOwnPartner(this._profiles.getProfileForLocalId(this._agreement.getOwnPartner().getId(), true));
            xpMessage.setCommunicationPartner(this._profiles.getProfileForLocalId(this._agreement.getCommunicationPartner().getId(), true));
            xpMessage.setAgreement(this._agreement);
            Communication communication = this._agreement.getCommunication(xpMessage.getSenderLocalId(), xpMessage.getReceiverLocalId());
            if (!"AS4".equals(communication.getPackagingId())) {
                _log.error("Agreement supports {} and not AS4.", (Object)communication.getPackagingId());
                throw new AS4Exception(AS4Error.EBMS_0001, "Agreement supports only " + communication.getPackagingId() + ".");
            }
            xpMessage.setCommunication(communication);
            xpMessage.setAdapterId(this._agreement.getDefaultAdapterId());
            this._syncReply = this._processorHelper.isSyncResponse(communication);
            this._duplicateElimination = this._processorHelper.isDuplicateElimination(communication);
            this._sendReceipt = this._processorHelper.isSendReceipt(communication);
        }
        catch (AgreementNotFoundException e) {
            _log.error("Agreement is not found on the System: {}", (Object)e.getMessage());
            throw new AS4Exception(AS4Error.EBMS_0001, "Agreement is not found.");
        }
        catch (AgreementException e) {
            _log.error("Communication is not defined in Agreement: {}", (Object)e.getMessage());
            throw new AS4Exception(AS4Error.EBMS_0001, "Agreement is incomplete.");
        }
        catch (ProfileException e) {
            _log.error("Profile is not defined in Agreement: {}", (Object)e.getMessage());
            throw new AS4Exception(AS4Error.EBMS_0001, "Profile is not found.");
        }
    }

    private CppPartner identifyPartner(XpMessage xpMessage, HashMap<String, String> parties, boolean isSender) throws AS4Exception {
        String partner = isSender ? "Sender" : "Receiver";
        try {
            CppPartner cppPartner = this._profiles.getProfileForPartyIds(parties, true);
            if (cppPartner.isDisabled()) {
                _log.fatal("{} is disabled. Reception denied. localId={}", (Object)partner, (Object)cppPartner.getLocalId());
                throw new AS4Exception(AS4Error.EBMS_0001, partner + " is blocked by the System.");
            }
            if (!isSender && cppPartner.isRemote()) {
                _log.fatal("Receiver is a remote partner. Reception denied. localId={}", (Object)cppPartner.getLocalId());
                throw new AS4Exception(AS4Error.EBMS_0003, "Receiver is a remote partner by the System");
            }
            return cppPartner;
        }
        catch (ProfileNotFoundException e) {
            _log.fatal("{} is not known to the System. {}{}", (Object)partner, (Object)e.getMessage(), parties);
            throw new AS4Exception(AS4Error.EBMS_0001, partner + " is not known to the System: " + String.valueOf(parties));
        }
        catch (ProfileException e) {
            _log.fatal("Could not access {} information from local data: {}", (Object)partner, (Object)e.getMessage());
            throw new AS4Exception(AS4Error.EBMS_0001, partner + " Profile could not be accessed.");
        }
    }

    private final class OutboundSignalCallback
    implements IAS4SignalProcessorCallback {
        private OutboundSignalCallback() {
        }

        @Override
        public void createXpAcknowledgment(SignalMessage signal, XpMessage responseXpMessage) {
        }

        @Override
        public SOAPMessage handleSignal(SOAPMessage responseMessage, SignalMessage signal, XpMessage responseXpMessage) throws AS4Exception {
            AS4Processor.this._processorHelper.storeEnvelope(responseMessage, responseXpMessage);
            boolean isError = AS4Processor.this._signalProcessor.isErrorSignal(signal);
            if (isError) {
                AS4Processor.this._messageDAO.updateMessageStatus(responseXpMessage.getReferenceDatabaseId(), responseXpMessage.getReferenceId(), 4);
                AS4Processor.this._messengerLog.log2dbWithHref(7, responseXpMessage.getReferenceDatabaseId(), responseXpMessage.getMessageId(), responseXpMessage.getMessageId(), responseXpMessage.getDatabaseId(), this.isInbound());
            } else {
                AS4Processor.this._messengerLog.log2dbWithHref(2, responseXpMessage.getReferenceDatabaseId(), responseXpMessage.getMessageId(), responseXpMessage.getMessageId(), responseXpMessage.getDatabaseId(), this.isInbound());
            }
            AS4Processor.this._messengerLog.log2db(79, responseXpMessage.getDatabaseId(), AS4ProcessorHelper.AS4_PACKAGE);
            if (isError || AS4Processor.this._syncReply) {
                AS4Processor.this._messengerLog.log2db(1, responseXpMessage.getDatabaseId(), "Sync Response");
                try {
                    AS4Processor.this.messageWorkDataDAO.uploadDirectoryToDB(responseXpMessage.getDatabaseId(), responseXpMessage.getCurrentContentReferenceFolder());
                    FileSystemUtils.deleteRecursively((File)responseXpMessage.getCurrentContentReferenceFolder());
                }
                catch (DbException e) {
                    _log.error("Couldn't upload message folder for {} to database: {}", (Object)responseXpMessage.getDatabaseId(), (Object)e.getMessage());
                }
                AS4Processor.this._archiveProcessor.sendFilesToArchive(responseXpMessage.getDatabaseId(), false);
                AS4Processor.this._messengerLog.log2dbWithHref(104, responseXpMessage.getDatabaseId(), "For message: " + responseXpMessage.getReferenceId(), responseXpMessage.getReferenceId(), responseXpMessage.getReferenceDatabaseId(), this.isInbound());
                AS4Processor.this._messageDAO.updateMessageStatus(responseXpMessage.getDatabaseId(), responseXpMessage.getMessageId(), 3);
                return responseMessage;
            }
            AS4Processor.this.asyncSoapResponseSender.addToOutboundQueue(responseMessage, responseXpMessage);
            return null;
        }

        @Override
        public SOAPMessage signMessage(SOAPMessage originalMessage, SignalMessage signal, XpMessage responseXpMessage) throws GeneralSecurityException {
            if (AS4Processor.this._signalProcessor.isErrorSignal(signal)) {
                return originalMessage;
            }
            return AS4Processor.this._processorHelper.signMessage(originalMessage, responseXpMessage);
        }

        @Override
        public boolean isInbound() {
            return false;
        }
    }

    private final class InboundSignalCallback
    implements IAS4SignalProcessorCallback {
        private final boolean _synchronous;

        private InboundSignalCallback(boolean synchronous) {
            this._synchronous = synchronous;
        }

        @Override
        public void createXpAcknowledgment(SignalMessage signal, XpMessage responseXpMessage) {
            XpAcknowledgment ack = AS4Processor.this._signalProcessor.createXpAcknowledgment(signal, responseXpMessage);
            AS4Processor.this._processorHelper.saveAckToDiskAndUpdateMessage(ack, responseXpMessage);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SOAPMessage handleSignal(SOAPMessage originalMessage, SignalMessage signal, XpMessage responseXpMessage) throws AS4Exception {
            SOAPMessage responseSoapMessage = originalMessage;
            if (responseXpMessage != null) {
                if (AS4Processor.this._syncReply) {
                    String logText = " " + AS4ProcessorHelper.AS4_PACKAGE + " " + responseXpMessage.getProtocol();
                    if (this._synchronous) {
                        logText = logText + " (Sync Reply)";
                    }
                    AS4Processor.this._messengerLog.log2db(60, responseXpMessage.getDatabaseId(), logText);
                }
                AS4Processor.this._processorHelper.storeEnvelope(responseSoapMessage, responseXpMessage);
                if (!AS4Processor.this._signalProcessor.isErrorSignal(signal)) {
                    ArrayList<InputStream> openedInputStreams = new ArrayList<InputStream>();
                    try {
                        responseSoapMessage = AS4Processor.this._processorHelper.processSecurityHeaders(responseSoapMessage, responseXpMessage, openedInputStreams);
                    }
                    finally {
                        openedInputStreams.forEach(openedInputStream -> {
                            try {
                                openedInputStream.close();
                            }
                            catch (IOException e) {
                                _log.error("Could not close opened input stream.", (Throwable)e);
                            }
                        });
                    }
                }
                AS4Processor.this._receiveFromListener.handleMessage(responseXpMessage);
            }
            return null;
        }

        @Override
        public boolean isInbound() {
            return true;
        }

        @Override
        public SOAPMessage signMessage(SOAPMessage originalMessage, SignalMessage signal, XpMessage responseXpMessage) {
            return originalMessage;
        }
    }
}

