/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.listener;

import de.pontonconsulting.xmlpipe.as.AS3ObjectFactory;
import de.pontonconsulting.xmlpipe.as.AS3Report;
import de.pontonconsulting.xmlpipe.as.ASException;
import de.pontonconsulting.xmlpipe.as.ASMessage;
import de.pontonconsulting.xmlpipe.as.ASReport;
import de.pontonconsulting.xmlpipe.config.IFolders;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.cpa.Agreements;
import de.pontonconsulting.xmlpipe.cpp.CppPartner;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.cpp.ProfileNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.listener.ASProcessor;
import de.pontonconsulting.xmlpipe.listener.ErrorNotificationService;
import de.pontonconsulting.xmlpipe.listener.IASProcessor;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.IdGenerator;
import de.pontonconsulting.xmlpipe.messenger.ReceiveFromListener;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.archive.ArchiveProcessor;
import de.pontonconsulting.xmlpipe.messenger.database.tables.FileRefDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MDNDataDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageWorkDataDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.registry.RegistryProfileUpdater;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import de.pontonconsulting.xmlpipe.security.MessageDigestCalculator;
import de.pontonconsulting.xmlpipe.security.SecurityException;
import de.pontonconsulting.xmlpipe.security.smime.SMIMEDecompressor;
import de.pontonconsulting.xmlpipe.security.smime.SMIMEDecrypter;
import de.pontonconsulting.xmlpipe.security.smime.SMIMEVerifier;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AS3Processor
extends ASProcessor
implements IASProcessor {
    private static final Logger _log = LogManager.getLogger((String)"Messenger.AS3Processor");
    private final AS3ObjectFactory _as3ObjectFactory;

    public AS3Processor(Agreements agreements, MessengerConfig messengerConfig, Profiles profiles, ReceiveFromListener receiveFromListener, ReferenceDateTask referenceDate, MessengerLog messengerLog, MessageDAO messageDAO, FileRefDAO fileRefDAO, MDNDataDAO mdnDataDAO, IFolders folders, IdGenerator idGenerator, ArchiveProcessor archiveProcessor, CertificateUtility certificateUtility, ErrorNotificationService errorNotificationService, SMIMEVerifier smimeVerifier, SMIMEDecrypter smimeDecrypter, SMIMEDecompressor smimeDecompressor, RegistryProfileUpdater registryProfileUpdater, AS3ObjectFactory as3ObjectFactory, MessageWorkDataDAO messageWorkDataDAO) {
        super(agreements, messengerConfig, profiles, receiveFromListener, referenceDate, messengerLog, messageDAO, fileRefDAO, mdnDataDAO, folders, idGenerator, archiveProcessor, certificateUtility, errorNotificationService, smimeVerifier, smimeDecrypter, smimeDecompressor, registryProfileUpdater, messageWorkDataDAO);
        this._as3ObjectFactory = as3ObjectFactory;
        this.setLogger(_log);
    }

    @Override
    protected CppPartner identifyReceiver() throws ASException {
        CppPartner receiver = null;
        try {
            String receiverLocalId = this._profiles.getLocalId("AS3-Name", this._incomingMessage.getTo());
            if (receiverLocalId == null) {
                _log.error("Receiver's AS3Name is not known to the System '{}'", (Object)this._incomingMessage.getTo());
                throw new ASException(43000, "AS3Name " + this._incomingMessage.getTo() + " is unknown");
            }
            this._xpMessage.setReceiverLocalId(receiverLocalId);
            receiver = this._profiles.getProfileForLocalId(this._xpMessage.getReceiverLocalId(), true);
            if (receiver.isRemote()) {
                _log.fatal("Receiver is a remote partner. Reception denied. localId={}", (Object)receiver.getLocalId());
                throw new ASException(43000, "Receiver is a remote partner. Reception denied.");
            }
            if (receiver.isDisabled()) {
                _log.fatal("Receiver is disabled. Reception denied. localId={}", (Object)receiver.getLocalId());
                throw new ASException(43000, "Receive is disabled. Reception denied.");
            }
        }
        catch (ProfileNotFoundException e) {
            _log.error("Receiver is not known to the System. {}", (Object)e.toString());
            throw new ASException(43000, "Receiver is not known to the System.");
        }
        catch (ProfileException e) {
            _log.fatal("Could not access Receiver information from local data: {}", (Object)e.getMessage());
            throw new ASException(43000, "Could not access Receiver information from local data: " + e.getMessage());
        }
        return receiver;
    }

    @Override
    protected CppPartner identifySender() throws ASException {
        CppPartner sender = null;
        try {
            String senderLocalId = this._profiles.getLocalId("AS3-Name", this._incomingMessage.getFrom());
            if (senderLocalId == null) {
                _log.error("Sender's AS3Name is not known to the System '{}'", (Object)this._incomingMessage.getTo());
                throw new ASException(43000, "AS3Name " + this._incomingMessage.getTo() + " is unknown");
            }
            this._xpMessage.setSenderLocalId(senderLocalId);
            sender = this._profiles.getProfileForLocalId(this._xpMessage.getSenderLocalId(), true);
            if (sender.isDisabled()) {
                _log.fatal("Sender is disabled. Reception denied. localId={}", (Object)sender.getLocalId());
                throw new ASException(43000, "Sender is disabled. Reception denied.");
            }
        }
        catch (ProfileNotFoundException e) {
            _log.error("Sender is not known to the System. {}", (Object)e.toString());
            throw new ASException(43000, "Sender is not known to the System.");
        }
        catch (ProfileException e) {
            _log.fatal("Could not access Sender information from local data: {}", (Object)e.getMessage());
            throw new ASException(43000, "Could not access Sender information from local data: " + e.getMessage());
        }
        return sender;
    }

    protected String getUserAgent() {
        return "PontonXP AS3-Processor";
    }

    @Override
    protected ASReport createOkReport(String statusDescription) {
        AS3Report report = this._as3ObjectFactory.createOKReport((ASMessage)this._incomingMessage, statusDescription);
        report.setMessengerLog(this._messengerLog);
        return report;
    }

    @Override
    protected ASReport createErrorReport(ASReport.DispositionModifier dispositionModifier, ASReport.DispositionModifierExtension dispositionModifierExtension, String statusDescription, List<String> details) {
        AS3Report report = this._as3ObjectFactory.createErrorReport((ASMessage)this._incomingMessage, dispositionModifier, dispositionModifierExtension, statusDescription, details);
        report.setMessengerLog(this._messengerLog);
        return report;
    }

    @Override
    protected MessageDigestCalculator createMessageDigestCalculator(String digestAlgorithm) throws SecurityException {
        return new MessageDigestCalculator(this._incomingMessage.getMimePart(), this._includeHeaderInDigestCalculation, digestAlgorithm, false);
    }

    @Override
    void validateSupportedPackager(XpMessage xpMessage) throws ASException {
        if (!"AS3".equals(xpMessage.getCommunication().getPackagingId())) {
            _log.error("Agreement supports {} and not AS3.", (Object)xpMessage.getCommunication().getPackagingId());
            throw new ASException(43000, "Agreement supports only " + xpMessage.getCommunication().getPackagingId() + ".");
        }
    }
}

