/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.integration;

import de.pontonconsulting.xmlpipe.TempFileCreator;
import de.pontonconsulting.xmlpipe.admintool.registry.index.IndexRecord;
import de.pontonconsulting.xmlpipe.config.DistributionConfigFinder;
import de.pontonconsulting.xmlpipe.config.IMessengerProperties;
import de.pontonconsulting.xmlpipe.registry.RegistryException;
import de.pontonconsulting.xmlpipe.registry.client.PartnerRegistryClient;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WebDavIntegration {
    private static final transient Logger LOG = LogManager.getLogger((String)"Messenger.WebDavIntegration");
    private static final String INDEX_FILE = "admin/index";
    private static final char SEP = ';';
    private static final Charset UTF_8_CHARSET = Charset.forName("UTF-8");
    private static final int REFRESH_INTERVAL = 300000;
    private final AtomicLong lastRefreshTime = new AtomicLong(0L);
    private final DistributionConfigFinder distributionConfigFinder;
    private final PartnerRegistryClient registryClient;
    private final String indexFilePath;
    private final TempFileCreator tempFileCreator;
    private Map<String, IndexRecord> cachedIndexRecordWithPartnerIds;
    private Map<String, IndexRecord> cachedIndexRecordWithFilePaths;

    public WebDavIntegration(DistributionConfigFinder distributionConfigFinder, PartnerRegistryClient registryClient, IMessengerProperties messengerProperties, TempFileCreator tempFileCreator) {
        this.distributionConfigFinder = distributionConfigFinder;
        this.registryClient = registryClient;
        this.tempFileCreator = tempFileCreator;
        this.indexFilePath = messengerProperties.getProperty("ponton.messenger.registry.index_file_path", INDEX_FILE);
    }

    public Map<String, IndexRecord> getRegistryIndex(boolean forceReload) throws RegistryException {
        this.updateIndexRecords(forceReload);
        return this.cachedIndexRecordWithFilePaths;
    }

    public IndexRecord getIndexRecordForPartnerId(String partnerId) throws RegistryException {
        this.updateIndexRecords(false);
        if (this.cachedIndexRecordWithPartnerIds != null) {
            return this.cachedIndexRecordWithPartnerIds.get(partnerId);
        }
        return null;
    }

    public Optional<IndexRecord> getIndexRecordForFilePath(String filePath) throws RegistryException {
        this.updateIndexRecords(false);
        if (this.cachedIndexRecordWithFilePaths != null) {
            return Optional.ofNullable(this.cachedIndexRecordWithFilePaths.get(filePath));
        }
        return Optional.empty();
    }

    public IndexRecord getIndexRecord(Map<String, String> partyIds) throws RegistryException {
        List<String> defaultPartyIdTypes = this.distributionConfigFinder.getDefaultPartyIdTypes();
        for (String defaultPartyIdType : defaultPartyIdTypes) {
            IndexRecord indexRecord;
            String partyIdValue = partyIds.get(defaultPartyIdType);
            if (!StringUtils.isNotBlank((CharSequence)partyIdValue) || (indexRecord = this.getIndexRecordForPartnerId(partyIdValue)) == null) continue;
            return indexRecord;
        }
        return null;
    }

    public boolean isRegistryEnabled() {
        return this.registryClient.isRegistryEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void updateIndexRecords(boolean forceReload) throws RegistryException {
        if (!this.isRegistryEnabled()) {
            LOG.debug("Skip update of IndexRecords, because PartnerRegistry is disabled");
            return;
        }
        if (!forceReload) {
            if (!this.needToRefreshIndexRecords()) return;
        }
        BufferedInputStream is = null;
        File index = null;
        InputStreamReader reader = null;
        try {
            index = this.tempFileCreator.createTempFile("tempFile", ".tmp");
            this.registryClient.downloadFile(index, this.indexFilePath);
            is = new BufferedInputStream(Files.newInputStream(index.toPath(), new OpenOption[0]));
            TreeMap<String, IndexRecord> indexRecordWithPartnerIds = new TreeMap<String, IndexRecord>();
            TreeMap<String, IndexRecord> indexRecordWithFilePaths = new TreeMap<String, IndexRecord>();
            reader = new InputStreamReader((InputStream)is, UTF_8_CHARSET);
            CSVFormat csvFormat = CSVFormat.DEFAULT.builder().setDelimiter(';').build();
            try {
                for (CSVRecord record : csvFormat.parse((Reader)reader)) {
                    IndexRecord indexRecord = new IndexRecord(record);
                    if (indexRecord.isValid()) {
                        indexRecordWithFilePaths.put(indexRecord.getFilePath(), indexRecord);
                    }
                    if (!indexRecord.isValid() || !StringUtils.isNotBlank((CharSequence)indexRecord.getPartnerId())) continue;
                    indexRecordWithPartnerIds.put(indexRecord.getPartnerId(), indexRecord);
                }
            }
            catch (UncheckedIOException e) {
                LOG.warn("Stopped reading index csv because of corrupted line. {}", (Object)e.getMessage());
            }
            this.cachedIndexRecordWithFilePaths = indexRecordWithFilePaths;
            this.cachedIndexRecordWithPartnerIds = indexRecordWithPartnerIds;
            this.lastRefreshTime.set(System.currentTimeMillis());
            IOUtils.closeQuietly((InputStream)is);
        }
        catch (RegistryException e) {
            LOG.error("Could not update index records. {}", (Object)e.getMessage());
            this.cachedIndexRecordWithFilePaths = null;
            this.cachedIndexRecordWithPartnerIds = null;
            throw e;
            catch (Exception e2) {
                LOG.error("Could not update index records.", (Throwable)e2);
                this.cachedIndexRecordWithFilePaths = null;
                this.cachedIndexRecordWithPartnerIds = null;
                return;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        if (index == null) return;
        if (index.delete()) return;
        LOG.warn("could not delete temporary file " + String.valueOf(index));
        return;
        finally {
            IOUtils.closeQuietly(is);
            IOUtils.closeQuietly(reader);
            if (index != null && !index.delete()) {
                LOG.warn("could not delete temporary file " + String.valueOf(index));
            }
        }
    }

    private boolean needToRefreshIndexRecords() {
        if (this.cachedIndexRecordWithFilePaths == null || this.cachedIndexRecordWithPartnerIds == null) {
            return true;
        }
        return System.currentTimeMillis() - this.lastRefreshTime.get() > 300000L;
    }
}

