/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.cpp;

import de.pontonconsulting.common.util.DataCache;
import de.pontonconsulting.xmlpipe.TempFileCreator;
import de.pontonconsulting.xmlpipe.activation.MessengerActivation;
import de.pontonconsulting.xmlpipe.adapter.IPartnerEventListener;
import de.pontonconsulting.xmlpipe.admintool.registry.index.IndexRecord;
import de.pontonconsulting.xmlpipe.config.ConfigResourceService;
import de.pontonconsulting.xmlpipe.config.DistributionConfigFinder;
import de.pontonconsulting.xmlpipe.config.IServerConfigBean;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.cpp.CppPartner;
import de.pontonconsulting.xmlpipe.cpp.DuplicateProfileException;
import de.pontonconsulting.xmlpipe.cpp.ICppPartnerFactory;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.cpp.ProfileNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.ProfileStoreAccessException;
import de.pontonconsulting.xmlpipe.events.ReloadProfileEvent;
import de.pontonconsulting.xmlpipe.events.ServiceLevel;
import de.pontonconsulting.xmlpipe.events.ShutdownCompleted;
import de.pontonconsulting.xmlpipe.events.ShutdownService;
import de.pontonconsulting.xmlpipe.events.StartupCompleted;
import de.pontonconsulting.xmlpipe.events.StartupService;
import de.pontonconsulting.xmlpipe.events.activation.ValidateLicenseEvent;
import de.pontonconsulting.xmlpipe.integration.WebDavIntegration;
import de.pontonconsulting.xmlpipe.messenger.IServiceProvider;
import de.pontonconsulting.xmlpipe.messenger.adapter.IPartnerUpdateListener;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.BackendPartnerId;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.PartnerProfile;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.PartnerProfileData;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.RemoteMaintenanceInterval;
import de.pontonconsulting.xmlpipe.messenger.database.tables.PartnerProfileDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.RemoteMaintenanceIntervalDAO;
import de.pontonconsulting.xmlpipe.registry.RegistryException;
import de.pontonconsulting.xmlpipe.registry.client.PartnerRegistryClient;
import jakarta.xml.bind.JAXBException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.runtime.SwitchBootstraps;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Profiles
implements IServiceProvider {
    private static final Pattern DIGIT_PATTERN = Pattern.compile("\\(\\d*\\)$");
    public static String CONFIG_PARTNERPROFILES = "partnerprofiles";
    public static String PRIVATE_PROFILE_SUBFOLDER = "private";
    static String PRIVATE_FOLDER_PATH = CONFIG_PARTNERPROFILES + "/" + PRIVATE_PROFILE_SUBFOLDER + "/";
    private static final ThreadLocal<ThreadCache> PROFILE_THREAD_CACHE = new ThreadLocal();
    private String lastId = null;
    private static final Logger _log = LogManager.getLogger((String)"Messenger.Profiles");
    private final File configFolder;
    private final ConfigResourceService configResourceService;
    private final List<IPartnerEventListener> _listeners = new ArrayList<IPartnerEventListener>();
    private final ApplicationEventPublisher eventPublisher;
    private final ICppPartnerFactory cppPartnerFactory;
    private final MessengerConfig messengerConfig;
    private final MessengerActivation activationProvider;
    private final WebDavIntegration webDavIntegration;
    private final PartnerRegistryClient registryClient;
    private final DistributionConfigFinder distributionConfigFinder;
    private final TempFileCreator tempFileCreator;
    private final DataCache<String, CppPartner> profileCache;
    private final List<Consumer<String>> partnerDeleteEventListeners = new ArrayList<Consumer<String>>();
    private final PartnerProfileDAO partnerProfileDAO;
    private final RemoteMaintenanceIntervalDAO remoteMaintenanceIntervalDAO;

    public static void initThreadCache() {
        PROFILE_THREAD_CACHE.set(new ThreadCache());
        _log.trace("Profile thread cache initialized");
    }

    public static void clearThreadCache() {
        PROFILE_THREAD_CACHE.remove();
        _log.trace("Profile thread cache cleared");
    }

    public Profiles(IServerConfigBean serverConfig, ConfigResourceService configResourceService, ICppPartnerFactory cppPartnerFactory, MessengerConfig messengerConfig, MessengerActivation activationProvider, WebDavIntegration webDavIntegration, PartnerRegistryClient registryClient, DistributionConfigFinder distributionConfigFinder, TempFileCreator tempFileCreator, ApplicationEventPublisher eventPublisher, PartnerProfileDAO partnerProfileDAO, RemoteMaintenanceIntervalDAO remoteMaintenanceIntervalDAO) throws ProfileStoreAccessException {
        int maxCapacity;
        this.configResourceService = configResourceService;
        this.cppPartnerFactory = cppPartnerFactory;
        this.messengerConfig = messengerConfig;
        this.activationProvider = activationProvider;
        this.webDavIntegration = webDavIntegration;
        this.registryClient = registryClient;
        this.distributionConfigFinder = distributionConfigFinder;
        this.tempFileCreator = tempFileCreator;
        this.eventPublisher = eventPublisher;
        this.partnerProfileDAO = partnerProfileDAO;
        this.remoteMaintenanceIntervalDAO = remoteMaintenanceIntervalDAO;
        try {
            maxCapacity = Integer.parseInt(System.getProperty("messenger.cache.profile.size", "1000"));
            if (maxCapacity <= 0) {
                _log.warn("The messenger.cache.profile.size system property must be greater than 0. Using default value 1000.");
                maxCapacity = 1000;
            }
        }
        catch (NumberFormatException e) {
            _log.warn("Could not parse messenger.cache.profile.size system property. Using default value 1000.", (Throwable)e);
            maxCapacity = 1000;
        }
        this.profileCache = new DataCache<String, CppPartner>(this::loadProfileToCache, partnerProfileDAO::getPartnerLastChange, maxCapacity);
        if (_log.isTraceEnabled()) {
            _log.trace("ctor");
        }
        if (serverConfig == null || serverConfig.getConfigFolder() == null) {
            throw new ProfileStoreAccessException(35000, "No configuration given!!!");
        }
        this.configFolder = new File(serverConfig.getConfigFolder(), CONFIG_PARTNERPROFILES);
    }

    public void init() throws ProfileStoreAccessException, URISyntaxException {
        if (_log.isTraceEnabled()) {
            _log.trace("init");
        }
        if (this.partnerProfileDAO.getAllPartnerProfiles().isEmpty()) {
            if (!this.configFolder.exists()) {
                String[] args = new String[]{this.configFolder.getAbsolutePath()};
                throw new ProfileStoreAccessException(22001, args, "Config folder <profiles> is missing.");
            }
            if (!new File(this.configFolder, PRIVATE_PROFILE_SUBFOLDER).exists()) {
                String[] args = new String[]{new File(this.configFolder, PRIVATE_PROFILE_SUBFOLDER).getAbsolutePath()};
                throw new ProfileStoreAccessException(22001, args, "Config folder <private profiles> is missing.");
            }
            Map<URI, InputStream> allPublicParts = this.getAllPublicParts();
            if (!allPublicParts.isEmpty()) {
                _log.trace("found {} profiles in file system", (Object)allPublicParts.size());
                boolean stored = this.migrateProfileFiles(allPublicParts);
                if (stored) {
                    _log.trace("stored profiles from file system to DB");
                } else {
                    _log.error("Could not store all profiles from file system to DB");
                }
            }
        } else if (_log.isTraceEnabled()) {
            _log.trace("loading profiles from DB");
        }
    }

    private CppPartner loadProfileToCache(String partnerId) {
        try {
            return this.loadCppPartner(partnerId, null, false);
        }
        catch (ProfileException e) {
            return null;
        }
    }

    private String extractLocalIdFromPrivateFile(Map.Entry<URI, InputStream> entry) {
        String string;
        block8: {
            InputStream privateConfigFile = this.getPrivateConfigFile(entry);
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document document = builder.parse(privateConfigFile);
                document.getDocumentElement().normalize();
                Element root = document.getDocumentElement();
                string = root.getAttribute("localId");
                if (privateConfigFile == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (privateConfigFile != null) {
                        try {
                            privateConfigFile.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    _log.error("Could not extract localId from: {}", (Object)entry.getKey(), (Object)e);
                    return null;
                }
            }
            privateConfigFile.close();
        }
        return string;
    }

    private boolean migrateProfileFiles(Map<URI, InputStream> files) {
        boolean success = true;
        for (Map.Entry<URI, InputStream> entry : files.entrySet()) {
            try {
                this.migrateProfileFile(entry, this.extractLocalIdFromPrivateFile(entry));
            }
            catch (Exception e) {
                _log.error("Could not store profile file in DB: {}", (Object)entry.getKey(), (Object)e);
                success = false;
            }
        }
        return success;
    }

    private void migrateProfileFile(Map.Entry<URI, InputStream> file, String partnerId) throws ProfileStoreAccessException {
        URI uri = file.getKey();
        File publicProfileFile = Paths.get(uri).toFile();
        File privateProfileFile = Paths.get(PRIVATE_FOLDER_PATH + this.getFilename(uri), new String[0]).toFile();
        try (InputStream publicInputStream = file.getValue();
             InputStream privateInputStream = this.getPrivateConfigFile(file);){
            CppPartner profile = this.parseCppPartner(partnerId, publicInputStream, privateInputStream);
            this.partnerProfileDAO.storePartnerProfile(profile, profile.getLastModified(), "SYSTEM");
            this.remoteMaintenanceIntervalDAO.update(profile.getLocalId(), profile.getMaintenanceIntervals().stream().map(e -> new RemoteMaintenanceInterval().setPartnerId(profile.getLocalId()).setStartTime(e.getStartTime()).setEndTime(e.getEndTime())).toList());
        }
        catch (ProfileException | IOException e2) {
            throw new ProfileStoreAccessException(-1, "Public profile file '" + String.valueOf(publicProfileFile) + "' or private profile file '" + String.valueOf(privateProfileFile) + "' could not be read: " + e2.getMessage());
        }
        try {
            Files.deleteIfExists(publicProfileFile.toPath());
            Files.deleteIfExists(privateProfileFile.toPath());
        }
        catch (IOException e3) {
            throw new RuntimeException(e3);
        }
    }

    private Map<URI, InputStream> getAllPublicParts() {
        return this.configResourceService.getResources(CONFIG_PARTNERPROFILES + "/*.xml");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CppPartner loadProfileToMemory(String localId, PartnerProfile partnerProfile, Optional<File> publicPartFile, boolean readOnly) throws ProfileException {
        CppPartner profile;
        block13: {
            if (_log.isTraceEnabled()) {
                _log.trace("loading profile: {}", (Object)localId);
            }
            if (publicPartFile.isPresent()) {
                try (BufferedInputStream publicPartInputStream = new BufferedInputStream(Files.newInputStream(publicPartFile.get().toPath(), new OpenOption[0]));){
                    PartnerProfileData partnerProfileData = this.partnerProfileDAO.getPartnerProfileData(partnerProfile.getPartnerId());
                    profile = this.parseCppPartner(localId, publicPartInputStream, new ByteArrayInputStream(partnerProfileData.getPrivateProfile()));
                    if (profile.doUpdates(readOnly)) {
                        CppPartner cppPartner = this.loadProfileToMemory(localId, partnerProfile, Optional.empty(), true);
                        return cppPartner;
                    }
                    break block13;
                }
                catch (IOException e) {
                    _log.error("Could not read public part for profile {}: {}", (Object)localId, (Object)e);
                    throw new ProfileStoreAccessException(-1, "Could not read public part for profile " + localId, e);
                }
            }
            PartnerProfileData partnerProfileData = this.partnerProfileDAO.getPartnerProfileData(partnerProfile.getPartnerId());
            profile = this.parseCppPartner(localId, new ByteArrayInputStream(partnerProfileData.getPublicProfile()), new ByteArrayInputStream(partnerProfileData.getPrivateProfile()));
            if (profile.doUpdates(readOnly)) {
                return this.loadProfileToMemory(localId, partnerProfile, Optional.empty(), true);
            }
        }
        if (profile.isRemote()) {
            this.checkActivationForRemotePartner();
        } else {
            this.checkActivationForLocalPartner();
        }
        profile.setLastChange(partnerProfile.getLastChange());
        return profile;
    }

    public CppPartner parseCppPartner(String localId, InputStream publicPartInputStream, InputStream privatePartInputStream) throws ProfileException {
        CppPartner partner = this.cppPartnerFactory.create();
        partner.init(localId, publicPartInputStream, privatePartInputStream);
        return partner;
    }

    private String getFilename(URI url) {
        return FilenameUtils.getName((String)url.getPath());
    }

    private InputStream getPrivateConfigFile(Map.Entry<URI, InputStream> publicPartUrl) {
        try {
            return this.configResourceService.getResource(PRIVATE_FOLDER_PATH + this.getFilename(publicPartUrl.getKey())).getValue();
        }
        catch (IOException e) {
            _log.warn("Could not read private part for: {}", (Object)publicPartUrl.getKey());
            return null;
        }
    }

    private String getLocalIdFromPartyIds(Map<String, String> partyIds) {
        String value;
        String type;
        String result = null;
        Iterator<String> iterator = partyIds.keySet().iterator();
        while (iterator.hasNext() && ((result = this.getLocalId(type = iterator.next(), value = partyIds.get(type))) == null || result.isEmpty())) {
        }
        return result;
    }

    public String getLocalId(String partyIdType, String partyIdValue) {
        return this.partnerProfileDAO.getPartnerIdForPartyId(partyIdType, partyIdValue).orElse(null);
    }

    public CppPartner getProfileForLocalId(String localId, boolean useCache) throws ProfileException {
        return this.getProfileForLocalId(localId, false, useCache);
    }

    public CppPartner getProfileForLocalId(String localId, File publicPart, boolean useCache) throws ProfileException {
        return this.getProfileForLocalId(localId, publicPart, false, useCache);
    }

    private CppPartner getProfileForLocalId(String localId, File publicPart, boolean readOnly, boolean useCache) throws ProfileException {
        CppPartner cppPartner;
        ThreadCache profileThreadCache = PROFILE_THREAD_CACHE.get();
        if (profileThreadCache != null && (cppPartner = profileThreadCache.getCppPartnerForDbId(localId)) != null) {
            return cppPartner;
        }
        if (useCache) {
            Optional<CppPartner> cppPartnerOptional = this.profileCache.get(localId);
            if (cppPartnerOptional.isEmpty()) {
                throw new ProfileNotFoundException(23001, new String[]{localId}, "No profile with id '" + localId + "' found in the database.");
            }
            cppPartner = cppPartnerOptional.get();
            _log.trace("Profile with id {} loaded from cache", (Object)localId);
        } else {
            cppPartner = this.loadCppPartner(localId, publicPart, readOnly);
        }
        if (profileThreadCache != null) {
            profileThreadCache.putCppPartner(cppPartner);
        }
        return cppPartner;
    }

    private CppPartner loadCppPartner(String localId, File publicPart, boolean readOnly) throws ProfileException {
        _log.trace("Loading Profile with id '{}' from database", (Object)localId);
        Optional<PartnerProfile> partnerProfile = this.partnerProfileDAO.getPartnerProfile(localId);
        if (partnerProfile.isEmpty()) {
            throw new ProfileNotFoundException(23001, new String[]{localId}, "No profile with internal identifier '" + localId + "' found in the database.");
        }
        return this.loadProfileToMemory(localId, partnerProfile.get(), Optional.ofNullable(publicPart), readOnly);
    }

    public CppPartner getProfileForLocalId(String localId, boolean readOnly, boolean useCache) throws ProfileException {
        return this.getProfileForLocalId(localId, null, readOnly, useCache);
    }

    public CppPartner getProfileForInternalId(String internalId, boolean useCache) throws ProfileException {
        CppPartner cppPartner;
        CppPartner cppPartner2;
        ThreadCache profileThreadCache = PROFILE_THREAD_CACHE.get();
        if (profileThreadCache != null && (cppPartner2 = profileThreadCache.getCppPartnerForBackendId(internalId)) != null) {
            return cppPartner2;
        }
        String localId = this.partnerProfileDAO.getPartnerIdForBackendPartnerId(internalId).orElse(null);
        if (localId == null && this.messengerConfig.isRegistryPartnerCreationEnabled()) {
            cppPartner = this.importPartnerFromRegistry(internalId);
            if (cppPartner == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug("No partner with internal id '{}' was found on the partner registry", (Object)internalId);
                }
            } else {
                _log.info("automatically imported partner profile for internal id {}", (Object)internalId);
                localId = cppPartner.getLocalId();
            }
        }
        if (localId == null) {
            throw new ProfileNotFoundException(23001, new String[]{internalId}, "No profile with internal identifier '" + internalId + "' installed.");
        }
        cppPartner = this.getProfileForLocalId(localId, useCache);
        if (profileThreadCache != null) {
            profileThreadCache.putCppPartner(cppPartner);
        }
        return cppPartner;
    }

    public CppPartner importPartnerFromRegistry(IndexRecord indexRecord) throws ProfileException, JAXBException {
        CppPartner cppPartner = this.downloadPartnerFromRegistry(indexRecord);
        if (cppPartner == null) {
            return null;
        }
        this.importRemotePartner(cppPartner, cppPartner.getLocalId(), cppPartner.getInternalId(), indexRecord.getDisplayName(), indexRecord.getFilePath(), indexRecord.getLastModifiedLong());
        if (_log.isDebugEnabled()) {
            _log.debug("Partner {} imported from {}.", (Object)cppPartner.getInternalId(), (Object)cppPartner.getRemoteFile());
        }
        return cppPartner;
    }

    public CppPartner importPartnerFromRegistry(String filePath, String backendId, String displayName) throws ProfileException {
        try {
            Optional<IndexRecord> indexRecordOptional = this.webDavIntegration.getIndexRecordForFilePath(filePath);
            if (indexRecordOptional.isEmpty()) {
                throw new ProfileNotFoundException(-1, String.format("IndexRecord does not exist for filepath: %s", filePath));
            }
            IndexRecord indexRecord = indexRecordOptional.get();
            CppPartner cppPartner = this.downloadPartnerFromRegistry(indexRecord);
            if (cppPartner == null) {
                throw new ProfileException(-1, String.format("Profile already exists for filepath: %s", filePath));
            }
            this.importRemotePartner(cppPartner, cppPartner.getLocalId(), backendId, displayName, indexRecord.getFilePath(), indexRecord.getLastModifiedLong());
            _log.debug("Partner {} imported from {}.", (Object)cppPartner.getInternalId(), (Object)cppPartner.getRemoteFile());
            return cppPartner;
        }
        catch (RegistryException e) {
            _log.debug("An error has occured during retrieving index record for filepath {}", (Object)filePath);
            throw new ProfileException(-1, (Throwable)e);
        }
    }

    public String generateId() {
        String newId = this.generateIdFromUUID(UUID.randomUUID());
        while (newId.equals(this.lastId)) {
            newId = this.generateIdFromUUID(UUID.randomUUID());
        }
        this.lastId = newId;
        return newId;
    }

    public String generateId(String registryProfilePath) {
        if (registryProfilePath == null) {
            return this.generateId();
        }
        return this.generateIdFromUUID(UUID.nameUUIDFromBytes(registryProfilePath.getBytes(StandardCharsets.UTF_8)));
    }

    private String generateIdFromUUID(UUID uuid) {
        return uuid.toString().replaceAll("-", "").substring(0, 30);
    }

    private CppPartner downloadPartnerFromRegistry(IndexRecord indexRecord) throws ProfileException {
        Optional<String> partnerId = this.partnerProfileDAO.getPartnerIdForRegistryPath(indexRecord.getFilePath());
        if (partnerId.isPresent()) {
            if (_log.isDebugEnabled()) {
                _log.debug("The remote file path '{}' already exists by the partner '{}'. The index record is ignored.", (Object)indexRecord.getFilePath(), (Object)partnerId.get());
            }
            return null;
        }
        File tempFile = null;
        try {
            tempFile = this.tempFileCreator.createTempFile("tempFile", ".tmp");
            tempFile = this.registryClient.downloadFile(tempFile, indexRecord.getFilePath());
            CppPartner cppPartner = this.parseCppPartnerFromRegistry(tempFile, this.generateId(indexRecord.getFilePath()));
            this.setInternalId(cppPartner, indexRecord);
            cppPartner.setRemoteFile(indexRecord.getFilePath());
            this.validateFunctionalKeyOfPartner(cppPartner, true);
            cppPartner.doUpdates(false);
            CppPartner cppPartner2 = cppPartner;
            return cppPartner2;
        }
        catch (RegistryException | IOException e) {
            String errorText = String.format("Could not import partner with the file path '%s' from the partner registry. %s", indexRecord.getFilePath(), e.getMessage());
            _log.error(errorText);
            throw new ProfileNotFoundException(-1, errorText);
        }
        finally {
            if (tempFile != null && tempFile.exists() && !tempFile.delete()) {
                _log.warn("could not delete temporary file {}", (Object)tempFile);
            }
        }
    }

    private void setInternalId(CppPartner cppPartner, IndexRecord indexRecord) {
        String partnerId = indexRecord.getPartnerId();
        if (StringUtils.isBlank((CharSequence)partnerId)) {
            List<String> defaultPartyIdTypes = this.distributionConfigFinder.getDefaultPartyIdTypes();
            for (String defaultPartyIdType : defaultPartyIdTypes) {
                String partyId = cppPartner.getPartyIdValue(defaultPartyIdType);
                if (!StringUtils.isNotBlank((CharSequence)partyId)) continue;
                cppPartner.setInternalId(partyId);
                return;
            }
            if (StringUtils.isBlank((CharSequence)cppPartner.getInternalId())) {
                cppPartner.setInternalId(indexRecord.getFilename());
            }
        } else {
            cppPartner.setInternalId(partnerId);
        }
    }

    private CppPartner importPartnerFromRegistry(String internalId) throws ProfileException {
        try {
            IndexRecord indexRecord = this.webDavIntegration.getIndexRecordForPartnerId(internalId);
            if (indexRecord == null) {
                _log.debug("No partner found in the partner registry for the partner Id '{}'.", (Object)internalId);
                return null;
            }
            return this.importPartnerFromRegistry(indexRecord);
        }
        catch (RegistryException e) {
            _log.debug("could not access partner registry {}.", (Object)e.toString());
            return null;
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    private CppPartner importPartnerFromRegistry(Map<String, String> partyIds) throws ProfileException {
        try {
            IndexRecord indexRecord = this.webDavIntegration.getIndexRecord(partyIds);
            if (indexRecord == null) {
                _log.debug("No partner found in the partner registry for party Ids: {}.", (Object)partyIds.toString());
                return null;
            }
            return this.importPartnerFromRegistry(indexRecord);
        }
        catch (RegistryException | JAXBException e) {
            _log.debug("could not access partner registry {}.", (Object)e.toString());
            return null;
        }
    }

    public void validateFunctionalKeyOfPartner(CppPartner cppPartner, boolean newProfile) throws DuplicateProfileException {
        Optional<String> partnerIdForRegistryPath;
        if (StringUtils.isNotBlank((CharSequence)cppPartner.getRemoteFile()) && (partnerIdForRegistryPath = this.partnerProfileDAO.getPartnerIdForRegistryPath(cppPartner.getRemoteFile())).isPresent() && !partnerIdForRegistryPath.get().equals(cppPartner.getLocalId())) {
            throw new DuplicateProfileException("remoteFile", cppPartner.getRemoteFile());
        }
        Optional<String> partnerIdForBackendPartnerId = this.partnerProfileDAO.getPartnerIdForBackendPartnerId(cppPartner.getInternalId());
        if (partnerIdForBackendPartnerId.isPresent() && !partnerIdForBackendPartnerId.get().equals(cppPartner.getLocalId())) {
            throw new DuplicateProfileException("internalId", cppPartner.getInternalId());
        }
        ArrayList duplicatePartyIds = new ArrayList();
        Arrays.stream(cppPartner.getPartyIds()).forEach(partyId -> {
            Optional<String> partnerIdForPartyId = this.partnerProfileDAO.getPartnerIdForPartyId(partyId.getType(), partyId.getValue());
            if (partnerIdForPartyId.isPresent() && !partnerIdForPartyId.get().equals(cppPartner.getLocalId())) {
                duplicatePartyIds.add(partyId.getValue() + "[" + partyId.getType() + "]");
            }
        });
        if (!duplicatePartyIds.isEmpty()) {
            throw new DuplicateProfileException("partyIds", String.join((CharSequence)", ", duplicatePartyIds));
        }
        if (newProfile && this.containsProfile(cppPartner.getLocalId())) {
            throw new DuplicateProfileException("localId", cppPartner.getLocalId());
        }
    }

    private CppPartner getExistProfileForPartyIds(Map<String, String> partyIds, boolean useCache) throws ProfileException {
        String localId = this.getLocalIdFromPartyIds(partyIds);
        if (localId == null) {
            StringBuilder requested = new StringBuilder("no match found for:");
            for (String type : partyIds.keySet()) {
                String value = partyIds.get(type);
                requested.append(" ").append(value);
                requested.append("[").append(type).append("]");
            }
            throw new ProfileNotFoundException(23002, new String[]{requested.toString()}, "Cannot find profile.");
        }
        return this.getProfileForLocalId(localId, useCache);
    }

    public CppPartner getProfileForPartyIds(Map<String, String> partyIds, boolean useCache) throws ProfileException {
        try {
            return this.getExistProfileForPartyIds(partyIds, useCache);
        }
        catch (ProfileException e) {
            if (this.messengerConfig.isRegistryPartnerCreationEnabled()) {
                CppPartner cppPartner = this.importPartnerFromRegistry(partyIds);
                if (cppPartner != null) {
                    return cppPartner;
                }
                if (_log.isDebugEnabled()) {
                    _log.debug("No partner with party ids '{}' was found on the partner registry.", (Object)partyIds.toString());
                }
            }
            throw e;
        }
    }

    public Map<String, String[]> getLocalPartnerWithPartyIDs() {
        TreeMap<String, String[]> result = new TreeMap<String, String[]>();
        this.partnerProfileDAO.getAllLocalPartnerProfiles().forEach(profile -> {
            ArrayList partyIdIds = new ArrayList();
            profile.getPartyIds().forEach(partyId -> partyIdIds.add(partyId.getPartyIdId()));
            Collections.sort(partyIdIds);
            result.put(profile.getPartnerId(), partyIdIds.toArray(new String[0]));
        });
        return result;
    }

    public Set<String> getAllInternalIds() {
        return this.partnerProfileDAO.getBackendPartnerIdsOfAllPartners();
    }

    public Set<String> getLocalInternalIds() {
        return this.partnerProfileDAO.getBackendPartnerIdsOfAllLocalPartners();
    }

    public Set<String> getRemoteInternalIds() {
        return this.partnerProfileDAO.getBackendPartnerIdsOfAllRemotePartners();
    }

    public Set<String> getLocalLocalIds() {
        return this.partnerProfileDAO.getPartnerIdsOfAllLocalPartners();
    }

    public List<String> getRemoteLocalIds() {
        return new ArrayList<String>(this.partnerProfileDAO.getPartnerIdsOfAllRemotePartners());
    }

    public void deleteProfile(String localId) throws ProfileException {
        Optional<PartnerProfile> partnerProfile;
        if (!this.containsProfile(localId)) {
            throw new ProfileNotFoundException();
        }
        ThreadCache profileThreadCache = PROFILE_THREAD_CACHE.get();
        if (profileThreadCache != null) {
            profileThreadCache.remove(localId);
        }
        if ((partnerProfile = this.partnerProfileDAO.getPartnerProfile(localId)).isEmpty()) {
            throw new ProfileNotFoundException(-1, "Partner profile with id " + localId + " not found in database.");
        }
        PartnerProfile dbPartnerProfile = partnerProfile.get();
        BackendPartnerId backendPartnerId = (BackendPartnerId)dbPartnerProfile.getBackendPartnerIds().stream().findFirst().orElseThrow(() -> new ProfileNotFoundException(-1, "Backend partner id not found for partner profile with id " + localId));
        if (!dbPartnerProfile.isRemote() && StringUtils.isNotBlank((CharSequence)dbPartnerProfile.getRegistryPath()) && this.registryClient.isRegistryEnabled()) {
            this.deleteProfileFromRegistry(dbPartnerProfile.getRegistryPath());
        }
        this.partnerProfileDAO.deletePartnerProfile(localId);
        _log.info("Deleted partner profile with id {}", (Object)localId);
        this.partnerDeleteEventListeners.forEach(callback -> callback.accept(localId));
        for (IPartnerEventListener listener : this._listeners) {
            try {
                listener.partnerDeleted(backendPartnerId.getBackendPartnerId(), dbPartnerProfile.getDisplayName(), !dbPartnerProfile.isRemote());
                if (!this.messengerConfig.isLoopback() || dbPartnerProfile.isRemote()) continue;
                listener.partnerDeleted(backendPartnerId.getBackendPartnerId(), dbPartnerProfile.getDisplayName(), false);
            }
            catch (Exception e) {
                _log.warn("error while notifying partner event listener: {}", (Object)e.toString());
            }
        }
        this.eventPublisher.publishEvent((ApplicationEvent)new ValidateLicenseEvent(this));
    }

    private void deleteProfileFromRegistry(String remoteFile) {
        try {
            this.registryClient.deleteFile(remoteFile);
        }
        catch (RegistryException | IOException e) {
            _log.error("could not delete partner profile from registry. {}", (Object)e.toString());
        }
    }

    public void partnerCertificateUpdated(CppPartner profile) {
        for (IPartnerEventListener listener : this._listeners) {
            if (!(listener instanceof IPartnerUpdateListener)) continue;
            try {
                ((IPartnerUpdateListener)listener).partnerCertificateUpdated(profile.getInternalId(), profile.getDisplayName(), profile.isLocal());
            }
            catch (Exception e) {
                _log.warn("error while notifying partner event listener: {}", (Object)e.toString());
            }
        }
    }

    private void notifyThatPartnerAdded(CppPartner profile) {
        for (IPartnerEventListener listener : this._listeners) {
            try {
                listener.partnerAdded(profile.getInternalId(), profile.getDisplayName(), profile.isLocal());
                if (!this.messengerConfig.isLoopback() || !profile.isLocal()) continue;
                listener.partnerAdded(profile.getInternalId(), profile.getDisplayName(), false);
            }
            catch (Exception e) {
                _log.warn("error while notifying partner event listener: {}", (Object)e.toString());
            }
        }
    }

    public boolean containsProfile(String localId) {
        return this.partnerProfileDAO.doesPartnerProfileExist(localId);
    }

    private void addNewProfile(CppPartner profile, long lastModified) throws ProfileStoreAccessException {
        profile.saveToDB("SYSTEM", Optional.of(lastModified));
        this.remoteMaintenanceIntervalDAO.update(profile.getLocalId(), profile.getMaintenanceIntervals().stream().map(e -> new RemoteMaintenanceInterval().setPartnerId(profile.getLocalId()).setStartTime(e.getStartTime()).setEndTime(e.getEndTime())).toList());
        this.notifyThatPartnerAdded(profile);
    }

    private URL fileToURL(File store) {
        try {
            return store.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public CppPartner createNewLocalPartner(String localId, String internalId, String displayname) throws ProfileException {
        this.checkActivationForLocalPartner();
        return this.createNewCppPartner(localId, internalId, displayname, false);
    }

    private void checkActivationForLocalPartner() throws ProfileException {
        int maxLocalPartners = this.activationProvider.getLocalProfilesMaxSize();
        if ((long)maxLocalPartners < this.partnerProfileDAO.getLocalPartnerCount() + 1L) {
            throw new ProfileException(23006, new String[]{"" + maxLocalPartners}, "The installed license does not allow more than " + maxLocalPartners + " local profiles.");
        }
    }

    public CppPartner createNewRemotePartner(String localId, String internalId, String displayname) throws ProfileException {
        this.checkActivationForRemotePartner();
        return this.createNewCppPartner(localId, internalId, displayname, true);
    }

    private void checkActivationForRemotePartner() throws ProfileException {
        int maxRemotePartners = this.activationProvider.getRemoteProfilesMaxSize();
        if ((long)maxRemotePartners < this.partnerProfileDAO.getRemotePartnerCount() + 1L) {
            throw new ProfileException(23007, new String[]{"" + maxRemotePartners}, "The installed license does not allow more than " + maxRemotePartners + " remote profiles.");
        }
    }

    private CppPartner createNewCppPartner(String localId, String internalId, String displayname, boolean remote) throws ProfileException {
        CppPartner partner = this.cppPartnerFactory.create();
        partner.init(localId, internalId, displayname, remote);
        this.validateFunctionalKeyOfPartner(partner, true);
        this.addNewProfile(partner, System.currentTimeMillis());
        return partner;
    }

    private CppPartner parseCppPartnerFromRegistry(File profileFile, String localId) throws ProfileException {
        CppPartner partner = this.cppPartnerFactory.create();
        partner.init(this.fileToURL(profileFile), null, localId);
        return partner;
    }

    public void importRemotePartner(CppPartner partner, String localId, String internalId, String displayName, String recordFilePath, long lastModified) throws ProfileException {
        this.checkActivationForRemotePartner();
        partner.setInternalId(internalId);
        partner.setLocalId(localId);
        partner.setRemote(true);
        partner.setAutoupdate(true);
        partner.setAgreementAutoupdate(true);
        partner.setDisplayName(this.getUniqueDisplayName(localId, displayName));
        partner.setRemoteFile(recordFilePath);
        partner.setLastModified(lastModified);
        this.addNewProfile(partner, lastModified);
    }

    public SortedSet<String> getAllDistinctDisplayNames(String localId) {
        return this.partnerProfileDAO.getAllDistinctDisplayNamesExcludePartner(localId);
    }

    public String getUniqueDisplayName(String localId, String displayname) {
        if (localId == null) {
            return null;
        }
        if (displayname == null) {
            displayname = localId;
        }
        if (StringUtils.isBlank((CharSequence)displayname)) {
            displayname = localId;
        }
        if (this.getAllDistinctDisplayNames(localId).contains(displayname)) {
            return this.getUniqueDisplayName(localId, displayname, 1);
        }
        return displayname;
    }

    private String getUniqueDisplayName(String localId, String displayname, int trial) {
        String result = displayname + " (" + trial + ")";
        if (this.getAllDistinctDisplayNames(localId).contains(result)) {
            return this.getUniqueDisplayName(localId, displayname, trial + 1);
        }
        Matcher matcher = DIGIT_PATTERN.matcher(displayname);
        if (matcher.find()) {
            String substring = matcher.group();
            displayname = displayname.replace(substring, "");
            int trials = Integer.parseInt(substring.replace("(", "").replace(")", ""));
            return this.getUniqueDisplayName(localId, displayname.trim(), trials + trial);
        }
        return result;
    }

    public void sendReloadProfileRequest(CppPartner cppPartner) {
        ThreadCache profileThreadCache = PROFILE_THREAD_CACHE.get();
        if (profileThreadCache != null) {
            profileThreadCache.putCppPartner(cppPartner);
        }
        this.profileCache.purgeEntry(cppPartner.getLocalId());
        this.eventPublisher.publishEvent((ApplicationEvent)new ReloadProfileEvent(this, cppPartner.getLocalId()));
    }

    public void addPartnerEventListener(IPartnerEventListener listener) {
        this._listeners.add(listener);
    }

    public void onApplicationEvent(ApplicationEvent event) {
        ApplicationEvent applicationEvent = event;
        Objects.requireNonNull(applicationEvent);
        ApplicationEvent applicationEvent2 = applicationEvent;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{StartupService.class, ShutdownService.class}, (Object)applicationEvent2, n)) {
            case 0: {
                StartupService startupEvent = (StartupService)applicationEvent2;
                if (this.getServiceLevel() != startupEvent.getServiceLevel()) break;
                try {
                    this.init();
                }
                catch (ProfileStoreAccessException | URISyntaxException e) {
                    throw new RuntimeException(e);
                }
                this.eventPublisher.publishEvent((ApplicationEvent)new StartupCompleted(this));
                break;
            }
            case 1: {
                ShutdownService shutdownEvent = (ShutdownService)applicationEvent2;
                if (this.getServiceLevel() != shutdownEvent.getServiceLevel()) break;
                this.eventPublisher.publishEvent((ApplicationEvent)new ShutdownCompleted(this));
                break;
            }
        }
    }

    @Override
    public String getServiceName() {
        return "profiles";
    }

    @Override
    public ServiceLevel getServiceLevel() {
        return ServiceLevel.getServiceLevel(this.getClass());
    }

    public void addPartnerDeleteEventListener(Consumer<String> consumer) {
        this.partnerDeleteEventListeners.add(consumer);
    }

    public void removePartnerDeleteEventListener(Consumer<String> consumer) {
        this.partnerDeleteEventListeners.remove(consumer);
    }

    private static class ThreadCache {
        private final int limit = 5;
        private final Queue<CppPartner> profiles = new LinkedBlockingQueue<CppPartner>(5);
        private final Map<String, CppPartner> dbIdd2CppPartner = new ConcurrentHashMap<String, CppPartner>();

        private ThreadCache() {
        }

        private CppPartner getCppPartnerForDbId(String dbId) {
            return this.dbIdd2CppPartner.get(dbId);
        }

        private CppPartner getCppPartnerForBackendId(String backendId) {
            for (Map.Entry<String, CppPartner> partnerEntry : this.dbIdd2CppPartner.entrySet()) {
                if (!partnerEntry.getValue().getInternalId().equals(backendId)) continue;
                return partnerEntry.getValue();
            }
            return null;
        }

        private void putCppPartner(CppPartner cppPartner) {
            if (this.profiles.size() == 5) {
                CppPartner removedProfile = this.profiles.remove();
                this.dbIdd2CppPartner.remove(removedProfile.getLocalId());
            }
            this.profiles.add(cppPartner);
            this.dbIdd2CppPartner.put(cppPartner.getLocalId(), cppPartner);
        }

        private void remove(String localId) {
            CppPartner removedCppPartner = this.dbIdd2CppPartner.remove(localId);
            if (removedCppPartner != null) {
                this.profiles.remove(removedCppPartner);
            }
        }
    }
}

