/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.cpp;

import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.cpa.AgreementException;
import de.pontonconsulting.xmlpipe.cpa.Communication;
import de.pontonconsulting.xmlpipe.cpp.CertificateIdNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.CppPartner;
import de.pontonconsulting.xmlpipe.cpp.PackageIdNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.PipelineIdNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.cpp.ProfileStoreAccessException;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.registry.RegistryException;
import de.pontonconsulting.xmlpipe.registry.RegistryProfileUpdater;
import de.pontonconsulting.xmlpipe.registry.client.PartnerRegistryClient;
import de.pontonconsulting.xmlpipe.security.CertificateReader;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import de.pontonconsulting.xmlpipe.security.certificate.CertificateChooser;
import de.pontonconsulting.xmlpipe.security.certificate.CertificateValidityFilter;
import de.pontonconsulting.xmlpipe.security.certificate.EmailCertificateFilter;
import de.pontonconsulting.xmlpipe.security.certificate.ICertificateFilter;
import de.pontonconsulting.xmlpipe.security.certificate.PublicKeyCertificateFilter;
import de.pontonconsulting.xmlpipe.security.util.SignCertInfo;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PartnerCertificateManager {
    private static final Logger LOGGER = LogManager.getLogger((String)"Messenger.PartnerCertificateManager");
    private final CertificateUtility certificateUtility;
    private final CertificateReader certificateInfo;
    private final CertificateChooser certificateChooser;
    private final PartnerRegistryClient registryClient;
    private final RegistryProfileUpdater registryProfileUpdater;
    private final ReferenceDateTask referenceDateTask;
    private final MessengerConfig messengerConfig;
    private final ReentrantLock certLock = new ReentrantLock();
    private final List<ICertificateFilter> certificateFilters = new ArrayList<PublicKeyCertificateFilter>(List.of(new PublicKeyCertificateFilter()));

    public PartnerCertificateManager(CertificateUtility certificateUtility, CertificateReader certificateInfo, CertificateChooser certificateChooser, PartnerRegistryClient registryClient, RegistryProfileUpdater registryProfileUpdater, ReferenceDateTask referenceDateTask, MessengerConfig messengerConfig) {
        this.certificateUtility = certificateUtility;
        this.certificateInfo = certificateInfo;
        this.certificateChooser = certificateChooser;
        this.registryClient = registryClient;
        this.registryProfileUpdater = registryProfileUpdater;
        this.referenceDateTask = referenceDateTask;
        this.messengerConfig = messengerConfig;
        this.certificateFilters.add(new CertificateValidityFilter(this.referenceDateTask));
    }

    private void validateCertificate(X509Certificate certificate, CppPartner partner, String certId) throws CertificateException {
        try {
            if (!partner.isCertificateTrusted(certId)) {
                throw new CertificateException(String.format("certificate %s of partner %s is revoked", certId, partner.getDisplayName()));
            }
            Date date = new Date(this.referenceDateTask.getReferenceDate().toInstant().plus((long)Integer.parseInt(this.messengerConfig.getProperty("ponton.messenger.certificate.switch.days_before_expiry")), ChronoUnit.DAYS).toEpochMilli());
            certificate.checkValidity(date);
        }
        catch (CertificateException e) {
            throw new CertificateException(this.certificateUtility.toUsingInfoText(certificate, e.getMessage()), e);
        }
    }

    public X509Certificate getPackagingCertificate(CppPartner partner, String packagingId) throws ProfileException, CertificateException {
        return this.getPackagingCertificate(partner, packagingId, true);
    }

    private X509Certificate getPackagingCertificate(CppPartner partner, String packagingId, boolean syncPartner) throws ProfileException, CertificateException {
        if (partner.isLocal()) {
            SignCertInfo signCertInfo = this.getPackagingSignKey(partner, packagingId);
            if (signCertInfo != null) {
                return signCertInfo.getCertificateChain()[0];
            }
            return null;
        }
        try {
            if (partner.getPackagingCertificateId(packagingId) == null) {
                return this.getDefaultCertificateForRemotePartner(partner);
            }
            return this.getDefinedPackagingCertificateForRemotePartner(partner, packagingId);
        }
        catch (CertificateException ce) {
            CppPartner updatedPartner;
            if (syncPartner && partner.isFromRegistry() && partner.isAutoupdate() && (updatedPartner = this.registryProfileUpdater.updateProfile(partner)) != null) {
                return this.getPackagingCertificate(updatedPartner, packagingId, false);
            }
            throw ce;
        }
    }

    private X509Certificate getPackagingCertificateForRemotePartner(CppPartner partner, String packagingId) throws PackageIdNotFoundException, CertificateException, CertificateIdNotFoundException {
        String certRefId = partner.getPackagingCertificateId(packagingId);
        if (certRefId == null) {
            certRefId = partner.getDefaultCertRefId();
        }
        if (certRefId != null) {
            X509Certificate certificate = partner.getX509Certificate(certRefId);
            this.validateCertificate(certificate, partner, certRefId);
            return certificate;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private X509Certificate getDefaultCertificateForRemotePartner(CppPartner partner) throws CertificateException, CertificateIdNotFoundException {
        String certId = partner.getDefaultCertRefId();
        if (certId == null) {
            return null;
        }
        X509Certificate certificate = partner.getX509Certificate(certId);
        try {
            this.validateCertificate(certificate, partner, certId);
        }
        catch (CertificateException e) {
            this.certLock.lock();
            try {
                String newCertId = partner.getDefaultCertRefId();
                if (certId.equals(newCertId)) {
                    X509Certificate x509Certificate = this.certificateChooser.getNextMatchingCertificate(this.certificateFilters, Communication.COMMON_SORT_CRITERIA, certificate, partner.getAllValidCertificates());
                    if (x509Certificate == null) {
                        LOGGER.warn("No next matching default certificate found for partner '{}'.", (Object)partner.getLocalId());
                        throw e;
                    }
                    newCertId = partner.getCertificateId(x509Certificate);
                    if (!certId.equals(newCertId)) {
                        partner.setDefaultCertRefId(newCertId);
                        try {
                            partner.save(false, false, false, false, false);
                            LOGGER.info(this.certificateUtility.toUsingInfoText(x509Certificate, "Changed default certificate for partner '" + partner.getLocalId() + "' to"));
                        }
                        catch (AgreementException | ProfileStoreAccessException e1) {
                            LOGGER.error("Could not update partner '{}'.", (Object)partner.getLocalId(), (Object)e1);
                        }
                    }
                }
                certificate = partner.getX509Certificate(newCertId);
            }
            finally {
                this.certLock.unlock();
            }
        }
        return certificate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private X509Certificate getDefinedPackagingCertificateForRemotePartner(CppPartner partner, String packagingId) throws CertificateException, PackageIdNotFoundException, CertificateIdNotFoundException {
        String certId = partner.getPackagingCertificateId(packagingId);
        X509Certificate certificate = partner.getX509Certificate(certId);
        try {
            this.validateCertificate(certificate, partner, certId);
        }
        catch (CertificateException e) {
            this.certLock.lock();
            try {
                String newCertId = partner.getPackagingCertificateId(packagingId);
                if (certId.equals(newCertId)) {
                    X509Certificate x509Certificate = this.findValidPackagingCertificate(partner, packagingId, certificate);
                    if (x509Certificate == null) {
                        LOGGER.warn("No next matching packaging certificate found for partner '{}'.", (Object)partner.getLocalId());
                        throw e;
                    }
                    try {
                        newCertId = partner.getCertificateId(x509Certificate);
                        if (!certId.equals(newCertId)) {
                            partner.setPackagingCertificate(packagingId, newCertId);
                            try {
                                partner.save(false, false, false, false, false);
                                LOGGER.info(this.certificateUtility.toUsingInfoText(x509Certificate, "Changed packaging certificate for partner '" + partner.getLocalId() + "' to"));
                            }
                            catch (AgreementException | ProfileStoreAccessException e1) {
                                LOGGER.error("Could not update partner '{}'.", (Object)partner.getLocalId(), (Object)e1);
                            }
                        }
                    }
                    catch (CertificateIdNotFoundException | PackageIdNotFoundException e2) {
                        LOGGER.error("Could not set new packaging certificate for partner '{}'.", (Object)partner.getLocalId(), (Object)e2);
                        X509Certificate x509Certificate2 = x509Certificate;
                        this.certLock.unlock();
                        return x509Certificate2;
                    }
                }
                certificate = partner.getX509Certificate(newCertId);
            }
            finally {
                this.certLock.unlock();
            }
        }
        return certificate;
    }

    private X509Certificate findValidPackagingCertificate(CppPartner partner, String packagingId, X509Certificate certificate) {
        if ("AS1".equals(packagingId)) {
            this.certificateFilters.add(new EmailCertificateFilter(partner.getPartyIdValue("E-Mail"), this.certificateInfo, this.certificateUtility));
        }
        return this.certificateChooser.getNextMatchingCertificate(this.certificateFilters, Communication.COMMON_SORT_CRITERIA, certificate, partner.getAllValidCertificates());
    }

    public SignCertInfo getPackagingSignKey(CppPartner partner, String packagingId) throws ProfileException, CertificateException {
        String certId = partner.getPackagingCertificateId(packagingId);
        if (certId == null) {
            return this.getDefaultValidSignKey(partner);
        }
        return this.getDefinedPackagingSignKey(partner, packagingId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SignCertInfo getDefinedPipelineSignKey(CppPartner partner, String certId, String pipelineId) throws ProfileException, CertificateException {
        SignCertInfo signCertInfo = partner.getPrivateKey(certId);
        X509Certificate currentCertificate = signCertInfo.getCertificateChain()[0];
        try {
            this.validateCertificate(currentCertificate, partner, certId);
        }
        catch (CertificateException e) {
            this.certLock.lock();
            try {
                String newCertId = partner.getPipelineCertRef(pipelineId);
                if (certId.equals(newCertId)) {
                    X509Certificate x509Certificate = this.certificateChooser.getNextMatchingCertificate(this.certificateFilters, Communication.COMMON_SORT_CRITERIA, currentCertificate, partner.getAllValidCertificates());
                    if (x509Certificate == null) {
                        LOGGER.warn("No next matching processing signing certificate found for partner '{}'.", (Object)partner.getLocalId());
                        throw e;
                    }
                    newCertId = partner.getCertificateId(x509Certificate);
                    if (!certId.equals(newCertId)) {
                        partner.setPipelineCertificate(pipelineId, newCertId);
                        try {
                            partner.save(false, false, false, false, false);
                            LOGGER.info(this.certificateUtility.toUsingInfoText(x509Certificate, "Changed processing signing certificate for partner '" + partner.getLocalId() + "' to"));
                            try {
                                this.synchronizeLocalPartnerWithRegistry(partner);
                            }
                            catch (RegistryException re) {
                                LOGGER.error("Could not synchronize local partner '{}' with registry.", (Object)partner.getLocalId(), (Object)re);
                            }
                        }
                        catch (AgreementException | ProfileStoreAccessException e1) {
                            LOGGER.error("Could not update partner '{}'.", (Object)partner.getLocalId(), (Object)e1);
                        }
                    }
                }
                signCertInfo = partner.getPrivateKey(newCertId);
            }
            finally {
                this.certLock.unlock();
            }
        }
        return signCertInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SignCertInfo getDefinedPackagingSignKey(CppPartner partner, String packagingId) throws ProfileException, CertificateException {
        String certId = partner.getPackagingCertificateId(packagingId);
        SignCertInfo signCertInfo = partner.getPrivateKey(certId);
        X509Certificate currentCertificate = signCertInfo.getCertificateChain()[0];
        try {
            this.validateCertificate(currentCertificate, partner, certId);
        }
        catch (CertificateException e) {
            this.certLock.lock();
            try {
                String newCertId = partner.getPackagingCertificateId(packagingId);
                if (certId.equals(newCertId)) {
                    X509Certificate x509Certificate = this.findValidPackagingCertificate(partner, packagingId, currentCertificate);
                    if (x509Certificate == null) {
                        LOGGER.warn("No next matching packaging signing certificate found for partner '{}'.", (Object)partner.getLocalId());
                        throw e;
                    }
                    newCertId = partner.getCertificateId(x509Certificate);
                    if (!certId.equals(newCertId)) {
                        partner.setPackagingCertificate(packagingId, newCertId);
                        try {
                            partner.save(false, false, false, false, false);
                            LOGGER.info(this.certificateUtility.toUsingInfoText(x509Certificate, "Changed packaging signing certificate for partner '" + partner.getLocalId() + "' to"));
                            try {
                                this.synchronizeLocalPartnerWithRegistry(partner);
                            }
                            catch (RegistryException re) {
                                LOGGER.error("Could not synchronize local partner '{}' with registry.", (Object)partner.getLocalId(), (Object)re);
                            }
                        }
                        catch (AgreementException | ProfileStoreAccessException e1) {
                            LOGGER.error("Could not update partner '{}'.", (Object)partner.getLocalId(), (Object)e1);
                        }
                    }
                }
                signCertInfo = partner.getPrivateKey(newCertId);
            }
            finally {
                this.certLock.unlock();
            }
        }
        return signCertInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SignCertInfo getDefaultValidSignKey(CppPartner partner) throws ProfileException, CertificateException {
        String certId = partner.getDefaultCertRefId();
        if (certId == null) {
            return null;
        }
        SignCertInfo signCertInfo = partner.getPrivateKey(certId);
        X509Certificate currentCertificate = signCertInfo.getCertificateChain()[0];
        try {
            this.validateCertificate(currentCertificate, partner, certId);
        }
        catch (CertificateException e) {
            this.certLock.lock();
            try {
                String newCertId = partner.getDefaultCertRefId();
                if (certId.equals(newCertId)) {
                    X509Certificate x509Certificate = this.certificateChooser.getNextMatchingCertificate(this.certificateFilters, Communication.COMMON_SORT_CRITERIA, currentCertificate, partner.getAllValidCertificates());
                    if (x509Certificate == null) {
                        LOGGER.warn("No next matching signing certificate found for partner '{}'.", (Object)partner.getLocalId());
                        throw e;
                    }
                    newCertId = partner.getCertificateId(x509Certificate);
                    if (!certId.equals(newCertId)) {
                        partner.setDefaultCertRefId(newCertId);
                        try {
                            partner.save(false, false, false, false, false);
                            LOGGER.info(this.certificateUtility.toUsingInfoText(x509Certificate, "Changed signing certificate for partner '" + partner.getLocalId() + "' to"));
                            try {
                                this.synchronizeLocalPartnerWithRegistry(partner);
                            }
                            catch (RegistryException re) {
                                LOGGER.error("Could not synchronize local partner '{}' with registry.", (Object)partner.getLocalId(), (Object)re);
                            }
                        }
                        catch (AgreementException | ProfileStoreAccessException e1) {
                            LOGGER.error("Could not update partner '{}'.", (Object)partner.getLocalId(), (Object)e1);
                        }
                    }
                }
                signCertInfo = partner.getPrivateKey(newCertId);
            }
            finally {
                this.certLock.unlock();
            }
        }
        return signCertInfo;
    }

    public X509Certificate getPipelineCertificate(CppPartner partner, String pipelineId) throws CertificateException, ProfileException {
        if (partner.isLocal()) {
            SignCertInfo signCertInfo = this.getPipelineSignKey(partner, pipelineId);
            if (signCertInfo != null) {
                return signCertInfo.getCertificateChain()[0];
            }
            return null;
        }
        try {
            if (partner.getPipelineCertRef(pipelineId) == null) {
                return this.getDefaultCertificateForRemotePartner(partner);
            }
            return this.getDefinedPipelineCertificateForRemotePartner(partner, pipelineId);
        }
        catch (CertificateException ce) {
            CppPartner updatedPartner;
            if (partner.isFromRegistry() && partner.isAutoupdate() && (updatedPartner = this.registryProfileUpdater.updateProfile(partner)) != null) {
                return this.getPipelineCertificateForRemotePartner(updatedPartner, pipelineId);
            }
            throw ce;
        }
    }

    private X509Certificate getPipelineCertificateForRemotePartner(CppPartner partner, String pipelineId) throws PipelineIdNotFoundException, CertificateException, CertificateIdNotFoundException {
        String certRefId = partner.getPipelineCertRef(pipelineId);
        if (certRefId == null) {
            certRefId = partner.getDefaultCertRefId();
        }
        if (certRefId != null) {
            X509Certificate certificate = partner.getX509Certificate(certRefId);
            this.validateCertificate(certificate, partner, certRefId);
            return certificate;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private X509Certificate getDefinedPipelineCertificateForRemotePartner(CppPartner partner, String pipelineId) throws CertificateException, PipelineIdNotFoundException, CertificateIdNotFoundException {
        String certId = partner.getPipelineCertRef(pipelineId);
        X509Certificate certificate = partner.getX509Certificate(certId);
        try {
            this.validateCertificate(certificate, partner, certId);
        }
        catch (CertificateException e) {
            this.certLock.lock();
            try {
                String newCertId = partner.getPipelineCertRef(pipelineId);
                if (certId.equals(newCertId)) {
                    X509Certificate x509Certificate = this.certificateChooser.getNextMatchingCertificate(this.certificateFilters, Communication.COMMON_SORT_CRITERIA, certificate, partner.getAllValidCertificates());
                    if (x509Certificate == null) {
                        LOGGER.warn("No next matching processing certificate found for partner '{}'.", (Object)partner.getLocalId());
                        throw e;
                    }
                    try {
                        newCertId = partner.getCertificateId(x509Certificate);
                        if (!certId.equals(newCertId)) {
                            partner.setPipelineCertificate(pipelineId, newCertId);
                            try {
                                partner.save(false, false, false, false, false);
                                LOGGER.info(this.certificateUtility.toUsingInfoText(x509Certificate, "Changed processing certificate for partner '" + partner.getLocalId() + "' to"));
                            }
                            catch (AgreementException | ProfileStoreAccessException e1) {
                                LOGGER.error("Could not update partner '{}'.", (Object)partner.getLocalId(), (Object)e1);
                            }
                        }
                    }
                    catch (CertificateIdNotFoundException | PipelineIdNotFoundException e2) {
                        LOGGER.error("Could not set new processing certificate for partner '{}'.", (Object)partner.getLocalId(), (Object)e2);
                        X509Certificate x509Certificate2 = x509Certificate;
                        this.certLock.unlock();
                        return x509Certificate2;
                    }
                }
                certificate = partner.getX509Certificate(newCertId);
            }
            finally {
                this.certLock.unlock();
            }
        }
        return certificate;
    }

    public SignCertInfo getPipelineSignKey(CppPartner partner, String pipelineId) throws ProfileException, CertificateException {
        String certRefId = partner.getPipelineCertRef(pipelineId);
        if (certRefId == null) {
            return this.getDefaultValidSignKey(partner);
        }
        return this.getDefinedPipelineSignKey(partner, certRefId, pipelineId);
    }

    private void synchronizeLocalPartnerWithRegistry(CppPartner partner) throws RegistryException {
        if (partner.isLocal() && partner.isFromRegistry()) {
            this.registryClient.uploadLocalPartner(partner);
        }
    }
}

