/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.cpa.update;

import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.cp.Option;
import de.pontonconsulting.xmlpipe.cpa.Agreement;
import de.pontonconsulting.xmlpipe.cpa.Agreements;
import de.pontonconsulting.xmlpipe.cpa.Communication;
import de.pontonconsulting.xmlpipe.cpa.update.AgreementUpdate;
import de.pontonconsulting.xmlpipe.cpa.update.AgreementUpdateFactory;
import de.pontonconsulting.xmlpipe.cpp.CppPartner;
import de.pontonconsulting.xmlpipe.cpp.OptionNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.uioption.UIOption;
import de.pontonconsulting.xmlpipe.uioption.UIOptionFinder;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AgreementUpdateUtility {
    private static final Log _log = LogFactory.getLog((String)"Messenger.AgreementUpdateUtility");
    private final AgreementUpdateFactory _agreementUpdateFactory;
    private final Agreements _agreements;
    private final Profiles _profiles;
    private final MessengerConfig _messengerConfig;

    public AgreementUpdateUtility(AgreementUpdateFactory agreementUpdateFactory, Agreements agreements, Profiles profiles, MessengerConfig messengerConfig) {
        this._agreementUpdateFactory = agreementUpdateFactory;
        this._agreements = agreements;
        this._profiles = profiles;
        this._messengerConfig = messengerConfig;
    }

    public void updateAllAgreementsFor(CppPartner partner, boolean transport, boolean processing, boolean packaging, boolean partyIds, boolean schemaSet) {
        List<String> agreementIds = this._agreements.getAgreementIdsForPartner(partner.getLocalId());
        if (agreementIds == null) {
            return;
        }
        for (String agreementId : agreementIds) {
            try {
                Agreement agreement = this._agreements.getAgreement(agreementId, false);
                AgreementUpdate updater = this._agreementUpdateFactory.createAgreementUpdate();
                updater.init(agreement);
                if (updater.update(transport, processing, packaging, partyIds)) {
                    agreement.save();
                }
                if (!partner.isLocal() || !this._messengerConfig.isAutomaticAgreementUpdateEnabled() || !schemaSet) continue;
                CppPartner remotePartner = this._profiles.getProfileForLocalId(agreement.getCommunicationPartner().getId(), false);
                if (partner.getLocalId().equals(remotePartner.getLocalId())) {
                    remotePartner = this._profiles.getProfileForLocalId(agreement.getOwnPartner().getId(), false);
                }
                if (!remotePartner.isFromRegistry() || !remotePartner.isLocal() && (!remotePartner.isRemote() || !remotePartner.isAgreementAutoupdate())) continue;
                updater.setAllSupportedSchemaSets();
                agreement.save();
            }
            catch (Exception exception) {}
        }
    }

    public void updateAllAgreementsForRegistryPartner(CppPartner partner) {
        List<String> agreementIds = this._agreements.getAgreementIdsForPartner(partner.getLocalId());
        int count = 0;
        for (String agreementId : agreementIds) {
            try {
                Agreement agreement = this._agreements.getAgreement(agreementId, false);
                this._agreements.recreateAndRegisterAgreement(agreement);
                ++count;
            }
            catch (Exception e) {
                _log.error((Object)"Could not update agreement with id '%s': %s".formatted(agreementId, e.getMessage()));
            }
        }
        _log.info((Object)("Updated " + count + " agreements."));
    }

    public boolean updateCertificates(String optionSort, Communication comm, CppPartner sender, CppPartner receiver) throws Exception {
        Option[] options;
        String id;
        boolean isPackaging;
        boolean changed = false;
        if ("packaging".equals(optionSort)) {
            isPackaging = true;
            id = comm.getPackagingId();
            options = comm.getPackagingOptions();
        } else {
            isPackaging = false;
            id = comm.getPipelineId();
            options = comm.getPipelineOptions();
        }
        List<String> senderCertRefIds = Arrays.asList(sender.getCertificateIds());
        List<String> receiverCertRefIds = Arrays.asList(receiver.getCertificateIds());
        for (Option option : options) {
            String certRefId;
            UIOption referenceUIOption = UIOptionFinder.getUIOption(optionSort, id, option);
            if (referenceUIOption == null || !StringUtils.isNotBlank((CharSequence)(certRefId = this.findCertRefId(option))) || "default".equals(certRefId)) continue;
            if ("senderCertificate".equals(referenceUIOption.getCertMode())) {
                if (!this.removeDeadCertRef(comm, isPackaging, senderCertRefIds, certRefId, referenceUIOption)) continue;
                changed = true;
                continue;
            }
            if (!"receiverCertificate".equals(referenceUIOption.getCertMode()) || !this.removeDeadCertRef(comm, isPackaging, receiverCertRefIds, certRefId, referenceUIOption)) continue;
            changed = true;
        }
        return changed;
    }

    private String findCertRefId(Option option) {
        Option[] subOptions = option.getSubOptions();
        if (subOptions != null) {
            for (Option subOption : subOptions) {
                if (!"certificateAlias".equals(subOption.getName())) continue;
                return subOption.getValue();
            }
        }
        return null;
    }

    private boolean removeDeadCertRef(Communication comm, boolean isPackaging, List<String> partnerCertRefIds, String certRefId, UIOption uiOption) throws OptionNotFoundException {
        if (!partnerCertRefIds.contains(certRefId)) {
            if (isPackaging) {
                comm.deletePackagingOptionCert(uiOption.getOptionPath());
            } else {
                comm.deletePipelineOptionCert(uiOption.getOptionPath());
            }
            return true;
        }
        return false;
    }
}

