/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.cpa.update;

import de.pontonconsulting.xmlpipe.Util;
import de.pontonconsulting.xmlpipe.admintool.InstallCertException;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.config.SchemaData;
import de.pontonconsulting.xmlpipe.config.SchemataConfig;
import de.pontonconsulting.xmlpipe.config.partnerprofile.Transport;
import de.pontonconsulting.xmlpipe.cp.AdditionalSchema;
import de.pontonconsulting.xmlpipe.cp.DocumentType;
import de.pontonconsulting.xmlpipe.cpa.Agreement;
import de.pontonconsulting.xmlpipe.cpa.Communication;
import de.pontonconsulting.xmlpipe.cpa.CommunicationNotFoundException;
import de.pontonconsulting.xmlpipe.cpa.update.AgreementUpdateUtility;
import de.pontonconsulting.xmlpipe.cpp.CppPartner;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.cpp.ProfileNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.messenger.IPipelineFactory;
import de.pontonconsulting.xmlpipe.messenger.database.DbException;
import de.pontonconsulting.xmlpipe.messenger.database.tables.EventLog;
import de.pontonconsulting.xmlpipe.messenger.packaging.IPackagingManager;
import de.pontonconsulting.xmlpipe.uiconfig.UIConfig;
import de.pontonconsulting.xmlpipe.uioption.UIOption;
import jakarta.xml.bind.JAXBException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AgreementUpdate {
    private static final String EVENT_ID_SEND = ".send";
    private static final String EVENT_ID_RECEIVE = ".receive";
    private static final String SUB_EVENT_ID_COMM = ".communication";
    private static final String SUB_EVENT_ID_PCKG = ".packaging";
    private static final String SUB_EVENT_ID_PROC = ".processing";
    private static final String SUB_EVENT_ID_ID = ".id";
    private static final String LOCATION = "/private/partnerAgreement/ShowPartnersAgreement.do";
    private static final Log _log = LogFactory.getLog((String)"Messenger.AgreementUpdate");
    private final IPipelineFactory _pipelineFactory;
    private final IPackagingManager _packagingManager;
    private final AgreementUpdateUtility _agreementUpdateUtility;
    private final UIConfig _uiConfig;
    private final Profiles _profiles;
    private final EventLog _EventLog;
    private final MessengerConfig messengerConfig;
    private Agreement _agreement;
    private final SchemataConfig _schemataConfig;
    private boolean _writeEvent = true;
    CppPartner _partner1 = null;
    CppPartner _partner2 = null;

    public AgreementUpdate(IPipelineFactory pipelineFactory, IPackagingManager packagingManager, AgreementUpdateUtility agreementUpdateUtility, UIConfig uiConfig, Profiles profiles, EventLog EventLog2, MessengerConfig messengerConfig, SchemataConfig schemataConfig) {
        this._pipelineFactory = pipelineFactory;
        this._packagingManager = packagingManager;
        this._agreementUpdateUtility = agreementUpdateUtility;
        this._uiConfig = uiConfig;
        this._profiles = profiles;
        this._EventLog = EventLog2;
        this.messengerConfig = messengerConfig;
        this._schemataConfig = schemataConfig;
    }

    public void init(Agreement agreement, boolean writeEvent) throws ProfileException {
        this._agreement = agreement;
        this._partner1 = this._profiles.getProfileForLocalId(agreement.getOwnPartner().getId(), true);
        this._partner2 = this._profiles.getProfileForLocalId(agreement.getCommunicationPartner().getId(), true);
        this._writeEvent = writeEvent;
    }

    public void init(Agreement agreement) throws Exception {
        this.init(agreement, true);
    }

    public boolean update(boolean transport, boolean processing, boolean packaging, boolean partyIds) throws Exception {
        boolean transp = true;
        if (transport) {
            transp = this.updateTransport();
        }
        boolean proc = true;
        if (processing) {
            proc = this.updatePipeline();
        }
        boolean pckg = true;
        if (packaging) {
            pckg = this.updatePackaging();
        }
        return transp | proc | pckg;
    }

    private boolean updateTransport() throws Exception {
        boolean changed = false;
        if (this.setTransportValues(this._partner1, this._partner2, EVENT_ID_SEND)) {
            changed = true;
        }
        if (this.setTransportValues(this._partner2, this._partner1, EVENT_ID_RECEIVE)) {
            changed = true;
        }
        return changed;
    }

    private boolean setTransportValues(CppPartner sender, CppPartner receiver, String direction) throws CommunicationNotFoundException, ProfileNotFoundException, ProfileException, DbException {
        boolean changed = false;
        Communication comm = this._agreement.getCommunication(sender.getLocalId(), receiver.getLocalId());
        List<Transport> transports = receiver.getTransportList();
        if (transports.size() == 0) {
            comm.setTransportId("");
            comm.setTransportURL("");
            comm.setTransportFallbackURL("");
            changed = true;
        } else {
            boolean OK = false;
            for (Transport transport : transports) {
                if (!transport.getId().equalsIgnoreCase(comm.getTransportId())) continue;
                if (!transport.getURL().equals(comm.getTransportURL())) {
                    if (transport.isFallback()) {
                        comm.setTransportFallbackURL(transport.getURL());
                    } else {
                        comm.setTransportURL(transport.getURL());
                    }
                    changed = true;
                }
                OK = true;
                break;
            }
            if (!OK) {
                String preferredId = receiver.getPreferredTransportId();
                String fallbackId = receiver.getFallbackTransportId();
                String newTransportId = preferredId != null ? preferredId : transports.get(0).getId();
                comm.setTransportId(newTransportId);
                comm.setTransportURL(receiver.getTransportUrl(newTransportId));
                if (fallbackId != null) {
                    comm.setTransportFallbackURL(receiver.getTransportUrl(fallbackId));
                }
                if (comm.getTransportURL().equals(comm.getTransportFallbackURL())) {
                    comm.setTransportFallbackURL("");
                }
                changed = true;
                if (this._writeEvent) {
                    String eventKey = this._EventLog.getEventId(EventLog.AGR_UPDATE_EVENT_ID, sender.getLocalId(), receiver.getLocalId(), ".communication." + System.currentTimeMillis());
                    this._EventLog.writeOK(eventKey, "agreementUpdate" + direction + ".communication.url.component", "agreementUpdate" + direction + ".communication.url.descriptionKey", "", new String[]{this._partner1.getDisplayName(), this._partner2.getDisplayName()}, "/private/partnerAgreement/ShowPartnersAgreement.do?localID=" + this._partner1.getLocalId() + "&nonLocalID=" + this._partner2.getLocalId() + "&pageType=send&tabName=communication");
                }
            }
        }
        int actualRetries = comm.getNumberOfRetries();
        if (actualRetries < 0) {
            int defaultRetries = 0;
            try {
                defaultRetries = this.messengerConfig.getDefaultRetransmissionRetries();
            }
            catch (JAXBException e1) {
                defaultRetries = 1;
            }
            comm.setNumberOfRetries(defaultRetries);
            changed = true;
        }
        List<Integer> actualRetryIntervals = comm.getRetryIntervals();
        Iterator<Integer> iterator = actualRetryIntervals.iterator();
        while (iterator.hasNext()) {
            Integer actualRetryInterval = iterator.next();
            if (actualRetryInterval >= 0) continue;
            iterator.remove();
        }
        if (actualRetryIntervals.size() == 0) {
            try {
                List<Integer> defaults = this.messengerConfig.getDefaultRetransmissionRetryIntervals();
                comm.setRetryIntervals(defaults);
                changed = true;
            }
            catch (JAXBException jax) {
                _log.error((Object)"could not get default retransmissions intervals from messenger.xml", (Throwable)jax);
            }
        }
        return changed;
    }

    private boolean updatePackaging() throws Exception {
        boolean changed = false;
        if (this.setPackagingValues(this._partner1, this._partner2, EVENT_ID_SEND)) {
            changed = true;
        }
        if (this.setPackagingValues(this._partner2, this._partner1, EVENT_ID_RECEIVE)) {
            changed = true;
        }
        return changed;
    }

    private boolean setPackagingValues(CppPartner sender, CppPartner receiver, String direction) throws CertificateException, NoSuchProviderException, InstallCertException, Exception {
        boolean changed = false;
        Communication communication = this._agreement.getCommunication(sender.getLocalId(), receiver.getLocalId());
        List<String> commonPackagingIds = Util.getEqualObjects(sender.getPackagingIds(), receiver.getPackagingIds());
        if (!commonPackagingIds.contains(communication.getPackagingId()) && commonPackagingIds.size() > 0) {
            String newPackagingId = null;
            String preferredId = receiver.getPreferredPackagingId();
            newPackagingId = preferredId != null && commonPackagingIds.contains(preferredId) ? preferredId : commonPackagingIds.get(0);
            communication.setPackagingId(newPackagingId);
            changed = true;
            if (this._writeEvent) {
                String eventKey = this._EventLog.getEventId(EventLog.AGR_UPDATE_EVENT_ID, sender.getLocalId(), receiver.getLocalId(), ".packaging.id." + System.currentTimeMillis());
                this._EventLog.writeOK(eventKey, "agreementUpdate" + direction + ".packaging.id.component", "agreementUpdate" + direction + ".packaging.id.descriptionKey", "", new String[]{this._partner1.getDisplayName(), this._partner2.getDisplayName()}, "/private/partnerAgreement/ShowPartnersAgreement.do?localID=" + this._partner1.getLocalId() + "&nonLocalID=" + this._partner2.getLocalId() + "&pageType=send&tabName=packaging");
            }
        }
        if (changed) {
            this.setAllStandardPackagingOptions(communication, sender, receiver, true);
        }
        if (this._agreementUpdateUtility.updateCertificates("packaging", communication, sender, receiver)) {
            changed = true;
        }
        return changed;
    }

    public boolean updatePipeline() throws Exception {
        boolean changed = false;
        if (this.setPipelineValues(this._partner1, this._partner2, EVENT_ID_SEND)) {
            changed = true;
        }
        if (this.setPipelineValues(this._partner2, this._partner1, EVENT_ID_RECEIVE)) {
            changed = true;
        }
        return changed;
    }

    private boolean setPipelineValues(CppPartner sender, CppPartner receiver, String direction) throws CertificateException, NoSuchProviderException, InstallCertException, Exception {
        boolean changed = false;
        Communication communication = this._agreement.getCommunication(sender.getLocalId(), receiver.getLocalId());
        List<String> commonPipelineIds = Util.getEqualObjects(sender.getPipelineIds(), receiver.getPipelineIds());
        if (!commonPipelineIds.contains(communication.getPipelineId()) && commonPipelineIds.size() > 0) {
            String preferredId = receiver.getPreferredPipelineId();
            String newPipelineId = preferredId != null && commonPipelineIds.contains(preferredId) ? preferredId : commonPipelineIds.get(0);
            communication.setPipelineId(newPipelineId);
            changed = true;
            if (this._writeEvent) {
                String eventKey = this._EventLog.getEventId(EventLog.AGR_UPDATE_EVENT_ID, sender.getLocalId(), receiver.getLocalId(), ".processing.id." + System.currentTimeMillis());
                this._EventLog.writeOK(eventKey, "agreementUpdate" + direction + ".processing.id.component", "agreementUpdate" + direction + ".processing.id.descriptionKey", "", new String[]{this._partner1.getDisplayName(), this._partner2.getDisplayName()}, "/private/partnerAgreement/ShowPartnersAgreement.do?localID=" + this._partner1.getLocalId() + "&nonLocalID=" + this._partner2.getLocalId() + "&pageType=send&tabName=processing");
            }
        }
        if (changed) {
            this.setAllStandardPipelineOptions(communication, sender, receiver, true);
        }
        if (this._agreementUpdateUtility.updateCertificates("processing", communication, sender, receiver)) {
            changed = true;
        }
        return changed;
    }

    public void setAllSupportedSchemaSets() throws ProfileNotFoundException, ProfileException, JAXBException {
        List<DocumentType> partner1_Docs = this._partner1.getDocumentTypes();
        List<DocumentType> partner2_Docs = this._partner2.getDocumentTypes();
        List<DocumentType> docs = Util.getEqualObjects(partner1_Docs, partner2_Docs);
        for (DocumentType documentType : docs) {
            SchemaData schema = this._schemataConfig.getSchemaBySetTypeVersion(documentType.getSchemaSet(), documentType.getType(), documentType.getVersion());
            if (schema == null) continue;
            for (AdditionalSchema additionalSchema : schema.getAdditionalSchemata()) {
                documentType.addAdditionalSchema(additionalSchema);
            }
            documentType.setDtd(schema.getDtdFile());
        }
        this._agreement.setDocumentTypes(docs);
    }

    public void setAllStandardOptions() throws ProfileNotFoundException, ProfileException, CommunicationNotFoundException {
        this.setStandardOptions(this._partner1, this._partner2);
        this.setStandardOptions(this._partner2, this._partner1);
    }

    private void setStandardOptions(CppPartner sender, CppPartner receiver) throws CommunicationNotFoundException, ProfileException {
        Communication comm = this._agreement.getCommunication(sender.getLocalId(), receiver.getLocalId());
        this.setAllStandardPackagingOptions(comm, sender, receiver, true);
        this.setAllStandardPipelineOptions(comm, sender, receiver, true);
    }

    private void setAllStandardPackagingOptions(Communication comm, CppPartner sender, CppPartner receiver, boolean useUIConfig) throws ProfileException {
        String packageId = comm.getPackagingId();
        if (packageId != null) {
            UIOption[] options = this._packagingManager.getPackagingOptions(packageId);
            try {
                if (useUIConfig) {
                    List<UIOption> uiOptionsList = this._uiConfig.getDefaultPackageUIOptions(packageId, options);
                    options = uiOptionsList.toArray(new UIOption[uiOptionsList.size()]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setStandardOptions(comm, "packaging", packageId, options, sender, receiver);
        }
    }

    private void setAllStandardPipelineOptions(Communication comm, CppPartner sender, CppPartner receiver, boolean useUIConfig) throws ProfileNotFoundException, ProfileException {
        String pipelineId = comm.getPipelineId();
        if (pipelineId != null) {
            UIOption[] options = this._pipelineFactory.getPipelineOptions(pipelineId);
            try {
                if (useUIConfig) {
                    List<UIOption> uiOptionsList = this._uiConfig.getDefaultPipelineUIOptions(pipelineId, options);
                    options = uiOptionsList.toArray(new UIOption[0]);
                }
            }
            catch (Exception e) {
                _log.error((Object)"could not get default pipeline options", (Throwable)e);
            }
            this.setStandardOptions(comm, "processing", pipelineId, options, sender, receiver);
        }
    }

    private void setStandardOptions(Communication comm, String optionSort, String id, UIOption[] options, CppPartner sender, CppPartner receiver) {
        for (int i = 0; i < options.length; ++i) {
            UIOption tempUIOption = options[i];
            if (!tempUIOption.getStandardActive() || !tempUIOption.getSupported()) continue;
            try {
                this.setStandardOptionValue(comm, optionSort, id, tempUIOption);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void setStandardOptionValue(Communication comm, String optionSort, String id, UIOption uiOption) throws ProfileNotFoundException, ProfileException {
        String uiOptionType = uiOption.getType();
        if ("boolean".equals(uiOptionType)) {
            if ("packaging".equals(optionSort)) {
                comm.setPackagingOptionValue(uiOption.getOptionPath(), uiOption.getValues(), uiOptionType);
            } else if ("processing".equals(optionSort)) {
                comm.setPipelineOptionValue(uiOption.getOptionPath(), uiOption.getValues(), uiOptionType);
            }
        } else if ("string".equals(uiOptionType)) {
            if ("packaging".equals(optionSort)) {
                comm.setPackagingOptionValue(uiOption.getOptionPath(), uiOption.getDefaultValue(), uiOptionType);
            } else if ("processing".equals(optionSort)) {
                comm.setPipelineOptionValue(uiOption.getOptionPath(), uiOption.getDefaultValue(), uiOptionType);
            }
        } else if ("list".equals(uiOptionType)) {
            String value = uiOption.getDefaultValue();
            if ("packaging".equals(optionSort)) {
                comm.setPackagingOptionValue(uiOption.getOptionPath(), value, uiOptionType);
            } else if ("processing".equals(optionSort)) {
                comm.setPipelineOptionValue(uiOption.getOptionPath(), value, uiOptionType);
            }
        }
    }
}

