/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.cpa;

import de.pontonconsulting.activation.ActivationException;
import de.pontonconsulting.common.security.IPasswordCrypt;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.config.SubjectElement;
import de.pontonconsulting.xmlpipe.config.partneragreement.CollaborationAgreement;
import de.pontonconsulting.xmlpipe.config.partneragreement.CommunicationType;
import de.pontonconsulting.xmlpipe.config.partneragreement.OptionType;
import de.pontonconsulting.xmlpipe.config.privatepartneragreement.NotificationSubjectElementType;
import de.pontonconsulting.xmlpipe.config.privatepartneragreement.ObjectFactory;
import de.pontonconsulting.xmlpipe.config.privatepartneragreement.RuleType;
import de.pontonconsulting.xmlpipe.cp.Authentication;
import de.pontonconsulting.xmlpipe.cp.Option;
import de.pontonconsulting.xmlpipe.cpa.Agreement;
import de.pontonconsulting.xmlpipe.cpa.AgreementException;
import de.pontonconsulting.xmlpipe.cpa.Agreements;
import de.pontonconsulting.xmlpipe.cpa.RuleData;
import de.pontonconsulting.xmlpipe.cpp.CertificateIdNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.CppPartner;
import de.pontonconsulting.xmlpipe.cpp.IdNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.OptionNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.PackageIdNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.PartnerCertificateManager;
import de.pontonconsulting.xmlpipe.cpp.PipelineIdNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.cpp.TransportIdNotFoundException;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.packaging.BasePackager;
import de.pontonconsulting.xmlpipe.messenger.packaging.PackagingException;
import de.pontonconsulting.xmlpipe.messenger.transport.TransportException;
import de.pontonconsulting.xmlpipe.security.CertificateReader;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import de.pontonconsulting.xmlpipe.security.certificate.CertificateChooser;
import de.pontonconsulting.xmlpipe.security.certificate.CertificateValidityFilter;
import de.pontonconsulting.xmlpipe.security.certificate.EmailCertificateFilter;
import de.pontonconsulting.xmlpipe.security.certificate.ICertificateFilter;
import de.pontonconsulting.xmlpipe.security.certificate.PublicKeyCertificateFilter;
import de.pontonconsulting.xmlpipe.security.certificate.SortCriteria;
import de.pontonconsulting.xmlpipe.security.util.SignCertInfo;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.asn1.x509.KeyPurposeId;

public class Communication {
    public static final String PROCESSING_EXCEPTIONID_DEFAULT = "default";
    public static final List<SortCriteria> COMMON_SORT_CRITERIA = List.of(SortCriteria.SUBJECT, SortCriteria.CN, SortCriteria.ISSUER, SortCriteria.KEY_USAGE, SortCriteria.EXTENDED_KEY_USAGE);
    private static final String DEFAULT_CERTIFICATE_ALIAS = "default";
    private static final String NO_VALID_CERTIFICATE_FOR_PARTNER = "No VALID Certificate for the partner '%s' is installed.";
    private static final Logger _log = LogManager.getLogger((String)"Messenger.Communication");
    private boolean transportURLValid = true;
    private boolean fallbackTransportURLValid = true;
    private final Agreement _agreement;
    private final IPasswordCrypt _passwordCrypt;
    private final ReferenceDateTask referenceDateTask;
    private final CertificateUtility certificateUtility;
    private final CertificateReader certificateInfo;
    private final CertificateChooser certificateChooser;
    private final List<ICertificateFilter> certificateFilters = new ArrayList<PublicKeyCertificateFilter>(List.of(new PublicKeyCertificateFilter()));
    private final PartnerCertificateManager partnerCertificateManager;
    private final MessengerConfig messengerConfig;
    private final Profiles profiles;
    private final Agreements agreements;
    private final CommunicationType _communication;
    private static final de.pontonconsulting.xmlpipe.config.partneragreement.ObjectFactory _factory = new de.pontonconsulting.xmlpipe.config.partneragreement.ObjectFactory();
    private static final ObjectFactory _privateFactory = new ObjectFactory();
    private final Map<String, Option> _transportOptionLookup = new TreeMap<String, Option>();
    private boolean _transportDirty;
    private final Map<String, Option> _packagingOptionLookup = new TreeMap<String, Option>();
    private boolean _packagingDirty;
    private final Map<String, Option> _pipelineOptionLookup = new TreeMap<String, Option>();
    private boolean _pipelineDirty;
    private final Map<String, String> _processingExceptionId = new HashMap<String, String>();
    private List<RuleType> _contentRules;
    final ReentrantLock packagingSignCertLock = new ReentrantLock();
    final ReentrantLock processingSignCertLock = new ReentrantLock();
    final ReentrantLock packagingEncryptCertLock = new ReentrantLock();
    final ReentrantLock processingEncryptCertLock = new ReentrantLock();

    protected Communication(CommunicationType communication, Agreement agreement, IPasswordCrypt passwordCrypt, ReferenceDateTask referenceDateTask, CertificateReader certificateInfo, CertificateUtility certificateUtility, CertificateChooser certificateChooser, PartnerCertificateManager partnerCertificateManager, MessengerConfig messengerConfig, Profiles profiles, Agreements agreements) {
        this._communication = communication;
        this._agreement = agreement;
        this._passwordCrypt = passwordCrypt;
        this.referenceDateTask = referenceDateTask;
        this.certificateUtility = certificateUtility;
        this.certificateInfo = certificateInfo;
        this.certificateChooser = certificateChooser;
        this.partnerCertificateManager = partnerCertificateManager;
        this.messengerConfig = messengerConfig;
        this.profiles = profiles;
        this.agreements = agreements;
        this.certificateFilters.add(new CertificateValidityFilter(this.referenceDateTask));
        this.updateLookupTables(true, true, true);
    }

    private String getFirstOptionPath() {
        return "/id";
    }

    private void updateLookupTables(boolean updateTransport, boolean updatePackaging, boolean updateProcessing) {
        if (updateTransport) {
            this._transportOptionLookup.clear();
            List transportOptions = this._communication.getTransport().getOption();
            Option allTransportOptions = new Option("id", "id", null);
            allTransportOptions.setSubOptions(this.getSubOptions(transportOptions, this.getFirstOptionPath(), this._transportOptionLookup));
            this._transportOptionLookup.put(this.getFirstOptionPath(), allTransportOptions);
        }
        if (updatePackaging) {
            this._packagingOptionLookup.clear();
            List packagingOptions = this._communication.getPackaging().getOption();
            Option allPackagingOptions = new Option("id", "id", null);
            allPackagingOptions.setSubOptions(this.getSubOptions(packagingOptions, this.getFirstOptionPath(), this._packagingOptionLookup));
            this._packagingOptionLookup.put(this.getFirstOptionPath(), allPackagingOptions);
        }
        if (updateProcessing) {
            this._pipelineOptionLookup.clear();
            List pipelineOptions = this._communication.getPipeline().getOption();
            Option allPipelineOptions = new Option("id", "id", null);
            allPipelineOptions.setSubOptions(this.getSubOptions(pipelineOptions, this.getFirstOptionPath(), this._pipelineOptionLookup));
            this._pipelineOptionLookup.put(this.getFirstOptionPath(), allPipelineOptions);
        }
        this._processingExceptionId.clear();
    }

    public void refresh() {
        boolean updateTransport = false;
        boolean updatePackaging = false;
        boolean updateProcessing = false;
        if (this._transportDirty) {
            updateTransport = true;
        }
        if (this._packagingDirty) {
            updatePackaging = true;
        }
        if (this._pipelineDirty) {
            updateProcessing = true;
        }
        this.updateLookupTables(updateTransport, updatePackaging, updateProcessing);
    }

    private void updatePackagingElement() {
        List optionElements = this._communication.getPackaging().getOption();
        optionElements.clear();
        Option options = this._packagingOptionLookup.get(this.getFirstOptionPath());
        List<OptionType> sub = this.createSubOptions(options.getSubOptions());
        optionElements.addAll(sub);
        this._packagingDirty = false;
    }

    private void updatePipelineElement() {
        List optionElements = this._communication.getPipeline().getOption();
        optionElements.clear();
        Option options = this._pipelineOptionLookup.get(this.getFirstOptionPath());
        List<OptionType> sub = this.createSubOptions(options.getSubOptions());
        optionElements.addAll(sub);
        this._pipelineDirty = false;
    }

    private void updateTransportElement() {
        List optionElements = this._communication.getTransport().getOption();
        optionElements.clear();
        Option options = this._transportOptionLookup.get(this.getFirstOptionPath());
        List<OptionType> sub = this.createSubOptions(options.getSubOptions());
        optionElements.addAll(sub);
        this._transportDirty = false;
    }

    protected void updateCommunicationOptions() {
        if (this._transportDirty) {
            this.updateTransportElement();
        }
        if (this._packagingDirty) {
            this.updatePackagingElement();
        }
        if (this._pipelineDirty) {
            this.updatePipelineElement();
        }
    }

    private List<OptionType> createSubOptions(Option[] options) {
        ArrayList<OptionType> result = new ArrayList<OptionType>();
        for (Option option : options) {
            Option[] subOptions = option.getSubOptions();
            List<OptionType> subOptionElement = this.createSubOptions(subOptions);
            OptionType optionType = _factory.createOptionType();
            optionType.setName(option.getName());
            optionType.setType(option.getType());
            optionType.setValue(option.getValue());
            optionType.getOption().addAll(subOptionElement);
            result.add(optionType);
        }
        return result;
    }

    public String getSenderLocalId() {
        return this._communication.getSenderRefId();
    }

    public void setSenderLocalId(String senderLocalId) {
        this._communication.setSenderRefId(senderLocalId);
    }

    public String getReceiverLocalId() {
        return this._communication.getReceiverRefId();
    }

    public void setReceiverLocalId(String receiverLocalId) {
        this._communication.setReceiverRefId(receiverLocalId);
    }

    public CollaborationAgreement.Partner getSender() throws ProfileException {
        CollaborationAgreement.Partner partner = this._agreement.getOwnPartner();
        if (this.getSenderLocalId().equals(partner.getId())) {
            return partner;
        }
        return this._agreement.getCommunicationPartner();
    }

    public CollaborationAgreement.Partner getReceiver() throws ProfileException {
        CollaborationAgreement.Partner partner = this._agreement.getCommunicationPartner();
        if (this.getReceiverLocalId().equals(partner.getId())) {
            return partner;
        }
        return this._agreement.getOwnPartner();
    }

    public String getTransportURL() {
        return this._communication.getTransport().getURL();
    }

    public void setTransportURL(String url) {
        this._communication.getTransport().setURL(url);
    }

    public String getTransportFallbackURL() {
        return this._communication.getTransport().getFallbackURL();
    }

    public void setTransportFallbackURL(String url) {
        this._communication.getTransport().setFallbackURL(url);
    }

    public Authentication getTransportAuthentication() {
        Authentication auth = null;
        CommunicationType.Transport.Authentication authType = this._communication.getTransport().getAuthentication();
        if (authType != null) {
            try {
                if (authType.getUser() != null && this._passwordCrypt.decryptPassword(authType.getPassword()) != null) {
                    auth = new Authentication(authType.getUser(), this._passwordCrypt.decryptPassword(authType.getPassword()));
                }
            }
            catch (GeneralSecurityException e) {
                _log.error("password decryption did not work", (Throwable)e);
            }
        }
        return auth;
    }

    public void setTransportAuthentication(Authentication auth) {
        if (auth == null) {
            this._communication.getTransport().setAuthentication(null);
            return;
        }
        CommunicationType.Transport.Authentication authType = this._communication.getTransport().getAuthentication();
        if (authType == null) {
            authType = _factory.createCommunicationTypeTransportAuthentication();
            this._communication.getTransport().setAuthentication(authType);
        }
        authType.setUser(auth.getUser());
        try {
            authType.setPassword(this._passwordCrypt.encryptPassword(auth.getPassword()));
        }
        catch (GeneralSecurityException e) {
            _log.error("password decryption did not work", (Throwable)e);
        }
    }

    private Option[] getSubOptions(List<OptionType> options, String parentPath, Map<String, Option> lookupMap) {
        ArrayList<Option> result = new ArrayList<Option>();
        for (OptionType element : options) {
            Option option = new Option(element.getName(), element.getValue(), element.getType());
            String path = parentPath + "/" + option.getName();
            lookupMap.put(path, option);
            List subOptions = element.getOption();
            Option[] subOptionsArray = this.getSubOptions(subOptions, path, lookupMap);
            option.setSubOptions(subOptionsArray);
            result.add(option);
        }
        return result.toArray(new Option[0]);
    }

    public String getTransportOptionValue(String optionPath) throws TransportIdNotFoundException {
        Option opt = this._transportOptionLookup.get(this.getFirstOptionPath() + optionPath);
        if (opt == null) {
            throw new TransportIdNotFoundException();
        }
        return opt.getValue();
    }

    public Option[] getPackagingOptions() {
        Option all = this._packagingOptionLookup.get(this.getFirstOptionPath());
        return all.getSubOptions();
    }

    public Option getPackagingOption(String optionPath) throws OptionNotFoundException {
        Option opt = this._packagingOptionLookup.get(this.getFirstOptionPath() + optionPath);
        if (opt == null) {
            throw new OptionNotFoundException();
        }
        return opt;
    }

    public Option getPackagingOption() throws OptionNotFoundException {
        Option opt = this._packagingOptionLookup.get(this.getFirstOptionPath());
        if (opt == null) {
            throw new OptionNotFoundException();
        }
        return opt;
    }

    public String getPackagingOptionValue(String optionPath) throws OptionNotFoundException {
        Option opt = this.getPackagingOption(optionPath);
        return opt.getValue();
    }

    public void setPackagingOptionValue(String optionPath, String value, String type) throws PackageIdNotFoundException {
        Option opt = this._packagingOptionLookup.get(this.getFirstOptionPath() + optionPath);
        if (opt == null) {
            try {
                opt = this.createOptionPath(optionPath, new PackageIdNotFoundException(), this._packagingOptionLookup);
            }
            catch (IdNotFoundException e) {
                throw (PackageIdNotFoundException)e;
            }
            opt.setType(type);
        }
        opt.setValue(value);
        this._packagingDirty = true;
    }

    public Option[] getPipelineOptions() {
        Option all = this._pipelineOptionLookup.get(this.getFirstOptionPath());
        return all.getSubOptions();
    }

    public Option getPipelineOption(String optionPath) throws OptionNotFoundException {
        Option opt = this._pipelineOptionLookup.get(this.getFirstOptionPath() + optionPath);
        if (opt == null) {
            throw new OptionNotFoundException();
        }
        return opt;
    }

    public Option getPipelineOption(String defaultOptionPath, String processingExceptionName) throws OptionNotFoundException {
        if (processingExceptionName == null || "default".equals(processingExceptionName)) {
            return this.getPipelineOption(defaultOptionPath);
        }
        return this.getPipelineOption(Communication.getProcessingExceptionsPath() + "/" + processingExceptionName + defaultOptionPath);
    }

    public Option getPipelineOptionForMessage(String defaultOptionPath, String messageSchemaLocation) throws OptionNotFoundException {
        return this.getPipelineOption(defaultOptionPath, this.getProcessingExceptionId(messageSchemaLocation));
    }

    public String getProcessingExceptionId(String messageSchemaLocation) {
        String excId = this._processingExceptionId.get(messageSchemaLocation);
        if (excId == null) {
            excId = this.determineProcessingExceptionId(messageSchemaLocation);
        }
        return excId;
    }

    private String determineProcessingExceptionId(String messageSchemaLocation) {
        Option[] processingExcpOptions;
        try {
            processingExcpOptions = this.getProcessingExceptions();
        }
        catch (OptionNotFoundException e) {
            return "default";
        }
        for (Option option : processingExcpOptions) {
            List<Option> schemaLocationOpts = option.getSubOptions("string", "schemaLocation", messageSchemaLocation);
            if (schemaLocationOpts == null || schemaLocationOpts.isEmpty()) continue;
            this._processingExceptionId.put(messageSchemaLocation, option.getName());
            return option.getName();
        }
        return "default";
    }

    public Option getProcessingExceptionOption() throws OptionNotFoundException {
        return this.getPipelineOption(Communication.getProcessingExceptionsPath());
    }

    public Option getProcessingException(String processingExceptionId) throws OptionNotFoundException {
        return this.getPipelineOption(Communication.determineProcessingExceptionPath(processingExceptionId));
    }

    private void addOption2LookupTable(Option option, Map<String, Option> lookupTable) {
        Option[] subOptions;
        lookupTable.put(this.getFirstOptionPath() + option.getPath(), option);
        for (Option subOption : subOptions = option.getSubOptions()) {
            this.addOption2LookupTable(subOption, lookupTable);
        }
    }

    public List<Option> getPipelineDefaultOptions() {
        Option[] options;
        ArrayList<Option> defaultOptions = new ArrayList<Option>();
        for (Option tempOption : options = this.getPipelineOptions()) {
            if (tempOption.getName().equals("processing")) continue;
            defaultOptions.add(tempOption);
        }
        return defaultOptions;
    }

    public List<Option> getPipelineOptions(String exceptionId) throws OptionNotFoundException {
        Option[] subOptions;
        if ("default".equals(exceptionId)) {
            return this.getPipelineDefaultOptions();
        }
        ArrayList<Option> procExcOptions = new ArrayList<Option>();
        Option excOption = this.getProcessingException(exceptionId);
        for (Option option : subOptions = excOption.getSubOptions()) {
            if (option.getName().equals("schemaLocation")) continue;
            procExcOptions.add(option);
        }
        return procExcOptions;
    }

    public static String determineProcessingExceptionPath(String processingExceptionId) {
        return Communication.getProcessingExceptionsPath() + "/" + processingExceptionId;
    }

    private static String getProcessingExceptionsPath() {
        return "/processing";
    }

    public Option[] getProcessingExceptions() throws OptionNotFoundException {
        return this.getProcessingExceptionOption().getSubOptions();
    }

    public Option getPipelineOption() throws OptionNotFoundException {
        Option opt = this._pipelineOptionLookup.get(this.getFirstOptionPath());
        if (opt == null) {
            throw new OptionNotFoundException();
        }
        return opt;
    }

    public String getPipelineOptionValue(String optionPath) throws OptionNotFoundException {
        Option opt = this.getPipelineOption(optionPath);
        return opt.getValue();
    }

    public static String determinePipelineDefaultOptionPath(String optionPath) {
        String resultPath = optionPath;
        if (optionPath.startsWith(Communication.getProcessingExceptionsPath())) {
            int index = optionPath.indexOf("/", Communication.getProcessingExceptionsPath().length() + 1);
            resultPath = index == -1 ? optionPath : optionPath.substring(index);
        }
        return resultPath;
    }

    public static String determineProcessingExceptionIdForPath(String optionPath) {
        String excId = null;
        if (optionPath.startsWith(Communication.getProcessingExceptionsPath())) {
            int startIndex = optionPath.indexOf("/", 1);
            int endIndex = optionPath.indexOf("/", Communication.getProcessingExceptionsPath().length() + 1);
            excId = startIndex == -1 || endIndex == -1 ? "default" : optionPath.substring(startIndex + 1, endIndex);
        }
        return excId;
    }

    public String getPipelineOptionValueForMessage(String defaultOptionPath, String messageSchemaLocation) throws OptionNotFoundException {
        Option opt = this.getPipelineOptionForMessage(defaultOptionPath, messageSchemaLocation);
        return opt.getValue();
    }

    public void setPipelineOptionValue(String optionPath, String value, String type) throws PipelineIdNotFoundException {
        Option opt = this.getOrCreatePipelineOption(optionPath);
        opt.setValue(value);
        if (type != null) {
            opt.setType(type);
        }
        this._pipelineDirty = true;
    }

    public Option getOrCreatePipelineOption(String optionPath) throws PipelineIdNotFoundException {
        Option opt = this._pipelineOptionLookup.get(this.getFirstOptionPath() + optionPath);
        if (opt == null) {
            try {
                opt = this.createOptionPath(optionPath, new PipelineIdNotFoundException(), this._pipelineOptionLookup);
            }
            catch (IdNotFoundException e) {
                throw (PipelineIdNotFoundException)e;
            }
        }
        return opt;
    }

    public Option getOrCreatePackagingOption(String optionPath) throws PackageIdNotFoundException {
        Option opt = this._packagingOptionLookup.get(this.getFirstOptionPath() + optionPath);
        if (opt == null) {
            try {
                opt = this.createOptionPath(optionPath, new PackageIdNotFoundException(), this._packagingOptionLookup);
            }
            catch (IdNotFoundException e) {
                throw (PackageIdNotFoundException)e;
            }
        }
        return opt;
    }

    public void setPipelineOptionCert(String optionPath, String certAlias) throws PipelineIdNotFoundException, OptionNotFoundException {
        this.setPipelineOptionCert(null, optionPath, certAlias);
    }

    public void setPipelineOptionCert(String exceptionId, String optionPath, String certAlias) throws PipelineIdNotFoundException, OptionNotFoundException {
        Object realOptionPath = optionPath;
        if (exceptionId != null && !exceptionId.equals("default")) {
            realOptionPath = Communication.determineProcessingExceptionPath(exceptionId) + optionPath;
        }
        Option opt = this.getOrCreatePipelineOption((String)realOptionPath);
        this.deletePipelineOptionCert((String)realOptionPath);
        if (StringUtils.isNotBlank((CharSequence)certAlias) && !"default".equals(certAlias)) {
            Option certAliasOption = new Option("certificateAlias", certAlias, "string");
            this.addSubOption(opt, certAliasOption, this._pipelineOptionLookup);
        }
        this._pipelineDirty = true;
    }

    private void addSubOption(Option parentOption, Option subOption, Map<String, Option> lookupTable) {
        parentOption.addSubOption(subOption);
        this.addOption2LookupTable(subOption, lookupTable);
    }

    public void setPackagingOptionCert(String optionPath, String certAlias) throws OptionNotFoundException, PackageIdNotFoundException {
        Option opt = this.getOrCreatePackagingOption(optionPath);
        this.deletePackagingOptionCert(optionPath);
        if (StringUtils.isNotBlank((CharSequence)certAlias) && !"default".equals(certAlias)) {
            Option certAliasOption = new Option("certificateAlias", certAlias, "string");
            this.addSubOption(opt, certAliasOption, this._packagingOptionLookup);
        }
        this._packagingDirty = true;
    }

    public String getPipelineOptionCertAlias(String optionPath) throws OptionNotFoundException {
        Option opt = this.getPipelineOption(optionPath);
        return this.getOptionCertAlias(opt);
    }

    public String getPackagingOptionCertAlias(String optionPath) throws OptionNotFoundException {
        Option opt = this.getPackagingOption(optionPath);
        return this.getOptionCertAlias(opt);
    }

    public String getOptionCertAlias(Option opt) {
        List<Option> certOptions = opt.getSubOptions(null, "certificateAlias");
        if (!certOptions.isEmpty()) {
            return certOptions.getFirst().getValue();
        }
        return null;
    }

    public X509Certificate getProcessingEncryptionCertificate() throws ProfileException, CertificateException {
        CppPartner receiver = this.profiles.getProfileForLocalId(this.getReceiver().getId(), true);
        try {
            X509Certificate certificate;
            String optionPath = "/Encryption";
            String certificateAlias = this.getPipelineOptionCertAlias("/Encryption");
            if (certificateAlias != null && !"default".equals(certificateAlias) && (certificate = this.getProcessingEncryptionCertificateFromAgreement(receiver, "/Encryption", certificateAlias)) == null) {
                throw new CertificateException(NO_VALID_CERTIFICATE_FOR_PARTNER.formatted(this.getReceiverLocalId()));
            }
        }
        catch (OptionNotFoundException optionPath) {
            // empty catch block
        }
        X509Certificate certificate = this.partnerCertificateManager.getPipelineCertificate(receiver, this.getPipelineId());
        if (certificate == null) {
            throw new CertificateException(NO_VALID_CERTIFICATE_FOR_PARTNER.formatted(this.getReceiverLocalId()));
        }
        return certificate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    X509Certificate getProcessingEncryptionCertificateFromAgreement(CppPartner receiver, String optionPath, String certificateAlias) throws CertificateException, PipelineIdNotFoundException, OptionNotFoundException, CertificateIdNotFoundException {
        X509Certificate certificate = receiver.getX509Certificate(certificateAlias);
        try {
            this.validateCertificate(certificate);
        }
        catch (CertificateException certEx) {
            this.processingEncryptCertLock.lock();
            try {
                String newCertificateAlias = this.getPipelineOptionCertAlias(optionPath);
                if (certificateAlias.equals(newCertificateAlias)) {
                    X509Certificate x509Certificate = this.certificateChooser.getNextMatchingCertificate(this.certificateFilters, COMMON_SORT_CRITERIA, certificate, receiver.getAllValidCertificates());
                    if (x509Certificate == null) {
                        _log.warn("No next matching encryption certificate found for processing in agreement with sender '" + this.getSenderLocalId() + "' and receiver '" + this.getReceiverLocalId() + "'.");
                        throw certEx;
                    }
                    newCertificateAlias = receiver.getCertificateId(x509Certificate);
                    if (!certificateAlias.equals(newCertificateAlias)) {
                        this.setPipelineOptionCert(optionPath, newCertificateAlias);
                        try {
                            Agreement agreement = this.agreements.getAgreement(this.getAgreement().getId(), false);
                            agreement.getCommunication(this.getSenderLocalId(), this.getReceiverLocalId()).setPipelineOptionCert(optionPath, newCertificateAlias);
                            agreement.save();
                            _log.info(this.certificateUtility.toUsingInfoText(x509Certificate, "Changed encryption certificate for processing in agreement with sender '" + this.getSenderLocalId() + "' and receiver '" + this.getReceiverLocalId() + "' to"));
                        }
                        catch (AgreementException e1) {
                            _log.error("Could not update agreement with sender '" + this.getSenderLocalId() + "' and receiver '" + this.getReceiverLocalId() + "'.", (Throwable)e1);
                        }
                    }
                }
                certificate = receiver.getX509Certificate(newCertificateAlias);
            }
            finally {
                this.processingEncryptCertLock.unlock();
            }
        }
        return certificate;
    }

    public SignCertInfo getProcessingSignKey() throws ProfileException, CertificateException {
        CppPartner sender = this.profiles.getProfileForLocalId(this.getSender().getId(), true);
        try {
            SignCertInfo signCertInfo;
            String optionPath = "/sign";
            String certificateAlias = this.getPipelineOptionCertAlias("/sign");
            if (certificateAlias != null && !"default".equals(certificateAlias) && (signCertInfo = this.getProcessingSignKeyForAgreement(sender, "/sign", certificateAlias)) == null) {
                throw new CertificateException(NO_VALID_CERTIFICATE_FOR_PARTNER.formatted(sender.getLocalId()));
            }
        }
        catch (OptionNotFoundException optionPath) {
            // empty catch block
        }
        SignCertInfo signCertInfo = this.partnerCertificateManager.getPipelineSignKey(sender, this.getPipelineId());
        if (signCertInfo == null) {
            throw new CertificateException(NO_VALID_CERTIFICATE_FOR_PARTNER.formatted(sender.getLocalId()));
        }
        return signCertInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SignCertInfo getProcessingSignKeyForAgreement(CppPartner sender, String optionPath, String certificateAlias) throws ProfileException, CertificateException {
        SignCertInfo signCertInfo = sender.getPrivateKey(certificateAlias);
        X509Certificate currentCertificate = signCertInfo.getCertificateChain()[0];
        try {
            this.validateCertificate(currentCertificate);
        }
        catch (CertificateException e) {
            this.processingSignCertLock.lock();
            try {
                String newCertificateAlias = this.getPipelineOptionCertAlias(optionPath);
                if (certificateAlias.equals(newCertificateAlias)) {
                    X509Certificate x509Certificate = this.certificateChooser.getNextMatchingCertificate(this.certificateFilters, COMMON_SORT_CRITERIA, currentCertificate, sender.getAllValidCertificates());
                    if (x509Certificate == null) {
                        _log.warn("No next matching signing certificate found for processing in agreement with sender: " + this.getSenderLocalId() + " and receiver: " + this.getReceiverLocalId() + ".");
                        throw e;
                    }
                    newCertificateAlias = sender.getCertificateId(x509Certificate);
                    if (!certificateAlias.equals(newCertificateAlias)) {
                        this.setPipelineOptionCert(optionPath, newCertificateAlias);
                        try {
                            Agreement agreement = this.agreements.getAgreement(this.getAgreement().getId(), false);
                            agreement.getCommunication(this.getSenderLocalId(), this.getReceiverLocalId()).setPipelineOptionCert(optionPath, newCertificateAlias);
                            agreement.save();
                            _log.info(this.certificateUtility.toUsingInfoText(x509Certificate, "Changed signing certificate for processing in agreement with sender: " + this.getSenderLocalId() + " and receiver: " + this.getReceiverLocalId() + "to "));
                        }
                        catch (AgreementException e1) {
                            _log.error("Could not update agreement with sender: " + this.getSenderLocalId() + " and receiver: " + this.getReceiverLocalId() + ".", (Throwable)e1);
                        }
                    }
                }
                signCertInfo = sender.getPrivateKey(newCertificateAlias);
            }
            finally {
                this.processingSignCertLock.unlock();
            }
        }
        return signCertInfo;
    }

    public X509Certificate getPackagingEncryptionCertificate() throws PackagingException, ActivationException, ProfileException, CertificateException {
        CppPartner receiver = this.profiles.getProfileForLocalId(this.getReceiver().getId(), true);
        try {
            BasePackager packager = this.getPackager();
            String optionPath = packager.getPackagingEncryptionPath();
            String certificateAlias = this.getPackagingOptionCertAlias(optionPath);
            if (certificateAlias != null && !"default".equals(certificateAlias)) {
                X509Certificate certificate = this.getPackagingEncryptionCertificateForAgreement(receiver, optionPath, certificateAlias);
                if (certificate == null) {
                    throw new CertificateException(NO_VALID_CERTIFICATE_FOR_PARTNER.formatted(this.getReceiverLocalId()));
                }
                return certificate;
            }
        }
        catch (OptionNotFoundException packager) {
            // empty catch block
        }
        X509Certificate certificate = this.partnerCertificateManager.getPackagingCertificate(receiver, this.getPackagingId());
        if (certificate == null) {
            throw new CertificateException(NO_VALID_CERTIFICATE_FOR_PARTNER.formatted(this.getReceiverLocalId()));
        }
        return certificate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    X509Certificate getPackagingEncryptionCertificateForAgreement(CppPartner receiver, String optionPath, String certificateAlias) throws OptionNotFoundException, CertificateException, PackageIdNotFoundException, CertificateIdNotFoundException {
        X509Certificate certificate = receiver.getX509Certificate(certificateAlias);
        try {
            this.validateCertificate(certificate);
        }
        catch (CertificateException e) {
            this.packagingEncryptCertLock.lock();
            try {
                String newCertificateAlias = this.getPackagingOptionCertAlias(optionPath);
                if (certificateAlias.equals(newCertificateAlias)) {
                    X509Certificate x509Certificate;
                    if ("AS1".equals(this.getPackagingId())) {
                        this.certificateFilters.add(new EmailCertificateFilter(receiver.getPartyIdValue("E-Mail"), this.certificateInfo, this.certificateUtility));
                    }
                    if ((x509Certificate = this.certificateChooser.getNextMatchingCertificate(this.certificateFilters, COMMON_SORT_CRITERIA, certificate, receiver.getAllValidCertificates())) == null) {
                        _log.warn("No next matching encryption certificate found for packaging in agreement with sender: " + this.getSenderLocalId() + " and receiver: " + this.getReceiverLocalId() + ".");
                        throw e;
                    }
                    newCertificateAlias = receiver.getCertificateId(x509Certificate);
                    if (!certificateAlias.equals(newCertificateAlias)) {
                        this.setPackagingOptionCert(optionPath, newCertificateAlias);
                        try {
                            Agreement agreement = this.agreements.getAgreement(this.getAgreement().getId(), false);
                            agreement.getCommunication(this.getSenderLocalId(), this.getReceiverLocalId()).setPackagingOptionCert(optionPath, newCertificateAlias);
                            agreement.save();
                            _log.info(this.certificateUtility.toUsingInfoText(x509Certificate, "Changed encryption certificate for packaging in agreement with sender: " + this.getSenderLocalId() + " and receiver: " + this.getReceiverLocalId() + "to "));
                        }
                        catch (AgreementException e1) {
                            _log.error("Could not update agreement with sender: " + this.getSenderLocalId() + " and receiver: " + this.getReceiverLocalId() + ".", (Throwable)e1);
                        }
                    }
                }
                certificate = receiver.getX509Certificate(newCertificateAlias);
            }
            finally {
                this.packagingEncryptCertLock.unlock();
            }
        }
        return certificate;
    }

    BasePackager getPackager() throws PackagingException, ActivationException {
        return this._agreement.getPackager(this.getPackagingId());
    }

    public SignCertInfo getPackagingSignKey() throws PackagingException, ActivationException, ProfileException, CertificateException {
        CppPartner sender = this.profiles.getProfileForLocalId(this.getSender().getId(), true);
        BasePackager packager = this.getPackager();
        String optionPath = packager.getPackagingSignPath();
        return this.getPackagingSignKey(optionPath, sender);
    }

    public SignCertInfo getClientAuthenticationKey() throws ActivationException, CertificateException, ProfileException, PackagingException {
        SignCertInfo packagingSignKey = this.getPackagingSignKey();
        X509Certificate clientCertificate = packagingSignKey.getCertificateChain()[0];
        List<String> extendedKeyUsage = clientCertificate.getExtendedKeyUsage();
        if (!(clientCertificate.getKeyUsage() == null || extendedKeyUsage != null && extendedKeyUsage.contains(KeyPurposeId.id_kp_clientAuth.getId()))) {
            _log.debug("The signing certificate has defined (extended) key usage without SSL/TLS WWW Client Authentication. Trying to get partner packaging/default certificate.");
            CppPartner sender = this.profiles.getProfileForLocalId(this.getSender().getId(), true);
            SignCertInfo partnerCertificate = this.partnerCertificateManager.getPackagingSignKey(sender, this.getPackagingId());
            if (partnerCertificate == null) {
                throw new CertificateException(NO_VALID_CERTIFICATE_FOR_PARTNER.formatted(this.getSender().getId()));
            }
            _log.debug("Found TLS client certificate with certificate id " + sender.getCertificateId(partnerCertificate.getCertificateChain()[0]));
            return partnerCertificate;
        }
        return packagingSignKey;
    }

    public SignCertInfo getPackagingAckSignKey() throws PackagingException, ActivationException, ProfileException, CertificateException {
        CppPartner ackSender = this.profiles.getProfileForLocalId(this.getReceiver().getId(), true);
        BasePackager packager = this.getPackager();
        String optionPath = packager.getPackagingAckSignPath();
        return this.getPackagingSignKey(optionPath, ackSender);
    }

    private SignCertInfo getPackagingSignKey(String optionPath, CppPartner sender) throws ProfileException, CertificateException {
        SignCertInfo signCertInfo;
        if (optionPath != null) {
            try {
                String certificateAlias = this.getPackagingOptionCertAlias(optionPath);
                if (certificateAlias != null && !"default".equals(certificateAlias)) {
                    SignCertInfo signCertInfo2 = this.getPackagingSignKeyFromAgreement(sender, optionPath, certificateAlias);
                    if (signCertInfo2 == null) {
                        throw new CertificateException(NO_VALID_CERTIFICATE_FOR_PARTNER.formatted(sender.getLocalId()));
                    }
                    return signCertInfo2;
                }
            }
            catch (OptionNotFoundException certificateAlias) {
                // empty catch block
            }
        }
        if ((signCertInfo = this.partnerCertificateManager.getPackagingSignKey(sender, this.getPackagingId())) == null) {
            throw new CertificateException(NO_VALID_CERTIFICATE_FOR_PARTNER.formatted(sender.getLocalId()));
        }
        return signCertInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SignCertInfo getPackagingSignKeyFromAgreement(CppPartner sender, String optionPath, String certificateAlias) throws ProfileException, CertificateException {
        SignCertInfo signCertInfo = sender.getPrivateKey(certificateAlias);
        X509Certificate currentCertificate = signCertInfo.getCertificateChain()[0];
        try {
            this.validateCertificate(currentCertificate);
        }
        catch (CertificateException e) {
            this.packagingSignCertLock.lock();
            try {
                String newCertificateAlias = this.getPackagingOptionCertAlias(optionPath);
                if (certificateAlias.equals(newCertificateAlias)) {
                    X509Certificate x509Certificate;
                    if ("AS1".equals(this.getPackagingId())) {
                        this.certificateFilters.add(new EmailCertificateFilter(sender.getPartyIdValue("E-Mail"), this.certificateInfo, this.certificateUtility));
                    }
                    if ((x509Certificate = this.certificateChooser.getNextMatchingCertificate(this.certificateFilters, COMMON_SORT_CRITERIA, currentCertificate, sender.getAllValidCertificates())) == null) {
                        _log.warn("No next matching signing certificate found for packaging agreement with sender '" + this.getSenderLocalId() + "' and receiver '" + this.getReceiverLocalId() + "'.");
                        throw e;
                    }
                    newCertificateAlias = sender.getCertificateId(x509Certificate);
                    if (!certificateAlias.equals(newCertificateAlias)) {
                        this.setPackagingOptionCert(optionPath, newCertificateAlias);
                        try {
                            Agreement agreement = this.agreements.getAgreement(this.getAgreement().getId(), false);
                            agreement.getCommunication(this.getSenderLocalId(), this.getReceiverLocalId()).setPackagingOptionCert(optionPath, newCertificateAlias);
                            agreement.save();
                            _log.info(this.certificateUtility.toUsingInfoText(x509Certificate, "Changed signing certificate for packaging in agreement with sender: " + this.getSenderLocalId() + " and receiver: " + this.getReceiverLocalId() + "to "));
                        }
                        catch (AgreementException e1) {
                            _log.error("Could not update agreement with sender '" + this.getSenderLocalId() + "' and receiver '" + this.getReceiverLocalId() + "'.", (Throwable)e1);
                        }
                    }
                }
                signCertInfo = sender.getPrivateKey(newCertificateAlias);
            }
            finally {
                this.packagingSignCertLock.unlock();
            }
        }
        return signCertInfo;
    }

    private void validateCertificate(X509Certificate certificate) throws CertificateException {
        Date date = new Date(this.referenceDateTask.getReferenceDate().toInstant().plus((long)Integer.parseInt(this.messengerConfig.getProperty("ponton.messenger.certificate.switch.days_before_expiry")), ChronoUnit.DAYS).toEpochMilli());
        try {
            certificate.checkValidity(date);
        }
        catch (CertificateException e) {
            throw new CertificateException(this.certificateUtility.toUsingInfoText(certificate, e.getMessage()), e);
        }
    }

    public void deletePipelineOptionCert(String optionPath) throws OptionNotFoundException {
        Option opt = this.getPipelineOption(optionPath);
        opt.deleteSubOption("base64", "certificate");
        opt.deleteSubOption("string", "certificateAlias");
        this._pipelineDirty = true;
    }

    public void deletePackagingOptionCert(String optionPath) throws OptionNotFoundException {
        Option opt = this.getPackagingOption(optionPath);
        opt.deleteSubOption("base64", "certificate");
        opt.deleteSubOption("string", "certificateAlias");
        this._packagingDirty = true;
    }

    public void deletePipelineOption(String optionPath) throws OptionNotFoundException {
        Option[] subOptions;
        Option opt = this.getPipelineOption(optionPath);
        for (Option subOption : subOptions = opt.getSubOptions()) {
            this.deletePipelineOption(subOption.getPath());
        }
        Option parentOpt = this.getPipelineOption(opt.getParentPath());
        parentOpt.deleteSubOption(opt);
        this._pipelineOptionLookup.remove(this.getFirstOptionPath() + optionPath);
        this._pipelineDirty = true;
    }

    public void deletePackagingOption(String optionPath) throws OptionNotFoundException {
        Option[] subOptions;
        Option opt = this.getPackagingOption(optionPath);
        for (Option subOption : subOptions = opt.getSubOptions()) {
            this.deletePackagingOption(subOption.getPath());
        }
        Option parentOpt = this.getPackagingOption(opt.getParentPath());
        parentOpt.deleteSubOption(opt);
        this._packagingOptionLookup.remove(this.getFirstOptionPath() + optionPath);
        this._packagingDirty = true;
    }

    private Option createOptionPath(String optionPath, IdNotFoundException exception, Map<String, Option> optionLookup) throws IdNotFoundException {
        Option lastOption;
        String lastOptionPath = this.getFirstOptionPath() + optionPath;
        int offset = lastOptionPath.length();
        do {
            if ((offset = lastOptionPath.lastIndexOf("/", offset)) <= 0) {
                throw exception;
            }
            String parentOption = lastOptionPath.substring(0, offset);
            lastOption = optionLookup.get(parentOption);
            --offset;
        } while (lastOption == null);
        ++offset;
        ++offset;
        while (offset != 0) {
            Object newOptionLookupId;
            String newOptionName;
            int newOffset = lastOptionPath.indexOf("/", offset);
            if (newOffset != -1) {
                newOptionName = lastOptionPath.substring(offset, newOffset);
                newOptionLookupId = lastOptionPath.substring(0, newOffset);
            } else {
                newOptionName = lastOptionPath.substring(offset);
                newOptionLookupId = lastOptionPath;
            }
            Option[] oldOptions = lastOption.getSubOptions();
            ArrayList<Option> oldOptionsA = new ArrayList<Option>();
            Collections.addAll(oldOptionsA, oldOptions);
            Option newOption = new Option(newOptionName, null, null);
            oldOptionsA.add(newOption);
            Option[] newOptions = oldOptionsA.toArray(new Option[0]);
            lastOption.setSubOptions(newOptions);
            optionLookup.put((String)newOptionLookupId, newOption);
            lastOption = newOption;
            offset = newOffset + 1;
        }
        return lastOption;
    }

    public String getPipelineId() {
        return this._communication.getPipeline().getId();
    }

    public void setPipelineId(String pipelineId) {
        this._communication.getPipeline().setId(pipelineId);
    }

    public String getTransportId() {
        return this._communication.getTransport().getId();
    }

    public void setTransportId(String transportId) {
        this._communication.getTransport().setId(transportId);
    }

    public int getNumberOfRetries() {
        return this._communication.getTransport().getNumberOfRetries();
    }

    public void setNumberOfRetries(int numberOfRetries) {
        this._communication.getTransport().setNumberOfRetries(numberOfRetries);
    }

    public List<Integer> getRetryIntervals() {
        return new ArrayList<Integer>(this._communication.getTransport().getRetryInterval());
    }

    public void setRetryIntervals(List<Integer> retryIntervals) {
        List jaxbRetryIntervals = this._communication.getTransport().getRetryInterval();
        jaxbRetryIntervals.clear();
        jaxbRetryIntervals.addAll(retryIntervals);
    }

    public String getPackagingId() {
        return this._communication.getPackaging().getId();
    }

    public void setPackagingId(String packagingId) {
        this._communication.getPackaging().setId(packagingId);
    }

    public void setContentRules(List<RuleType> rules) {
        this._contentRules = rules;
    }

    public void setContentRules(RuleData[] allRules) {
        this._contentRules.clear();
        for (RuleData allRule : allRules) {
            this.addContentRule(allRule);
        }
    }

    public void addContentRule(RuleData newRule) {
        RuleType rule = _privateFactory.createRuleType();
        this.setRule(newRule, rule);
        this._contentRules.add(rule);
    }

    private void setRule(RuleData ruleData, RuleType rule) {
        if (ruleData != null && rule != null) {
            RuleType.Trigger trigger = _privateFactory.createRuleTypeTrigger();
            rule.setId(Integer.valueOf(ruleData.getId()));
            if (ruleData.getActionType() != null && !"EMailNotification".equals(ruleData.getActionType())) {
                RuleType.Action action = _privateFactory.createRuleTypeAction();
                action.setType(ruleData.getActionType());
                action.setValue(ruleData.getActionValue() == null ? "" : ruleData.getActionValue());
                rule.setAction(action);
            } else if (ruleData.getEmail() != null || "EMailNotification".equals(ruleData.getActionType())) {
                RuleType.EmailNotification notification = _privateFactory.createRuleTypeEmailNotification();
                notification.setEmail(ruleData.getEmail() == null ? "" : ruleData.getEmail());
                notification.setWithAttachment(Boolean.valueOf(ruleData.getWithAttachment()));
                notification.getSubjectElement().clear();
                ArrayList<NotificationSubjectElementType> nse = new ArrayList<NotificationSubjectElementType>();
                if (ruleData.getSubjectElements() != null) {
                    for (SubjectElement se : ruleData.getSubjectElements()) {
                        NotificationSubjectElementType nset = _privateFactory.createNotificationSubjectElementType();
                        if (1 == se.getType()) {
                            if (se.getVariable() != null && !se.getVariable().isEmpty()) {
                                nset.setVariable(se.getVariable());
                            } else {
                                nset.setVariable(MessengerConfig.DEFAULT_SUBJECT_ELEMENT_VARIABLE);
                            }
                        } else if (2 == se.getType()) {
                            if (se.getXpath() != null && !se.getXpath().isEmpty()) {
                                nset.setXPath(se.getXpath());
                            } else if (se.getText() != null && !se.getText().isEmpty()) {
                                nset.setXPath(se.getText());
                            } else {
                                nset.setXPath("");
                            }
                        } else if (se.getText() != null && !se.getText().isEmpty()) {
                            nset.setText(se.getText());
                        } else if (se.getXpath() != null && !se.getXpath().isEmpty()) {
                            nset.setText(se.getXpath());
                        } else {
                            nset.setText("");
                        }
                        nse.add(nset);
                    }
                    notification.getSubjectElement().addAll(nse);
                }
                rule.setEmailNotification(notification);
            }
            trigger.setOperator(ruleData.getOperator());
            trigger.setValue(ruleData.getXpathValue());
            trigger.setXPath(ruleData.getXpath());
            rule.setTrigger(trigger);
        }
    }

    public RuleData[] getContentRules() {
        ArrayList<RuleData> newList = new ArrayList<RuleData>();
        for (RuleType rule : this._contentRules) {
            RuleData newRule = new RuleData(rule.getId());
            RuleType.Action action = rule.getAction();
            RuleType.EmailNotification notification = rule.getEmailNotification();
            if (action != null && notification == null) {
                newRule.setActionType(action.getType());
                newRule.setActionValue(action.getValue());
            } else if (action == null && notification != null) {
                newRule.setActionType("EMailNotification");
                newRule.setEmail(notification.getEmail());
                newRule.setWithAttachment(notification.isWithAttachment());
                ArrayList<SubjectElement> nse = new ArrayList<SubjectElement>();
                for (NotificationSubjectElementType nset : notification.getSubjectElement()) {
                    if (nset.getVariable() != null) {
                        nse.add(new SubjectElement(1, nset.getVariable()));
                        continue;
                    }
                    if (nset.getXPath() != null) {
                        nse.add(new SubjectElement(2, nset.getXPath()));
                        continue;
                    }
                    if (nset.getText() == null) continue;
                    nse.add(new SubjectElement(3, nset.getText()));
                }
                newRule.setSubjectElements(nse);
            } else {
                newRule.setActionType("Flag");
            }
            newRule.setOperator(rule.getTrigger().getOperator());
            newRule.setXpathValue(rule.getTrigger().getValue());
            newRule.setXpath(rule.getTrigger().getXPath());
            newList.add(newRule);
        }
        return newList.toArray(new RuleData[0]);
    }

    public Agreement getAgreement() {
        return this._agreement;
    }

    public String getXmlEncoding() {
        return this._agreement.getXmlEncoding(this.getSenderLocalId(), this.getReceiverLocalId());
    }

    public String getLineEnding() {
        return this._agreement.getLineEnding(this.getSenderLocalId(), this.getReceiverLocalId());
    }

    public boolean getPrettyPrint() {
        return this._agreement.getPrettyPrint(this.getSenderLocalId(), this.getReceiverLocalId());
    }

    public boolean getUpdatePapinet1Envelope() {
        return this._agreement.getUpdatePapinet1Envelope(this.getSenderLocalId(), this.getReceiverLocalId());
    }

    public String getDoctypeAction() {
        return this._agreement.getDoctypeAction(this.getSenderLocalId(), this.getReceiverLocalId());
    }

    public boolean getXmlModificationEnabled() {
        return this._agreement.getXmlModificationEnabled(this.getSenderLocalId(), this.getReceiverLocalId());
    }

    public void setXmlEncoding(String xmlEncoding) {
        this._agreement.setXmlEncoding(xmlEncoding, this.getSenderLocalId(), this.getReceiverLocalId());
    }

    public void setLineEnding(String lineEnding) {
        this._agreement.setLineEnding(lineEnding, this.getSenderLocalId(), this.getReceiverLocalId());
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this._agreement.setPrettyPrint(prettyPrint, this.getSenderLocalId(), this.getReceiverLocalId());
    }

    public void setUpdatePapinet1Envelope(boolean updatePapinet1Envelope) {
        this._agreement.setUpdatePapinet1Envelope(updatePapinet1Envelope, this.getSenderLocalId(), this.getReceiverLocalId());
    }

    public void setDoctypeAction(String doctypeAction) {
        this._agreement.setDoctypeAction(doctypeAction, this.getSenderLocalId(), this.getReceiverLocalId());
    }

    public void setXmlModificationEnabled(boolean enabled) {
        this._agreement.setXmlModificationEnabled(enabled, this.getSenderLocalId(), this.getReceiverLocalId());
    }

    public String getWorkingTransportURL() throws TransportException {
        if (this.transportURLValid && this.getTransportURL() != null) {
            return this.getTransportURL();
        }
        if (this.fallbackTransportURLValid && this.getTransportFallbackURL() != null) {
            return this.getTransportFallbackURL();
        }
        _log.debug("Both TransportURL and FallbackTransportURL are not valid");
        throw new TransportException(-1, "Both TransportURL and FallbackTransportURL are not valid");
    }

    public void setTransportURLValid(boolean valid) {
        this.transportURLValid = valid;
        this._agreement.getAgreements().saveUrlIsValid(this._agreement.getId(), valid);
    }

    public boolean isTransportURLValid() {
        return this.transportURLValid;
    }

    public void setFallbackTransportURLValid(boolean valid) {
        this.fallbackTransportURLValid = valid;
        this._agreement.getAgreements().saveFallbackUrlIsValid(this._agreement.getId(), valid);
    }

    public boolean isFallbackTransportURLValid() {
        return this.fallbackTransportURLValid;
    }

    public void initUrlValidity(boolean transportURLValid, boolean fallbackTransportURLValid) {
        this.transportURLValid = transportURLValid;
        this.fallbackTransportURLValid = fallbackTransportURLValid;
        _log.trace("initUrlValidity ({} / {}) on agreement {}", (Object)transportURLValid, (Object)fallbackTransportURLValid, (Object)this._agreement.getId());
    }

    public void setURLValid(String url, boolean valid) {
        if (Objects.isNull(url)) {
            return;
        }
        if (url.equals(this.getTransportURL())) {
            this.setTransportURLValid(valid);
        } else if (url.equals(this.getTransportFallbackURL())) {
            this.setFallbackTransportURLValid(valid);
        }
    }
}

