/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.config;

import de.pontonconsulting.xmlpipe.config.IServerConfigBean;
import de.pontonconsulting.xmlpipe.config.SSLKeystoreBean;
import de.pontonconsulting.xmlpipe.config.ServerSettings;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.net.ssl.SSLContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.http2.HTTP2Cipher;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class SslContextFactoryInitializer {
    private final Log log = LogFactory.getFactory().getInstance("Messenger." + this.getClass().getSimpleName());
    private final IServerConfigBean config;
    private final SSLKeystoreBean sslKeystoreBean;

    public SslContextFactoryInitializer(IServerConfigBean config, SSLKeystoreBean sslKeystoreBean) {
        this.config = config;
        this.sslKeystoreBean = sslKeystoreBean;
    }

    public SslContextFactory.Server configureSslContextFactory(boolean wantClientAuth) throws Exception {
        for (ServerSettings connector : this.config.getConnectors().values()) {
            if (!connector.isSsl()) continue;
            KeyStore keystore = this.sslKeystoreBean.getSslCertificateKeystore();
            if (keystore == null) {
                this.log.error((Object)("Unable to start the listener on '" + connector.getAddress() + ":" + connector.getPort() + "'. keystore-ssl is not found."));
                continue;
            }
            boolean hasKey = false;
            Enumeration<String> aliases = keystore.aliases();
            while (aliases.hasMoreElements()) {
                if (!keystore.isKeyEntry(aliases.nextElement())) continue;
                hasKey = true;
                break;
            }
            if (!hasKey) {
                this.log.error((Object)("Unable to start the listener on '" + connector.getAddress() + ":" + connector.getPort() + "'. keystore-ssl doesn't include any keys."));
                continue;
            }
            SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
            sslContextFactory.setKeyStore(keystore);
            sslContextFactory.setKeyManagerPassword(connector.getSslKeyPassword());
            sslContextFactory.setKeyStorePassword("changeit");
            sslContextFactory.setTrustStorePassword("changeit");
            sslContextFactory.setTrustStore(this.sslKeystoreBean.getSslTrustCertificateKeystore());
            sslContextFactory.setSniRequired(false);
            sslContextFactory.setRenegotiationAllowed(false);
            sslContextFactory.setCipherComparator(HTTP2Cipher.COMPARATOR);
            this.initProtocols((SslContextFactory)sslContextFactory, connector);
            this.initCiphers((SslContextFactory)sslContextFactory, connector);
            sslContextFactory.setNeedClientAuth(false);
            sslContextFactory.setWantClientAuth(wantClientAuth);
            if (System.getProperty("java.vendor").toLowerCase().startsWith("ibm")) {
                sslContextFactory.setKeyManagerFactoryAlgorithm("IbmX509");
                sslContextFactory.setTrustManagerFactoryAlgorithm("IbmX509");
            }
            return sslContextFactory;
        }
        return new SslContextFactory.Server();
    }

    private void initProtocols(SslContextFactory factory, ServerSettings connector) throws NoSuchAlgorithmException, NoSuchProviderException, KeyManagementException {
        SSLContext sslContext = SSLContext.getInstance("TLS", "BCJSSE");
        sslContext.init(null, null, new SecureRandom());
        String[] allProtocols = sslContext.createSSLEngine().getSupportedProtocols();
        String[] disabledProtocols = connector.getExcludedProtocols();
        ArrayList<String> includedProtocols = new ArrayList<String>();
        ArrayList<String> excludedProtocols = new ArrayList<String>();
        for (String allProtocol : allProtocols) {
            boolean exclude = false;
            for (String disabledProtocol : disabledProtocols) {
                if (!allProtocol.matches(disabledProtocol)) continue;
                exclude = true;
                break;
            }
            if (exclude) {
                excludedProtocols.add(allProtocol);
                continue;
            }
            includedProtocols.add(allProtocol);
        }
        this.log.info((Object)"Included SSL Protocols:");
        factory.setIncludeProtocols(includedProtocols.toArray(new String[0]));
        Collections.sort(includedProtocols);
        for (String included : includedProtocols) {
            this.log.info((Object)("  " + included));
        }
        this.log.info((Object)"Excluded SSL Protocols:");
        factory.setExcludeProtocols(excludedProtocols.toArray(new String[0]));
        Collections.sort(excludedProtocols);
        for (String excluded : excludedProtocols) {
            this.log.info((Object)("  " + excluded));
        }
    }

    private void initCiphers(SslContextFactory factory, ServerSettings connector) throws NoSuchAlgorithmException, NoSuchProviderException, KeyManagementException {
        SSLContext sslContext = SSLContext.getInstance("TLS", "BCJSSE");
        sslContext.init(null, null, new SecureRandom());
        String[] allCiphers = sslContext.createSSLEngine().getSupportedCipherSuites();
        String[] disabledCiphers = connector.getExcludedCiphers();
        ArrayList<String> includedCiphers = new ArrayList<String>();
        ArrayList<String> excludedCiphers = new ArrayList<String>();
        for (String allCipher : allCiphers) {
            boolean exclude = false;
            for (String disabledCipher : disabledCiphers) {
                if (!allCipher.matches(disabledCipher)) continue;
                exclude = true;
                break;
            }
            if (exclude) {
                excludedCiphers.add(allCipher);
                continue;
            }
            includedCiphers.add(allCipher);
        }
        this.log.info((Object)"Included SSL Ciphers:");
        factory.setIncludeCipherSuites(includedCiphers.toArray(new String[0]));
        Collections.sort(includedCiphers);
        for (String included : includedCiphers) {
            this.log.info((Object)("  " + included));
        }
        this.log.info((Object)"Excluded SSL Ciphers:");
        factory.setExcludeCipherSuites(excludedCiphers.toArray(new String[0]));
        Collections.sort(excludedCiphers);
        for (String excluded : excludedCiphers) {
            this.log.info((Object)("  " + excluded));
        }
    }
}

