/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.config;

import de.ponton.xmlpipe.rest.settings.server.Service;
import de.pontonconsulting.common.security.IPasswordCrypt;
import de.pontonconsulting.xmlpipe.config.IServerConfigBean;
import de.pontonconsulting.xmlpipe.config.ServerConfigBeanChangedEvent;
import de.pontonconsulting.xmlpipe.config.ServerSettings;
import de.pontonconsulting.xmlpipe.config.XpValidationEventHandler;
import de.pontonconsulting.xmlpipe.config.server.ClientAuthType;
import de.pontonconsulting.xmlpipe.config.server.LogLevel;
import de.pontonconsulting.xmlpipe.config.server.ObjectFactory;
import de.pontonconsulting.xmlpipe.config.server.Server;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.MessengerConfig;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerConfigDAO;
import jakarta.annotation.PostConstruct;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.ValidationEventHandler;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.util.encoders.Base64;
import org.eclipse.jetty.util.StringUtil;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

public class ServerConfigBean
implements IServerConfigBean {
    private static final Logger LOG = LogManager.getLogger((String)"Messenger.ServerConfigBean");
    private static final ObjectFactory OBJECT_FACTORY = new ObjectFactory();
    public static final String XP_CONFIG = "XP_CONFIG_FOLDER";
    public static final String PONTONXP_HOME = "PONTONXP_HOME";
    public static final String CLUSTER_HOME = "CLUSTER_HOME";
    private static final byte[] CRYPTED_PW_IDENTIFIER = "PXPPWC".getBytes();
    private static final String WEBROOT = "webroot";
    private File _addonsConfigsFolder;
    private File _configFile;
    private File _configFolder;
    private File _xpHome;
    private File _clusterHome;
    private final File _adaptersFolder;
    private long _timestampOflastChange;
    private Server _server;
    private final TreeMap<String, ServerSettings> _settings = new TreeMap();
    private final IPasswordCrypt _crypt;
    private int _listenerHttpPort;
    private int _listenerHttpsPort;
    private final ApplicationEventPublisher applicationEventPublisher;
    private final MessengerConfigDAO messengerConfigDAO;

    public ServerConfigBean(IPasswordCrypt crypt, ApplicationEventPublisher applicationEventPublisher, MessengerConfigDAO messengerConfigDAO) {
        String configFolderString;
        String clusterHomeString;
        this.applicationEventPublisher = applicationEventPublisher;
        this.messengerConfigDAO = messengerConfigDAO;
        File appFolder = new File("").getAbsoluteFile();
        this._addonsConfigsFolder = new File(appFolder, "addons/configs");
        this._adaptersFolder = new File(appFolder, "addons/adapters");
        this._crypt = crypt;
        String xpHomeString = System.getProperty(PONTONXP_HOME);
        if (xpHomeString == null || xpHomeString.length() == 0) {
            try {
                this._xpHome = new File(appFolder, "data").getCanonicalFile();
                System.setProperty(PONTONXP_HOME, this._xpHome.getCanonicalPath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this._xpHome = new File(xpHomeString);
        }
        if ((clusterHomeString = System.getProperty(CLUSTER_HOME)) == null || clusterHomeString.length() == 0) {
            try {
                this._clusterHome = this._xpHome;
                System.setProperty(CLUSTER_HOME, this._clusterHome.getCanonicalPath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this._clusterHome = new File(clusterHomeString);
        }
        if ((configFolderString = System.getProperty(XP_CONFIG)) != null) {
            File temp = new File(configFolderString);
            if (temp.exists()) {
                this._configFolder = temp;
            } else {
                System.err.println("Config folder " + temp.getAbsolutePath() + " does not exist.");
            }
        }
        if (this._configFolder == null) {
            this._configFolder = new File(appFolder, "config");
            System.setProperty(XP_CONFIG, this._configFolder.getAbsolutePath());
            LOG.info("Set config folder to {}.", (Object)this._configFolder.getAbsolutePath());
        }
    }

    @Override
    @PostConstruct
    public void init() throws IOException, JAXBException {
        File configFile = new File(this._configFolder, "server.xml");
        this.setConfigFile(configFile);
    }

    @Override
    public void setConfigFile(File configFile) throws JAXBException {
        this._configFile = configFile;
        this.loadConfigToMemory(true);
    }

    private void loadConfigToMemory(boolean forcedReload) throws JAXBException {
        if (this._configFile.exists() && !this.messengerConfigDAO.doesMessengerConfigExist("server.xml")) {
            try (BufferedInputStream inputStream = new BufferedInputStream(Files.newInputStream(this._configFile.toPath(), new OpenOption[0]));){
                this.messengerConfigDAO.storeMessengerConfig(inputStream.readAllBytes(), "server.xml", "SYSTEM");
            }
            catch (IOException e) {
                throw new JAXBException("Configuration file '" + String.valueOf(this._configFile) + "' could not be read: " + e.getMessage());
            }
            try {
                Files.delete(this._configFile.toPath());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (this._timestampOflastChange != this.messengerConfigDAO.getTimestampAsLongByConfigType("server.xml") || forcedReload) {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{OBJECT_FACTORY.getClass()});
            Unmarshaller u = jc.createUnmarshaller();
            XpValidationEventHandler validation = new XpValidationEventHandler();
            MessengerConfig messengerConfig = this.messengerConfigDAO.loadMessengerConfig("server.xml");
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(messengerConfig.getData());){
                u.setEventHandler((ValidationEventHandler)validation);
                this._server = (Server)u.unmarshal((InputStream)inputStream);
                this._timestampOflastChange = messengerConfig.getTimestamp().toInstant().toEpochMilli();
            }
            catch (JAXBException jaxb) {
                if (validation.getMessage() != null) {
                    jaxb = new JAXBException("Xml Error (Line:" + validation.getLine() + " / Column:" + validation.getColumn() + ") " + validation.getMessage());
                }
                throw jaxb;
            }
            catch (IOException e) {
                throw new JAXBException(e.getMessage(), (Throwable)e);
            }
            boolean saveNeeded = false;
            this._listenerHttpPort = -1;
            this._listenerHttpsPort = -1;
            for (Server.Connector connector : this._server.getConnector()) {
                ServerSettings settings = new ServerSettings();
                settings.setId(connector.getId());
                settings.setAddress(connector.getAddress());
                settings.setPort(connector.getPort());
                settings.setMinThreads(connector.getMinThreads());
                settings.setMaxThreads(connector.getMaxThreads());
                settings.setLowResources(connector.getLowResources());
                settings.setLowResourcePersistTimeMs(connector.getLowResourcePersistTime());
                settings.setMaxIdleTimeMs(connector.getMaxIdleTime());
                Server.Connector.SSL ssl = connector.getSSL();
                if (ssl != null) {
                    settings.setSsl(true);
                    ClientAuthType authType = ssl.getClientAuthentication();
                    settings.setNeedClientCert(ClientAuthType.NEED.equals((Object)authType));
                    settings.setWantClientCert(ClientAuthType.WANT.equals((Object)authType));
                    settings.setSslKeystore(ssl.getKeystore());
                    settings.setTrustKeystore(ssl.getClientAuthKeystore());
                    try {
                        String authPassword = ssl.getClientAuthKeystorePassword();
                        try {
                            authPassword = this.decryptPassword(authPassword);
                        }
                        catch (IllegalArgumentException e) {
                            String newCrypted = this.encryptPassword(authPassword);
                            ssl.setClientAuthKeystorePassword(newCrypted);
                            saveNeeded = true;
                        }
                        settings.setTrustPassword(authPassword);
                        String sslPassword = ssl.getKeystorePassword();
                        try {
                            sslPassword = this.decryptPassword(sslPassword);
                        }
                        catch (IllegalArgumentException e) {
                            String newCrypted = this.encryptPassword(sslPassword);
                            ssl.setKeystorePassword(newCrypted);
                            saveNeeded = true;
                        }
                        settings.setSslPassword(sslPassword);
                        String sslKeyPassword = ssl.getKeyPassword();
                        try {
                            sslKeyPassword = this.decryptPassword(sslKeyPassword);
                        }
                        catch (IllegalArgumentException e) {
                            String newCrypted = this.encryptPassword(sslKeyPassword);
                            ssl.setKeyPassword(newCrypted);
                            saveNeeded = true;
                        }
                        settings.setSslKeyPassword(sslKeyPassword);
                    }
                    catch (GeneralSecurityException e) {
                        e.printStackTrace();
                    }
                    String[] excludedProtocols = this.getRegExValues(ssl.getExcludedProtocols(), "SSL*");
                    settings.setExcludedProtocols(excludedProtocols);
                    String[] excludedCiphers = this.getRegExValues(ssl.getExcludedCiphers(), "*EXPORT*,*anon*,*DES*,*_DH*,*NULL*,*SHA");
                    settings.setExcludedCiphers(excludedCiphers);
                }
                for (String serviceString : connector.getService()) {
                    settings.addService(serviceString);
                    if (!"LISTENERS".equals(serviceString)) continue;
                    if (this._listenerHttpPort == -1 && !settings.isSsl()) {
                        this._listenerHttpPort = settings.getPort();
                        continue;
                    }
                    if (this._listenerHttpsPort != -1 || !settings.isSsl()) continue;
                    this._listenerHttpsPort = settings.getPort();
                }
                this._settings.put(settings.getId(), settings);
            }
            if (saveNeeded) {
                this.save();
            }
        }
    }

    private String[] getRegExValues(String values, String defaultValues) {
        String usedValues = StringUtil.isNotBlank((String)values) ? values : defaultValues;
        ArrayList<String> regExArray = new ArrayList<String>();
        for (String value : usedValues.split(",")) {
            regExArray.add(value.trim().replace("*", ".*"));
        }
        return regExArray.toArray(new String[0]);
    }

    private String decryptPassword(String input) throws GeneralSecurityException {
        boolean encryptedPwFound = false;
        byte[] decodedPw = Base64.decode((byte[])input.getBytes());
        if (decodedPw.length > CRYPTED_PW_IDENTIFIER.length) {
            for (int i = 0; i < CRYPTED_PW_IDENTIFIER.length; ++i) {
                if (decodedPw[i] != CRYPTED_PW_IDENTIFIER[i]) {
                    encryptedPwFound = false;
                    break;
                }
                encryptedPwFound = true;
            }
        }
        if (!encryptedPwFound) {
            throw new IllegalArgumentException("not crypted");
        }
        byte[] encryptedPw = new byte[decodedPw.length - CRYPTED_PW_IDENTIFIER.length];
        for (int i = 0; i < encryptedPw.length; ++i) {
            encryptedPw[i] = decodedPw[i + CRYPTED_PW_IDENTIFIER.length];
        }
        if (this._crypt == null) {
            return input;
        }
        return this._crypt.decryptPassword(encryptedPw);
    }

    private String encryptPassword(String input) throws GeneralSecurityException {
        int i;
        byte[] cryptedPW = this._crypt.encryptPassword(input);
        byte[] storedCryptedPw = new byte[CRYPTED_PW_IDENTIFIER.length + cryptedPW.length];
        for (i = 0; i < CRYPTED_PW_IDENTIFIER.length; ++i) {
            storedCryptedPw[i] = CRYPTED_PW_IDENTIFIER[i];
        }
        for (i = 0; i < cryptedPW.length; ++i) {
            storedCryptedPw[i + ServerConfigBean.CRYPTED_PW_IDENTIFIER.length] = cryptedPW[i];
        }
        return new String(Base64.encode((byte[])storedCryptedPw));
    }

    @Override
    public void save() throws JAXBException {
        this.save("SYSTEM");
    }

    @Override
    public void save(String username) throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{OBJECT_FACTORY.getClass()});
        Marshaller m = jc.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        m.setProperty("jaxb.encoding", (Object)"UTF-8");
        XpValidationEventHandler validationEventHandler = new XpValidationEventHandler();
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            m.setEventHandler((ValidationEventHandler)validationEventHandler);
            m.marshal((Object)this._server, (OutputStream)bos);
            this._timestampOflastChange = this.messengerConfigDAO.storeMessengerConfig(bos.toByteArray(), "server.xml", username);
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new ServerConfigBeanChangedEvent(this));
        }
        catch (FileNotFoundException e) {
            throw new JAXBException("Configuration file '" + String.valueOf(this._configFile) + "' not found: " + e.getMessage());
        }
        catch (JAXBException e) {
            if (validationEventHandler.getMessage() != null) {
                JAXBException je = new JAXBException("Xml Error in " + this._configFile.getAbsolutePath() + " (" + validationEventHandler.getLine() + ", " + validationEventHandler.getColumn() + "): " + validationEventHandler.getMessage());
                je.setStackTrace(e.getStackTrace());
                throw je;
            }
            throw e;
        }
        catch (IOException e1) {
            throw new JAXBException("Could not write to configuration file '" + String.valueOf(this._configFile) + "': " + e1.getMessage());
        }
    }

    @Override
    public void forceReload() throws JAXBException {
        this.loadConfigToMemory(true);
    }

    @Override
    public Map<String, ServerSettings> getConnectors() {
        return this._settings;
    }

    @Override
    public void setConnectors(List<ServerSettings> connectors) {
        this._settings.clear();
        this._server.getConnector().clear();
        this._listenerHttpPort = -1;
        this._listenerHttpsPort = -1;
        for (ServerSettings settings : connectors) {
            this._settings.put(settings.getId(), settings);
            Server.Connector connector = OBJECT_FACTORY.createServerConnector();
            connector.setId(settings.getId());
            connector.setAddress(settings.getAddress());
            connector.setPort(settings.getPort());
            connector.setMinThreads(settings.getMinThreads());
            connector.setMaxThreads(settings.getMaxThreads());
            connector.setLowResources(settings.getLowResources());
            connector.setLowResourcePersistTime(settings.getLowResourcesPersistTimeMs());
            connector.setMaxIdleTime(settings.getMaxIdleTimeMs());
            for (String service : settings.getServices()) {
                connector.getService().add(service);
                if (!"LISTENERS".equals(service)) continue;
                if (this._listenerHttpPort == -1 && !settings.isSsl()) {
                    this._listenerHttpPort = settings.getPort();
                    continue;
                }
                if (this._listenerHttpsPort != -1 || !settings.isSsl()) continue;
                this._listenerHttpsPort = settings.getPort();
            }
            if (settings.isSsl()) {
                Server.Connector.SSL ssl = OBJECT_FACTORY.createServerConnectorSSL();
                connector.setSSL(ssl);
                ClientAuthType clientAuth = ClientAuthType.NONE;
                if (settings.isNeedClientCert()) {
                    clientAuth = ClientAuthType.NEED;
                } else if (settings.isWantClientCert()) {
                    clientAuth = ClientAuthType.WANT;
                }
                try {
                    ssl.setClientAuthentication(clientAuth);
                    ssl.setClientAuthKeystorePassword(this.encryptPassword(settings.getTrustPassword()));
                    ssl.setClientAuthKeystore(settings.getTrustKeystore());
                    ssl.setKeyPassword(this.encryptPassword(settings.getSslKeyPassword()));
                    ssl.setKeystorePassword(this.encryptPassword(settings.getSslPassword()));
                    ssl.setKeystore(settings.getSslKeystore());
                }
                catch (GeneralSecurityException e) {
                    e.printStackTrace();
                }
            }
            this._server.getConnector().add(connector);
        }
    }

    @Override
    public String getLogFolder() {
        return this._server.getFolders().getLogFolder();
    }

    @Override
    public void setLogFolder(String logFolder) {
        this._server.getFolders().setLogFolder(logFolder);
    }

    @Override
    public String getTempFolder() {
        return Path.of(System.getProperty("java.io.tmpdir"), "jetty").toAbsolutePath().toString();
    }

    @Override
    public String getServerLogLevel() {
        return this._server.getLogging().getServerLogLevel().toString();
    }

    @Override
    public void setServerLogLevel(String serverLogLevel) {
        this._server.getLogging().setServerLogLevel(LogLevel.valueOf((String)serverLogLevel));
    }

    @Override
    public String getMessengerLogLevel() {
        return this._server.getLogging().getMessengerLogLevel().toString();
    }

    @Override
    public void setMessengerLogLevel(String serverLogLevel) {
        this._server.getLogging().setMessengerLogLevel(LogLevel.valueOf((String)serverLogLevel));
    }

    @Override
    public String getJDBCLogLevel() {
        return this._server.getLogging().getJDBCLogLevel().toString();
    }

    @Override
    public void setJDBCLogLevel(String serverLogLevel) {
        this._server.getLogging().setJDBCLogLevel(LogLevel.valueOf((String)serverLogLevel));
    }

    @Override
    public File getConfigFile() {
        return this._configFile;
    }

    @Override
    public File getConfigFolder() {
        return this._configFolder;
    }

    @Override
    public File getAdaptersFolder() {
        return this._adaptersFolder;
    }

    @Override
    public File getXpHome() {
        return this._xpHome;
    }

    @Override
    public File getRealFile(String folderString) throws IOException {
        if (folderString == null || folderString.length() == 0) {
            throw new IOException("Missing folder name");
        }
        try {
            return new File(this.getRealPath(folderString)).getCanonicalFile();
        }
        catch (IOException e) {
            LOG.error("could not resolve folder {} :{}", (Object)folderString, (Object)e.toString());
            throw e;
        }
    }

    @Override
    public String getRealPath(String folderString) throws IOException {
        if (folderString == null || folderString.length() == 0) {
            throw new IOException("Missing folder name");
        }
        Object pathString = folderString;
        if (((String)pathString).startsWith("$PONTONXP_HOME")) {
            pathString = this._xpHome.getCanonicalPath() + folderString.substring("$PONTONXP_HOME".length());
        } else if (((String)pathString).startsWith("$XP_CONFIG_FOLDER")) {
            pathString = this._configFolder.getCanonicalPath() + folderString.substring("$XP_CONFIG_FOLDER".length());
        } else if (((String)pathString).startsWith("$CLUSTER_HOME")) {
            pathString = this._clusterHome.getCanonicalPath() + folderString.substring("$CLUSTER_HOME".length());
        } else if (((String)pathString).startsWith("$CONTEXT")) {
            pathString = this._xpHome.getCanonicalPath() + "/webroot" + folderString.substring("$CONTEXT".length());
        }
        return this.getNormalizedPath((String)pathString);
    }

    private String getNormalizedPath(String path) {
        return path.replaceAll("\\\\", "/");
    }

    @Override
    public int getListenerHttpPort() {
        return this._listenerHttpPort;
    }

    @Override
    public int getListenerHttpsPort() {
        return this._listenerHttpsPort;
    }

    @Override
    public int getRESTport() {
        return this._server.getConnector().stream().filter(c -> c.getService().contains(Service.REST.name())).findFirst().map(Server.Connector::getPort).orElse(0);
    }

    @Override
    public int getUserPasswordValidity() {
        int result = 365;
        Server.SecuritySettings securitySettings = this._server.getSecuritySettings();
        if (securitySettings != null) {
            result = securitySettings.getUserPasswordValidity();
        }
        return result;
    }

    @Override
    public void setUserPasswordValidity(int userPasswordValidity) {
        Server.SecuritySettings securitySettings = this._server.getSecuritySettings();
        if (securitySettings == null) {
            securitySettings = OBJECT_FACTORY.createServerSecuritySettings();
            this._server.setSecuritySettings(securitySettings);
        }
        securitySettings.setUserPasswordValidity(userPasswordValidity);
    }

    @Override
    public boolean isTwoFactorsEnforced() {
        Server.SecuritySettings securitySettings = this._server.getSecuritySettings();
        if (securitySettings != null) {
            return securitySettings.isEnforceTwoFactors();
        }
        return false;
    }

    @Override
    public void setTwoFactorsEnforced(boolean twoFactorsRequired) {
        Server.SecuritySettings securitySettings = this._server.getSecuritySettings();
        if (securitySettings == null) {
            securitySettings = OBJECT_FACTORY.createServerSecuritySettings();
            this._server.setSecuritySettings(securitySettings);
        }
        securitySettings.setEnforceTwoFactors(twoFactorsRequired);
    }

    @Override
    public File getSchemaSetFolder() {
        return new File(this.getConfigFolder(), "Schemata");
    }

    @Override
    public File getEnvelopesFolder() {
        return new File(this.getConfigFolder(), "Envelopes");
    }

    @Override
    public File getAgreementTemplateFolder() {
        return new File(this.getConfigFolder(), "agreementTemplates");
    }

    @Override
    public File getXslFolder() {
        return new File(this.getConfigFolder(), "XSL");
    }

    @Override
    public int getUserAccountLockDuration() {
        int result = 1;
        Server.SecuritySettings securitySettings = this._server.getSecuritySettings();
        if (securitySettings != null) {
            result = securitySettings.getUserAccountLockDuration();
        }
        return result;
    }

    @Override
    public int getMaxFailedLoginAttempts() {
        int result = 3;
        Server.SecuritySettings securitySettings = this._server.getSecuritySettings();
        if (securitySettings != null) {
            result = securitySettings.getMaxFailedLoginAttempts();
        }
        return result;
    }

    @Override
    public void setUserAccountLockDuration(int minutes) {
        Server.SecuritySettings securitySettings = this._server.getSecuritySettings();
        if (securitySettings == null) {
            securitySettings = OBJECT_FACTORY.createServerSecuritySettings();
            this._server.setSecuritySettings(securitySettings);
        }
        securitySettings.setUserAccountLockDuration(minutes);
    }

    @Override
    public void setMaxFailedLoginAttempts(int count) {
        Server.SecuritySettings securitySettings = this._server.getSecuritySettings();
        if (securitySettings == null) {
            securitySettings = OBJECT_FACTORY.createServerSecuritySettings();
            this._server.setSecuritySettings(securitySettings);
        }
        securitySettings.setMaxFailedLoginAttempts(count);
    }

    @Override
    public File getAddonsConfigsFolder() {
        return this._addonsConfigsFolder;
    }

    private void createAdapterInterfaceIfNotExists() {
        if (Objects.isNull(this._server.getAdapterInterface())) {
            this._server.setAdapterInterface(OBJECT_FACTORY.createServerAdapterInterface());
            this._server.getAdapterInterface().setEnabled(Boolean.valueOf(false));
        }
    }

    @Override
    public boolean isAdapterInterfaceEnabled() {
        Server.AdapterInterface adapterInterface = this._server.getAdapterInterface();
        if (Objects.nonNull(adapterInterface)) {
            return adapterInterface.isEnabled();
        }
        return false;
    }

    @Override
    public void setAdapterInterfaceEnabled(boolean enabled) {
        this.createAdapterInterfaceIfNotExists();
        this._server.getAdapterInterface().setEnabled(Boolean.valueOf(enabled));
    }

    @Override
    public String getAdapterInterfaceAddress() {
        Server.AdapterInterface adapterInterface = this._server.getAdapterInterface();
        if (Objects.nonNull(adapterInterface)) {
            return adapterInterface.getAddress();
        }
        return "0.0.0.0";
    }

    @Override
    public void setAdapterInterfaceAddress(String address) {
        this.createAdapterInterfaceIfNotExists();
        this._server.getAdapterInterface().setAddress(address);
    }

    @Override
    public int getAdapterInterfacePort() {
        Server.AdapterInterface adapterInterface = this._server.getAdapterInterface();
        if (Objects.nonNull(adapterInterface)) {
            return adapterInterface.getPort();
        }
        return 2600;
    }

    @Override
    public void setAdapterInterfacePort(int port) {
        this.createAdapterInterfaceIfNotExists();
        this._server.getAdapterInterface().setPort(port);
    }

    @Override
    public int getAdapterInterfaceTimeout() {
        Server.AdapterInterface adapterInterface = this._server.getAdapterInterface();
        if (Objects.nonNull(adapterInterface)) {
            return adapterInterface.getTimeout();
        }
        return 60;
    }

    @Override
    public void setAdapterInterfaceTimeout(int timeout) {
        this.createAdapterInterfaceIfNotExists();
        this._server.getAdapterInterface().setTimeout(timeout);
    }
}

