/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.config;

import de.pontonconsulting.common.file.DBConfigChangeWatcher;
import de.pontonconsulting.xmlpipe.config.ConfigResourceService;
import de.pontonconsulting.xmlpipe.config.MultipleSchemaSetFoundException;
import de.pontonconsulting.xmlpipe.config.SchemaData;
import de.pontonconsulting.xmlpipe.config.XpValidationEventHandler;
import de.pontonconsulting.xmlpipe.config.schemaset.SchemaSet;
import de.pontonconsulting.xmlpipe.cp.AdditionalSchema;
import de.pontonconsulting.xmlpipe.message.PayloadRecognizer;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.ValidationEventHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SchemataConfig {
    private static final char SEPARATOR = '\u0000';
    private static final String EMPTY = "";
    private static final String XSL_FOLDER = "XSL";
    private static final String SCHEMATA_FOLDER = "Schemata";
    private static final Logger _log = LogManager.getLogger((String)"Messenger.SchemataConfig");
    private static final String SCHEMASETS_CONFIG_CLASSES = "de.pontonconsulting.xmlpipe.config.schemaset";
    private final ConfigResourceService _configResourceService;
    private final MessageDigest messageDigest;
    private LinkedHashMap<String, SchemaData> allSchemaData = new LinkedHashMap();
    private final SortedMap<String, SchemaSet> _schemasets;
    private final SortedMap<String, SchemaSet> internalSchemasets;
    private final SortedMap<String, String> _dtdSchemaLocationMapping;
    private final SortedMap<String, List<SchemaData>> _fromRootElement;
    private final SortedMap<String, SortedSet<String>> _schemaLocation2schemasets;
    private final SortedMap<String, List<SchemaData>> _typeVersion;
    private final SortedMap<String, SchemaData> _typeVersionSet;
    private final SortedSet<String> _ambiguousSchemaData;
    private PayloadRecognizer globalPayloadRecognizer;
    private final SortedMap<String, SortedSet<SchemaData>> _contentProperties;
    private boolean _reinitGrammarPool = false;
    private final ReadWriteLock readWriteLock;
    private final Lock readLock;
    private final Lock writeLock;
    private final AtomicBoolean needsInitialization = new AtomicBoolean(true);

    public SchemataConfig(ConfigResourceService configResourceService, DBConfigChangeWatcher dbConfigChangeWatcher) throws NoSuchAlgorithmException {
        this.messageDigest = MessageDigest.getInstance("SHA-1");
        this.readWriteLock = new ReentrantReadWriteLock(true);
        this.readLock = this.readWriteLock.readLock();
        this.writeLock = this.readWriteLock.writeLock();
        this._typeVersionSet = new TreeMap<String, SchemaData>();
        this._typeVersion = new TreeMap<String, List<SchemaData>>();
        this._ambiguousSchemaData = new TreeSet<String>();
        this._schemasets = new TreeMap<String, SchemaSet>();
        this.internalSchemasets = new TreeMap<String, SchemaSet>();
        this._fromRootElement = new TreeMap<String, List<SchemaData>>();
        this._dtdSchemaLocationMapping = new TreeMap<String, String>();
        this._schemaLocation2schemasets = new TreeMap<String, SortedSet<String>>();
        this._contentProperties = new TreeMap<String, SortedSet<SchemaData>>();
        this._configResourceService = configResourceService;
        dbConfigChangeWatcher.addFileChangeListener(this::reinit);
    }

    public void reinit() {
        this.writeLock.lock();
        try {
            _log.trace("Start reinit of SchemataConfig");
            this.needsInitialization.set(true);
            this.setReinitGrammarPool(true);
            this._typeVersionSet.clear();
            this._typeVersion.clear();
            this._ambiguousSchemaData.clear();
            this._schemasets.clear();
            this.internalSchemasets.clear();
            this._fromRootElement.clear();
            this._dtdSchemaLocationMapping.clear();
            this._schemaLocation2schemasets.clear();
            this._contentProperties.clear();
            try {
                this.loadSchemasetsToMemory();
            }
            catch (IOException e) {
                _log.error("could not load schemasets", (Throwable)e);
            }
            this.needsInitialization.set(false);
            this.globalPayloadRecognizer = new PayloadRecognizer(this);
            _log.trace("Finished reinit of SchemataConfig (typeVersionSet={} / schemaSets={} / internalSchemaSets={} / fromRootElement={} / schemaLocations={})", (Object)this._typeVersionSet.size(), (Object)this._schemasets.size(), (Object)this.internalSchemasets.size(), (Object)this._fromRootElement.size(), (Object)this._schemaLocation2schemasets.size());
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public synchronized boolean getReinitGrammarPool() {
        return this._reinitGrammarPool;
    }

    public synchronized void setReinitGrammarPool(boolean reinitGrammarPool) {
        this._reinitGrammarPool = reinitGrammarPool;
    }

    private void ensureInitialization() {
        if (this.needsInitialization.get()) {
            this.reinit();
        }
    }

    private synchronized void loadSchemasetsToMemory() throws IOException {
        Map<URI, InputStream> resourcesAsList = this._configResourceService.getResources("Schemata/*.xml");
        for (Map.Entry<URI, InputStream> entry : resourcesAsList.entrySet()) {
            XpValidationEventHandler validation = new XpValidationEventHandler();
            try {
                JAXBContext jc = JAXBContext.newInstance((String)SCHEMASETS_CONFIG_CLASSES);
                Unmarshaller u = jc.createUnmarshaller();
                u.setEventHandler((ValidationEventHandler)validation);
                InputStream inputStream = entry.getValue();
                try {
                    SchemaSet schemaset = (SchemaSet)u.unmarshal(inputStream);
                    this.addSchemaSet(schemaset);
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (JAXBException jaxb) {
                if (validation.getMessage() != null) {
                    _log.fatal("Could not load schema set file '" + String.valueOf(entry.getKey()) + "'Reason: Xml Error in (Line:" + validation.getLine() + " / Column:" + validation.getColumn() + ") " + validation.getMessage(), (Throwable)jaxb);
                    continue;
                }
                _log.fatal("Could not load schema set file '" + String.valueOf(entry.getKey()) + "'", (Throwable)jaxb);
            }
        }
        _log.debug("loaded {} message type definitions.", (Object)this._typeVersionSet.size());
        this.allSchemaData = this.allSchemaData.entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
        _log.debug("Found {} schemasets.", (Object)this._schemasets.size());
    }

    private void addSchemaSet(SchemaSet schemaSet) {
        if (this._schemasets.containsKey(schemaSet.getName())) {
            _log.warn("duplicate schemaset {}", (Object)schemaSet.getName());
            return;
        }
        if (schemaSet.isInternal()) {
            this.internalSchemasets.put(schemaSet.getName(), schemaSet);
        } else {
            this._schemasets.put(schemaSet.getName(), schemaSet);
        }
        List schemaList = schemaSet.getSchema();
        File schemaFolder = new File(schemaSet.getSchemaFolder());
        File xslFolder = new File(schemaSet.getXSLFolder());
        schemaFolder = new File(SCHEMATA_FOLDER, schemaFolder.toString());
        xslFolder = new File(XSL_FOLDER, xslFolder.toString());
        for (SchemaSet.Schema schema : schemaList) {
            TreeSet<String> schemaSets;
            SchemaData result = this.createSchemaData(schema, schemaSet, schemaFolder, xslFolder);
            if (!schemaSet.isInternal()) {
                this.allSchemaData.put(result.getId(), result);
            }
            if (schema.getDtdFile() != null && !schema.getDtdFile().isEmpty()) {
                this._dtdSchemaLocationMapping.put(schema.getDtdFile(), schema.getName());
            }
            if (!schema.getSchemaFile().isEmpty()) {
                List<SchemaData> list = this.getSchemaDataListFromRoot(result.getNamespace(), result.getRootElement());
                if (list == null) {
                    list = this.createEmptySchemaDataListForRoot(result.getNamespace(), result.getRootElement());
                }
                list.add(result);
            }
            if ((schemaSets = (TreeSet<String>)this._schemaLocation2schemasets.get(schema.getName())) == null) {
                schemaSets = new TreeSet<String>();
                this._schemaLocation2schemasets.put(schema.getName(), schemaSets);
            }
            schemaSets.add(schemaSet.getName());
            String typeVersionId = this.buildTypeVersionId(result.getMessageVersion(), result.getMessageType());
            ArrayList<SchemaData> typeVersions = (ArrayList<SchemaData>)this._typeVersion.get(typeVersionId);
            if (this._typeVersion.get(typeVersionId) == null) {
                typeVersions = new ArrayList<SchemaData>();
                this._typeVersion.put(typeVersionId, typeVersions);
            } else {
                this._ambiguousSchemaData.add(typeVersionId);
            }
            typeVersions.add(result);
            String typeVersionSetId = this.buildTypeVersionSetId(result.getMessageVersion(), result.getMessageType(), result.getSchemaSetName());
            SchemaData invalid = this._typeVersionSet.put(typeVersionSetId, result);
            if (invalid != null) {
                _log.error("invalid schema configuration ! multiple definitions of message type: {} message version: {} schemaset: {}", (Object)result.getMessageType(), (Object)result.getMessageVersion(), (Object)result.getSchemaSetName());
            }
            this.addToContentPropertiesLookup(result);
        }
    }

    public SchemaData fetchSchemaDataFromContentProperty(String propertyName, String propertyValue) throws MultipleSchemaSetFoundException {
        this.ensureInitialization();
        this.readLock.lock();
        try {
            SortedSet schemaDataSet = (SortedSet)this._contentProperties.get(this.buildContentPropertyId(propertyName, propertyValue));
            if (schemaDataSet == null || schemaDataSet.isEmpty()) {
                SchemaData schemaData = null;
                return schemaData;
            }
            if (schemaDataSet.size() == 1) {
                SchemaData schemaData = (SchemaData)schemaDataSet.first();
                return schemaData;
            }
            throw new MultipleSchemaSetFoundException(new ArrayList<SchemaData>(schemaDataSet));
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void addToContentPropertiesLookup(SchemaData schemaData) {
        Map<String, String> contentProperties = schemaData.getPackagingParameterContentProperties();
        for (Map.Entry<String, String> entry : contentProperties.entrySet()) {
            String key = this.buildContentPropertyId(entry.getKey(), entry.getValue());
            TreeSet<SchemaData> schemaDataSet = (TreeSet<SchemaData>)this._contentProperties.get(key);
            if (schemaDataSet == null) {
                schemaDataSet = new TreeSet<SchemaData>();
                this._contentProperties.put(key, schemaDataSet);
            }
            schemaDataSet.add(schemaData);
        }
    }

    private String buildContentPropertyId(String key, String value) {
        StringBuilder builder = new StringBuilder();
        builder.append(key);
        builder.append('\u0000');
        builder.append(value);
        return builder.toString();
    }

    private String buildTypeVersionSetId(String version, String type, String set) {
        StringBuilder builder = new StringBuilder();
        builder.append(version);
        builder.append('\u0000');
        builder.append(type);
        builder.append('\u0000');
        builder.append(set);
        return builder.toString();
    }

    private String buildTypeVersionId(String version, String type) {
        StringBuilder builder = new StringBuilder();
        builder.append(version);
        builder.append('\u0000');
        builder.append(type);
        return builder.toString();
    }

    public ArrayList<String> getSchemaSetNames() {
        this.ensureInitialization();
        this.readLock.lock();
        try {
            ArrayList<String> arrayList = new ArrayList<String>(this._schemasets.keySet());
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public List<String> getInternalSchemaSetNames() {
        this.ensureInitialization();
        this.readLock.lock();
        try {
            ArrayList<String> arrayList = new ArrayList<String>(this.internalSchemasets.keySet());
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public SchemaData getSchemaByTypeVersion(String messageType, String version) throws MultipleSchemaSetFoundException {
        this.ensureInitialization();
        this.readLock.lock();
        try {
            String typeVersionId = this.buildTypeVersionId(version, messageType);
            List schemas = (List)this._typeVersion.get(typeVersionId);
            if (schemas == null) {
                SchemaData schemaData = null;
                return schemaData;
            }
            if (schemas.size() == 1) {
                SchemaData schemaData = (SchemaData)schemas.getFirst();
                return schemaData;
            }
            throw new MultipleSchemaSetFoundException(schemas);
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPriorityBySetTypeVersion(String schemaSetName, String messageType, String version) {
        this.ensureInitialization();
        this.readLock.lock();
        try {
            Optional<SchemaSet> schemaSet = this.findSchemaSet(schemaSetName);
            if (schemaSet.isPresent()) {
                int n = schemaSet.get().getPriority();
                return n;
            }
            _log.warn("No schema set available for name: {}, message type: {}, version: {}", (Object)schemaSetName, (Object)messageType, (Object)version);
            int n = 1;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchemaData getSchemaBySetTypeVersion(String schemaSetName, String messageType, String version) {
        this.ensureInitialization();
        this.readLock.lock();
        try {
            String typeVersionSetId = this.buildTypeVersionSetId(version, messageType, schemaSetName);
            SchemaData result = (SchemaData)this._typeVersionSet.get(typeVersionSetId);
            if (result == null) {
                _log.warn("No schema set available for name: {}, message type: {}, version: {}", (Object)schemaSetName, (Object)messageType, (Object)version);
            }
            SchemaData schemaData = result;
            return schemaData;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Optional<SchemaSet> findSchemaSet(String schemaSetName) {
        this.ensureInitialization();
        this.readLock.lock();
        try {
            if (StringUtils.isNotBlank((CharSequence)schemaSetName)) {
                if (this._schemasets.containsKey(schemaSetName)) {
                    Optional<SchemaSet> optional = Optional.of((SchemaSet)this._schemasets.get(schemaSetName));
                    return optional;
                }
                if (this.internalSchemasets.containsKey(schemaSetName)) {
                    Optional<SchemaSet> optional = Optional.of((SchemaSet)this.internalSchemasets.get(schemaSetName));
                    return optional;
                }
            }
            Optional<SchemaSet> optional = Optional.empty();
            return optional;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<String> getSchemaSetNames(String[] schemaLocations) {
        this.ensureInitialization();
        this.readLock.lock();
        try {
            TreeSet schemaSets = new TreeSet();
            for (int i = 0; i < schemaLocations.length; ++i) {
                SortedSet schemas = (SortedSet)this._schemaLocation2schemasets.get(schemaLocations[i]);
                if (schemas == null) continue;
                schemaSets.addAll(schemas);
            }
            ArrayList<String> arrayList = new ArrayList<String>(schemaSets);
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchemaSet.Schema[] getSchemaTypesFor(String schemaSetName) {
        this.ensureInitialization();
        this.readLock.lock();
        try {
            Optional<SchemaSet> schemaSetType = this.findSchemaSet(schemaSetName);
            if (schemaSetType.isEmpty()) {
                SchemaSet.Schema[] schemaArray = new SchemaSet.Schema[]{};
                return schemaArray;
            }
            List schemaTypes = schemaSetType.get().getSchema();
            SchemaSet.Schema[] schemaArray = schemaTypes.toArray(new SchemaSet.Schema[0]);
            return schemaArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public File getXslFolder() {
        return new File(XSL_FOLDER);
    }

    private List<SchemaData> getSchemaDataListFromRoot(String namespace, String root) {
        String rootKey = this.createRootKey(namespace, root);
        return (List)this._fromRootElement.get(rootKey);
    }

    private String createRootKey(String namespace, String root) {
        return "#" + namespace + "#" + root;
    }

    private List<SchemaData> createEmptySchemaDataListForRoot(String namespace, String rootElement) {
        ArrayList<SchemaData> list = new ArrayList<SchemaData>();
        String rootKey = this.createRootKey(namespace, rootElement);
        this._fromRootElement.put(rootKey, list);
        return list;
    }

    private SchemaData createSchemaData(SchemaSet.Schema schema, SchemaSet schemaSet, File schemaFolder, File xslFolder) {
        SchemaData result = new SchemaData();
        result.setName(schema.getName());
        result.setMessageType(schema.getMessageType());
        result.setMessageVersion(schema.getMessageVersion());
        String namespace = schema.getNamespace();
        if (namespace != null && !namespace.equals(EMPTY)) {
            result.setNamespace(namespace);
        }
        result.setSchemaFile(new File(schemaFolder, schema.getSchemaFile()));
        result.setDtdFile(schema.getDtdFile());
        if (schema.getEnvelopeMapping() != null) {
            result.setPontonXPath("Ponton".equals(schema.getEnvelopeMapping().getXPathType()));
        }
        result.setValidateable(schemaSet.isValidateable());
        result.setDefaultFileExtension(schemaSet.getDefaultFileExtension());
        result.setRootElement(schema.getRootElement());
        if (result.getRootElement() == null) {
            result.setRootElement(schema.getMessageType());
        }
        if (schema.getMessageTypeMarker() != null) {
            SchemaSet.Schema.MessageTypeMarker marker = schema.getMessageTypeMarker();
            result.setMessageTypeMarker(marker.getXPath(), marker.getValue());
        }
        if (StringUtils.isNotBlank((CharSequence)schema.getXSLFile())) {
            File xslFile = new File(xslFolder, schema.getXSLFile());
            result.setXslFile(xslFile);
        }
        if (schema.getEnvelopeMapping() != null) {
            result.setEnvelopeMapping(schema.getEnvelopeMapping());
        }
        if (schema.getPackagingParameters() != null) {
            result.setPackagingParameters(schema.getPackagingParameters());
        }
        for (SchemaSet.Schema.AdditionalSchemaFile schemaFile : schema.getAdditionalSchemaFile()) {
            AdditionalSchema additionalSchema = new AdditionalSchema(new File(schemaFolder, schemaFile.getFile()), schemaFile.getNamespace(), schemaFile.getSchemalocation());
            if (schemaFile.getMainDocumentAt() != null) {
                additionalSchema.setWrappedMainDocumentRequired(schemaFile.getMainDocumentAt().isRequired());
                for (String xpath : schemaFile.getMainDocumentAt().getXPath()) {
                    additionalSchema.addXPath(xpath);
                }
            }
            result.addAdditionalSchemata(additionalSchema);
        }
        result.setDisplayName(schema.getDisplayName());
        result.setSchemaSetName(schemaSet.getName());
        String id = this.createId(result);
        result.setId(id);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchemaData fetchSchemaDataFromMetaData(String namespaceUri, String schemaLocation, String systemId, String rootElement) throws MultipleSchemaSetFoundException {
        this.ensureInitialization();
        this.readLock.lock();
        try {
            SchemaData schemaData;
            List<SchemaData> schemas = this.getSchemaDataListFromRoot(namespaceUri, rootElement);
            if (schemas == null) {
                SchemaData schemaData2 = null;
                return schemaData2;
            }
            String schemaFile = null;
            String location = schemaLocation;
            if (location != null) {
                StringTokenizer st = new StringTokenizer(location);
                if (st.countTokens() % 2 == 0) {
                    while (st.hasMoreTokens()) {
                        String tempNS = st.nextToken();
                        String tempSL = st.nextToken();
                        if (!tempNS.equals(namespaceUri)) continue;
                        location = tempSL;
                        break;
                    }
                }
                schemaFile = this.extractFileName(location);
            }
            if (namespaceUri != null) {
                schemaData = this.fetchSchemaDataForNamespace(schemas, namespaceUri, location, schemaFile);
                return schemaData;
            }
            schemaData = this.fetchSchemaDataForNoNamespace(schemas, location, systemId, schemaFile);
            return schemaData;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private String extractFileName(String schemaLocation) {
        String schemaFile = null;
        int index = schemaLocation.lastIndexOf(47);
        if (index > -1) {
            schemaFile = schemaLocation.substring(index);
        }
        return schemaFile;
    }

    private SchemaData fetchSchemaDataForNoNamespace(List<SchemaData> schemas, String schemaLocation, String systemId, String schemaFile) throws MultipleSchemaSetFoundException {
        ArrayList<SchemaData> temp = new ArrayList<SchemaData>();
        List<SchemaData> schemaDataList = schemas;
        for (SchemaData schemaData : schemaDataList) {
            if (schemaData.getNamespace() != null) continue;
            temp.add(schemaData);
        }
        switch (temp.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (SchemaData)temp.get(0);
            }
        }
        schemaDataList = temp;
        if (schemaLocation != null) {
            for (SchemaData schemaData : schemaDataList) {
                if (!schemaLocation.equalsIgnoreCase(schemaData.getName())) continue;
                return schemaData;
            }
        }
        if (schemaFile != null) {
            for (SchemaData schemaData : schemaDataList) {
                if (schemaData.getSchemaFile() == null || schemaLocation == null || !schemaLocation.equalsIgnoreCase(schemaData.getSchemaFile().getName())) continue;
                return schemaData;
            }
        }
        if (systemId != null) {
            for (SchemaData schemaData : schemaDataList) {
                if (!systemId.equalsIgnoreCase(schemaData.getDtdFile())) continue;
                return schemaData;
            }
        }
        if (schemaDataList.size() > 0) {
            throw new MultipleSchemaSetFoundException(schemaDataList);
        }
        return null;
    }

    private SchemaData fetchSchemaDataForNamespace(List<SchemaData> schemas, String namespaceUri, String schemaLocation, String schemaFile) throws MultipleSchemaSetFoundException {
        ArrayList<SchemaData> temp = new ArrayList<SchemaData>();
        List<SchemaData> schemaDataList = schemas;
        for (SchemaData schemaData : schemaDataList) {
            if (!namespaceUri.equals(schemaData.getNamespace())) continue;
            temp.add(schemaData);
        }
        switch (temp.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (SchemaData)temp.get(0);
            }
        }
        schemaDataList = temp;
        if (schemaLocation != null) {
            for (SchemaData schemaData : schemaDataList) {
                if (!schemaLocation.equalsIgnoreCase(schemaData.getName())) continue;
                return schemaData;
            }
            if (schemaFile != null) {
                for (SchemaData schemaData : schemaDataList) {
                    if (schemaData.getSchemaFile() == null || !schemaLocation.equalsIgnoreCase(schemaData.getSchemaFile().getName())) continue;
                    return schemaData;
                }
            }
        }
        if (schemaDataList.size() > 0) {
            throw new MultipleSchemaSetFoundException(schemaDataList);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTypeVersionAmbiguous(String messageType, String version) {
        this.ensureInitialization();
        this.readLock.lock();
        try {
            String typeVersionId = this.buildTypeVersionId(version, messageType);
            boolean bl = this._ambiguousSchemaData.contains(typeVersionId);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private synchronized String createId(SchemaData schemaData) {
        String idInfo = schemaData.getSchemaSetName() + "|" + schemaData.getMessageType() + "|" + schemaData.getMessageVersion();
        byte[] hash = this.messageDigest.digest(idInfo.getBytes(StandardCharsets.UTF_8));
        StringBuilder id = new StringBuilder();
        for (byte b : hash) {
            id.append(String.format("%02X", b));
        }
        return id.toString();
    }

    public Set<SchemaData> getAllSchemaData() {
        this.ensureInitialization();
        this.readLock.lock();
        try {
            Set<SchemaData> set = Collections.unmodifiableSet(new LinkedHashSet<SchemaData>(this.allSchemaData.values()));
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public SchemaData findSchemaDataById(String id) {
        this.ensureInitialization();
        this.readLock.lock();
        try {
            SchemaData schemaData = this.allSchemaData.get(id);
            return schemaData;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public PayloadRecognizer getGlobalPayloadRecognizer() {
        this.ensureInitialization();
        this.readLock.lock();
        try {
            PayloadRecognizer payloadRecognizer = this.globalPayloadRecognizer;
            return payloadRecognizer;
        }
        finally {
            this.readLock.unlock();
        }
    }
}

