/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.config;

import de.pontonconsulting.xmlpipe.config.IServerConfigBean;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.ListenerCertificate;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.MessengerConfig;
import de.pontonconsulting.xmlpipe.messenger.database.tables.ListenerConfigDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerConfigDAO;
import de.pontonconsulting.xmlpipe.security.CertificateReader;
import de.pontonconsulting.xmlpipe.security.PontonKeystore;
import de.pontonconsulting.xmlpipe.server.Startup;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class KeystoreBean {
    protected static final String KEYSTORE_PASSWORD = "randomPassword";
    protected static final String KEYSTORE_NAME = "keystore";
    protected static final String XP_ROOT_CA = "XPRootCA-chain.pem";
    protected static final String XP_ROOT_CA_ALIAS = "cn=xp root ca,o=ponton gmbh,c=de";
    private final IServerConfigBean _serverConfig;
    private final CertificateReader _certificate;
    private final ReferenceDateTask referenceDateTask;
    private final MessengerConfigDAO messengerConfigDAO;
    private long lastModified = 0L;
    private final PontonKeystore pontonKeystore;
    private final ListenerConfigDAO listenerConfigDAO;
    private final ReadWriteLock rwLockForKeyStore = new ReentrantReadWriteLock();
    private final Lock readLock = this.rwLockForKeyStore.readLock();
    private final Lock writeLock = this.rwLockForKeyStore.writeLock();

    public KeystoreBean(IServerConfigBean serverConfig, CertificateReader certificate, ReferenceDateTask referenceDateTask, MessengerConfigDAO messengerConfigDAO, ListenerConfigDAO listenerConfigDAO) throws Exception {
        this._serverConfig = serverConfig;
        this._certificate = certificate;
        this.referenceDateTask = referenceDateTask;
        this.messengerConfigDAO = messengerConfigDAO;
        this.listenerConfigDAO = listenerConfigDAO;
        File keystoreFile = new File(this._serverConfig.getConfigFolder(), KEYSTORE_NAME);
        if (keystoreFile.exists() && !messengerConfigDAO.doesMessengerConfigExist(KEYSTORE_NAME)) {
            this.lastModified = messengerConfigDAO.storeMessengerConfig(Files.readAllBytes(keystoreFile.toPath()), KEYSTORE_NAME, "SYSTEM");
            Files.delete(keystoreFile.toPath());
        }
        MessengerConfig messengerConfig = messengerConfigDAO.loadMessengerConfig(KEYSTORE_NAME);
        this.lastModified = messengerConfig.getTimestamp().toInstant().toEpochMilli();
        this.pontonKeystore = new PontonKeystore(messengerConfig.getData(), KEYSTORE_PASSWORD, this._certificate, referenceDateTask::getReferenceDate, this::saveKeystore);
        try (InputStream inputStream = Objects.requireNonNull(Startup.class.getClassLoader().getResource(XP_ROOT_CA)).openStream();){
            ListenerCertificate listenerCertificate;
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            X509Certificate caCert = (X509Certificate)certificateFactory.generateCertificate(inputStream);
            if (this.pontonKeystore.getCA(XP_ROOT_CA_ALIAS) == null) {
                this.pontonKeystore.addNewCA(caCert);
            }
            if (listenerConfigDAO.loadListenerCertificate(XP_ROOT_CA_ALIAS, ListenerCertificate.Type.SERVER_CA) == null) {
                listenerCertificate = new ListenerCertificate();
                listenerCertificate.setCertificate(caCert.getEncoded());
                listenerCertificate.setAliasAndType(XP_ROOT_CA_ALIAS, ListenerCertificate.Type.SERVER_CA);
                listenerCertificate.setStatus(ListenerCertificate.Status.TRUSTED);
                listenerCertificate.setLastCheck(OffsetDateTime.now(ZoneOffset.UTC));
                listenerConfigDAO.importCertificate(listenerCertificate);
            }
            if (listenerConfigDAO.loadListenerCertificate(XP_ROOT_CA_ALIAS, ListenerCertificate.Type.CLIENT_CA) == null) {
                listenerCertificate = new ListenerCertificate();
                listenerCertificate.setCertificate(caCert.getEncoded());
                listenerCertificate.setLastCheck(OffsetDateTime.now(ZoneOffset.UTC));
                listenerCertificate.setAliasAndType(XP_ROOT_CA_ALIAS, ListenerCertificate.Type.CLIENT_CA);
                listenerCertificate.setStatus(ListenerCertificate.Status.TRUSTED);
                listenerConfigDAO.importCertificate(listenerCertificate);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PontonKeystore getKeystore() {
        this.readLock.lock();
        try {
            long timestampByConfigType = this.messengerConfigDAO.getTimestampAsLongByConfigType(KEYSTORE_NAME);
            if (timestampByConfigType == this.lastModified) {
                PontonKeystore pontonKeystore = this.pontonKeystore;
                return pontonKeystore;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return this.reloadKeystore();
    }

    private PontonKeystore reloadKeystore() {
        this.writeLock.lock();
        try {
            MessengerConfig messengerConfig = this.messengerConfigDAO.loadMessengerConfig(KEYSTORE_NAME);
            this.pontonKeystore.reloadKeystore(messengerConfig.getData());
            this.lastModified = messengerConfig.getTimestamp().toInstant().toEpochMilli();
            PontonKeystore pontonKeystore = this.pontonKeystore;
            return pontonKeystore;
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void saveKeystore(byte[] bytes) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        this.messengerConfigDAO.storeMessengerConfig(bytes, KEYSTORE_NAME, authentication != null ? authentication.getName() : "SYSTEM");
    }
}

