/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.config;

import de.pontonconsulting.common.security.IPasswordCrypt;
import de.pontonconsulting.common.security.PasswordCrypt;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import java.security.Provider;
import java.security.Security;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class DatabaseConfig {
    public static final String ENV_DATABASE_URL = "DATABASE_URL";
    public static final String ENV_DATABASE_USER = "DATABASE_USER";
    public static final String ENV_DATABASE_PW = "DATABASE_PASSWORD";
    public static final String ENV_DATABASE_MIN_CON = "DATABASE_CONNECTIONS_MIN";
    public static final String ENV_DATABASE_MAX_CON = "DATABASE_CONNECTIONS_MAX";
    public static final String ENV_DATABASE_TIMEOUT = "DATABASE_CONNECTION_TIMEOUT";
    public static final String ENV_DATABASE_LOG_SQL = "DATABASE_LOGGING_SQL";
    static final String DEFAULT_MIN_CONNECTIONS = "2";
    static final String DEFAULT_MAX_CONNECTIONS = "100";
    static final int MAX_CONNECTIONS = 500;
    static final String DEFAULT_CONNECTION_TIMEOUT = "300";
    private static final Logger _log = LogManager.getLogger((String)("Messenger." + DatabaseConfig.class.getName()));
    private final String url;
    private final String username;
    private final String password;
    private final int minConnections;
    private final int maxConnections;
    private final long connectionTimeout;

    public DatabaseConfig(IPasswordCrypt passwordCrypt, Map<String, String> systemEnv) {
        this.url = this.getProperty(systemEnv, ENV_DATABASE_URL, "");
        this.username = this.getProperty(systemEnv, ENV_DATABASE_USER, "");
        this.password = this.getPassword(passwordCrypt, systemEnv);
        this.minConnections = Integer.parseInt(this.getProperty(systemEnv, ENV_DATABASE_MIN_CON, DEFAULT_MIN_CONNECTIONS));
        this.maxConnections = Integer.parseInt(this.getProperty(systemEnv, ENV_DATABASE_MAX_CON, DEFAULT_MAX_CONNECTIONS));
        this.connectionTimeout = Long.parseLong(this.getProperty(systemEnv, ENV_DATABASE_TIMEOUT, DEFAULT_CONNECTION_TIMEOUT));
        this.validateParameters(systemEnv);
    }

    private void validateParameters(Map<String, String> systemEnv) {
        String jdbcURL = systemEnv.get(ENV_DATABASE_URL);
        String usr = systemEnv.get(ENV_DATABASE_USER);
        String pw = systemEnv.get(ENV_DATABASE_PW);
        if (StringUtils.isBlank((CharSequence)jdbcURL)) {
            throw new IllegalArgumentException("DATABASE_URL is required");
        }
        if (StringUtils.isBlank((CharSequence)usr)) {
            throw new IllegalArgumentException("DATABASE_USER is required");
        }
        if (StringUtils.isBlank((CharSequence)pw)) {
            throw new IllegalArgumentException("DATABASE_PASSWORD is required");
        }
        this.validateJdbcURL(jdbcURL);
        if (this.minConnections < 2 || this.minConnections > 500) {
            throw new IllegalArgumentException("DATABASE_CONNECTIONS_MIN must be between 2 and 500");
        }
        if (this.maxConnections < 2 || this.maxConnections > 500) {
            throw new IllegalArgumentException("DATABASE_CONNECTIONS_MAX must be between 2 and 500");
        }
        if (this.maxConnections < this.minConnections) {
            throw new IllegalArgumentException("DATABASE_CONNECTIONS_MAX must be bigger than DATABASE_CONNECTIONS_MIN");
        }
        if (this.connectionTimeout < 60L || this.connectionTimeout > 3600L) {
            throw new IllegalArgumentException("DATABASE_CONNECTION_TIMEOUT must be between 60 and 3600");
        }
    }

    private void validateJdbcURL(String jdbcUrl) {
        if (StringUtils.isBlank((CharSequence)jdbcUrl)) {
            return;
        }
        if (jdbcUrl.contains(":sqlserver:")) {
            if (jdbcUrl.contains("useUnicode=false")) {
                _log.warn("JDBC-URL should contain 'useUnicode=true' parameter to support unicode characters");
            }
            if (jdbcUrl.contains("sendStringParametersAsUnicode=false")) {
                _log.warn("JDBC-URL should not contain 'sendStringParametersAsUnicode=false' parameter to support unicode characters");
            }
            this.checkCharacterEncoding(jdbcUrl);
        } else if (jdbcUrl.contains(":mysql:")) {
            if (jdbcUrl.contains("useUnicode=false")) {
                _log.warn("JDBC-URL should not contain 'useUnicode=false' parameter to support unicode characters");
            }
            this.checkCharacterEncoding(jdbcUrl);
        } else if (jdbcUrl.contains(":oracle:")) {
            this.checkCharacterEncoding(jdbcUrl);
            Pattern pattern = Pattern.compile("NLS_LANG=([^&;]+)");
            Matcher matcher = pattern.matcher(jdbcUrl);
            if (matcher.find() && !matcher.group(1).endsWith("AL32UTF8")) {
                _log.warn("JDBC-URL should not set 'NLS_LANG={}'. Remove parameter or use unicode compatible value '*.AL32UTF8", (Object)matcher.group(1));
            }
        } else if (jdbcUrl.contains(":postgresql:")) {
            this.checkCharacterEncoding(jdbcUrl);
            Pattern pattern = Pattern.compile("client_encoding=([^&;]+)");
            Matcher matcher = pattern.matcher(jdbcUrl);
            if (matcher.find() && !matcher.group(1).endsWith("UTF8")) {
                _log.warn("JDBC-URL should not set 'client_encoding={}'. Remove parameter or use 'UTF-8' instead to support unicode characters", (Object)matcher.group(1));
            }
        }
    }

    private void checkCharacterEncoding(String jdbcUrl) {
        String characterEncoding;
        Pattern pattern = Pattern.compile("characterEncoding=([^&;]+)");
        Matcher matcher = pattern.matcher(jdbcUrl);
        String string = characterEncoding = matcher.find() ? matcher.group(1) : null;
        if (Objects.nonNull(characterEncoding) && !"UTF-8".equals(characterEncoding)) {
            _log.warn("JDBC-URL should not set 'characterEncoding={}'. Remove parameter or use 'UTF-8' instead to support unicode characters", (Object)characterEncoding);
        }
    }

    public static void main(String[] args) {
        if (args.length != 2 || !"encrypt".equals(args[0])) {
            System.err.println("Usage: encrypt <password>");
            System.exit(1);
        }
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            System.out.println("encrypted pw: " + MessengerConfig.getEncryptedPassword(new PasswordCrypt("IpIndependent"), args[1]));
        }
        catch (Exception e) {
            System.err.println("Can't encrypt password: " + String.valueOf(e));
        }
    }

    private String getProperty(Map<String, String> systemEnvironment, String envProperty, String defaultValue) {
        String value = systemEnvironment.get(envProperty);
        if (Objects.nonNull(value) && !value.trim().isEmpty()) {
            _log.debug("Found environment variable {}: {}", (Object)envProperty, (Object)(ENV_DATABASE_PW.equals(envProperty) ? "***" : value));
            return value;
        }
        value = defaultValue;
        _log.debug("Use default value for {}: {}", (Object)envProperty, (Object)(ENV_DATABASE_PW.equals(envProperty) ? "***" : value));
        return value;
    }

    private String getPassword(IPasswordCrypt passwordCrypt, Map<String, String> systemEnv) {
        String pw;
        String configValue = this.getProperty(systemEnv, ENV_DATABASE_PW, "");
        if (configValue.equals(pw = MessengerConfig.getRealPassword(passwordCrypt, configValue))) {
            _log.warn("Database password is not encrypted. See documentation for how to encrypt it (script /sql/encryptPW).");
        }
        return pw;
    }

    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public int getMinConnections() {
        return this.minConnections;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }
}

