/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.config;

import de.pontonconsulting.xmlpipe.config.AddOn;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AddOnInfoReader {
    private static Log LOG = LogFactory.getFactory().getInstance("Messenger.AddOnInfoReader");
    private static final String PONTON_ADDON_PROPERTIES = "ponton-addon.properties";
    private static final String ADDON_ID = "ponton.addon.id";
    private static final String ADDON_VERSION = "ponton.addon.version";
    private static final String ADDON_DATE = "ponton.addon.builddate";
    private final URLClassLoader classLoader;

    public AddOnInfoReader() {
        File appFolder = new File("").getAbsoluteFile();
        File addonsConfigsFolder = new File(appFolder, "addons/configs");
        File adaptersFolder = new File(appFolder, "addons/adapters");
        ArrayList<URL> urls = new ArrayList<URL>();
        this.addJars(urls, addonsConfigsFolder);
        this.addJars(urls, adaptersFolder);
        this.classLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]), this.getClass().getClassLoader().getParent());
    }

    private void addJars(List<URL> urls, File folder) {
        File[] addons = folder.listFiles(file -> file.getName().toLowerCase().endsWith(".jar"));
        if (addons != null) {
            Arrays.sort(addons, (a, b) -> a.getAbsolutePath().compareToIgnoreCase(b.getAbsolutePath()));
            for (File file2 : addons) {
                try {
                    urls.add(file2.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    LOG.warn((Object)("could not add File to ResourceLoader " + String.valueOf(file2) + e.toString()));
                }
            }
        }
    }

    public List<AddOn> getAddOnInfos() {
        ArrayList<AddOn> addOns = new ArrayList<AddOn>();
        try {
            Enumeration<URL> configs = this.classLoader.getResources(PONTON_ADDON_PROPERTIES);
            while (configs.hasMoreElements()) {
                URL url = configs.nextElement();
                LOG.info((Object)("Found XP AddOn: " + url.toString()));
                try {
                    InputStream in = url.openStream();
                    try {
                        Properties properties = new Properties();
                        properties.load(in);
                        String name = properties.getProperty(ADDON_ID, "undefined");
                        String version = properties.getProperty(ADDON_VERSION, "undefined");
                        String builddate = properties.getProperty(ADDON_DATE);
                        addOns.add(new AddOn(name, version, builddate));
                    }
                    finally {
                        if (in == null) continue;
                        in.close();
                    }
                }
                catch (IOException io) {
                    LOG.error((Object)"could not read XP AddOn content");
                }
            }
        }
        catch (IOException e) {
            LOG.error((Object)"could not read XP AddOn jars", (Throwable)e);
        }
        return addOns;
    }
}

