/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.as;

import de.pontonconsulting.xmlpipe.as.ASReport;
import de.pontonconsulting.xmlpipe.as.ASReportException;
import de.pontonconsulting.xmlpipe.as.IAS2Object;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import de.pontonconsulting.xmlpipe.security.smime.SMIMESigner;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MailDateFormat;
import jakarta.mail.internet.MimeBodyPart;

public class AS2Report
extends ASReport
implements IAS2Object {
    private String _as2Version;

    protected AS2Report(CertificateUtility certificateUtility, SMIMESigner smimeSigner, ReferenceDateTask referenceDateTask) {
        super(certificateUtility, smimeSigner, referenceDateTask);
    }

    @Override
    public MimeBodyPart getReportMimePart() throws ASReportException {
        if (!this.isLoadedFromMimePart()) {
            if (this._mimePart == null) {
                try {
                    this._mimePart = super.prepareMimePart();
                    this._mimePart.addHeader("AS2-Version", "1.1");
                    this._mimePart.addHeader("AS2-From", this._from);
                    this._mimePart.addHeader("AS2-To", this._to);
                }
                catch (MessagingException me) {
                    throw new ASReportException(44002, (Throwable)me);
                }
            }
            return this._mimePart;
        }
        return this._mimePart;
    }

    @Override
    protected String getReportText() {
        if (!this.isLoadedFromMimePart()) {
            MailDateFormat _format = new MailDateFormat();
            StringBuilder text = new StringBuilder();
            text.append("MDN for: ").append("\r\n");
            text.append(" Message Id: ").append(this.getMDN().getOriginalMessageID()).append("\r\n");
            text.append(" From: ").append(this._from).append("\r\n");
            text.append(" To: ").append(this._to).append("\r\n");
            text.append(" Received on: ").append(_format.format(this.referenceDateTask.getReferenceDate())).append("\r\n");
            text.append(" Status: ").append(this.getMDN().getDispositionType());
            if (this.getMDN().getDispositionModifier() != null && this.getMDN().getDispositionModifier().length() > 0) {
                text.append("/").append(this.getMDN().getDispositionModifier());
            }
            text.append("\r\n");
            text.append(" Status-Description: ").append(this.getStatusDescription()).append("\r\n");
            text.append(" Comment: This is not a guarantee that the message has").append("\r\n");
            text.append("          been completely processed or understood by").append("\r\n");
            text.append("          internal system.").append("\r\n");
            return text.toString();
        }
        return super.getReportText();
    }

    @Override
    public String getTransferEncoding() {
        return "binary";
    }

    @Override
    public String getAS2Version() {
        return this._as2Version;
    }

    @Override
    public void setAS2Version(String as2Version) {
        this._as2Version = as2Version;
    }

    @Override
    public String getPackagingName() {
        return "AS2";
    }
}

