/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.as;

import de.pontonconsulting.xmlpipe.as.AS2Message;
import de.pontonconsulting.xmlpipe.as.AS2MessageHelper;
import de.pontonconsulting.xmlpipe.as.AS2Report;
import de.pontonconsulting.xmlpipe.as.ASException;
import de.pontonconsulting.xmlpipe.as.ASMessage;
import de.pontonconsulting.xmlpipe.as.ASObject;
import de.pontonconsulting.xmlpipe.as.ASObjectFactory;
import de.pontonconsulting.xmlpipe.as.ASReport;
import de.pontonconsulting.xmlpipe.as.IAS2Object;
import de.pontonconsulting.xmlpipe.cpp.CppPartner;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.IdGenerator;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import de.pontonconsulting.xmlpipe.security.smime.SMIMESigner;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.ContentType;
import jakarta.mail.internet.InternetHeaders;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import java.io.IOException;
import java.util.List;

public class AS2ObjectFactory
extends ASObjectFactory {
    private static final String USER_AGENT = "PontonXP AS2-Processor";
    public static final String HEADER_SUBJECT_VALUE = "AS2 Business Message";
    public static final String PARTYID_TYPE = "AS2-Name";
    public static final String HEADER_AS2_VERSION = "AS2-Version";
    public static final String HEADER_AS2_VERSION_1_0 = "1.0";
    public static final String HEADER_AS2_VERSION_1_1 = "1.1";
    public static final String HEADER_AS2_FROM = "AS2-From";
    public static final String HEADER_AS2_TO = "AS2-To";

    public AS2ObjectFactory(IdGenerator idGenerator, ReferenceDateTask referenceDateTask, CertificateUtility certificateUtility, SMIMESigner smimeSigner, Profiles profiles) {
        super(idGenerator, referenceDateTask, certificateUtility, smimeSigner, profiles);
    }

    @Override
    public AS2Message createASMessage(InternetHeaders headers, ContentType contentType, MimeBodyPart mimePart) throws ASException, MessagingException {
        AS2Message as2Message = new AS2Message();
        this.initASMessage(as2Message, headers, mimePart);
        return as2Message;
    }

    @Override
    public AS2Report createASReport(InternetHeaders headers, ContentType contentType, MimeBodyPart mimePart) throws ASException, MessagingException {
        AS2Report as2Report = new AS2Report(this._certificateUtility, this._smimeSigner, this.referenceDateTask);
        this.initASReport(as2Report, headers, mimePart);
        return as2Report;
    }

    public IAS2Object createAS2Object(MimeMessage mimeMessage) throws ASException, MessagingException, IOException {
        return (IAS2Object)((Object)super.createASObject(mimeMessage));
    }

    public AS2Message createAS2Message(XpMessage message) throws ASException {
        AS2Message as2Message = new AS2Message();
        this.initASMessage(as2Message, message);
        as2Message.setAS2Version(HEADER_AS2_VERSION_1_1);
        try {
            CppPartner ownPartner = this._profiles.getProfileForLocalId(message.getAgreement().getOwnPartner().getId(), true);
            as2Message.setFrom(ownPartner.getPartyIdValue(PARTYID_TYPE));
            if (as2Message.getFrom() == null || as2Message.getFrom().length() == 0) {
                throw new ASException(43003, "Sender AS2 name is not set.");
            }
        }
        catch (ProfileException e) {
            throw new ASException(43003, "Sender is not set.");
        }
        try {
            CppPartner communicationPartner = this._profiles.getProfileForLocalId(message.getAgreement().getCommunicationPartner().getId(), true);
            as2Message.setTo(communicationPartner.getPartyIdValue(PARTYID_TYPE));
            if (as2Message.getTo() == null || as2Message.getTo().length() == 0) {
                throw new ASException(43004, "Receiver AS2 name is not set.");
            }
        }
        catch (ProfileException e) {
            throw new ASException(43004, "Receiver is not set.");
        }
        return as2Message;
    }

    public AS2Report createOKReport(ASMessage asMessage, String statusDescription) {
        AS2Report as2Report = new AS2Report(this._certificateUtility, this._smimeSigner, this.referenceDateTask);
        this.initOKASReport(as2Report, asMessage, statusDescription);
        return as2Report;
    }

    public AS2Report createErrorReport(ASMessage asMessage, ASReport.DispositionModifier dispositionModifier, ASReport.DispositionModifierExtension dispositionModifierExtension, String statusDescription, List<String> details) {
        AS2Report as2Report = new AS2Report(this._certificateUtility, this._smimeSigner, this.referenceDateTask);
        this.initErrorASReport(as2Report, asMessage, dispositionModifier, dispositionModifierExtension, statusDescription, details);
        return as2Report;
    }

    @Override
    protected void parseASMessageHeaders(ASMessage asMessage) throws MessagingException {
        AS2Message as2Message = (AS2Message)asMessage;
        InternetHeaders headers = as2Message.getInternetHeaders();
        if (headers.getHeader("Receipt-Delivery-Option") != null && headers.getHeader("Receipt-Delivery-Option").length > 0) {
            as2Message.getMDNParameters().setSyncReplyRequested(false);
            as2Message.getMDNParameters().setAsyncMDNRecipient(headers.getHeader("Receipt-Delivery-Option")[0]);
        } else {
            as2Message.getMDNParameters().setSyncReplyRequested(true);
        }
    }

    @Override
    protected void parseASObjectHeaders(ASObject asObject) throws MessagingException {
        InternetHeaders headers = asObject.getInternetHeaders();
        asObject.setFrom(this.getNormalizedHeader(headers, HEADER_AS2_FROM));
        asObject.setTo(this.getNormalizedHeader(headers, HEADER_AS2_TO));
        if (headers.getHeader(HEADER_AS2_VERSION) != null && headers.getHeader(HEADER_AS2_VERSION).length > 0) {
            ((IAS2Object)((Object)asObject)).setAS2Version(headers.getHeader(HEADER_AS2_VERSION)[0]);
        }
    }

    private String getNormalizedHeader(InternetHeaders headers, String headerName) throws MessagingException {
        if (headers.getHeader(headerName) != null && headers.getHeader(headerName).length > 0) {
            String value = headers.getHeader(headerName)[0];
            return AS2MessageHelper.normalize(value);
        }
        throw new MessagingException("No header '" + headerName + "' found.");
    }

    @Override
    protected String getUserAgent() {
        return USER_AGENT;
    }
}

