/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.adapter.test.config;

import de.pontonconsulting.xmlpipe.config.IServerConfigBean;
import de.pontonconsulting.xmlpipe.config.XpValidationEventHandler;
import de.pontonconsulting.xmlpipe.config.testadapter.TestAdapterConfig;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.ValidationEventHandler;
import java.io.FileNotFoundException;
import java.net.URL;

public class TestAdapterConfiguration {
    private static final String CONFIGURATION_FILE = "testadapter.xml";
    private static final String TESTADAPTER_CONFIG_PACKAGE = "de.pontonconsulting.xmlpipe.config.testadapter";
    private final URL _configFile = this.getClass().getClassLoader().getResource("testadapter.xml");
    private TestAdapterConfig _config;

    public TestAdapterConfiguration(IServerConfigBean serverConfig) throws JAXBException, FileNotFoundException {
        if (this._configFile == null) {
            throw new FileNotFoundException("File 'testadapter.xml' not found.");
        }
        this.loadConfigToMemory();
    }

    protected boolean loadConfigToMemory() throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((String)TESTADAPTER_CONFIG_PACKAGE);
        Unmarshaller u = jc.createUnmarshaller();
        XpValidationEventHandler validationEventHandler = new XpValidationEventHandler();
        u.setEventHandler((ValidationEventHandler)validationEventHandler);
        try {
            this._config = (TestAdapterConfig)u.unmarshal(this._configFile);
        }
        catch (JAXBException e) {
            if (validationEventHandler.getMessage() != null) {
                JAXBException je = new JAXBException("Xml Error in testadapter.xml (" + validationEventHandler.getLine() + ", " + validationEventHandler.getColumn() + "): " + validationEventHandler.getMessage());
                je.setStackTrace(e.getStackTrace());
                throw je;
            }
            if (e.getLinkedException() != null) {
                JAXBException je = new JAXBException("Xml Error in testadapter.xml: " + e.getLinkedException().getMessage());
                je.setStackTrace(e.getStackTrace());
                throw je;
            }
            throw e;
        }
        return true;
    }

    public int getMessengerPort() throws JAXBException {
        this.loadConfigToMemory();
        return this._config.getMessenger().getPortNumber();
    }

    public String getSampleFiles() throws JAXBException {
        this.loadConfigToMemory();
        return this._config.getFolders().getSampleFiles();
    }

    public void setSampleFiles(String sampleFiles) {
        this._config.getFolders().setSampleFiles(sampleFiles);
    }

    public String getInbox() throws JAXBException {
        this.loadConfigToMemory();
        return this._config.getFolders().getInbox();
    }

    public void setInbox(String inbox) {
        this._config.getFolders().setInbox(inbox);
    }

    public String getOutbox() throws JAXBException {
        this.loadConfigToMemory();
        return this._config.getFolders().getOutbox();
    }

    public void setOutbox(String outbox) {
        this._config.getFolders().setOutbox(outbox);
    }

    public String getWork() throws JAXBException {
        this.loadConfigToMemory();
        return this._config.getFolders().getWork();
    }

    public void setWork(String work) {
        this._config.getFolders().setWork(work);
    }

    public String getLog() throws JAXBException {
        this.loadConfigToMemory();
        return this._config.getFolders().getLog();
    }

    public void setLog(String log) {
        this._config.getFolders().setLog(log);
    }

    public boolean getXSLCaching() throws JAXBException {
        this.loadConfigToMemory();
        return this._config.isXSLCaching();
    }

    public void setXSLCaching(boolean xslCaching) {
        this._config.setXSLCaching(xslCaching);
    }
}

