/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.adapter.sampleadapter;

import de.pontonconsulting.xmlpipe.adapter.AdapterException;
import de.pontonconsulting.xmlpipe.adapter.GenericAdapter;
import de.pontonconsulting.xmlpipe.adapter.ISpecificAdapter;
import de.pontonconsulting.xmlpipe.adapter.MessageResult;
import de.pontonconsulting.xmlpipe.message.BackEndMessage;
import de.pontonconsulting.xmlpipe.message.BackEndMessageException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SampleAdapter
implements ISpecificAdapter {
    private Log _log;
    private GenericAdapter _ga;

    public static void main(String[] args) {
        SampleAdapter adapter = new SampleAdapter();
        adapter.partnerExistenceTest();
        adapter.getPartnerlistTest();
        adapter.sendTest();
        adapter.shutdown();
    }

    public SampleAdapter() {
        try {
            this._log = LogFactory.getFactory().getInstance(this.getID() + ".Main");
            this._log.debug((Object)"Initializing SampleAdapter");
            this._ga = new GenericAdapter(this.getID());
            this._ga.setServerPort(0);
            this._ga.setProcessingTimeout(1200);
            this._ga.setAdapterIP("127.0.0.1");
            this._ga.setEndAdapter((ISpecificAdapter)this);
            this._ga.addMessengerConnection("localhost", 8080, "/pontonxp/AdapterService");
        }
        catch (AdapterException ae) {
            this._log.fatal((Object)"Error while initializing SampleAdapter", (Throwable)ae);
        }
        catch (IOException ioe) {
            this._log.fatal((Object)"Error while initializing SampleAdapter", (Throwable)ioe);
        }
    }

    public int getNumberOfParallelThreads() {
        return 1;
    }

    public MessageResult receiveMessage(BackEndMessage message) {
        this._log.info((Object)("*** Receiving message: " + message.getTransferIDText()));
        this._log.info((Object)(" ** Conversation id: " + message.getConversationIDText()));
        this._log.info((Object)(" ** Local sender id: " + message.getSenderOrganisationText()));
        this._log.info((Object)(" ** Local receiver id: " + message.getReceiverOrganisationText()));
        this._log.info((Object)("*** # of attachments: " + message.getNumberOfAttachments()));
        String[] attachments = message.listAttachments();
        for (int i = 0; i < attachments.length; ++i) {
            File attachment = message.getAttachment(attachments[i]);
            this._log.info((Object)("  --> Attachment: " + attachment.getAbsolutePath()));
        }
        try {
            message.getMessageDocumentInputStream();
            message.writeMessageDocumentTo(new File("payload.xml"));
            message.writeBackEndMessageTo(new File("full.xml"));
            message.writeBackEndEnvelopeTo(new File("envelope.xml"));
        }
        catch (BackEndMessageException e) {
            e.printStackTrace();
        }
        return new MessageResult(MessageResult.MSG_SUCCESSFULLY_RECEIVED);
    }

    public MessageResult receiveTestMessage(BackEndMessage message) {
        return this.receiveMessage(message);
    }

    public MessageResult receiveAcknowledgement(BackEndMessage message) {
        return new MessageResult(MessageResult.MSG_SUCCESSFULLY_RECEIVED);
    }

    public boolean doSelfCheck() {
        return true;
    }

    public String getID() {
        return "sample-adapter";
    }

    public String getStatus() {
        return "SampleAdapter is ready to receive Messages.";
    }

    public String shutdown() {
        this._ga.shutdown();
        return null;
    }

    public File getWorkFolder() {
        return new File(".");
    }

    public boolean supportsAcknowledgements() {
        return false;
    }

    public boolean supportsAttachments() {
        return true;
    }

    public void sendTest() {
        try {
            BackEndMessage bem = new BackEndMessage(new File("webroot/WEB-INF/testadapter/samples/BE_PN21_InfoRequest_mini.xml"));
            bem.setSenderOrganisation("joerg");
            bem.setReceiverOrganisation("micha");
            bem.setDTDSet("papinet2.1");
            bem.setMessageName("PurchaseOrder");
            bem.setDTDVersionNumber("V2R10");
            bem.addAttachment(new File("test-resources/xp_logo.jpg"));
            bem.addAttachment(new File("test-resources/partners.xml"));
            this._log.info((Object)("*** attached files: " + bem.getNumberOfAttachments()));
            String[] attachments = bem.listAttachments();
            for (int i = 0; i < bem.getNumberOfAttachments(); ++i) {
                this._log.info((Object)("  --> names: " + attachments[i]));
            }
            this._ga.sendMessage(bem);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (AdapterException e) {
            e.printStackTrace();
        }
        catch (BackEndMessageException bme) {
            bme.printStackTrace();
        }
    }

    public void partnerExistenceTest() {
        try {
            for (int i = 0; i < 2000000; ++i) {
                this._ga.getFullPartnerList();
            }
        }
        catch (AdapterException e) {
            e.printStackTrace();
        }
    }

    public void getPartnerlistTest() {
        try {
            int i;
            String[] partners = this._ga.getFullPartnerList();
            for (i = 0; i < partners.length; ++i) {
                this._log.info((Object)("*** (all) Partner " + i + " has local id: " + partners[i]));
            }
            partners = this._ga.getLocalPartnerList();
            for (i = 0; i < partners.length; ++i) {
                this._log.info((Object)("*** (own) Partner " + i + " has local id: " + partners[i]));
            }
            partners = this._ga.getRemotePartnerList();
            for (i = 0; i < partners.length; ++i) {
                this._log.info((Object)("*** (remote) Partner " + i + " has local id: " + partners[i]));
            }
        }
        catch (AdapterException e) {
            e.printStackTrace();
        }
    }
}

