/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.adapter.pingall;

import de.pontonconsulting.xmlpipe.adapter.pingall.JmxPingAllMBean;
import de.pontonconsulting.xmlpipe.adapter.pingall.PingAllThread;
import de.pontonconsulting.xmlpipe.adapter.pingall.PingResult;
import de.pontonconsulting.xmlpipe.cluster.GlobalTaskManager;
import de.pontonconsulting.xmlpipe.messenger.database.GlobalTaskType;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JmxPingAll
implements JmxPingAllMBean {
    private static final String MBEAN_NAME = "de.ponton:type=PontonXP,name=PingAll";
    private static final Logger LOG = LogManager.getLogger((String)"Messenger.JmxPingAllThread");
    private final PingAllThread pingAllThread;
    private final GlobalTaskManager globalTaskManager;

    public JmxPingAll(PingAllThread pingAllThread, GlobalTaskManager globalTaskManager) throws NotCompliantMBeanException, InstanceAlreadyExistsException, MBeanRegistrationException, MalformedObjectNameException {
        this.pingAllThread = pingAllThread;
        this.globalTaskManager = globalTaskManager;
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        ObjectName pingAllName = new ObjectName(MBEAN_NAME);
        mBeanServer.registerMBean(this, pingAllName);
    }

    @Override
    public int getInterval() {
        return this.pingAllThread.getInterval();
    }

    @Override
    public boolean isEnabled() {
        return this.pingAllThread.isEnabled();
    }

    @Override
    public TabularData getPingResultsData() throws OpenDataException {
        TabularDataSupport tabularData = new TabularDataSupport(this.createTabularType());
        this.pingAllThread.getPingResults().forEach((key, pingResult) -> {
            try {
                this.putPingResultData((PingResult)pingResult, tabularData);
            }
            catch (OpenDataException e) {
                LOG.error("Could not update ping result data.", (Throwable)e);
            }
        });
        return tabularData;
    }

    private TabularType createTabularType() throws OpenDataException {
        String typeName = "PingResultCompositeType";
        String description = "Ping Result";
        String[] itemNames = new String[]{"SenderId", "ReceiverId", "URLType", "PingMessageId", "ReplyMessageId", "PingTime", "ReplyTime", "Duration", "Description", "Error"};
        String[] itemDescriptions = new String[]{"Sender Internal Id", "Receiver Internal Id", "Transport URL Type (primary or fallback)", "EbXML Ping Message Id", "EbXML Reply Message Id", "Creation Time of EbXML Ping", "Creation Time of EbXML Reply", "Milliseconds between Creation Time of EbXML Ping and Creation Time of EbXML Reply", "Reply Text", "Is the EbXML Reply an Error Message"};
        OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.DATE, SimpleType.DATE, SimpleType.INTEGER, SimpleType.STRING, SimpleType.BOOLEAN};
        CompositeType pingResultCompositeType = new CompositeType("PingResultCompositeType", "Ping Result", itemNames, itemDescriptions, itemTypes);
        String tabularTypeName = "PingResultsTabularType";
        String tabularTypeDescription = "Ping Results";
        String[] indexNames = new String[]{"SenderId", "ReceiverId", "URLType"};
        return new TabularType("PingResultsTabularType", "Ping Results", pingResultCompositeType, indexNames);
    }

    private void putPingResultData(PingResult pingResult, TabularData tabularData) throws OpenDataException {
        HashMap<String, Object> items = new HashMap<String, Object>();
        items.put("SenderId", pingResult.getSenderId());
        items.put("ReceiverId", pingResult.getReceiverId());
        items.put("URLType", pingResult.getUrlType());
        items.put("PingMessageId", pingResult.getPingMessageId());
        items.put("ReplyMessageId", pingResult.getReplyMessageId());
        items.put("PingTime", pingResult.getPingTime());
        items.put("ReplyTime", pingResult.getReplyTime());
        items.put("Duration", pingResult.getDuration());
        items.put("Description", pingResult.getDescription());
        items.put("Error", pingResult.isError());
        CompositeDataSupport pingResultData = new CompositeDataSupport(tabularData.getTabularType().getRowType(), items);
        tabularData.put(pingResultData);
    }

    @Override
    public int getPendingPings() {
        return this.pingAllThread.getPendingPings();
    }

    @Override
    public void wakeUpPingAll() {
        this.globalTaskManager.scheduleManualExecution(GlobalTaskType.PING_ALL);
    }
}

