/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.adapter.hotfolder.support;

import de.pontonconsulting.xmlpipe.adapter.hotfolder.HotFolderAdapter;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileFilter;
import org.apache.commons.lang3.StringUtils;

public class HotFolderFileFilter<T>
implements GenericFileFilter<T> {
    private File baseFolder;
    private boolean subdir = false;
    private List<String> extensions;
    private Integer minAge;

    public boolean accept(GenericFile<T> file) {
        long systemTime = System.currentTimeMillis();
        File realFile = (File)file.getFile();
        if (realFile.isDirectory()) {
            return true;
        }
        if (!realFile.exists()) {
            if (HotFolderAdapter.LOG.isTraceEnabled()) {
                HotFolderAdapter.LOG.trace("File will be ignored: {}, the file does not exist.", (Object)realFile.getAbsolutePath());
            }
            return false;
        }
        String lowercaseFileName = realFile.getName().toLowerCase();
        boolean found = false;
        for (String extension : this.getExtensions()) {
            if (!lowercaseFileName.endsWith("." + extension)) continue;
            found = true;
            break;
        }
        if (!found) {
            if (HotFolderAdapter.LOG.isTraceEnabled()) {
                HotFolderAdapter.LOG.trace("File will be ignored: {}, not acceptable file name: {}.", (Object)realFile.getAbsolutePath(), (Object)realFile.getName());
            }
            return false;
        }
        if (this.minAge != null) {
            long lastModified = realFile.lastModified();
            long fileAge = systemTime - lastModified;
            if (lastModified > 0L && this.minAge > 0 && (long)(this.minAge * 1000) >= fileAge) {
                if (HotFolderAdapter.LOG.isTraceEnabled()) {
                    HotFolderAdapter.LOG.trace("File will be ignored: {}, minimum age was too small {} ms.", (Object)realFile.getAbsolutePath(), (Object)fileAge);
                }
                return false;
            }
        }
        if (this.isSubdir()) {
            File partnerFolder = realFile.getParentFile();
            if (partnerFolder == null) {
                if (HotFolderAdapter.LOG.isTraceEnabled()) {
                    HotFolderAdapter.LOG.trace("File will be ignored: {}, no parent folder found.", (Object)realFile.getAbsolutePath());
                }
                return false;
            }
            File outboxFolder = partnerFolder.getParentFile();
            if (this.baseFolder.equals(outboxFolder)) {
                if (HotFolderAdapter.LOG.isTraceEnabled()) {
                    HotFolderAdapter.LOG.trace("File is included: {}", (Object)realFile.getAbsolutePath());
                }
                return true;
            }
        } else {
            File outboxFolder = realFile.getParentFile();
            if (this.baseFolder.equals(outboxFolder)) {
                if (HotFolderAdapter.LOG.isTraceEnabled()) {
                    HotFolderAdapter.LOG.trace("File is included: {}", (Object)realFile.getAbsolutePath());
                }
                return true;
            }
            if (HotFolderAdapter.LOG.isTraceEnabled()) {
                HotFolderAdapter.LOG.trace("File will be ignored: {}, baseFolder: {}, fileFolder: {}.", (Object)realFile.getAbsolutePath(), (Object)this.baseFolder, (Object)outboxFolder);
            }
            return false;
        }
        if (HotFolderAdapter.LOG.isTraceEnabled()) {
            HotFolderAdapter.LOG.trace("File will be ignored: {}", (Object)realFile.getAbsolutePath());
        }
        return false;
    }

    public File getBaseFolder() {
        return this.baseFolder;
    }

    public void setBaseFolder(File baseFolder) {
        this.baseFolder = baseFolder;
    }

    public List<String> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<String>();
        }
        return this.extensions;
    }

    public void addExtension(String extension) {
        if (StringUtils.isBlank((CharSequence)extension)) {
            return;
        }
        this.getExtensions().add(extension.toLowerCase());
    }

    public boolean isSubdir() {
        return this.subdir;
    }

    public void setSubdir(boolean subdir) {
        this.subdir = subdir;
    }

    public long getMinAge() {
        return this.minAge.intValue();
    }

    public void setMinAge(Integer minAge) {
        this.minAge = minAge;
    }
}

