/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.adapter.as4certificateupdate;

import de.pontonconsulting.xmlpipe.adapter.as4certificateupdate.AS4TestWorker;
import de.pontonconsulting.xmlpipe.config.IMessengerProperties;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AS4TestService {
    private static final Logger LOGGER = LogManager.getLogger((String)("Messenger." + AS4TestService.class.getName()));
    private static final int ONE_DAY_IN_SECONDS = 86400;
    private final AS4TestWorker as4TestWorker;
    private final ScheduledExecutorService scheduledExecutorService;
    private final IMessengerProperties messengerProperties;
    private ScheduledFuture<?> scheduledTask;

    public AS4TestService(AS4TestWorker as4TestWorker, ScheduledExecutorService scheduledExecutorService, IMessengerProperties properties) {
        this.as4TestWorker = as4TestWorker;
        this.scheduledExecutorService = scheduledExecutorService;
        this.messengerProperties = properties;
    }

    public synchronized void start() {
        if (this.scheduledTask == null) {
            String intervalString = this.messengerProperties.getProperty("ponton.messenger.cert_update_scheduler_interval_in_seconds", String.valueOf(86400));
            long period = 86400L;
            try {
                period = Long.parseLong(intervalString);
            }
            catch (NumberFormatException e) {
                LOGGER.warn("invalid value {} for {}, using default {}", (Object)intervalString, (Object)"ponton.messenger.cert_update_scheduler_interval_in_seconds", (Object)period);
            }
            LOGGER.info("execute AS4TestService every {} seconds", (Object)period);
            this.scheduledTask = this.scheduledExecutorService.scheduleAtFixedRate(this.as4TestWorker, 0L, period, TimeUnit.SECONDS);
        }
    }

    public void stop() {
        if (this.scheduledTask != null) {
            this.scheduledTask.cancel(true);
        }
    }
}

