/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.adapter.as4certificateupdate;

import de.pontonconsulting.xmlpipe.adapter.as4certificateupdate.AS4CertUpdateException;
import de.pontonconsulting.xmlpipe.adapter.as4certificateupdate.AS4CertUpdateExceptionTuple;
import de.pontonconsulting.xmlpipe.admintool.InstallCertException;
import de.pontonconsulting.xmlpipe.cpa.Communication;
import de.pontonconsulting.xmlpipe.cpp.CppPartner;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.messenger.packaging.AS4CertificateUpdateUtility;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;

public class AS4CertificateUpdateValidator {
    private static final Logger LOG = LogManager.getLogger((String)("Messenger." + AS4CertificateUpdateValidator.class.getName()));
    private static final String REJECTED_CERT_UPDATE_REQUEST_REASON = "Rejected cert update request, reason {}";
    private final AS4CertificateUpdateUtility as4CertificateUpdateUtility;
    private final CertificateUtility certificateUtility;
    private final Profiles profiles;

    public AS4CertificateUpdateValidator(AS4CertificateUpdateUtility as4CertificateUpdateUtility, CertificateUtility certificateUtility, Profiles profiles) {
        this.as4CertificateUpdateUtility = as4CertificateUpdateUtility;
        this.certificateUtility = certificateUtility;
        this.profiles = profiles;
    }

    Optional<AS4CertUpdateExceptionTuple> validateCertUpdateRequestMessage(Communication communication, String currentAgreementRef, Document certUpdateRequestDocument) throws CertificateException, InstallCertException, NoSuchProviderException, ProfileException {
        boolean certificateUpdateEnabled = this.as4CertificateUpdateUtility.isCertificateUpdateEnabledForCommunication(communication);
        if (!certificateUpdateEnabled) {
            String description = "Received a cert update request, which was not expected.";
            LOG.debug(REJECTED_CERT_UPDATE_REQUEST_REASON, (Object)"Received a cert update request, which was not expected.");
            return Optional.of(new AS4CertUpdateExceptionTuple(AS4CertUpdateException.AgreementMismatch, "Received a cert update request, which was not expected."));
        }
        Optional<String> referenceID = this.as4CertificateUpdateUtility.receiveTextContentFromBackendMessage(certUpdateRequestDocument, "http://docs.oasis-open.org/ebcore/ns/AgreementUpdate/v1.0", "ID");
        if (referenceID.isEmpty()) {
            String description = "No ID to reference given.";
            LOG.debug(REJECTED_CERT_UPDATE_REQUEST_REASON, (Object)"No ID to reference given.");
            return Optional.of(new AS4CertUpdateExceptionTuple(AS4CertUpdateException.MessageRejected, "No ID to reference given."));
        }
        return Stream.of(this.validateTimeStamps(certUpdateRequestDocument), this.validateAgreementIdentifier(currentAgreementRef, certUpdateRequestDocument), this.validateKeyInfo(communication, certUpdateRequestDocument)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    private Optional<AS4CertUpdateExceptionTuple> validateTimeStamps(Document certUpdateRequestDocument) {
        Optional<AS4CertUpdateExceptionTuple> timeStampValidation;
        OffsetDateTime now = OffsetDateTime.now(ZoneOffset.UTC);
        Optional<String> activateByString = this.as4CertificateUpdateUtility.receiveTextContentFromBackendMessage(certUpdateRequestDocument, "http://docs.oasis-open.org/ebcore/ns/AgreementUpdate/v1.0", "ActivateBy");
        if (activateByString.isPresent()) {
            Optional<String> expireByString;
            OffsetDateTime activateBy = OffsetDateTime.parse(activateByString.get());
            timeStampValidation = Optional.ofNullable(this.validateTimeStampsActivateBy(activateBy, now));
            Optional<String> respondByString = this.as4CertificateUpdateUtility.receiveTextContentFromBackendMessage(certUpdateRequestDocument, "http://docs.oasis-open.org/ebcore/ns/AgreementUpdate/v1.0", "RespondBy");
            if (respondByString.isPresent()) {
                timeStampValidation = Optional.ofNullable(this.validateTimeStampsRespondBy(respondByString.get(), now));
            }
            if ((expireByString = this.as4CertificateUpdateUtility.receiveTextContentFromBackendMessage(certUpdateRequestDocument, "http://docs.oasis-open.org/ebcore/ns/AgreementUpdate/v1.0", "ExpireBy")).isPresent()) {
                timeStampValidation = Optional.ofNullable(this.validateTimeStampsExpireBy(expireByString.get(), activateBy, now));
            }
        } else {
            String description = "ActivateBy is absent.";
            LOG.debug(REJECTED_CERT_UPDATE_REQUEST_REASON, (Object)"ActivateBy is absent.");
            return Optional.of(new AS4CertUpdateExceptionTuple(AS4CertUpdateException.ActivateByRejected, "ActivateBy is absent."));
        }
        return timeStampValidation;
    }

    private AS4CertUpdateExceptionTuple validateTimeStampsExpireBy(String expireByString, OffsetDateTime activateBy, OffsetDateTime now) {
        OffsetDateTime expireBy = OffsetDateTime.parse(expireByString);
        if (expireBy.isBefore(now)) {
            String description = "ExpireBy is in the past.";
            LOG.debug(REJECTED_CERT_UPDATE_REQUEST_REASON, (Object)"ExpireBy is in the past.");
            return new AS4CertUpdateExceptionTuple(AS4CertUpdateException.ExpireByRejected, "ExpireBy is in the past.");
        }
        if (expireBy.isBefore(activateBy)) {
            String description = "ExpireBy is in before ActivateBy.";
            LOG.debug(REJECTED_CERT_UPDATE_REQUEST_REASON, (Object)"ExpireBy is in before ActivateBy.");
            return new AS4CertUpdateExceptionTuple(AS4CertUpdateException.ExpireByRejected, "ExpireBy is in before ActivateBy.");
        }
        return null;
    }

    private AS4CertUpdateExceptionTuple validateTimeStampsRespondBy(String respondByString, OffsetDateTime now) {
        OffsetDateTime respondBy = OffsetDateTime.parse(respondByString);
        if (respondBy.isBefore(now)) {
            String description = "RespondBy is in the past.";
            LOG.debug(REJECTED_CERT_UPDATE_REQUEST_REASON, (Object)"RespondBy is in the past.");
            return new AS4CertUpdateExceptionTuple(AS4CertUpdateException.RespondByRejected, "RespondBy is in the past.");
        }
        return null;
    }

    private AS4CertUpdateExceptionTuple validateTimeStampsActivateBy(OffsetDateTime activateBy, OffsetDateTime now) {
        if (activateBy.isBefore(now)) {
            String description = "ActivateBy is in the past.";
            LOG.debug(REJECTED_CERT_UPDATE_REQUEST_REASON, (Object)"ActivateBy is in the past.");
            return new AS4CertUpdateExceptionTuple(AS4CertUpdateException.ActivateByRejected, "ActivateBy is in the past.");
        }
        if (activateBy.isBefore(now.plusDays(1L))) {
            String description = "ActivateBy is due less than one day.";
            LOG.debug(REJECTED_CERT_UPDATE_REQUEST_REASON, (Object)"ActivateBy is due less than one day.");
            return new AS4CertUpdateExceptionTuple(AS4CertUpdateException.ActivateByRejected, "ActivateBy is due less than one day.");
        }
        return null;
    }

    private Optional<AS4CertUpdateExceptionTuple> validateAgreementIdentifier(String currentAgreementRef, Document certUpdateRequestDocument) {
        Optional<String> currentAgreementIdentifier = this.as4CertificateUpdateUtility.receiveTextContentFromBackendMessage(certUpdateRequestDocument, "http://docs.oasis-open.org/ebcore/ns/AgreementUpdate/v1.0", "CurrentAgreementIdentifier");
        if (currentAgreementIdentifier.isPresent()) {
            if (!currentAgreementIdentifier.get().equals(currentAgreementRef)) {
                String description = "The Agreement update request has a value for current agreement identifier that is unknown.";
                LOG.debug(REJECTED_CERT_UPDATE_REQUEST_REASON, (Object)"The Agreement update request has a value for current agreement identifier that is unknown.");
                return Optional.of(new AS4CertUpdateExceptionTuple(AS4CertUpdateException.UnknownAgreement, "The Agreement update request has a value for current agreement identifier that is unknown."));
            }
        } else {
            String description = "The Agreement update request has no value for current agreement identifier.";
            LOG.debug(REJECTED_CERT_UPDATE_REQUEST_REASON, (Object)"The Agreement update request has no value for current agreement identifier.");
            return Optional.of(new AS4CertUpdateExceptionTuple(AS4CertUpdateException.UnknownAgreement, "The Agreement update request has no value for current agreement identifier."));
        }
        Optional<String> updatedAgreementIdentifier = this.as4CertificateUpdateUtility.receiveTextContentFromBackendMessage(certUpdateRequestDocument, "http://docs.oasis-open.org/ebcore/ns/AgreementUpdate/v1.0", "UpdatedAgreementIdentifier");
        if (updatedAgreementIdentifier.isPresent()) {
            if (updatedAgreementIdentifier.get().length() > 50) {
                String description = "Lenght of the Updated Agreement Indentifier is more than 50, which is a security breach.";
                LOG.debug(REJECTED_CERT_UPDATE_REQUEST_REASON, (Object)"Lenght of the Updated Agreement Indentifier is more than 50, which is a security breach.");
                return Optional.of(new AS4CertUpdateExceptionTuple(AS4CertUpdateException.InvalidUpdatedAgreement, "Lenght of the Updated Agreement Indentifier is more than 50, which is a security breach."));
            }
        } else {
            String description = "The agreement update request has no value for updated agreement identifier.";
            LOG.debug(REJECTED_CERT_UPDATE_REQUEST_REASON, (Object)"The agreement update request has no value for updated agreement identifier.");
            return Optional.of(new AS4CertUpdateExceptionTuple(AS4CertUpdateException.InvalidUpdatedAgreement, "The agreement update request has no value for updated agreement identifier."));
        }
        return Optional.empty();
    }

    private Optional<AS4CertUpdateExceptionTuple> validateKeyInfo(Communication communication, Document certUpdateRequestDocument) throws ProfileException, CertificateException, NoSuchProviderException, InstallCertException {
        Optional<String> x509CertificateBase64 = this.as4CertificateUpdateUtility.receiveTextContentFromBackendMessage(certUpdateRequestDocument, "http://www.w3.org/2000/09/xmldsig#", "X509Certificate");
        if (x509CertificateBase64.isPresent()) {
            Optional<String> digestOfCurrentCertificateFromMessage;
            String currentDefaultCertRefId;
            X509Certificate x509CertificateUpdate = this.certificateUtility.getX509Certificate(x509CertificateBase64.get());
            if (!this.certificateUtility.isCertValid(x509CertificateUpdate)) {
                String description = "Certificate is expired.";
                LOG.debug(REJECTED_CERT_UPDATE_REQUEST_REASON, (Object)"Certificate is expired.");
                return Optional.of(new AS4CertUpdateExceptionTuple(AS4CertUpdateException.CertificateRejected, "Certificate is expired."));
            }
            CppPartner sender = this.profiles.getProfileForLocalId(communication.getSender().getId(), true);
            X509Certificate currentDefaultCertificate = sender.getX509Certificate(currentDefaultCertRefId = sender.getDefaultCertRefId());
            String digestOfCurrentCertificate = this.as4CertificateUpdateUtility.getDigestOfCertificateBase64Encoded(currentDefaultCertificate);
            if (!digestOfCurrentCertificate.equals((digestOfCurrentCertificateFromMessage = this.as4CertificateUpdateUtility.receiveTextContentFromBackendMessage(certUpdateRequestDocument, "http://www.w3.org/2009/xmldsig11#", "X509Digest")).orElse("null"))) {
                String description = "The certificate update request references a current certificate that is unknown, or unknown in the context of the current agreement.";
                LOG.debug(REJECTED_CERT_UPDATE_REQUEST_REASON, (Object)"The certificate update request references a current certificate that is unknown, or unknown in the context of the current agreement.");
                return Optional.of(new AS4CertUpdateExceptionTuple(AS4CertUpdateException.UnknownCurrentCertificate, "The certificate update request references a current certificate that is unknown, or unknown in the context of the current agreement."));
            }
        } else {
            String description = "The X509Certificate cannot be extracted from certificate update request.";
            LOG.debug(REJECTED_CERT_UPDATE_REQUEST_REASON, (Object)"The X509Certificate cannot be extracted from certificate update request.");
            return Optional.of(new AS4CertUpdateExceptionTuple(AS4CertUpdateException.InvalidMessage, "The X509Certificate cannot be extracted from certificate update request."));
        }
        Optional<String> x509IssuerSerial = this.as4CertificateUpdateUtility.receiveTextContentFromBackendMessage(certUpdateRequestDocument, "http://www.w3.org/2000/09/xmldsig#", "X509IssuerSerial");
        Optional<String> pgpData = this.as4CertificateUpdateUtility.receiveTextContentFromBackendMessage(certUpdateRequestDocument, "http://www.w3.org/2000/09/xmldsig#", "PGPData");
        Optional<String> mgmtData = this.as4CertificateUpdateUtility.receiveTextContentFromBackendMessage(certUpdateRequestDocument, "http://www.w3.org/2000/09/xmldsig#", "MgmtData");
        Optional<String> spkiData = this.as4CertificateUpdateUtility.receiveTextContentFromBackendMessage(certUpdateRequestDocument, "http://www.w3.org/2000/09/xmldsig#", "SPKIData");
        if (x509IssuerSerial.isPresent() || pgpData.isPresent() || mgmtData.isPresent() || spkiData.isPresent()) {
            String description = "The content of the KeyInfo element contains at least one forbidden element: X509IssuerSerial, PGPData, MgmtData, SPKIData";
            LOG.debug(REJECTED_CERT_UPDATE_REQUEST_REASON, (Object)"The content of the KeyInfo element contains at least one forbidden element: X509IssuerSerial, PGPData, MgmtData, SPKIData");
            return Optional.of(new AS4CertUpdateExceptionTuple(AS4CertUpdateException.InvalidKeyInfo, "The content of the KeyInfo element contains at least one forbidden element: X509IssuerSerial, PGPData, MgmtData, SPKIData"));
        }
        return Optional.empty();
    }
}

