/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.adapter.as4certificateupdate;

import de.pontonconsulting.xmlpipe.cpa.Agreement;
import de.pontonconsulting.xmlpipe.cpa.AgreementException;
import de.pontonconsulting.xmlpipe.cpa.Communication;
import de.pontonconsulting.xmlpipe.cpp.CppPartner;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.message.BackEndMessage;
import de.pontonconsulting.xmlpipe.message.BackEndMessageException;
import de.pontonconsulting.xmlpipe.messenger.IdGenerator;
import de.pontonconsulting.xmlpipe.messenger.packaging.AS4CertificateUpdateUtility;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.GeneralSecurityException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AS4CertificateUpdateBackendMessageGenerator {
    private static final Logger LOG = LogManager.getLogger((String)("Messenger." + AS4CertificateUpdateBackendMessageGenerator.class.getName()));
    private final AS4CertificateUpdateUtility as4CertificateUpdateUtility;
    private final IdGenerator idGenerator;
    private final Profiles profiles;

    public AS4CertificateUpdateBackendMessageGenerator(AS4CertificateUpdateUtility as4CertificateUpdateUtility, IdGenerator idGenerator, Profiles profiles) {
        this.as4CertificateUpdateUtility = as4CertificateUpdateUtility;
        this.idGenerator = idGenerator;
        this.profiles = profiles;
    }

    BackEndMessage generateUpdateRequestMessage(CppPartner sender, String certId, Agreement agreement, File workFolder) {
        try {
            CppPartner receiver = this.profiles.getProfileForLocalId(agreement.getOwnPartner().getId(), true).getInternalId().equals(sender.getInternalId()) ? this.profiles.getProfileForLocalId(agreement.getCommunicationPartner().getId(), true) : this.profiles.getProfileForLocalId(agreement.getOwnPartner().getId(), true);
            Communication communication = agreement.getCommunication(sender.getLocalId(), receiver.getLocalId());
            boolean certificateUpdate = this.as4CertificateUpdateUtility.isCertificateUpdateEnabledForCommunication(communication);
            if (certificateUpdate) {
                LOG.info("Send AS4 Certificate Update Message from {} to {}", (Object)sender.getLocalId(), (Object)receiver.getLocalId());
                agreement.setAS4CertUpdateID(certId);
                agreement.setAS4UpdatedAgreementRef(sender.getInternalId() + "-" + receiver.getInternalId() + "-" + certId);
                agreement.setAS4UpdatedAgreementInboundTestSuccessful(false);
                agreement.setAS4UpdatedAgreementOutboundTestSuccessful(false);
                agreement.setAS4CertUpdateInitiator(sender.getInternalId());
                String currentAgreementRefType = this.as4CertificateUpdateUtility.getCurrentAgreementRefType(communication);
                agreement.setAS4UpdatedAgreementRefType(currentAgreementRefType);
                agreement.save();
                File certUpdateRequestPayload = this.as4CertificateUpdateUtility.createCertificateUpdateRequest(communication, certId, this.idGenerator.generateMessageId(), workFolder);
                BackEndMessage backendMessage = new BackEndMessage(certUpdateRequestPayload, true);
                backendMessage.setSenderOrganisation(sender.getInternalId());
                backendMessage.setReceiverOrganisation(receiver.getInternalId());
                backendMessage.setMessageName("CertUpdateRequest");
                backendMessage.setDTDSet("AgreementUpdate");
                backendMessage.setDTDVersionNumber("2.1");
                return backendMessage;
            }
        }
        catch (AgreementException | ProfileException | BackEndMessageException | GeneralSecurityException | ParserConfigurationException | TransformerException e) {
            LOG.error("Error while sending certificate update message", e);
        }
        return null;
    }

    BackEndMessage generateAS4TestMessage(CppPartner sender, CppPartner receiver, Agreement agreement, File workFolder) {
        try {
            File file = new File(workFolder, "as4ping.xml");
            Files.write(file.toPath(), "<?xml version=\"1.0\" encoding=\"UTF-8\"?><AS4PingMessage/>".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            BackEndMessage testMessage = new BackEndMessage(file);
            testMessage.setSenderOrganisation(sender.getInternalId());
            testMessage.setReceiverOrganisation(receiver.getInternalId());
            testMessage.setMessageName("PING");
            testMessage.setDTDSet("ponton");
            testMessage.setDTDVersionNumber("2.1");
            testMessage.addProcessingDirective("agreementRef", agreement.getAS4UpdatedAgreementRef());
            testMessage.addProcessingDirective("/AgreementRef", agreement.getAS4UpdatedAgreementRef());
            return testMessage;
        }
        catch (BackEndMessageException | IOException e) {
            LOG.error("Cannot send as4 test message", e);
            return null;
        }
    }
}

