/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.activation;

import de.pontonconsulting.activation.AbstractModel;
import de.pontonconsulting.activation.Activation;
import de.pontonconsulting.activation.ActivationException;
import de.pontonconsulting.activation.ActivationManager;
import de.pontonconsulting.activation.License;
import de.pontonconsulting.activation.ProductIdentification;
import de.pontonconsulting.xmlpipe.Constants;
import de.pontonconsulting.xmlpipe.activation.ClusterModeException;
import de.pontonconsulting.xmlpipe.activation.GracePeriodCalculator;
import de.pontonconsulting.xmlpipe.activation.NetInterface;
import de.pontonconsulting.xmlpipe.activation.NetworkCards;
import de.pontonconsulting.xmlpipe.admintool.InstallCertException;
import de.pontonconsulting.xmlpipe.config.ActivationKeystoreBean;
import de.pontonconsulting.xmlpipe.config.IServerConfigBean;
import de.pontonconsulting.xmlpipe.config.KeystoreBean;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.events.activation.ActivationDeletedEvent;
import de.pontonconsulting.xmlpipe.events.activation.ActivationInstalledEvent;
import de.pontonconsulting.xmlpipe.events.activation.LicenseDeletedEvent;
import de.pontonconsulting.xmlpipe.events.activation.LicenseInstalledEvent;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.MessengerLicense;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerActivationDAO;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import de.pontonconsulting.xmlpipe.security.PontonKeystore;
import jakarta.annotation.PostConstruct;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class MessengerActivation
extends ActivationManager {
    private static final Logger LOGGER = LogManager.getLogger((String)"Messenger.MessengerActivation");
    private static final String SHA_256 = "SHA-256";
    private static final int DEFAULT_MAX_LOCAL_PARTNER_TRIAL = 2;
    private static final int DEFAULT_MAX_REMOTE_PARTNER_TRIAL = 5;
    private final ReferenceDateTask referenceDateTask;
    private final KeystoreBean pontonKeyStoreBean;
    private final ActivationKeystoreBean activationKeyStoreBean;
    private final IServerConfigBean serverConfigBean;
    private final CertificateUtility certificateUtility;
    private final NetworkCards networkCards;
    private final ApplicationEventPublisher applicationEventPublisher;
    private String instanceAlias = null;
    private final GracePeriodCalculator gracePeriodCalculator;
    private String instanceId = null;
    private String clusterId = null;
    private int messengerId = -1;
    private final MessengerActivationDAO messengerActivationDAO;
    private final MessengerConfig messengerConfig;
    private final KeyFactory keyFactory = KeyFactory.getInstance("RSA");
    private final int maxRemotePartnerTrial = 5;
    private final int maxLocalPartnerTrial = 2;
    private final ReadWriteLock rwLockForKeyStore = new ReentrantReadWriteLock();
    private final Lock readLock = this.rwLockForKeyStore.readLock();
    private final Lock writeLock = this.rwLockForKeyStore.writeLock();
    private final AtomicReference<X509Certificate> activationCertificate = new AtomicReference();
    private final AtomicReference<OffsetDateTime> activationCertificateTimestamp = new AtomicReference();
    private final AtomicReference<X509Certificate> licenseCertificate = new AtomicReference();
    private final AtomicReference<OffsetDateTime> licenseCertificateTimestamp = new AtomicReference();

    public MessengerActivation(ReferenceDateTask referenceDateTask, KeystoreBean pontonKeyStoreBean, ActivationKeystoreBean activationKeyStoreBean, IServerConfigBean serverConfigBean, CertificateUtility certificateUtility, NetworkCards networkCards, ApplicationEventPublisher eventPublished, GracePeriodCalculator gracePeriodCalculator, MessengerActivationDAO messengerActivationDAO, MessengerConfig messengerConfig) throws NoSuchAlgorithmException {
        this.referenceDateTask = referenceDateTask;
        this.pontonKeyStoreBean = pontonKeyStoreBean;
        this.activationKeyStoreBean = activationKeyStoreBean;
        this.serverConfigBean = serverConfigBean;
        this.certificateUtility = certificateUtility;
        this.networkCards = networkCards;
        this.applicationEventPublisher = eventPublished;
        this.gracePeriodCalculator = gracePeriodCalculator;
        this.messengerActivationDAO = messengerActivationDAO;
        this.messengerConfig = messengerConfig;
    }

    @PostConstruct
    public void init() throws ActivationException, NoSuchAlgorithmException, CertificateEncodingException, KeyStoreException, UnrecoverableKeyException {
        String keyPassword = this.generateKeyPassword();
        this.instanceAlias = this.generateInstanceAlias(keyPassword);
        LOGGER.debug("Instance alias is {}", (Object)this.instanceAlias);
        this.importAncientLicenseFromPontonKeyStore();
        this.importAncientMessengerActivationFromPontonKeyStore(keyPassword);
        this.checkClusterModeConformity();
        this.clusterId = this.checkAndCreateClusterProductIdentification();
        this.instanceId = this.checkAndCreateMessengerProductIdentification();
        this.messengerId = this.messengerActivationDAO.storeInstanceId(this.instanceAlias, this.instanceId, "SYSTEM", this.networkCards.getDefaultInetAddress().getHostAddress());
        try {
            this.messengerConfig.setClusterEnabled(this.isClusterModeEnabled());
        }
        catch (ActivationException e) {
            LOGGER.error("Error checking ClusterMode: {}", (Object)e.toString());
        }
        this.messengerConfig.setMessengerId(this.messengerId);
        LOGGER.info("MessengerActivation initialized (InstanceId:{} / InstanceAlias:{} / MessengerId:{} / ClusterId:{})", (Object)this.instanceId, (Object)this.instanceAlias, (Object)this.messengerId, (Object)this.clusterId);
    }

    private void importAncientLicenseFromPontonKeyStore() throws CertificateEncodingException, KeyStoreException {
        if (!this.messengerActivationDAO.doesMessengerLicenseExist()) {
            X509Certificate licenseCert = this.pontonKeyStoreBean.getKeystore().getLicenseCert();
            if (Objects.nonNull(licenseCert)) {
                this.messengerActivationDAO.storeMessengerLicense(licenseCert, "SYSTEM");
                this.pontonKeyStoreBean.getKeystore().deleteLicenseCert();
            } else {
                LOGGER.warn("Found no license certificate to import from keystore");
            }
        }
    }

    private void importAncientMessengerActivationFromPontonKeyStore(String keyPassword) throws CertificateEncodingException, KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException {
        if (!this.messengerActivationDAO.doesMessengerActivationExist(this.instanceAlias)) {
            X509Certificate activationCert = this.pontonKeyStoreBean.getKeystore().getInstanceActivationCert(this.instanceAlias);
            if (Objects.nonNull(activationCert)) {
                this.messengerActivationDAO.storeMessengerActivation(activationCert.getEncoded(), this.instanceAlias, "SYSTEM");
                this.pontonKeyStoreBean.getKeystore().deleteInstanceActivation(this.instanceAlias);
            } else {
                LOGGER.warn("Found no activation cert to import from key in keystore for instanceAlias: {}", (Object)this.instanceAlias);
            }
            PrivateKey productKey = this.pontonKeyStoreBean.getKeystore().getInstanceProductKey(keyPassword.toCharArray(), this.instanceAlias);
            X509Certificate productCert = this.pontonKeyStoreBean.getKeystore().getInstanceProductCert(this.instanceAlias);
            if (productKey != null && productCert != null) {
                this.messengerActivationDAO.storeInstanceProductKey(productKey.getEncoded(), productCert.getEncoded(), this.instanceAlias, "SYSTEM");
                this.pontonKeyStoreBean.getKeystore().deleteInstanceProductKey(this.instanceAlias);
            } else {
                LOGGER.warn("Found no ProductIdentifier to import from keystore for instanceAlias: {}", (Object)this.instanceAlias);
            }
        }
    }

    private void checkClusterModeConformity() {
        try {
            String otherActiveInstanceAlias;
            if (!this.isClusterModeEnabled() && Objects.nonNull(otherActiveInstanceAlias = this.messengerActivationDAO.getOtherActiveActivationInstanceAlias(this.instanceAlias))) {
                throw new ClusterModeException("Can't start this instance (" + this.instanceAlias + ") because ClusterMode is NOT enabled in current license and another active instance was found (" + otherActiveInstanceAlias + ").");
            }
        }
        catch (ActivationException e) {
            throw new ClusterModeException("ClusterMode capability of license can't be checked: " + e.getMessage());
        }
    }

    @Scheduled(fixedRate=1L, timeUnit=TimeUnit.MINUTES)
    public void storeHeartBeat() {
        this.messengerActivationDAO.storeHeartBeat(this.instanceAlias);
    }

    private String buildAuthenticationId(X509Certificate x509Certificate) {
        byte[] publicKey = x509Certificate.getPublicKey().getEncoded();
        byte[] keyHash = this.digestPublicKey(publicKey);
        return Base64.getUrlEncoder().encodeToString(keyHash).substring(0, 16);
    }

    private byte[] digestPublicKey(byte[] publicKey) {
        try {
            MessageDigest crc = MessageDigest.getInstance(SHA_256);
            crc.update(publicKey);
            return crc.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private PontonKeystore getActivationKeystore() {
        return this.activationKeyStoreBean.getKeystore();
    }

    protected Date getReferenceDate() {
        return this.referenceDateTask.getReferenceDate();
    }

    public String getProductName() {
        return Constants.getXP_NAME();
    }

    public String getProductVersion() {
        return Constants.getXP_VERSION();
    }

    public X500Principal getRequestSubject() {
        return new X500Principal("CN=X/P Messenger");
    }

    public void storeActivationCert(X509Certificate certificate) throws ActivationException {
        LOGGER.trace("Try to install activation: {}", (Object)this.certificateUtility.toUsingInfoText(certificate));
        this.writeLock.lock();
        try {
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            this.messengerActivationDAO.storeMessengerActivation(certificate.getEncoded(), this.instanceAlias, authentication != null ? authentication.getName() : "SYSTEM");
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new ActivationInstalledEvent((Object)this, new Activation(certificate)));
            LOGGER.trace("Successfully installed activation: {}", (Object)this.certificateUtility.toUsingInfoText(certificate));
        }
        catch (CertificateEncodingException e) {
            LOGGER.error(e.toString());
            ActivationException ae = new ActivationException(1019L, "could not store activation");
            ae.setStackTrace(e.getStackTrace());
            throw ae;
        }
        finally {
            this.writeLock.unlock();
        }
        try {
            this.syncActivationCert();
        }
        catch (InstallCertException | NoSuchProviderException | CertificateException e) {
            LOGGER.error(e.toString());
        }
    }

    public void storeLicenseCert(X509Certificate certificate) throws ActivationException {
        this.writeLock.lock();
        try {
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            this.messengerActivationDAO.storeMessengerLicense(certificate, authentication != null ? authentication.getName() : "SYSTEM");
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new LicenseInstalledEvent((Object)this, new License(certificate, this.getLicenseCA())));
        }
        catch (CertificateEncodingException e) {
            LOGGER.error(e.toString());
            ActivationException ae = new ActivationException(1021L, "could not store license certificate");
            ae.setStackTrace(e.getStackTrace());
            throw ae;
        }
        finally {
            this.writeLock.unlock();
        }
        try {
            this.syncLicenseCert();
        }
        catch (InstallCertException | NoSuchProviderException | CertificateException e) {
            LOGGER.error(e.toString());
        }
    }

    public void storeProductKey(PrivateKey privateKey, X509Certificate certificate) throws ActivationException {
        this.writeLock.lock();
        try {
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            String userName = authentication != null ? authentication.getName() : "SYSTEM";
            this.messengerActivationDAO.storeInstanceProductKey(privateKey.getEncoded(), certificate.getEncoded(), this.instanceAlias, userName);
        }
        catch (GeneralSecurityException e) {
            throw new ActivationException(1017L, "could not store product identification", (Throwable)e);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public String storeClusterProductKey(PrivateKey privateKey, X509Certificate certificate) throws ActivationException {
        try {
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            String userName = authentication != null ? authentication.getName() : "SYSTEM";
            String clusterId = this.buildAuthenticationId(certificate);
            this.messengerActivationDAO.storeClusterProductKey(privateKey.getEncoded(), certificate.getEncoded(), clusterId, userName);
            return clusterId;
        }
        catch (Exception e) {
            throw new ActivationException(1017L, "could not store product identification", (Throwable)e);
        }
    }

    private String generateKeyPassword() throws NoSuchAlgorithmException {
        NetInterface networkInterface = this.networkCards.getDefaultInterface();
        byte[] mac = networkInterface.getHardwareAddress();
        MessageDigest digester = MessageDigest.getInstance(SHA_256);
        digester.update(mac);
        digester.update(Integer.toString(this.serverConfigBean.getRESTport()).getBytes());
        byte[] hash = digester.digest();
        return new String(Hex.encodeHex((byte[])hash));
    }

    private String generateInstanceAlias(String password) throws NoSuchAlgorithmException {
        MessageDigest digester = MessageDigest.getInstance(SHA_256);
        byte[] hash = digester.digest(password.getBytes());
        return new String(Hex.encodeHex((byte[])hash));
    }

    public void deleteLicense() {
        LOGGER.info("Deleting license.");
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        this.writeLock.lock();
        try {
            this.messengerActivationDAO.storeMessengerLicense(null, authentication != null ? authentication.getName() : "SYSTEM");
        }
        catch (CertificateEncodingException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.writeLock.unlock();
        }
        try {
            this.syncLicenseCert();
        }
        catch (InstallCertException | NoSuchProviderException | CertificateException e) {
            LOGGER.error(e.toString());
        }
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new LicenseDeletedEvent((Object)this));
    }

    public void deleteActivation() {
        LOGGER.info("Deleting activation.");
        this.writeLock.lock();
        try {
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            this.messengerActivationDAO.removeActivation(this.instanceAlias, authentication != null ? authentication.getName() : "SYSTEM");
        }
        finally {
            this.writeLock.unlock();
        }
        try {
            this.syncActivationCert();
        }
        catch (InstallCertException | NoSuchProviderException | CertificateException e) {
            LOGGER.error(e.toString());
        }
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new ActivationDeletedEvent((Object)this));
    }

    public X509Certificate getProductIdentificationCert() throws ActivationException {
        return this.getProductIdentificationCert(this.messengerActivationDAO.loadMessengerProductIdentifierCert(this.instanceAlias));
    }

    public X509Certificate getClusterProductIdentificationCert() throws ActivationException {
        return this.getProductIdentificationCert(this.messengerActivationDAO.loadClusterProductIdentifierCert());
    }

    private X509Certificate getProductIdentificationCert(byte[] productCertificate) throws ActivationException {
        try {
            if (Objects.isNull(productCertificate) || productCertificate.length == 0) {
                return null;
            }
            return this.certificateUtility.getX509Certificate(productCertificate);
        }
        catch (InstallCertException | GeneralSecurityException e) {
            LOGGER.error(e.toString());
            ActivationException ae = new ActivationException(1011L, "could not get product identification certificate");
            ae.setStackTrace(e.getStackTrace());
            throw ae;
        }
    }

    public PrivateKey getProductIdentificationPK() throws ActivationException {
        this.writeLock.lock();
        try {
            PrivateKey privateKey = this.getProductIdentificationPK(this.messengerActivationDAO.loadMessengerProductIdentifierKey(this.instanceAlias));
            return privateKey;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public PrivateKey getClusterProductIdentificationPK() throws ActivationException {
        this.writeLock.lock();
        try {
            PrivateKey privateKey = this.getProductIdentificationPK(this.messengerActivationDAO.loadClusterProductIdentifierKey());
            return privateKey;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private PrivateKey getProductIdentificationPK(byte[] productKey) throws ActivationException {
        try {
            if (Objects.isNull(productKey) || productKey.length == 0) {
                return null;
            }
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(productKey);
            return this.keyFactory.generatePrivate(keySpec);
        }
        catch (GeneralSecurityException e) {
            throw new ActivationException(1023L, "could not get product identification key", (Throwable)e);
        }
    }

    public X509Certificate getLicenseCert() throws ActivationException {
        this.readLock.lock();
        try {
            Optional<OffsetDateTime> timestampForMessengerLicense = this.messengerActivationDAO.getTimestampForMessengerLicense();
            if (timestampForMessengerLicense.isEmpty()) {
                X509Certificate x509Certificate = null;
                return x509Certificate;
            }
            if (timestampForMessengerLicense.get().equals(this.licenseCertificateTimestamp.get())) {
                X509Certificate x509Certificate = this.licenseCertificate.get();
                return x509Certificate;
            }
        }
        finally {
            this.readLock.unlock();
        }
        try {
            this.syncLicenseCert();
            return this.licenseCertificate.get();
        }
        catch (InstallCertException | NoSuchProviderException | CertificateException e) {
            LOGGER.error(e.toString());
            ActivationException ae = new ActivationException(1010L, "could not get license certificate");
            ae.setStackTrace(e.getStackTrace());
            throw ae;
        }
    }

    private void syncLicenseCert() throws InstallCertException, CertificateException, NoSuchProviderException {
        this.writeLock.lock();
        try {
            Optional<OffsetDateTime> timestampForMessengerLicense = this.messengerActivationDAO.getTimestampForMessengerLicense();
            if (timestampForMessengerLicense.isEmpty()) {
                this.licenseCertificate.set(null);
                this.licenseCertificateTimestamp.set(null);
                return;
            }
            MessengerLicense messengerLicense = this.messengerActivationDAO.loadMessengerLicense();
            if (Objects.isNull(messengerLicense) || Objects.isNull(messengerLicense.getLicense()) || messengerLicense.getLicense().length == 0) {
                this.licenseCertificate.set(null);
                this.licenseCertificateTimestamp.set(null);
                return;
            }
            this.licenseCertificate.set(this.certificateUtility.getX509Certificate(messengerLicense.getLicense()));
            this.licenseCertificateTimestamp.set(messengerLicense.getTimestamp());
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Long getLicenseSerialNumber() {
        return this.messengerActivationDAO.getLicenseSerialNumber();
    }

    public X509Certificate getActivationCert() throws ActivationException {
        Object timestampForMessengerActivation;
        this.readLock.lock();
        try {
            timestampForMessengerActivation = this.messengerActivationDAO.getTimestampForMessengerActivation(this.instanceAlias);
            if (((Optional)timestampForMessengerActivation).isEmpty()) {
                X509Certificate x509Certificate = null;
                return x509Certificate;
            }
            if (((Optional)timestampForMessengerActivation).get().equals(this.activationCertificateTimestamp.get())) {
                X509Certificate x509Certificate = this.activationCertificate.get();
                return x509Certificate;
            }
        }
        finally {
            this.readLock.unlock();
        }
        this.writeLock.lock();
        try {
            this.syncActivationCert();
            timestampForMessengerActivation = this.activationCertificate.get();
            return timestampForMessengerActivation;
        }
        catch (InstallCertException | GeneralSecurityException e) {
            LOGGER.error(e.toString());
            ActivationException ae = new ActivationException(1012L, "could not get activation certificate");
            ae.setStackTrace(e.getStackTrace());
            throw ae;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void syncActivationCert() throws InstallCertException, CertificateException, NoSuchProviderException {
        Optional<OffsetDateTime> timestampForMessengerActivation = this.messengerActivationDAO.getTimestampForMessengerActivation(this.instanceAlias);
        if (timestampForMessengerActivation.isEmpty()) {
            return;
        }
        if (timestampForMessengerActivation.get().equals(this.activationCertificateTimestamp.get())) {
            return;
        }
        de.pontonconsulting.xmlpipe.messenger.database.hibernate.MessengerActivation messengerActivation = this.messengerActivationDAO.loadMessengerActivation(this.instanceAlias);
        if (Objects.isNull(messengerActivation) || Objects.isNull(messengerActivation.getActivation()) || messengerActivation.getActivation().length == 0) {
            this.activationCertificate.set(null);
            this.activationCertificateTimestamp.set(null);
            return;
        }
        this.activationCertificate.set(this.certificateUtility.getX509Certificate(messengerActivation.getActivation()));
        this.activationCertificateTimestamp.set(messengerActivation.getTimestamp());
    }

    public X509Certificate getLicenseCA() throws ActivationException {
        try {
            X509Certificate cert = this.getActivationKeystore().getLicenseCA();
            if (Objects.isNull(cert)) {
                LOGGER.error("License CA was null.");
                throw new ActivationException(1020L, "could not get license CA");
            }
            return cert;
        }
        catch (GeneralSecurityException e) {
            LOGGER.error(e.toString());
            ActivationException ae = new ActivationException(1020L, "could not get license CA");
            ae.setStackTrace(e.getStackTrace());
            throw ae;
        }
    }

    public X509Certificate[] getCertificateChain(X509Certificate cert) throws ActivationException {
        LOGGER.trace("getting chain for certificate : {}", (Object)this.certificateUtility.toUsingInfoText(cert));
        ArrayList<X509Certificate> v = new ArrayList<X509Certificate>();
        v.add(cert);
        X500Principal subject = cert.getSubjectX500Principal();
        X500Principal issuer = cert.getIssuerX500Principal();
        while (!issuer.equals(subject)) {
            X509Certificate issuerCert = this.getIssuerCertificate(cert);
            if (issuerCert == null) {
                throw new ActivationException(1022L, "could not get certificate chain");
            }
            LOGGER.trace("found issuer certificate : {}", (Object)this.certificateUtility.toUsingInfoText(issuerCert));
            try {
                issuerCert.checkValidity();
                v.add(issuerCert);
                subject = issuerCert.getSubjectX500Principal();
                issuer = issuerCert.getIssuerX500Principal();
                cert = issuerCert;
            }
            catch (CertificateExpiredException | CertificateNotYetValidException e) {
                LOGGER.error(e.toString());
                StringBuilder builder = new StringBuilder();
                builder.append("Certificate for '").append(issuerCert.getIssuerX500Principal().getName()).append("' is out of date");
                String msg = e.getMessage();
                if (StringUtils.isBlank((CharSequence)msg)) {
                    builder.append(".");
                } else {
                    builder.append(": ").append(msg);
                }
                ActivationException activationException = new ActivationException(1022L, builder.toString());
                activationException.setStackTrace(e.getStackTrace());
                throw activationException;
            }
        }
        X509Certificate[] certChain = new X509Certificate[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            certChain[i] = (X509Certificate)v.get(i);
        }
        return certChain;
    }

    private X509Certificate getIssuerCertificate(X509Certificate cert) {
        X509Certificate[] certificates;
        X500Principal issuer = cert.getIssuerX500Principal();
        try {
            certificates = this.getCACertificates();
        }
        catch (GeneralSecurityException e) {
            LOGGER.error(e.toString());
            return null;
        }
        for (X509Certificate aCert : certificates) {
            if (!aCert.getSubjectX500Principal().equals(issuer)) continue;
            return aCert;
        }
        return null;
    }

    private X509Certificate[] getCACertificates() throws GeneralSecurityException {
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
        X509Certificate mainCA = null;
        try {
            mainCA = this.pontonKeyStoreBean.getKeystore().getCA("1.2.840.113549.1.9.1=#1619696e666f40706f6e746f6e2d636f6e73756c74696e672e6465,cn=ponton root ca,ou=network service,o=ponton consulting gmbh,l=hamburg,c=de");
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
        if (mainCA == null && (mainCA = this.pontonKeyStoreBean.getKeystore().getCA("oid.1.2.840.113549.1.9.1=info@ponton-consulting.de, cn=ponton root ca, ou=network service, o=ponton consulting gmbh, l=hamburg, c=de")) != null) {
            this.pontonKeyStoreBean.getKeystore().deleteCA("oid.1.2.840.113549.1.9.1=info@ponton-consulting.de, cn=ponton root ca, ou=network service, o=ponton consulting gmbh, l=hamburg, c=de");
            try {
                this.pontonKeyStoreBean.getKeystore().addCA(mainCA);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (mainCA != null) {
            certificates.add(mainCA);
        }
        X509Certificate licenseCA = null;
        try {
            licenseCA = this.getActivationKeystore().getCA("xp.license.ca");
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
        if (licenseCA != null) {
            certificates.add(licenseCA);
        }
        X509Certificate activationCA = null;
        try {
            activationCA = this.getActivationKeystore().getCA("xp.activation.ca");
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
        if (activationCA != null) {
            certificates.add(activationCA);
        }
        return certificates.toArray(new X509Certificate[0]);
    }

    public long getDaysLeft() {
        try {
            License license = this.getLicense();
            if (!license.isTrialVersion() && "never".equals(license.getActivationRuleFlag())) {
                return this.toDays(license.getEndDate());
            }
            return this.toDays(this.getActivation().getEndDate());
        }
        catch (ActivationException e) {
            LOGGER.error(e.toString());
            return -1L;
        }
    }

    private long toDays(Date time) {
        long ms;
        if (time != null && (ms = time.getTime() - this.referenceDateTask.getReferenceCurrentTimeMillis()) >= 0L) {
            return TimeUnit.MILLISECONDS.toDays(ms);
        }
        return -1L;
    }

    public String getCompanyName() {
        try {
            return this.getLicense().isTrialVersion() ? "TRIAL Version" : this.getLicense().getSubjectCN();
        }
        catch (ActivationException e) {
            LOGGER.error(e.getMessage());
            return null;
        }
    }

    public boolean isTrialVersion() {
        try {
            return this.getLicenseOrActivation().isTrialVersion();
        }
        catch (ActivationException e) {
            LOGGER.error(e.getMessage());
            return false;
        }
    }

    public int getMaxRemotePartnerTrial() {
        return 5;
    }

    public int getMaxLocalPartnerTrial() {
        return 2;
    }

    public int getLocalProfilesMaxSize() {
        try {
            AbstractModel abstractModel = this.getLicenseOrActivation();
            return abstractModel.isTrialVersion() ? this.getMaxLocalPartnerTrial() : abstractModel.getPontonXPMaxNumberOfLocalPartners();
        }
        catch (ActivationException e) {
            LOGGER.error(e.getMessage());
            return this.getMaxLocalPartnerTrial();
        }
    }

    public int getRemoteProfilesMaxSize() {
        try {
            AbstractModel abstractModel = this.getLicenseOrActivation();
            return abstractModel.isTrialVersion() ? this.getMaxRemotePartnerTrial() : abstractModel.getPontonXPMaxNumberOfRemotePartners();
        }
        catch (ActivationException e) {
            LOGGER.error(e.getMessage());
            return this.getMaxRemotePartnerTrial();
        }
    }

    public boolean isSoapListenerEnabled() throws ActivationException {
        return this.isEbXML2MessagingEnabled() || this.isAS4MessagingEnabled();
    }

    public boolean isASxMessagingEnabled() throws ActivationException {
        AbstractModel abstractModel = this.getLicenseOrActivation();
        return abstractModel.isTrialVersion() || abstractModel.isASxMessagingEnabled();
    }

    public boolean isPlainMessagingEnabled() throws ActivationException {
        AbstractModel abstractModel = this.getLicenseOrActivation();
        return abstractModel.isTrialVersion() || abstractModel.isPlainMessagingEnabled();
    }

    public boolean isAS4MessagingEnabled() throws ActivationException {
        AbstractModel abstractModel = this.getLicenseOrActivation();
        return abstractModel.isTrialVersion() || abstractModel.isAS4MessagingEnabled();
    }

    public boolean isAS4EllipticCurveEnabled() throws ActivationException {
        AbstractModel abstractModel = this.getLicenseOrActivation();
        return abstractModel.isTrialVersion() || abstractModel.isAS4EllipticCurveEnabled();
    }

    public boolean isEbXML2MessagingEnabled() throws ActivationException {
        AbstractModel abstractModel = this.getLicenseOrActivation();
        return abstractModel.isTrialVersion() || abstractModel.isEbXML2MessagingEnabled();
    }

    private AbstractModel getLicenseOrActivation() throws ActivationException {
        License license = this.getLicense();
        if ("never".equals(license.getActivationRuleFlag())) {
            return license;
        }
        Activation activation = this.getActivation();
        if (activation.isTrialVersion() && license.isFullVersion()) {
            return license;
        }
        return activation;
    }

    public boolean isClusterModeEnabled() throws ActivationException {
        return this.getLicenseOrActivation().isClusterModeEnabled();
    }

    protected void doCheckActivation(Activation activation) {
        LOGGER.trace("Checking activation at: {}", (Object)this.referenceDateTask.getReferenceDate());
        LOGGER.trace("Checking activation certificate: {}", (Object)this.certificateUtility.toUsingInfoText(activation.getCertificate()));
    }

    private String checkAndCreateMessengerProductIdentification() {
        try {
            de.pontonconsulting.xmlpipe.messenger.database.hibernate.MessengerActivation msgActivation = this.messengerActivationDAO.loadMessengerActivation(this.instanceAlias);
            if (Objects.isNull(msgActivation) || Objects.isNull(msgActivation.getProductKey()) || msgActivation.getProductKey().length == 0) {
                LOGGER.info("Found no ProductIdentifier for instance alias {}. Creating new one.", (Object)this.instanceAlias);
                ProductIdentification productIdentification = ProductIdentification.createProductIdenfication((String)"CN=Ponton X/P");
                this.importProductIdentification(productIdentification);
                return this.buildAuthenticationId(productIdentification.getCertificate());
            }
            return msgActivation.getInstanceId();
        }
        catch (ActivationException | GeneralSecurityException e) {
            LOGGER.error("Could not generate new product identification for instance alias {}: {}", (Object)this.instanceId, (Object)e.getCause());
            return null;
        }
    }

    private String checkAndCreateClusterProductIdentification() {
        try {
            MessengerLicense messengerLicense = this.messengerActivationDAO.loadMessengerLicense();
            if (Objects.isNull(messengerLicense) || Objects.isNull(messengerLicense.getProductKey()) || messengerLicense.getProductKey().length == 0) {
                LOGGER.info("Found no Cluster-ProductIdentifier. Creating new one.");
                ProductIdentification productIdentification = ProductIdentification.createProductIdenfication((String)"CN=Ponton X/P");
                return this.storeClusterProductKey(productIdentification.getPrivateKey(), productIdentification.getCertificate());
            }
            return messengerLicense.getClusterId();
        }
        catch (ActivationException | GeneralSecurityException e) {
            LOGGER.error("Could not generate new product identification for instance alias {}: {}", (Object)this.instanceId, (Object)e.getCause());
            return null;
        }
    }

    public long calculateGracePeriod() {
        Activation activation;
        try {
            activation = this.getActivation();
        }
        catch (ActivationException e) {
            LOGGER.warn("Cannot get Activation for Grace Period '{}'. Using -1 instead of it.", (Object)e.getMessage());
            return -1L;
        }
        return this.gracePeriodCalculator.calculateGracePeriod(activation);
    }

    public int getReactivationInterval() {
        try {
            return this.getLicenseOrActivation().getReactivationInterval();
        }
        catch (ActivationException e) {
            LOGGER.warn("Cannot get License or Activation for Reactivation Interval '{}'. Using 0 instead of it.", (Object)e.getMessage());
            return 0;
        }
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public int getMessengerId() {
        return this.messengerId;
    }

    public List<de.pontonconsulting.xmlpipe.messenger.database.hibernate.MessengerActivation> loadAllMessengerActivations() {
        return this.messengerActivationDAO.loadAllMessengerActivations();
    }
}

