/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.activation;

import de.pontonconsulting.xmlpipe.activation.ActivationControlJob;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;

public class ActivationControlScheduler {
    private static final Log LOG = LogFactory.getFactory().getInstance("Messenger.ActivationControlScheduler");
    private static final JobKey QUARTZ_JOB_NAME = new JobKey("ActivationControlJob");
    private static final TriggerKey QUARTZ_TRIGGER_NAME = new TriggerKey("ActivationControlkCronTrigger");
    private final Scheduler scheduler;

    public ActivationControlScheduler(Scheduler scheduler) {
        Objects.requireNonNull(scheduler, "ActivationControlScheduler: Scheduler is required.");
        this.scheduler = scheduler;
    }

    @PostConstruct
    public void startQuartz() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        int seconds = gregorianCalendar.get(13);
        int minutes = gregorianCalendar.get(12);
        int hours = gregorianCalendar.get(11);
        int day = gregorianCalendar.get(5);
        String cronExpression = seconds + " " + minutes + " " + hours + " " + day + "/1 * ? *";
        JobDetail jobDetail = null;
        try {
            jobDetail = JobBuilder.newJob(ActivationControlJob.class).withIdentity(QUARTZ_JOB_NAME).build();
            CronTrigger cronTrigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(QUARTZ_TRIGGER_NAME).forJob(jobDetail).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression)).build();
            this.scheduler.scheduleJob(jobDetail, (Trigger)cronTrigger);
            LOG.debug((Object)("Added default cron job '" + String.valueOf(QUARTZ_JOB_NAME) + "' with expression '" + cronExpression + "'."));
            Date nextFireTime = cronTrigger.getNextFireTime();
            LOG.debug((Object)("Next execution time: " + String.valueOf(nextFireTime)));
        }
        catch (Exception e) {
            if (jobDetail != null) {
                try {
                    this.scheduler.deleteJob(QUARTZ_JOB_NAME);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            LOG.error((Object)("Could not add default cron job '" + String.valueOf(QUARTZ_JOB_NAME) + "' with expression '" + cronExpression + "': " + e.toString()));
        }
    }

    @PreDestroy
    public void stopQuartz() {
        try {
            this.scheduler.unscheduleJob(QUARTZ_TRIGGER_NAME);
            LOG.debug((Object)("Deleted quartz trigger '" + QUARTZ_TRIGGER_NAME.getName() + "'."));
        }
        catch (SchedulerException e) {
            LOG.error((Object)("Could not delete quartz trigger '" + QUARTZ_TRIGGER_NAME.getName() + "': " + e.toString()));
        }
        try {
            this.scheduler.deleteJob(QUARTZ_JOB_NAME);
            LOG.debug((Object)("Deleted quartz job '" + QUARTZ_JOB_NAME.getName() + "'."));
        }
        catch (SchedulerException e) {
            LOG.error((Object)("Could not delete quartz job '" + QUARTZ_JOB_NAME.getName() + "': " + e.toString()));
        }
    }
}

