/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class Util {
    public static final String PROPERTIES_FOLDER = "properties";
    public static final int KB = 1024;
    public static final int MB = 0x100000;

    public static String[] bindStringArrays(String[] stringArray1, String[] stringArray2) {
        int i;
        if (stringArray1 == null) {
            stringArray1 = new String[]{};
        }
        if (stringArray2 == null) {
            stringArray2 = new String[]{};
        }
        String[] result = new String[stringArray1.length + stringArray2.length];
        for (i = 0; i < stringArray1.length; ++i) {
            result[i] = stringArray1[i];
        }
        for (i = 0; i < stringArray2.length; ++i) {
            result[i + stringArray1.length] = stringArray2[i];
        }
        return result;
    }

    public static String[] list2StringArray(List<String> listWithStrings) {
        if (listWithStrings == null) {
            return null;
        }
        String[] stringArray = new String[listWithStrings.size()];
        for (int i = 0; i < listWithStrings.size(); ++i) {
            stringArray[i] = listWithStrings.get(i);
        }
        return stringArray;
    }

    public static String getMessagesForJsp_Path() {
        return "properties.MESSAGES_FOR_JSP.MESSAGES_FOR_JSP";
    }

    public static String getErrorMessages_Path() {
        return "properties.ErrorMessages.ErrorMessages";
    }

    public static String getApplicationResources_Path() {
        return "properties.ApplicationResources.ApplicationResources";
    }

    public static String getCertificateResources_Path() {
        return "properties.ApplicationResources.Certificate.CertificateResources";
    }

    public static String getEvents_Path() {
        return "properties.Events.Events";
    }

    public static String getResourceForTree_Path() {
        return "properties.resourceForTree.resourceForTree";
    }

    public static String getLOG_MESSAGES_Path() {
        return "properties.LOG_MESSAGES.LOG_MESSAGES";
    }

    public static String getLogMessagesDescription_Path() {
        return "properties.LogMessagesDescription.LogMessagesDescription";
    }

    public static String getOptions_Path() {
        return "properties.Options.Options";
    }

    public static String getPasswordValidation_Path() {
        return "properties.PasswordValidation.PasswordValidation";
    }

    public static <T> List<T> array2List(T[] arr) {
        ArrayList<T> list = new ArrayList<T>();
        for (int i = 0; i < arr.length; ++i) {
            list.add(arr[i]);
        }
        return list;
    }

    public static String[] getEqualElements(String[] array1, String[] array2) {
        ArrayList<String> temp = new ArrayList<String>();
        for (int i = 0; i < array1.length; ++i) {
            for (int k = 0; k < array2.length; ++k) {
                if (!array1[i].equals(array2[k])) continue;
                temp.add(array1[i]);
            }
        }
        Collections.sort(temp);
        return Util.list2StringArray(temp);
    }

    public static String[] getEqualElementsUnsorted(String[] array1, String[] array2) {
        ArrayList<String> temp = new ArrayList<String>();
        for (int i = 0; i < array1.length; ++i) {
            for (int k = 0; k < array2.length; ++k) {
                if (!array1[i].equals(array2[k])) continue;
                temp.add(array1[i]);
            }
        }
        return Util.list2StringArray(temp);
    }

    public static <T> List<T> getEqualObjects(List<T> list1, List<T> list2) {
        if (list1 == null || list2 == null) {
            return new ArrayList(0);
        }
        ArrayList<T> resultList = new ArrayList<T>(list1);
        for (T element : list1) {
            if (list2.contains(element)) continue;
            resultList.remove(element);
        }
        return resultList;
    }

    public static <T> List<T> getEqualObjects(T[] array1, T[] array2) {
        ArrayList<T> result = new ArrayList<T>();
        for (int i = 0; i < array1.length; ++i) {
            for (int k = 0; k < array2.length; ++k) {
                if (!array1[i].equals(array2[k])) continue;
                result.add(array1[i]);
            }
        }
        return result;
    }

    public static boolean equals(Object[] array1, Object[] array2) {
        boolean equal = true;
        if (array1 != null) {
            if (array2 != null) {
                if (array1.length != array2.length) {
                    return false;
                }
                List<Object> array2AsList = Arrays.asList(array2);
                for (int i = 0; i < array1.length; ++i) {
                    if (array2AsList.contains(array1[i])) continue;
                    equal = false;
                }
            } else {
                return true;
            }
        }
        return equal;
    }

    public static String formatDouble(double value, String pattern) {
        DecimalFormat myFormatter = new DecimalFormat(pattern);
        return myFormatter.format(value);
    }

    public static String printDate(Date date, String pattern, Locale locale) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern, locale);
        return sdf.format(date);
    }

    public static String printDate(Date date, String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        return sdf.format(date);
    }

    public static Date createDate(String dateAsString, String pattern) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        return sdf.parse(dateAsString);
    }

    public static long getFullDataSize(String data, int unit) {
        BigDecimal decimal = new BigDecimal(data);
        BigDecimal result = decimal.multiply(BigDecimal.valueOf(unit));
        return result.longValue();
    }

    public static double getFullDataSize(double data, int unit) {
        BigDecimal decimal = BigDecimal.valueOf(data);
        BigDecimal result = decimal.multiply(BigDecimal.valueOf(unit));
        return result.doubleValue();
    }

    public static double getDataSize4Unit(double fullData, int unit) {
        if (unit == 0) {
            return 0.0;
        }
        BigDecimal decimal = BigDecimal.valueOf(fullData);
        BigDecimal result = decimal.divide(BigDecimal.valueOf(unit), 2, RoundingMode.UP);
        return result.doubleValue();
    }

    public static String getDataSizeToString(double fullData, int unit) {
        Double dataSize = Util.getDataSize4Unit(fullData, unit);
        return dataSize.toString();
    }

    public static Comparator<String> getStringComparator() {
        return new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return s1.compareToIgnoreCase(s2);
            }
        };
    }

    public static List<String> getStartWith(List<String> list, String prefix) {
        ArrayList<String> result = new ArrayList<String>();
        for (String string : list) {
            if (!string.startsWith(prefix)) continue;
            result.add(string);
        }
        return result;
    }

    public static String buildString(List<String> strings, String separator) {
        Object result = "";
        for (int i = 0; i < strings.size(); ++i) {
            String string = strings.get(i);
            if (i != 0 && separator != null) {
                result = (String)result + separator;
            }
            result = (String)result + string;
        }
        return result;
    }

    public static boolean isEmpty(String string) {
        return string == null || string.trim().equals("");
    }

    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static List<String> getIntersect(List<String> list1, List<String> list2) {
        HashSet<String> set1 = new HashSet<String>(list1);
        HashSet<String> set2 = new HashSet<String>(list2);
        return new ArrayList<String>(Util.getIntersect(set1, set2));
    }

    public static Set<String> getIntersect(Set<String> set1, Set<String> set2) {
        HashSet<String> copyOfSet1 = new HashSet<String>(set1);
        set1.removeAll(set2);
        copyOfSet1.removeAll(set1);
        return copyOfSet1;
    }

    public static long calculateTTL(int numberOfRetries, List<Integer> retryIntervals) {
        long intervalSum = 0L;
        int numberOfTries = numberOfRetries + 1;
        for (int i = 0; i < numberOfTries; ++i) {
            int index = i < retryIntervals.size() ? i : retryIntervals.size() - 1;
            intervalSum += (long)retryIntervals.get(index).intValue();
        }
        long ttl = intervalSum;
        return ttl;
    }

    public static int compareVersions(String leftVersion, String rightVersion) {
        if (leftVersion == null || rightVersion == null) {
            throw new IllegalArgumentException("Given versions must not be NULL.");
        }
        String[] leftVersionParts = leftVersion.split("\\.");
        String[] rightVersionParts = rightVersion.split("\\.");
        int minLength = Math.min(leftVersionParts.length, rightVersionParts.length);
        for (int i = 0; i < minLength; ++i) {
            int rightVersionPart;
            int leftVersionPart = Util.getNumber(leftVersionParts[i]);
            if (leftVersionPart == (rightVersionPart = Util.getNumber(rightVersionParts[i]))) continue;
            if (leftVersionPart < rightVersionPart) {
                return -1;
            }
            if (leftVersionPart <= rightVersionPart) continue;
            return 1;
        }
        return 0;
    }

    private static int getNumber(String versionPart) {
        return Integer.parseInt(versionPart.split("-")[0]);
    }
}

