/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import org.apache.commons.io.FileUtils;

public class TempFileCreator {
    public File createTempFile(String prefix, String suffix) throws IOException {
        return Files.createTempFile(prefix, suffix, new FileAttribute[0]).toFile();
    }

    public File createTempFile(String prefix, String suffix, Path directory) throws IOException {
        return Files.createTempFile(directory, prefix, suffix, new FileAttribute[0]).toFile();
    }

    public Path createTempFolder(String prefix) throws IOException {
        return Files.createTempDirectory(prefix, new FileAttribute[0]);
    }

    public void deleteFile(Path path) throws IOException {
        if (Objects.nonNull(path) && Files.exists(path, new LinkOption[0])) {
            Files.delete(path);
        }
    }

    public void deleteFile(File file) throws IOException {
        if (Objects.nonNull(file)) {
            this.deleteFile(file.toPath());
        }
    }

    public void deleteDirectory(Path path) throws IOException {
        if (Objects.nonNull(path) && Files.exists(path, new LinkOption[0])) {
            FileUtils.deleteDirectory((File)path.toFile());
        }
    }
}

