/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.common.util;

import de.pontonconsulting.common.util.CacheEntry;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public class DataCache<K, T extends CacheEntry> {
    private final Function<K, T> supplier;
    private final Function<K, OffsetDateTime> lastChangeFunction;
    private final Map<K, T> cache;

    public DataCache(Function<K, T> supplier, Function<K, OffsetDateTime> lastChangeFunction, final int maxCapacity) {
        this.supplier = supplier;
        this.lastChangeFunction = lastChangeFunction;
        this.cache = Collections.synchronizedMap(new LinkedHashMap<K, T>(maxCapacity, 0.75f, true){
            private static final long serialVersionUID = 8554103769100052745L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, T> eldest) {
                return this.size() > maxCapacity;
            }
        });
    }

    public Optional<T> get(K key) {
        CacheEntry entry = (CacheEntry)this.cache.get(key);
        if (entry == null) {
            entry = (CacheEntry)this.supplier.apply(key);
            if (entry != null) {
                entry.setReadOnly();
                this.cache.put(key, entry);
            }
        } else {
            OffsetDateTime lastChange = this.lastChangeFunction.apply(key);
            if (lastChange != null && entry.getLastChange().isBefore(lastChange)) {
                entry = (CacheEntry)this.supplier.apply(key);
                if (entry != null) {
                    entry.setReadOnly();
                    this.cache.put(key, entry);
                }
            } else if (lastChange == null) {
                this.cache.remove(key);
                return Optional.empty();
            }
        }
        return Optional.ofNullable(entry);
    }

    public void purgeEntry(K key) {
        this.cache.remove(key);
    }
}

