/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.user;

import de.ponton.xmlpipe.rest.IDtoFactory;
import de.ponton.xmlpipe.rest.user.UserDto;
import de.pontonconsulting.xmlpipe.config.SSLKeystoreBean;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.MessengerUser;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.UserRole;
import de.pontonconsulting.xmlpipe.security.acegi.PontonUserDetailsServiceImpl;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class UserDtoFactory
implements IDtoFactory<UserDto, MessengerUser> {
    private static final Logger LOG = LogManager.getLogger((String)("Messenger." + UserDtoFactory.class.getName()));
    private final PontonUserDetailsServiceImpl pontonUserDetailsService;
    private final SSLKeystoreBean keystoreBean;

    public UserDtoFactory(PontonUserDetailsServiceImpl pontonUserDetailsService, SSLKeystoreBean keystoreBean) {
        this.pontonUserDetailsService = pontonUserDetailsService;
        this.keystoreBean = keystoreBean;
    }

    @Override
    public UserDto create(MessengerUser valueObject) {
        UserDto userDto = new UserDto();
        userDto.setUsername(valueObject.getUsername());
        userDto.setRoles(valueObject.getRoles().stream().map(UserRole::getId).sorted().collect(Collectors.toCollection(LinkedHashSet::new)));
        if (valueObject.getLanguage() != null) {
            userDto.setLanguage(valueObject.getLanguage());
        }
        try {
            X509Certificate userCertificate = this.keystoreBean.getSSLTrustCertificate(valueObject.getUsername());
            if (userCertificate != null) {
                userDto.setCertificate(Base64.getEncoder().encodeToString(userCertificate.getEncoded()));
            }
        }
        catch (Exception e) {
            LOG.debug(e.getMessage(), (Throwable)e);
        }
        return userDto;
    }

    @Override
    public MessengerUser parse(UserDto valueObject) {
        return this.pontonUserDetailsService.loadUserByUsername(valueObject.getUsername());
    }
}

