/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.user;

import de.ponton.xmlpipe.rest.user.AdminSecuritySettingsDto;
import de.pontonconsulting.xmlpipe.config.IServerConfigBean;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.validation.Valid;
import jakarta.xml.bind.JAXBException;
import java.security.Principal;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin/securitySettings"})
@Validated
public class SecuritySettingsController {
    public static final String DOCUMENTATION_TAG = "User Security Settings";
    private final IServerConfigBean serverConfigBean;

    public SecuritySettingsController(IServerConfigBean serverConfigBean) {
        this.serverConfigBean = serverConfigBean;
    }

    @GetMapping
    @Operation(summary="Get Security Settings", description="permission:ADMIN_SECURITY_SETTINGS_GET<br><br>Return the current Administration Security Settings", tags={"User Security Settings"})
    @Secured(value={"ADMIN_SECURITY_SETTINGS_GET"})
    public ResponseEntity<AdminSecuritySettingsDto> getAdminSecuritySettings() {
        return ResponseEntity.ok((Object)new AdminSecuritySettingsDto().setUserAccountLockDuration(this.serverConfigBean.getUserAccountLockDuration()).setUserPasswordValidity(this.serverConfigBean.getUserPasswordValidity()).setTwoFactorsEnforced(this.serverConfigBean.isTwoFactorsEnforced()).setUserMaxFailedLoginAttempts(this.serverConfigBean.getMaxFailedLoginAttempts()));
    }

    @PutMapping
    @Operation(summary="Set Security Settings", description="permission:ADMIN_SECURITY_SETTINGS_PUT<br><br>Set the current Administration Security Settings", tags={"User Security Settings"})
    @Secured(value={"ADMIN_SECURITY_SETTINGS_PUT"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public ResponseEntity<Void> setAdminSecuritySettings(@Valid @RequestBody AdminSecuritySettingsDto adminSecuritySettingsDto, Principal principal) throws JAXBException {
        this.serverConfigBean.setUserPasswordValidity(adminSecuritySettingsDto.getUserPasswordValidity());
        this.serverConfigBean.setMaxFailedLoginAttempts(adminSecuritySettingsDto.getUserMaxFailedLoginAttempts());
        this.serverConfigBean.setUserAccountLockDuration(adminSecuritySettingsDto.getUserAccountLockDuration());
        if (!this.serverConfigBean.isTwoFactorsEnforced()) {
            this.serverConfigBean.setTwoFactorsEnforced(adminSecuritySettingsDto.isTwoFactorsEnforced());
        }
        this.serverConfigBean.save(principal.getName());
        return ResponseEntity.noContent().build();
    }
}

