/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.status;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.ponton.xmlpipe.rest.activation.MessengerActivationService;
import de.ponton.xmlpipe.rest.status.MessengerInfoService;
import de.ponton.xmlpipe.rest.status.MessengerStatusDto;
import de.ponton.xmlpipe.rest.status.PartnerProfileExchangeFormat;
import de.pontonconsulting.activation.ActivationException;
import de.pontonconsulting.xmlpipe.Constants;
import de.pontonconsulting.xmlpipe.config.IServerConfigBean;
import de.pontonconsulting.xmlpipe.cpp.ProfileStoreAccessException;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.HttpAdapterInfo;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.KnownServerCertificate;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.ListenerCertificate;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.ListenerFTPUser;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.MessengerActivation;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.MessengerConfig;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.MessengerLicense;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.MessengerUser;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.PartnerAgreement;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.PartnerProfileData;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.PlugableAdapterConfig;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.RemoteMaintenanceInterval;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.UserRole;
import de.pontonconsulting.xmlpipe.messenger.database.tables.HttpAdapterInfoDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.KnownServerCertificateDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.ListenerConfigDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerActivationDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerAddOnDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerConfigDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerUserDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.PartnerAgreementDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.PartnerProfileDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.RemoteMaintenanceIntervalDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.UserRoleDAO;
import de.pontonconsulting.xmlpipe.util.ZipCreatorFileVisitor;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class ConfigurationExporter {
    private static final Logger LOG = LogManager.getLogger((String)"Messenger.ConfigurationExporter");
    public static final String FILE_MESSENGER_CONFIGS = "messengerConfigs.json";
    public static final String FILE_AGREEMENTS = "agreements.json";
    public static final String FILE_KNOWN_SERVER_CERTIFICATES = "knownServerCertificates.json";
    public static final String FILE_MESSENGER_ACTIVATIONS = "messengerActivations.json";
    public static final String FILE_MESSENGER_LICENSES = "messengerLicenses.json";
    public static final String FILE_PROFILES = "profiles.json";
    public static final String FILE_MESSENGER_STATUS = "messengerStatus.json";
    public static final String FILE_MESSENGER_INFO = "messengerInfo.json";
    public static final String FILE_MESSENGER_ACTIVATION = "messengerActivation.json";
    public static final String FILE_LISTENER_FTP_USERS = "listenerFtpUsers.json";
    public static final String FILE_LISTENER_CERTIFICATES = "listenerCertificates.json";
    public static final String FILE_MESSENGER_USERS = "messengerUsers.json";
    public static final String FILE_USER_ROLES = "userRoles.json";
    public static final String FILE_HTTP_ADAPTER_INFO = "httpAdapterInfos.json";
    public static final String FILE_REMOTE_MAINTENANCE_INTERVALS = "remoteMaintenanceIntervals.json";
    private static final String FILE_PREFIX = "PontonXP-";
    private static final String FILE_SUFFIX = "-Configs.zip";
    private final MessengerConfigDAO messengerConfigDAO;
    private final ObjectMapper objectMapper;
    private final ReferenceDateTask referenceDateTask;
    private final IServerConfigBean serverConfigBean;
    private final SimpleDateFormat dateFormatter;
    private final MessengerInfoService messengerInfoService;
    private final MessengerActivationService messengerActivationService;
    private final PartnerAgreementDAO partnerAgreementDAO;
    private final KnownServerCertificateDAO knownServerCertificateDAO;
    private final MessengerActivationDAO messengerActivationDAO;
    private final PartnerProfileDAO partnerProfileDAO;
    private final ListenerConfigDAO listenerConfigDAO;
    private final HttpAdapterInfoDAO httpAdapterInfoDAO;
    private final RemoteMaintenanceIntervalDAO remoteMaintenanceIntervalDAO;
    private final MessengerAddOnDAO messengerAddOnDAO;
    private final MessengerUserDAO messengerUserDAO;
    private final UserRoleDAO userRoleDAO;

    public ConfigurationExporter(ObjectMapper objectMapper, ReferenceDateTask referenceDateTask, IServerConfigBean serverConfigBean, MessengerConfigDAO messengerConfigDAO, PartnerProfileDAO partnerProfileDAO, MessengerInfoService messengerInfoService, MessengerActivationService messengerActivationService, PartnerAgreementDAO partnerAgreementDAO, KnownServerCertificateDAO knownServerCertificateDAO, MessengerActivationDAO messengerActivationDAO, ListenerConfigDAO listenerConfigDAO, HttpAdapterInfoDAO httpAdapterInfoDAO, RemoteMaintenanceIntervalDAO remoteMaintenanceIntervalDAO, MessengerAddOnDAO messengerAddOnDAO, MessengerUserDAO messengerUserDAO, UserRoleDAO userRoleDAO) {
        this.objectMapper = objectMapper;
        this.remoteMaintenanceIntervalDAO = remoteMaintenanceIntervalDAO;
        this.messengerConfigDAO = messengerConfigDAO;
        this.partnerProfileDAO = partnerProfileDAO;
        this.referenceDateTask = referenceDateTask;
        this.serverConfigBean = serverConfigBean;
        this.messengerInfoService = messengerInfoService;
        this.messengerActivationService = messengerActivationService;
        this.partnerAgreementDAO = partnerAgreementDAO;
        this.knownServerCertificateDAO = knownServerCertificateDAO;
        this.messengerActivationDAO = messengerActivationDAO;
        this.listenerConfigDAO = listenerConfigDAO;
        this.httpAdapterInfoDAO = httpAdapterInfoDAO;
        this.messengerAddOnDAO = messengerAddOnDAO;
        this.messengerUserDAO = messengerUserDAO;
        this.dateFormatter = new SimpleDateFormat("yyyyMMdd_HHmm");
        this.userRoleDAO = userRoleDAO;
    }

    public File export(MessengerStatusDto messengerStatus) throws IOException {
        try {
            File exportBaseFolder = Files.createTempDirectory("ConfigExport", new FileAttribute[0]).toFile();
            File exportFolder = this.newFolder(exportBaseFolder, "export");
            this.writeMetaData(this.newFolder(exportFolder, "metadata"), messengerStatus);
            this.exportConfigFolder(this.newFolder(exportFolder, "configfolder"));
            this.exportDB(this.newFolder(exportFolder, "database"));
            return this.zipExportFolder(exportBaseFolder, exportFolder);
        }
        catch (IOException e) {
            LOG.error("Can't generate ConfigFileExport: %s".formatted(e.getMessage()), (Throwable)(LOG.isDebugEnabled() ? e : null));
            throw e;
        }
    }

    private void writeMetaData(File exportFolder, MessengerStatusDto messengerStatus) throws IOException {
        this.objectMapper.writeValue(new File(exportFolder, FILE_MESSENGER_STATUS), (Object)messengerStatus);
        this.objectMapper.writeValue(new File(exportFolder, FILE_MESSENGER_INFO), (Object)this.messengerInfoService.getMessengerInfo());
        try {
            this.objectMapper.writeValue(new File(exportFolder, FILE_MESSENGER_ACTIVATION), (Object)this.messengerActivationService.getMessengerActivation());
        }
        catch (ActivationException e) {
            throw new IOException(e);
        }
    }

    private void exportConfigFolder(File exportFolder) throws IOException {
        File plugableAdapterConfigFolder = new File(this.serverConfigBean.getConfigFolder(), "plugableAdapterConfigs");
        for (PlugableAdapterConfig plugableAdapterConfig : this.messengerAddOnDAO.loadAllPlugableAdapterConfigs()) {
            File file = new File(plugableAdapterConfigFolder, plugableAdapterConfig.getFilename());
            if (file.lastModified() >= plugableAdapterConfig.getTimestamp().toInstant().toEpochMilli()) continue;
            Files.write(file.toPath(), plugableAdapterConfig.getData(), StandardOpenOption.WRITE, StandardOpenOption.CREATE);
        }
        FileUtils.copyDirectory((File)this.serverConfigBean.getConfigFolder(), (File)exportFolder);
    }

    private void exportDB(File exportFolder) throws IOException {
        this.exportMessengerConfig(exportFolder);
        this.exportAgreements(exportFolder);
        this.exportProfiles(exportFolder);
        this.exportKnownServerCertificates(exportFolder);
        this.exportMessengerActivation(exportFolder);
        this.exportMessengerLicense(exportFolder);
        this.exportListenerFtpUsers(exportFolder);
        this.exportListenerCertificates(exportFolder);
        this.exportHttpAdapterInfo(exportFolder);
        this.exportUserRoles(exportFolder);
        this.exportMessengerUsers(exportFolder);
        this.exportRemoteMaintenanceIntervals(exportFolder);
    }

    private File zipExportFolder(File targetFolder, File exportFolder) throws IOException {
        String zipFilename = FILE_PREFIX + Constants.getXP_VERSION().replaceAll("[() ]", "") + "-" + this.dateFormatter.format(this.referenceDateTask.getReferenceDate()) + FILE_SUFFIX;
        File configZipFile = new File(targetFolder, zipFilename);
        Files.walkFileTree(exportFolder.toPath(), new ZipCreatorFileVisitor(exportFolder.toPath(), configZipFile.toPath()));
        return configZipFile;
    }

    private void exportMessengerConfig(File exportDir) throws IOException {
        List<MessengerConfig> messengerConfigs = this.messengerConfigDAO.loadAllMessengerConfigs();
        if (!messengerConfigs.isEmpty()) {
            this.objectMapper.writeValue(new File(exportDir, FILE_MESSENGER_CONFIGS), messengerConfigs);
        }
    }

    private void exportRemoteMaintenanceIntervals(File exportDir) throws IOException {
        List<RemoteMaintenanceInterval> remoteMaintenanceIntervals = this.remoteMaintenanceIntervalDAO.readAll();
        if (!remoteMaintenanceIntervals.isEmpty()) {
            this.objectMapper.writeValue(new File(exportDir, FILE_REMOTE_MAINTENANCE_INTERVALS), remoteMaintenanceIntervals);
        }
    }

    private void exportAgreements(File exportDir) throws IOException {
        List<PartnerAgreement> agreementList = this.partnerAgreementDAO.loadAllPartnerAgreements();
        if (!agreementList.isEmpty()) {
            this.objectMapper.writeValue(new File(exportDir, FILE_AGREEMENTS), agreementList);
        }
    }

    private void exportKnownServerCertificates(File exportDir) throws IOException {
        List<KnownServerCertificate> certificateList = this.knownServerCertificateDAO.loadAllKnownServerCertificates();
        if (!certificateList.isEmpty()) {
            this.objectMapper.writeValue(new File(exportDir, FILE_KNOWN_SERVER_CERTIFICATES), certificateList);
        }
    }

    private void exportMessengerActivation(File exportDir) throws IOException {
        List<MessengerActivation> activationList = this.messengerActivationDAO.loadAllMessengerActivations();
        if (!activationList.isEmpty()) {
            this.objectMapper.writeValue(new File(exportDir, FILE_MESSENGER_ACTIVATIONS), activationList);
        }
    }

    private void exportMessengerUsers(File exportDir) throws IOException {
        List<MessengerUser> messengerUsers = this.messengerUserDAO.getAll();
        if (!messengerUsers.isEmpty()) {
            this.objectMapper.writeValue(new File(exportDir, FILE_MESSENGER_USERS), messengerUsers);
        }
    }

    private void exportUserRoles(File exportDir) throws IOException {
        List<UserRole> userRoles = this.userRoleDAO.getAllUserRoles();
        if (!userRoles.isEmpty()) {
            this.objectMapper.writeValue(new File(exportDir, FILE_USER_ROLES), userRoles);
        }
    }

    private void exportMessengerLicense(File exportDir) throws IOException {
        List<MessengerLicense> licenseList = this.messengerActivationDAO.loadAllMessengerLicenses();
        if (!licenseList.isEmpty()) {
            this.objectMapper.writeValue(new File(exportDir, FILE_MESSENGER_LICENSES), licenseList);
        }
    }

    private void exportProfiles(File exportDir) throws IOException {
        List<PartnerProfileExchangeFormat> partnerProfiles = this.partnerProfileDAO.getAllPartnerProfiles().stream().map(partnerProfile -> {
            try {
                PartnerProfileData partnerProfileData = this.partnerProfileDAO.getPartnerProfileData(partnerProfile.getPartnerId());
                return new PartnerProfileExchangeFormat().setPartnerId(partnerProfile.getPartnerId()).setUsername(partnerProfile.getUsername()).setLastChange(partnerProfile.getLastChange()).setPublicProfile(partnerProfileData.getPublicProfile()).setPrivateProfile(partnerProfileData.getPrivateProfile());
            }
            catch (ProfileStoreAccessException e) {
                throw new RuntimeException(e);
            }
        }).toList();
        if (!partnerProfiles.isEmpty()) {
            this.objectMapper.writeValue(new File(exportDir, FILE_PROFILES), partnerProfiles);
        }
    }

    private void exportListenerFtpUsers(File exportDir) throws IOException {
        List<ListenerFTPUser> ftpUsers = this.listenerConfigDAO.loadFtpUsers();
        if (!ftpUsers.isEmpty()) {
            this.objectMapper.writeValue(new File(exportDir, FILE_LISTENER_FTP_USERS), ftpUsers);
        }
    }

    private void exportListenerCertificates(File exportDir) throws IOException {
        List<ListenerCertificate> certs = this.listenerConfigDAO.loadListenerCertificates();
        if (!certs.isEmpty()) {
            this.objectMapper.writeValue(new File(exportDir, FILE_LISTENER_CERTIFICATES), certs);
        }
    }

    private void exportHttpAdapterInfo(File exportDir) throws IOException {
        List<HttpAdapterInfo> httpAdapters = this.httpAdapterInfoDAO.getAllHttpAdapters();
        if (!httpAdapters.isEmpty()) {
            this.objectMapper.writeValue(new File(exportDir, FILE_HTTP_ADAPTER_INFO), httpAdapters);
        }
    }

    private File newFolder(File baseFolder, String newFolderName) throws IOException {
        File newFolder = new File(baseFolder, newFolderName);
        if (!newFolder.exists() && !newFolder.mkdirs()) {
            throw new IOException("Export folder " + String.valueOf(newFolder) + " can't be created");
        }
        return newFolder;
    }
}

